<?php

/**
* @package JFusion_SMF
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * JFusion Public Class for SMF 1.1.x
 * For detailed descriptions on these functions please check the model.abstractpublic.php
 * @package JFusion_SMF
 */
class JFusionPublic_smf extends JFusionPublic{

	function getJname()
	{
		return 'smf';
	}

	function getRegistrationURL()
	{
		return 'index.php?action=register';
	}

	function getLostPasswordURL()
	{
		return 'index.php?action=reminder';
	}

	function getLostUsernameURL()
	{
		return 'index.php?action=reminder';
	}

	function getBuffer(&$data)
	{
		$action = JRequest::getVar('action');
		if ($action=='register' || $action=='reminder') {
			$master = JFusionFunction::getMaster();
			if( $master->name != $this->getJname() ) {
				$JFusionMaster = JFusionFactory::getPublic($master->name);
				$params = JFusionFactory::getParams($master->name);
				$source_url = $params->get('source_url');
				$source_url = rtrim ( $source_url , '/' );
				if ( $action=='register' ) {
					header('Location: '.$source_url.JRoute::_($JFusionMaster->getRegistrationURL(),false));
				} else {
					header('Location: '.$source_url.JRoute::_($JFusionMaster->getLostPasswordURL(),false));
				}
				exit();
			}
		}
		if ($action=='logout') {
			$mainframe = &JFactory::getApplication('site');

	        // logout any joomla users
        	$mainframe->logout();

	        // clean up session
        	$session =& JFactory::getSession();
        	$session->close();
			header('Location: '.$data->baseURL);
        	exit();
		}

		// We're going to want a few globals... these are all set later.
		global $time_start, $maintenance, $msubject, $mmessage, $mbname, $language;
		global $boardurl, $boarddir, $sourcedir, $webmaster_email, $cookiename;
		global $db_connection, $db_server, $db_name, $db_user, $db_prefix, $db_persist, $db_error_send, $db_last_error;
		global $modSettings, $context, $sc, $user_info, $topic, $board, $txt;
		global $scripturl, $ID_MEMBER, $func;

		// Required to avoid a warning about a license violation even though this is not the case
		global $forum_version;

//        require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'plugins'.DS.$this->getJname().DS.'hooks.php');

		// Get the path
		$params = JFusionFactory::getParams($this->getJname());
		$source_path = $params->get('source_path');
		$cookie_domain = $params->get('cookie_domain');
		$cookie_path = $params->get('cookie_path');
		$cookie_name = $params->get('cookie_name');

		if ( $action == 'logout' ) setcookie($cookie_name, '',1,$cookie_path,$cookie_domain);

		if (substr($source_path, -1) == DS) {
			$index_file = $source_path .'index.php';
		} else {
			$index_file = $source_path .DS.'index.php';
		}

		if ( ! is_file($index_file) ) {
			JError::raiseWarning(500, 'The path to the SMF index file set in the component preferences does not exist');
			return null;
		}

		//set the current directory to SMF
		chdir($source_path);
		global $jfusion_smf_globals;
		$jfusion_smf_globals['data'] = $data;
		$jfusion_smf_globals['class'] = get_class($this);

		// Get the output
		ob_start('jfusion_smf_die');
		$rs = include_once($index_file);
		// die if popup
		if ( $action == 'findmember' || $action == 'helpadmin' ) {
			die();
		}
		$data->buffer = ob_get_contents();
		ob_end_clean();

		unset($jfusion_smf_globals);

		//change the current directory back to Joomla.
		chdir(JPATH_SITE);

		// Log an error if we could not include the file
		if (!$rs) {
			JError::raiseWarning(500, 'Could not find SMF in the specified directory');
		}
		$document = JFactory::getDocument();
		$document->addScript(JFusionFunction::getJoomlaURL().'administrator'.DS.'components'.DS.'com_jfusion'.DS.'plugins'.DS.'smf'.DS.'js'.DS.'script.js');
	}

	function parseBody(&$data)
	{
		$regex_body		= array();
		$replace_body	= array();

		//fix for form actions
		$regex_body[]	= '#action="'.$data->integratedURL.'index.php(.*?)"(.*?)>#me';
		$replace_body[]	= '$this->fixAction("index.php$1","$2","' . $data->baseURL .'")';

		$regex_body[]	= '#href="'.$data->integratedURL.'index.php(.*?)"#Sise';
		$replace_body[] = '\'href="\'.$this->fixUrl("index.php$1","'.$data->baseURL.'","'.$data->fullURL.'").\'"\'';

		$regex_body[]	= '#href="\#(.*?)"#Sise';
		$replace_body[] = '\'href="\'.$this->fixUrl("#$1","'.$data->baseURL.'","'.$data->fullURL.'").\'"\'';

		//Jump Related fix
		$regex_body[]	= '#<select name="jumpto" id="jumpto".*?">(.*?)</select>#mSsie';
		$replace_body[]	= '$this->fixJump("$1")';

		$regex_body[] = '#<input (.*?) window.location.href = \'(.*?)\' \+ this.form.jumpto.options(.*?)>#mSsi';
		$replace_body[] = '<input $1 window.location.href = jf_scripturl + this.form.jumpto.options$3>';

		$regex_body[]	= '#smf_scripturl \+ \"\?action#mSsi';
		$replace_body[]	= 'jf_scripturl + "&action';

		$regex_body[]	= '#<a (.*?) onclick="doQuote(.*?)>#mSsi';
		$replace_body[]	= '<a $1 onclick="jfusion_doQuote$2>';

		$regex_body[]	= '#<a (.*?) onclick="modify_msg(.*?)>#mSsi';
		$replace_body[]	= '<a $1 onclick="jfusion_modify_msg$2>';

		$regex_body[]	= '#modify_save\(#mSsi';
		$replace_body[]	= 'jfusion_modify_save(';

		// Chaptcha fix
		$regex_body[]	= '#\"'.$data->integratedURL.'(index.php\?)(action=verificationcode;rand=)(.*?)\"#sie';
		$replace_body[]	= '\'\"\'.$this->fixUrl("index.php?$2$3","'.$data->baseURL.'","'.$data->fullURL.'").\'\"\'';

		$data->body = preg_replace($regex_body, $replace_body, $data->body);
	}

	function parseHeader(&$data)
	{
		static $regex_header, $replace_header;
		if ( ! $regex_header || ! $replace_header )
		{
			$params = JFusionFactory::getParams('joomla_int');
			$joomla_url = $params->get('source_url');

			$baseURLnoSef = 'index.php?option=com_jfusion&Itemid=' . JRequest::getVar('Itemid');
			if (substr($joomla_url, -1) == '/') $baseURLnoSef = $joomla_url . $baseURLnoSef;
			else $baseURLnoSef = $joomla_url . '/' . $baseURLnoSef;

			// Define our preg arrays
			$regex_header		= array();
			$replace_header	= array();

			//convert relative links into absolute links
			$regex_header[]	= '#(href|src)=("./|"/)(.*?)"#mS';
			$replace_header[]	= '$1="'.$data->integratedURL.'$3"';

			//$regex_header[]	= '#(href|src)="(.*)"#mS';
			//$replace_header[]	= 'href="'.$data->integratedURL.'$2"';

			//convert relative links into absolute links
			$regex_header[]	= '#(href|src)=("./|"/)(.*?)"#mS';
			$replace_header[]	= '$1="'.$data->integratedURL.'$3"';

			$regex_header[] = '#var smf_scripturl = ["|\'](.*?)["|\'];#mS';
			$replace_header[] = 'var smf_scripturl = "$1"; var jf_scripturl = "'.$baseURLnoSef.'";';
		}
		$data->header = preg_replace($regex_header, $replace_header, $data->header);
	}

	function fixUrl($q='',$baseURL,$fullURL)
	{
        //SMF uses semi-colons to seperate vars as well. Convert these to normal ampersands
        $q = str_replace(';','&',$q);

        if ( strpos($q,'#') === 0 ) return $fullURL.$q;

        if (substr($baseURL, -1) != '/'){
			//non sef URls
			$q = str_replace('?', 	'&amp;', $q);
			$url = $baseURL . '&amp;jfile=' .$q;
        } else {
			$params = JFusionFactory::getParams($this->getJname());
			$sefmode = $params->get('sefmode');
			if ($sefmode==1) {
				$url =  JFusionFunction::routeURL($q, JRequest::getVar('Itemid'));
			} else {
				//we can just append both variables
				$url = $baseURL . $q;
			}
		}
		return $url;
	}

	function fixAction($url, $extra, $baseURL)
	{
		//JError::raiseWarning(500, $url);
		$url = htmlspecialchars_decode($url);
		$Itemid = JRequest::getVar('Itemid');

		$extra = stripslashes( $extra );
		$url = str_replace(';','&',$url);
		if (substr($baseURL, -1) != '/'){
			//non-SEF mode
		  	$url_details = parse_url($url);
		  	$url_variables = array();
		 	$jfile = basename($url_details['path']);
		 	if ( isset($url_details['query']) ) {
				parse_str($url_details['query'], $url_variables);
				$baseURL .= '&'.$url_details['query'];
		 	}
		  	//set the correct action and close the form tag
			$replacement = 'action="'.$baseURL . '"' . $extra . '>';
			$replacement .= '<input type="hidden" name="jfile" value="'. $jfile . '"/>';
			$replacement .= '<input type="hidden" name="Itemid" value="'.$Itemid . '"/>';
		  	$replacement .= '<input type="hidden" name="option" value="com_jfusion"/>';
		} else {
			//check to see what SEF mode is selected
		    $params = JFusionFactory::getParams($this->getJname());
		    $sefmode = $params->get('sefmode');
		    if ($sefmode==1) {
		    	//extensive SEF parsing was selected
			  	$url =  JFusionFunction::routeURL($url, $Itemid);
				$replacement = 'action="'.$url . '"' . $extra . '>';
				return $replacement;
			} else {
				//simple SEF mode
		      	$url_details = parse_url($url);
			  	$url_variables = array();
		 		$jfile = basename($url_details['path']);
		 		if ( isset($url_details['query']) ) {
		 			parse_str($url_details['query'], $url_variables);
					$jfile .= '?'.$url_details['query'];
		 		}
				$replacement = 'action="'.$baseURL . $jfile.'"' . $extra . '>';
			}
		}
		unset($url_variables['option'],$url_variables['jfile'],$url_variables['Itemid']);

		//add any other variables
		if(is_array($url_variables)){
	 		foreach ($url_variables as $key => $value){
				$replacement .=  '<input type="hidden" name="'. $key .'" value="'.$value . '"/>';
  			}
		}
  		return $replacement;
	}

	function fixJump($content)
	{
	  $find = '#<option value="[?](.*?)">(.*?)</option>#mSsi';
	  $replace = '<option value="&$1">$2</option>';

	  $content = preg_replace($find, $replace, $content);

	  return '<select name="jumpto" id="jumpto" onchange="if (this.selectedIndex > 0 && this.options[this.selectedIndex].value && this.options[this.selectedIndex].value.length) window.location.href = jf_scripturl + this.options[this.selectedIndex].value;">'.$content.'</select>';
	}

	/*function getPathWay()
	{
		$db = JFusionFactory::getDatabase($this->getJname());
		$pathway = array();

		list ($board_id ) = split  ( '.'  , JRequest::getVar('board'),1 );
		list ($topic_id ) = split  ( '.'  , JRequest::getVar('topic'),1 );
		list ($action ) = split  ( ';'  , JRequest::getVar('action'),1 );

		$msg = JRequest::getVar('msg');

        $query = 'SELECT ID_TOPIC,ID_BOARD, subject '.
        		'FROM #__messages '.
        		'WHERE ID_TOPIC = ' . $db->Quote($topic_id);
        $db->setQuery($query );
        $topic = $db->loadObject();

        if ($topic) {
			$board_id = $topic->ID_BOARD;
        }

		if ($board_id) {
			$boards = array();
			// Loop while the parent is non-zero.
			while ($board_id != 0)
			{
		        $query = 'SELECT b.ID_PARENT , b.ID_BOARD, b.ID_CAT, b.name , c.name as catname '.
		        		'FROM #__boards AS b INNER JOIN #__categories AS c ON b.ID_CAT = c.ID_CAT '.
		        		'WHERE ID_BOARD = ' . $db->Quote($board_id);
		        $db->setQuery($query );
		        $result = $db->loadObject();

				$board_id = 0;
		 		if ($result) {
		 			$board_id = $result->ID_PARENT;
		 			$boards[] = $result;
				}
			}
			$boards = array_reverse($boards);
			$cat_id = 0;
			foreach($boards as $board) {
				$path = new stdClass();
				if ( $board->ID_CAT != $cat_id ) {
					$cat_id = $board->ID_CAT;
					$path->title = $board->catname;
					$path->url = 'index.php#'.$board->ID_CAT;
					$pathway[] = $path;

					$path = new stdClass();
					$path->title = $board->name;
					$path->url = 'index.php?board='.$board->ID_BOARD.'.0';
				} else {
					$path->title = $board->name;
					$path->url = 'index.php?board='.$board->ID_BOARD.'.0';
				}
				$pathway[] = $path;
			}
		}
		switch ($action) {
		    case 'post':
		    	$path = new stdClass();
		    	if ( JRequest::getVar('board') ) {
					$path->title = 'Modify Toppic ( Start new topic )';
					$path->url = 'index.php?action=post&board='.$board_id.'.0';;
		    	} else if ( $msg ) {
					$path->title = 'Modify Toppic ( '.$topic->subject.' )';
					$path->url = 'index.php?action=post&topic='.$topic_id.'.msg'.$msg.'#msg'.$msg;
		    	} else {
					$path->title = 'Post reply ( Re: '.$topic->subject.' )';
					$path->url = 'index.php?action=post&topic='.$topic_id;
		    	}
				$pathway[] = $path;
		        break;
			case 'pm':
				$path = new stdClass();
				$path->title = 'Personal Messages';
				$path->url = 'index.php?action=pm';
				$pathway[] = $path;

				$path = new stdClass();
				if ( JRequest::getVar('sa')=='send' ) {
					$path->title = 'New Message';
					$path->url = 'index.php?action=pm&sa=send';
					$pathway[] = $path;
				} elseif ( JRequest::getVar('sa')=='search' ) {
					$path->title = 'Search Messages';
					$path->url = 'index.php?action=pm&sa=search';
					$pathway[] = $path;
				} elseif ( JRequest::getVar('sa')=='prune' ) {
					$path->title = 'Prune Messages';
					$path->url = 'index.php?action=pm&sa=prune';
					$pathway[] = $path;
				} elseif ( JRequest::getVar('sa')=='manlabels' ) {
					$path->title = 'Manage Labels';
					$path->url = 'index.php?action=pm&sa=manlabels';
					$pathway[] = $path;
				} elseif ( JRequest::getVar('f')=='outbox' ) {
					$path->title = 'Outbox';
					$path->url = 'index.php?action=pm&f=outbox';
					$pathway[] = $path;
				} else {
					$path->title = 'Inbox';
					$path->url = 'index.php?action=pm';
					$pathway[] = $path;
				}
		        break;
			case 'search2':
				$path = new stdClass();
				$path->title = 'Search';
				$path->url = 'index.php?action=search';
				$pathway[] = $path;
				$path = new stdClass();
				$path->title = 'Search Results';
				$path->url = 'index.php?action=search';
				$pathway[] = $path;
				break;
			case 'search':
				$path = new stdClass();
				$path->title = 'Search';
				$path->url = 'index.php?action=search';
				$pathway[] = $path;
				break;
			case 'unread':
				$path = new stdClass();
				$path->title = 'Recent Unread Topics';
				$path->url = 'index.php?action=unread';
				$pathway[] = $path;
				break;
			case 'unreadreplies':
				$path = new stdClass();
				$path->title = 'Updated Topics';
				$path->url = 'index.php?action=unreadreplies';
				$pathway[] = $path;
				break;
			default:
				if ( $topic_id ) {
					$path = new stdClass();
					$path->title = $topic->subject;
					$path->url = 'index.php?topic='.$topic_id;
					$pathway[] = $path;
				}
		}
		return $pathway;
	}*/

	/************************************************
	 * For JFusion Search Plugin
	 ***********************************************/
 	function cleanUpSearchText($text)
	{
		//remove phpbb's bbcode uids
		$text = preg_replace("#\[(.*?):(.*?)]#si","[$1]",$text);
		$text = JFusionFunction::parseCode($text,'html');
		return $text;
	}

	function getSearchQueryColumns()
	{
		$columns = new stdClass();
		$columns->title = "p.subject";
		$columns->text = "p.body";
		return $columns;
	}

	function getSearchQuery()
	{
		//need to return threadid, postid, title, text, created, section
		$query = 'SELECT p.ID_TOPIC, p.ID_MSG, p.ID_BOARD, CASE WHEN p.subject = "" THEN CONCAT("Re: ",fp.subject) ELSE p.subject END AS title, p.body AS text,
					FROM_UNIXTIME(p.posterTime, "%Y-%m-%d %h:%i:%s") AS created,
					CONCAT_WS( "/", f.name, fp.subject ) AS section
					FROM #__messages AS p
					INNER JOIN #__topics AS t ON t.ID_TOPIC = p.ID_TOPIC
					INNER JOIN #__messages AS fp ON fp.ID_MSG = t.ID_FIRST_MSG
					INNER JOIN #__boards AS f on f.ID_BOARD = p.ID_BOARD';
		return $query;
	}

	function filterSearchResults(&$results)
	{

	}

	function getSearchResultLink($post)
	{
		$forum = JFusionFactory::getForum($this->getJname());
		return $forum->getPostURL($post->ID_TOPIC,$post->ID_MSG);
	}

   /************************************************
	 * Functions For JFusion Who's Online Module
	 ***********************************************/

	/**
	 * Returns a query to find online users
	 * Make sure columns are named as userid, username, username_clean (if applicable), name (of user), and email
	 **/
	function getOnlineUserQuery($limit)
	{
		$limiter = (!empty($limit)) ? "LIMIT 0,$limit" : '';

		return "SELECT DISTINCT u.ID_MEMBER AS userid, u.memberName AS username, u.realName AS name, u.emailAddress as email FROM #__members AS u INNER JOIN #__log_online AS s ON u.ID_MEMBER = s.ID_MEMBER WHERE s.ID_MEMBER != 0 $limiter";
	}

	/**
	 * Returns number of guests
	 * @return int
	 */
	function getNumberOnlineGuests()
	{
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT COUNT(DISTINCT(ip)) FROM #__log_online WHERE ID_MEMBER = 0";
		$db->setQuery($query);
		return $db->loadResult();
	}

	/**
	 * Returns number of logged in users
	 * @return int
	 */
	function getNumberOnlineMembers()
	{
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT COUNT(DISTINCT(ip)) FROM #__log_online WHERE ID_MEMBER != 0";
		$db->setQuery($query);
		return $db->loadResult();
	}

	/**
	 * Function called by sh404sef for url building
     * @param array with titles for url
     * @param array global pointer to sh404sef remaning $_GET values from the url
	 */
	function sh404sef(&$title,&$get)
	{
		if( isset($get['action'] ) ) {
			$title[] = $get['action'];
			shRemoveFromGETVarsList('action');
		}

		foreach( $get as $key => $value ) {
			$title[] = $key.$value;
			shRemoveFromGETVarsList($key);
		}
	}
}

function jfusion_smf_die($buffer) {
	global $jfusion_smf_globals;
	global $context;

	if ( isset($context['get_data']) ){
		if ( $context['get_data'] && strpos( $context['get_data']  , 'jFusion_Route' ) ) {
			$buffer = str_replace ($context['get_data'],'?action=admin',$buffer);
		}
	}

	$data = $jfusion_smf_globals['data'];

	$data->buffer = $buffer;
	ini_set('pcre.backtrack_limit',strlen($data->buffer)*2);

	$pattern = '#<head[^>]*>(.*?)<\/head>.*?<body[^>]*>(.*)<\/body>#si';
	if (preg_match($pattern, $data->buffer, $temp)) {
		$data->header = $temp[1];
		$data->body = $temp[2];
		unset($temp);

		$plugin= new $jfusion_smf_globals['class']();
		$plugin->parseHeader($data);
		$plugin->parseBody($data);
		return '<html><head>'.$data->header.'</head><body>'.$data->body.'<body></html>';
	} else {
		return $buffer;
	}
}