<?php

/**
 * @package JFusion
 * @subpackage Models
 * @author JFusion development team
 * @copyright Copyright (C) 2008 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
* Abstract interface for all JFusion forum implementations.
* @package JFusion
*/
class JFusionForum
{
     /**
     * returns the name of this JFusion plugin
     * @return string name of current JFusion plugin
     */
    function getJname()
    {
        return '';
    }


     /**
     * Returns the URL to a thread of the integrated software
     * @param integer $threadid threadid
     * @return string URL
     */
    function getThreadURL($threadid)
    {
        return '';
    }

     /**
     * Returns the URL to a post of the integrated software
     * @param integer $threadid threadid
     * @param integer $postid postid
     * @return string URL
     */
    function getPostURL($threadid, $postid)
    {
        return '';
    }

     /**
     * Returns the URL to a userprofile of the integrated software
     * @param integer $uid userid
     * @return string URL
     */
    function getProfileURL($uid)
    {
        return '';
    }

    /**
     * Retrieves the source path to the user's avatar
     * @param $uid software's user id
     * @return string with source path to users avatar
     */
    function getAvatar($uid)
    {
    	return 0;
    }

     /**
     * Returns the URL to the view all private messages URL of the integrated software
     * @return string URL
     */
    function getPrivateMessageURL()
    {
        return '';
    }

     /**
     * Returns the URL to a view new private messages URL of the integrated software
     * @return string URL
     */
    function getViewNewMessagesURL()
    {
        return '';
    }

     /**
     * Returns the URL to a get private messages URL of the integrated software
     * @return string URL
     */
    function getPrivateMessageCounts($puser_id)
    {
        return 0;
    }

     /**
     * Returns the an array with SQL statements used by the activity module
     * @return array
     */
    function getActivityQuery($usedforums, $result_order, $result_limit, $display_limit)
    {
        return 0;
    }

     /**
     * Returns the a list of forums of the integrated software
     * @return array List of forums
     */
    function getForumList()
    {
        return 0;
    }

    /**
     * Filter forums from a set of results sent in / useful if the plugin needs to restrict the forums visible to a user
     * @param $results set of results from query
     * @param $limit int limit results parameter as set in the module's params; used for plugins that cannot limit using a query limiter
     */
 	function filterActivityResults(&$results, $limit=0)
 	{

 	}

    /************************************************
	 * Functions For JFusion Discussion Bot Plugin
	 ***********************************************/

    /**
     * Checks to see if a thread already exists for the content item and calls the appropriate function
     * @param object with discussion bot parameters
     * @param object $contentitem object containing content information
     * @param int default forum id to create the new thread in if applicable (retrieved from $this->getDefaultForum)
     * @return array Returns status of actions with errors if any
     */
	function checkThreadExists(&$params, &$contentitem, $forumid)
	{
	    $status = array();
        $status['debug'] = array();
        $status['error'] = array();

        return $status;
	}

    /**
     * Retrieves the default forum based on section/category stipulations or default set in the plugins config
     * @param object with discussion bot parameters
     * @param object $contentitem object containing content information
     * @return int Returns id number of the forum
     */
	function getDefaultForum(&$dbparams, &$contentitem)
	{
		//content section/category
		$sectionid =& $contentitem->sectionid;
		$catid =& $contentitem->catid;

		//default forum to create post in
		$forumid = $dbparams->get("default_forum");

		//determine default forum
		$sections = $dbparams->get("pair_sections");
		$sectionPairs = empty($sections) ? false :  explode(";",$sections);

		$categories = $dbparams->get("pair_categories");
		$categoryPairs = empty($categories) ? false : explode(";",$categories);

		if($sectionPairs)
		{
			foreach($sectionPairs as $pairs)
			{
				$pair = explode(",",$pairs);
				//check to see if this section matches the articles
				if($pair[0]==$sectionid) $forumid = $pair[1];
			}
		}

		if($categoryPairs)
		{
			foreach($categoryPairs as $pairs)
			{
				$pair = explode(",",$pairs);
				//check to see if this category matches the articles
				if($pair[0]==$catid) $forumid = $pair[1];
			}
		}

		return $forumid;
	}

    /**
     * Retrieves thread information
     * @param int Id of specific thread
     * @return object Returns object with thread information
     * return the object with these three items
     * $result->forumid
     * $result->threadid (yes add it even though it is passed in as it will be needed in other functions)
     * $result->postid - this is the id of the first post in the thread
     */
    function getThread($threadid)
    {
		return '';
    }

     /**
     * Creates new thread and posts first post
     * @param object with discussion bot parameters
     * @param object $contentitem object containing content information
     * @param int Id of forum to create thread
     * @param array $status contains errors and status of actions
     */
	function createThread(&$params, &$contentitem, $forumid, &$status)
	{

	}

	 /**
     * Updates information in a specific thread/post
     * @param object with discussion bot parameters
     * @param $existingthread object with existin thread info
     * @param object $contentitem object containing content information
     * @param array $status contains errors and status of actions
     */
	function updateThread(&$params, &$existingthread, &$contentitem, &$status)
	{

	}

	/**
     * Prepares text before saving to db or presentint to joomla article
     * @param string Text to be modified
     * @param $prepareForJoomla boolean to indicate if the text is to be saved to software's db or presented in joomla article
     * @return string Modified text
     */
	function prepareText($text, $prepareForJoomla = false)
	{
		if($prepareForJoomla===false) {
			//first thing is to remove all joomla plugins
			preg_match_all('/\{(.*)\}/U',$text,$matches);

			//find each thread by the id
			foreach($matches[1] AS $plugin) {
				//replace plugin with nothing
				$text = str_replace('{'.$plugin.'}',"",$text);
			}
		}

		return $text;
	}

	/**
	 * Returns an object of columns used in createPostTable()
	 * Saves from having to repeat the same code over and over for each plugin
	 * For example:
	 * $columns->userid = "userid";
	 * $columns->username = "username";
	 * $columns->username_clean = "username_clean"; //if applicable for filtered usernames
	 * $columns->dateline = "dateline";
	 * $columns->posttext = "pagetext";
	 * $columns->posttitle = "title";
	 * $columns->postid = "postid";
	 * $columns->threadid = "threadid";
	 * $columns->guest = "guest";
	 * @return object with column names
	 */
	function getDiscussionColumns()
	{
		return;
	}

	/**
     * Creates a table of posts to be displayed in content item
     * @param object with discussion bot parameters
     * @param obj of thread information
     * @param obj list of posts retrieved from getPosts();
     * @param array of css classes
     * @param obj with discussion bot parameters
     * @return string HTML of table to displayed
     */
	function createPostTable(&$dbparams, &$existingthread, &$posts, &$css)
	{
		$columns = $this->getDiscussionColumns();
		if(empty($columns)) return;

		//get required params
		defined('_DATE_FORMAT_LC2') or define('_DATE_FORMAT_LC2','%A, %d %B %Y %H:%M');
		$date_format = $dbparams->get('custom_date', _DATE_FORMAT_LC2);
		$tz_offset = intval($dbparams->get('tz_offset'));
		$showdate = intval($dbparams->get('show_date'));
		$showuser = intval($dbparams->get('show_user'));
		$showavatar = $dbparams->get("show_avatar");
		$avatar_software = $dbparams->get("avatar_software",false);
		$userlink = intval($dbparams->get('user_link'));
		$link_software = $dbparams->get('userlink_software',false);
		$userlink_custom = $dbparams->get('userlink_custom',false);
		$body_limit = (int) $dbparams->get("body_limit");
		$itemid = $dbparams->get("itemid");
		$jname = $this->getJname();
		$header = $dbparams->get("post_header");
		if($showdate && $showuser) $colspan = 2;
		else $colspan = 1;

		$table  = "<div class='{$css["postHeader"]}'>$header</div>\n";

		for ($i=0; $i<count($posts); $i++)
		{
			$p = &$posts[$i];
			$userid = $p->{$columns->userid};
			$username = $p->{$columns->username};
			$username_clean = (isset($columns->username_clean)) ? $p->{$columns->username_clean} : $p->{$columns->username};
			$dateline = $p->{$columns->dateline};
			$posttext = $p->{$columns->posttext};
			$posttitle = $p->{$columns->posttitle};
			$postid = $p->{$columns->postid};
			$threadid = $p->{$columns->threadid};
			$guest = $p->{$columns->guest};

			$table .= "<div class = '{$css["postBody"]}'> \n";

			//get Joomla's id
			$userlookup = JFusionFunction::lookupUser($this->getJname(),$userid,false,$username_clean);

			//avatar
			if($showavatar){
                if(empty($avatar_software) || $avatar_software=='jfusion') {
					$avatarSrc = $this->getAvatar($userid);
                } elseif(!empty($userlookup)) {
                	$avatarSrc = JFusionFunction::getAltAvatar($avatar_software,$userlookup->id);
                }

				if(empty($avatarSrc)) {
					$avatarSrc = JFusionFunction::getJoomlaURL().'components/com_jfusion/images/noavatar.png';
				}

				$size = @getimagesize($avatar);
				$maxheight = $dbparams->get('avatar_height',80);
				$maxwidth = $dbparams->get('avatar_width',60);
	            //size the avatar to fit inside the dimensions if larger
				if($size!==false && ($size[0] > $maxwidth || $size[1] > $maxheight)) {
					$wscale = $maxwidth/$size[0];
					$hscale = $maxheight/$size[1];
					$scale = min($hscale, $wscale);
					$w = floor($scale*$size[0]);
					$h = floor($scale*$size[1]);
				}
				elseif($size!==false) {
					//the avatar is within the limits
					$w = $size[0];
					$h = $size[1];
				} else {
					//getimagesize failed
					$w = $maxwidth;
					$h = $maxheight;
				}

				$avatar = "<div class='{$css["userAvatar"]}'><img height='$h' width='$w' src='$avatarSrc'></div>";
			} else {
				$avatar = "";
			}
			$table .= $avatar;

			//post title
			$urlstring_pre = JFusionFunction::routeURL($this->getPostURL($threadid,$postid), $itemid);
			$title = '<a href="'. $urlstring_pre . '">'. $posttitle .'</a>';
			$table .= "<div class = '{$css["postTitle"]}'>{$title}</div>\n";

			//user info
			if ($showuser)
			{
				if ($userlink && empty($guest) && !empty($userlookup)) {
					if(!empty($link_software) && $link_software != 'jfusion' && $link_software!='custom') {
						$user_url = JFusionFunction::getAltProfileURL($link_software,$userlookup->id);
					} elseif ($link_software=='custom' && !empty($userlink_custom)) {
						$user_url =  $userlink_custom.$userlookup->id;
					} else {
						$user_url = false;
					}

					if($user_url === false) {
						$user_url = JFusionFunction::routeURL($this->getProfileURL($userid), $itemid);
					}
					$user = '<a href="'. $user_url . '">'.$username.'</a>';
				} elseif(!empty($guest)) {
					$user = "$username (".JText::_('GUEST').")";
				} else {
					$user = $username;
				}

				$table .= "<div class='{$css["postUser"]}'> ".JText::_('BY')." $user</div>";
			}

			//post date
			if($showdate){
				jimport('joomla.utilities.date');
				$JDate =  new JDate($dateline);
				$JDate->setOffset($tz_offset);
				$date = $JDate->toFormat($date_format);
				$table .= "<div class='{$css["postDate"]}'>".$date."</div>";
			}

			//post body
			$text = $this->prepareText($posttext,true);

			//apply the post body limit if there is one
			if(!empty($body_limit) && strlen($text) > $body_limit) {
				$text = substr($text,0,$body_limit) . '...';
			}

			$table .= "<div class='{$css["postText"]}'>{$text}</div> \n";
			$table .= "</div>";
		}

		return $table;
	}

	/**
     * Retrieves the posts to be displayed in the content item if enabled
     * @param object with discussion bot parameters
     * @param object with forumid, threadid, and postid (first post in thread)
     * @return array or object Returns retrieved posts
     */
	function getPosts(&$params, &$existingthread)
	{
		return array();
	}

	/**
	 * Returns the total number of posts in a thread
     * @param object with forumid, threadid, and postid (first post in thread)
	 * @return int
	 */
	function getReplyCount(&$existingthread)
	{
		return 0;
	}

	/**
	 * Returns HTML of a quick reply
	 * @param $dbparams object with discussion bot parameters
	 * @param boolean $showGuestInputs toggles whether to show guest inputs or not
	 * @return string of html
	 */
	function createQuickReply(&$dbparams,$showGuestInputs)
	{
	   	$html  = "<textarea name='quickReply' class='inputbox'></textarea><br>";
	   	$html .= "<div style='width:100%; text-align:right;'><input type='submit' value='Submit'/></div>";
	   	return $html;
	}

	/**
	 * Creates a post from the quick reply
	 * @param object with discussion bot parameters
	 * @param $ids array with forum id ($ids["forumid"], thread id ($ids["threadid"]) and first post id ($ids["postid"])
	 * @param $contentitem object of content item
	 * @param $userinfo object info of the forum user
	 * @return array with status
	 */
	function createPost(&$params, &$ids, &$contentitem, &$userinfo)
	{
		$status = array();
		$status["error"] = false;
		return $status;
	}
}