<?php
/**
* @package JFusion
* @subpackage Modules
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/


/**
* @package JFusion
* @subpackage Modules
*/
class modjfusionActivityHelper {
	function renderPluginAuto($jname, $config, $params) {
		//now check to see if the plugin is configured
	    $jdb =& JFactory::getDBO();
	    $query = 'SELECT status from #__jfusion WHERE name = ' . $jdb->Quote($jname);
	    $jdb->setQuery($query );
	    $config['selected_forums'] = $params->get('selected_forums_'.$jname);

	    if ($jdb->loadResult() == 1) {

	        $forum = JFusionFactory::getForum($jname);
	        $db = JFusionFactory::getDatabase($jname);

	        if (JError::isError($db)) {
	            return JText::_('NO_DATABASE');
	        } else {
	            if ($config['forum_mode'] == 0 || empty($config['selected_forums'])) {
	                $selectedforumssql = "";
	            } else if (is_array($config['selected_forums'])) {
	                $selectedforumssql = implode(",", $config['selected_forums']);
	            } else {
	                $selectedforumssql = $config['selected_forums'];
	            }

	            //define some other JFusion specific parameters
	            $query = $forum->getActivityQuery($selectedforumssql, $config['result_order'], $config['result_limit']);

	            // load
	            if($config['mode']==LAT) {
	            	$db->setQuery($query[$config['mode'].$config['lat_mode']]);
	            } else {
	            	$db->setQuery($query[$config['mode']]);
	            }

	            $result = $db->loadObjectList();
	            if($config['debug']) {
	            	$resultBeforeFiltering = $result;
	            }
				$forum->filterActivityResults($result, $config['result_limit']);
	            //reorder the keys for the for loop
	            if(is_array($result)) {
	            	$result = array_values($result);
	            }
	            if ($config['debug']) {
	            	$queryMode = ($config['mode']==LAT) ? $config['mode'].$config['lat_mode'] : $config['mode'];
	                $debug  = 'Query mode: ' . $queryMode . '<br><br>';
					$sqlQuery = ($config['mode']==LAT) ? $query[$config['mode'].$config['lat_mode']] : $query[$config['mode']];
					$debug .= 'SQL Query: ' . $sqlQuery .'<br><br>';
	                $debug .= 'Error: ' . $db->stderr() . '<br><br>';
	                $debug .= "Results Before Filtering:<br><pre>".print_r($resultBeforeFiltering,true).'</pre><br><br>';
	                $debug .= "Results After Filtering:<br><pre>".print_r($result,true).'</pre><br><br>';
	                die($debug);
	            } else {

	                // fire
	                if (JError::isError($db)) {
	                    return $db->stderr();
	                } else if (!$result) {
	                    return JText::_('NO_POSTS');
	                } else {
						$output = "<ul>";
	                    // process result
	                    for ($i=0; $i<count($result); $i++) {
	                        $user = "";

							//cleanup the strings for output
			                $safeHtmlFilter = & JFilterInput::getInstance(null, null, 1, 1);
			                foreach ($result[$i] as $key => $value){
				            	$result[$i]->$key =  $safeHtmlFilter->clean($value, gettype($value));
				            }

				            //get the Joomla userid
				            $userlookup = JFusionFunction::lookupUser($jname, $result[$i]->userid, false, $result[$i]->username);

				            //get the avatar of the logged in user
				            if ($config['avatar']) {
				            	// retrieve avatar
			    	            $avatarSrc =& $config['avatar_software'];
			    	            if($jname!='joomla_int' && $jname!='joomla_ext' && ($avatarSrc=='' || $avatarSrc=='jfusion')) {
			    	            	$avatar = $forum->getAvatar($result[$i]->userid);
			    	            } elseif(!empty($avatarSrc) && $avatarSrc!='jfusion' && !empty($userlookup)) {
			    	            	$avatar = JFusionFunction::getAltAvatar($avatarSrc, $userlookup->id );
			    	            }

								if(empty($avatar)) {
									$avatar = JFusionFunction::getJoomlaURL().'components/com_jfusion/images/noavatar.png';
								}

								$size = @getimagesize($avatar);
								$maxheight = $config['avatar_height'];
								$maxwidth = $config['avatar_width'];

								//size the avatar to fit inside the dimensions if larger
								if($size!==false && ($size[0] > $maxwidth || $size[1] > $maxheight)) {
									$wscale = $maxwidth/$size[0];
									$hscale = $maxheight/$size[1];
									$scale = min($hscale, $wscale);
									$w = floor($scale*$size[0]);
									$h = floor($scale*$size[1]);
								}
								elseif($size!==false) {
									//the avatar is within the limits
									$w = $size[0];
									$h = $size[1];
								} else {
									//getimagesize failed
									$w = $maxwidth;
									$h = $maxheight;
								}

								$avatar = "<img style='vertical-align:middle; float:left; margin:3px;' src='$avatar' height='{$h}' width='{$w}' alt='avatar' />";
				            } else {
				            	$avatar = '';
				            }


				            //process user info
	                        if ($config['showuser']) {
	                            if ($config['userlink'] && empty($result[$i]->guest)) {
	                            	if($config['userlink_software']!='' && $config['userlink_software'] != 'jfusion' && $config["userlink_software"]!='custom' && !empty($userlookup)) {
	                            		$user_url = JFusionFunction::getAltProfileURL($config['userlink_software'], $userlookup->id);
	                            	} elseif ($config['userlink_software']=='custom' && !empty($config['userlink_custom'])  && !empty($userlookup)) {
										$user_url = $config['userlink_custom'].$userlookup->id;
									} else {
	                            		$user_url = false;
	                            	}

	                            	if($user_url === false) {
	                            		$user_url = JFusionFunction::routeURL($forum->getProfileURL($result[$i]->userid, $result[$i]->username), $config['itemid']);
	                            	}

									$user = '<a href="'. $user_url . '" target="' . $config['new_window'] . '">'.$result[$i]->username.'</a>';
	                            } elseif(!empty($result[$i]->guest)) {
	                            	$user = $result[$i]->username . " (".JText::_('GUEST').")";
	                            } else {
									$user = $result[$i]->username;
	                            }
	                            $user = " - <b>".$user."</b> ";
	                        }

	                        //process date info
	                        if($config['showdate']) {
	                        	jimport('joomla.utilities.date');
	                        	$JDate =  new JDate($result[$i]->dateline);
	                        	$JDate->setOffset($config['tz_offset']);
	                        	$date = $JDate->toFormat($config['date_format']);
	                        } else {
	                        	$date = '';
	                        }

	                        //process subject or body info
	                        $subject = (($config['replace_subject'] == 0 && empty($result[$i]->subject)) || $config['replace_subject'] == 1) ? $result[$i]->body : $result[$i]->subject;

	                        //make sure that a message is always shown
							if (empty($subject)) {
								$subject = JText::_('NO_SUBJECT');
							} elseif (strlen($subject) > $config['display_limit_subject']) {
								//we need to shorten the subject
								$subject = substr($subject,0,$config['display_limit_subject']) . '...';
							}

	                        //combine all info into an urlstring
	                        if ($config['linktype'] == LINKPOST) {
								$urlstring_pre = JFusionFunction::routeURL($forum->getPostURL($result[$i]->threadid, $result[$i]->postid), $config['itemid']);
	    	                    $urlstring = '<a href="'. $urlstring_pre . '" target="' . $config['new_window'] . '">'. $subject.'</a>';
	                        } else {
	                        	$urlstring_pre = JFusionFunction::routeURL($forum->getThreadURL($result[$i]->threadid), $config['itemid']);
	                        	$urlstring = '<a href="'. $urlstring_pre . '" target="' . $config['new_window'] . '">' .$subject.'</a>';
	                        }

	                        if($config['mode'] == LAT) {
	                        	if($config['show_reply_num']) {
		                        	$existingthread = $forum->getThread($result[$i]->threadid);
		                        	$count = (!empty($existingthread)) ? $forum->getReplyCount($existingthread) : 0;
		                        	$post = ($count==1) ? "REPLY" : "REPLIES";
		                        	$body = " [$count ".JText::_($post)."]";
	                        	} else {
	                        		$body = "";
	                        	}
	                        } else {
	                        	//gotta make it presentable
	                        	if($config['display_body']==1){
	                        		$body = strip_tags($forum->prepareText($result[$i]->body,true));
	                        		if(!empty($config['display_limit']) && strlen($body) > $config['display_limit']) {
	                        			$body = substr($body,0,$config['display_limit']) . '...';
	                        		}
	                        		$body = " - " . $body;
	                        	} else {
	                        		$body = "";
	                        	}
	                        }

	                        //put it all together for output
	                        //prevents the images from cascading
	                        $liStyle = (!empty($avatar)) ? ' style="clear:left;"' : '';
	                        $output .= '<li'.$liStyle.'>'.$avatar.'<i>'. $urlstring . '</i><b>'.$user.'</b>'.$date.$body.'</li>';

	                    }
	                $output .= "</ul>";
					return $output;
	                }
	            }
	        }
	    } else {
	        return JText::_('NOT_CONFIGURED');
	    }
	}

	function renderPluginMode($jname, $config, $view, $pluginParam) {
		$forum = JFusionFactory::getForum($jname);
		if(method_exists($forum, "renderActivityModule")) {
			return $forum->renderActivityModule($config, $view, $pluginParam);
		}
		return JText::_('NOT_IMPLEMENTED_YET');
	}
}
?>
