<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredit$ 1.1 - `credits_payments.php`							   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: John Jakubowski "Darkwaltz4" {blackwaltz4@msn.com}		   # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #                Support: http://www.vbcredits.com/				   # ||
|| ##################################################################### ||
\*=======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'credits_payments');
define('SKIP_SESSIONCREATE', 1);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('subscription');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
define('VB_AREA', 'Subscriptions');
define('CWD', (($getcwd = getcwd()) ? $getcwd : '.'));

require_once(CWD . '/includes/init.php');
require_once(DIR . '/includes/adminfunctions.php');
require_once(DIR . '/includes/class_paid_subscription.php');

$vbulletin->input->clean_array_gpc('r', array(
	'method'    => TYPE_STR
));

$vbulletin->nozip = true;
$api = $db->query_first_slave("SELECT * FROM " . TABLE_PREFIX . "paymentapi WHERE classname = '" . $db->escape_string($vbulletin->GPC['method']) . "'");

if (!empty($api) AND $vbulletin->GPC['method'] == 'paypal')
{
	$subobj = new vB_PaidSubscription($vbulletin);
	if (file_exists(DIR . '/includes/paymentapi/class_' . $api['classname'] . '.php'))
	{
		require_once(DIR . '/includes/paymentapi/class_' . $api['classname'] . '.php');
		$api_class = 'vB_PaidSubscriptionMethod_' . $api['classname'];
		$apiobj = new $api_class($vbulletin);

		// at this point we know if the system is going to want to display feedback, so do the appropriate queries here
		if ($apiobj->display_feedback)
		{
			// initialize $vbphrase and set language constants
			$vbphrase = init_language();

			$vbulletin->userinfo['styleid'] = $vbulletin->options['styleid'];
			$style = $db->query_first_slave("
				SELECT *
				FROM " . TABLE_PREFIX . "style
				WHERE styleid = " . intval($vbulletin->options['styleid'])
			);
			define('STYLEID', $style['styleid']);

			cache_templates(array('STANDARD_REDIRECT', 'STANDARD_ERROR', 'STANDARD_ERROR_LITE', 'headinclude'), $style['templatelist']);
			$stylevar = fetch_stylevars($style, $vbulletin->userinfo);
			$headinclude = '<base href="' . $vbulletin->options['bburl'] . '/" />';
			eval('$headinclude .= "' . fetch_template('headinclude') . '";');
		}

		if (!empty($api['settings']))
		{ // need to convert this from a serialized array with types to a single value
			$apiobj->settings = $subobj->construct_payment_settings($api['settings']);
		}

		if (verify_payment())
		{
			// its a valid payment now lets check transactionid
			$transaction = $db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "paymenttransaction
				WHERE transactionid = '" . $db->escape_string($apiobj->transaction_id) . "'
					AND paymentapiid = $api[paymentapiid]
			");

			if (($apiobj->type == 2 OR (empty($transaction) AND $apiobj->type == 1)) AND $vbulletin->options['paymentemail'])
			{
				if (!$vbphrase)
				{
					// initialize $vbphrase and set language constants
					$vbphrase = init_language();
				}

				$emailphrase = ($apiobj->type == 2) ? 'payment_reversed' : 'payment_received';
				$emails = explode(' ', $vbulletin->options['paymentemail']);

				$username = unhtmlspecialchars($apiobj->paymentinfo['username']);
				$userid = $apiobj->paymentinfo['userid'];
				$subscription = $vbphrase['purchase'] . ' ' . $vbphrase['credits'];
				$amount = vb_number_format($apiobj->paymentinfo['amount'], 2) . ' ' . strtoupper($apiobj->paymentinfo['currency']);
				$processor = $api['title'];
				$transactionid = $apiobj->transaction_id;

				eval(fetch_email_phrases($emailphrase, 0));
				foreach($emails AS $toemail)
				{
					if (trim($toemail))
					{
						vbmail($toemail, $subject, $message, true);
					}
				}
			}

			if (empty($transaction))
			{ // transaction hasn't been processed before
				/*insert query*/
				$trans = array(
					'transactionid' => $apiobj->transaction_id,
					'paymentinfoid' => $apiobj->paymentinfo['paymentinfoid'],
					'amount'        => $apiobj->paymentinfo['amount'],
					'currency'      => $apiobj->paymentinfo['currency'],
					'state'         => $apiobj->type,
					'dateline'      => TIMENOW,
					'paymentapiid'  => $api['paymentapiid'],
				);

				$db->query_write(fetch_query_sql($trans, 'paymenttransaction'));

				if ($apiobj->type == 1)
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + " . $apiobj->paymentinfo['credits'] . " WHERE userid = " . $apiobj->paymentinfo['userid']);
					$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (touserid, action, amount, timestamp) VALUES (" . $apiobj->paymentinfo['userid'] . ", 'purchase', " . $apiobj->paymentinfo['credits'] . ", " . TIMENOW . ")");

					if ($apiobj->display_feedback)
					{
						$vbulletin->url = $vbulletin->options['bburl'] . '/payments.php';
						eval(print_standard_redirect('payment_complete', true, true));
					}
				}
				else if ($apiobj->type == 2)
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits - " . $apiobj->paymentinfo['credits'] . " WHERE userid = " . $apiobj->paymentinfo['userid']);
				}
			}
			else if ($apiobj->type == 2)
			{ // transaction is a reversal / refund
					$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits - " . $apiobj->paymentinfo['credits'] . " WHERE userid = " . $apiobj->paymentinfo['userid']);
			}
			else if ($apiobj->display_feedback)
			{ // its most likely a re-post of a payment, if we've already dealt with it serve up a redirect
				$vbulletin->url = $vbulletin->options['bburl'] . '/payments.php';
				eval(print_standard_redirect('payment_complete', true, true));
			}
		}
		else
		{ // something went horribly wrong, get $apiobj->error
			$trans = array(
				'state'         => 0,
				'dateline'      => TIMENOW,
				'paymentapiid'  => $api['paymentapiid'],
				'request'       => serialize(array(
					'GET' => serialize($_GET),
					'POST' => serialize($_POST)
				)),
			);
			$db->query_write(fetch_query_sql($trans, 'paymenttransaction'));
			if ($apiobj->display_feedback AND !empty($apiobj->error))
			{
				//die("<p>{$apiobj->error}</p>");
				// we dont load header / footer, so just show the LITE template
				define('VB_ERROR_LITE', true);
				standard_error($apiobj->error);
			}
		}
	}
}
else
{
	exec_header_redirect($vbulletin->options['forumhome'] . '.php');
}

function verify_payment()
{
	global $vbulletin, $apiobj;
	// Leave all of these values as TYPE_STR since we have to send them back to paypal exactly how we received them!
	$vbulletin->input->clean_array_gpc('p', array(
		'item_number'    => TYPE_STR,
		'business'       => TYPE_STR,
		'receiver_email' => TYPE_STR,
		'tax'            => TYPE_STR,
		'txn_type'       => TYPE_STR,
		'payment_status' => TYPE_STR,
		'mc_currency'    => TYPE_STR,
		'mc_gross'       => TYPE_STR,
		'txn_id'         => TYPE_STR
	));

	$apiobj->transaction_id = $vbulletin->GPC['txn_id'];

	$mc_gross = doubleval($vbulletin->GPC['mc_gross']);
	$tax = doubleval($vbulletin->GPC['tax']);

	$query[] = 'cmd=_notify-validate';
	foreach($_POST AS $key => $val)
	{
		if (!empty($val))
		{
			$query[] = $key . '=' . urlencode ($val);
		}
	}
	$query = implode('&', $query);

	$used_curl = false;

	if (function_exists('curl_init') AND $ch = curl_init())
	{
		curl_setopt($ch, CURLOPT_URL, 'http://www.paypal.com/cgi-bin/webscr');
		curl_setopt($ch, CURLOPT_TIMEOUT, 15);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDSIZE, 0);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $query);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_USERAGENT, 'vBulletin via cURL/PHP');

		$result = curl_exec($ch);
		curl_close($ch);
		if ($result !== false)
		{
			$used_curl = true;
		}
	}
	if (!$used_curl)
	{
		$header = "POST /cgi-bin/webscr HTTP/1.0\r\n";
		$header .= "Host: www.paypal.com\r\n";
		$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
		$header .= "Content-Length: " . strlen($query) . "\r\n\r\n";
		if ($fp = fsockopen('www.paypal.com', 80, $errno, $errstr, 15))
		{
			socket_set_timeout($fp, 15);
			fwrite($fp, $header . $query);
			while (!feof($fp))
			{
				$result = fgets($fp, 1024);
				if (strcmp($result, 'VERIFIED') == 0)
				{
					break;
				}
			}
			fclose($fp);
		}
	}

	if ($result == 'VERIFIED' AND (strtolower($vbulletin->GPC['business']) == strtolower($apiobj->settings['ppemail']) OR strtolower($vbulletin->GPC['receiver_email']) == strtolower($apiobj->settings['primaryemail'])))
	{
		$apiobj->paymentinfo = $vbulletin->db->query_first("
			SELECT paymentinfo.*, user.username
			FROM " . TABLE_PREFIX . "paymentinfo AS paymentinfo
			INNER JOIN " . TABLE_PREFIX . "user AS user USING (userid)
			WHERE hash = '" . $vbulletin->db->escape_string($vbulletin->GPC['item_number']) . "'
		");
		
		$cost = unserialize($apiobj->paymentinfo['credits']);
		$apiobj->paymentinfo['credits'] = $cost[1];
		
		if ($tax > 0)
		{
			$mc_gross -= $tax;
		}

		// lets check the values
		if (!empty($apiobj->paymentinfo))
		{
			$apiobj->paymentinfo['currency'] = strtolower($vbulletin->GPC['mc_currency']);
			$apiobj->paymentinfo['amount'] = floatval($vbulletin->GPC['mc_gross']);
			// Check if its a payment or if its a reversal
			if (($vbulletin->GPC['txn_type'] == 'web_accept' OR $vbulletin->GPC['txn_type'] == 'subscr_payment') AND $vbulletin->GPC['payment_status'] == 'Completed' AND $mc_gross == $cost[0])
			{
				$apiobj->type = 1;
			}
			else if ($vbulletin->GPC['payment_status'] == 'Reversed' OR $vbulletin->GPC['payment_status'] == 'Refunded')
			{
				$apiobj->type = 2;
			}
		}

		// Paypal likes to get told its message has been received
		if (SAPI_NAME == 'cgi' OR SAPI_NAME == 'cgi-fcgi')
		{
			header('Status: 200 OK');
		}
		else
		{
			header('HTTP/1.1 200 OK');
		}
		return ($apiobj->type > 0);
	}
	else
	{
		$apiobj->error = 'Invalid Request';
	}
	return false;
}
?>