<?php
define('CODE_VERSION','5.0');

if (!ini_get('safe_mode')) set_time_limit(0);

// Error Reporting
error_reporting(E_ALL & ~E_NOTICE);

// Environment
define('NO_REGISTER_GLOBALS', 1);

$phrasegroups = array(
'global',
'calendar',
'holiday',
'timezone',
'posting','commbull');
$globaltemplates = array();
$actiontemplates = array();
$specialtemplates = array();

if (defined('DIR')) {}
else require_once ('./global.php');
require_once(DIR . '/'.$vbulletin->config['Misc']['admincpdir'].'/commbull_functions.php');

$vbulletin->input->clean_gpc('p', 'action', TYPE_STR);
$action = $vbulletin->GPC['action'];

if ($action == 'update')
{
	$commbull_vars = array('mail_subject' => TYPE_STR,
	'email_from' => TYPE_STR,
	'mailsatonce' => TYPE_UINT,
	'auto_nextpage' => TYPE_UINT,
	'auto_timer' => TYPE_NUM,
	'includedate' => TYPE_UINT,
	'fixcss' => TYPE_UINT,
	'ignore_admin' => TYPE_UINT,
	'usevbmailqueue' => TYPE_UINT,
	'fromday' => TYPE_UINT,
	'frommonth' => TYPE_UINT,
	'fromyear' => TYPE_UINT,
	
	'activedays' => TYPE_UINT,
	'include_forum_title' => TYPE_BOOL,

	'numtopics1' => TYPE_UINT,
	'topicorder1' => TYPE_STR,
	'hotonly1' => TYPE_UINT,
	'reuse1' => TYPE_UINT,

	'numtopics2' => TYPE_UINT,
	'topicorder2' => TYPE_STR,
	'hotonly2' => TYPE_UINT,
	'reuse2' => TYPE_UINT,

	'numtopics3' => TYPE_UINT,
	'topicorder3' => TYPE_STR,
	'hotonly3' => TYPE_UINT,
	'reuse3' => TYPE_UINT,

	'numtopics4' => TYPE_UINT,
	'topicorder4' => TYPE_STR,
	'hotonly4' => TYPE_UINT,

	'post_character_count' => TYPE_UINT,
	'numpolls' => TYPE_UINT,
	'calendar' => TYPE_ARRAY_BOOL,
	'numevents' => TYPE_UINT,
	'numbirthdays' => TYPE_UINT,
	'dostats'	=> TYPE_BOOL,
	'douserinfo' => TYPE_STR,
	'sc' => TYPE_STR,
	'rsc' => TYPE_UINT,
	'lic' => TYPE_STR,
	'forum' => TYPE_ARRAY_BOOL,
	'group' => TYPE_ARRAY_BOOL,
	'newlines' => TYPE_UINT,
	'extramaterial' => TYPE_STR,
	'referal_tag' => TYPE_STR,
	'mailheaders' => TYPE_STR,
	'postcopy' => TYPE_UINT,
	'pfid' => TYPE_UINT,
	'pftype' => TYPE_UINT,
	'pcu' => TYPE_STR,
	'open' => TYPE_UINT);

	$vbulletin->input->clean_array_gpc('p', $commbull_vars);

	$commbull = array();

	foreach ($commbull_vars AS $key => $val)  {  $commbull[$key] = $vbulletin->GPC[$key];  }

	$sql = "SELECT title FROM ".TABLE_PREFIX."datastore WHERE title = 'commbull'";
	$result = $db->query_read($sql);

	if ($db->num_rows($result))
	{
		$sql = "UPDATE ".TABLE_PREFIX."datastore SET data = '".$db->escape_string(serialize($commbull))."', unserialize=1
			WHERE title = 'commbull'";
	}
	else
	{
		if (SIMPLE_VERSION > 355)
		{
			$sql = "INSERT INTO ".TABLE_PREFIX."datastore
			 (title, data, unserialize)
			 VALUES ('commbull','".$db->escape_string(serialize($commbull))."', 1)";
		}
		else
		{
			$sql = "INSERT INTO ".TABLE_PREFIX."datastore
			 (title, data)
			 VALUES ('commbull','".$db->escape_string(serialize($commbull))."')";
		}
	}

	$db->query_write($sql);

	exec_header_redirect('commbull_settings.php');
	exit;
} // update settings

$maintitle = "<b>Community Bulletin Email Generator</b> version ".CODE_VERSION." <br />";

print_cp_header();

$commbull = commbull_get_settings();
$commbull['lastsent'] = commbull_get_last_sent($commbull);

/*
$commbull['dateset'] = mktime(0,0,0,$commbull['frommonth'],$commbull['fromday'],$commbull['fromyear']);

if ($commbull['lastsent'] > $commbull['dateset'])
{
	$commbull['frommonth'] = date('m',$commbull['lastsent']);
	$commbull['fromday'] = date('d',$commbull['lastsent']);
	$commbull['fromyear'] = date('Y',$commbull['lastsent']);
}*/


if ($action == '')
{

	echo <<< TEOL
<script language="JavaScript">
function altervalue(theinput,thevalue)
{
	oldvalue = parseInt(theinput.value);
	theinput.value = oldvalue+thevalue;
}
</script>
<style>
.inputplus {FONT-WEIGHT:bold}
</style>
$maintitle

TEOL;

	echo "<hr>$vbphrase[lastsent] ".vbdate($vbulletin->options['dateformat'],$commbull['lastsent']);

	// this constructs a hidden value 'do' ... we are using action ...
	print_form_header('commbull_settings','update');
	construct_hidden_code('action','update');

	print_input_row($vbphrase['subject'],'mail_subject',(isset($commbull['mail_subject']) ? $commbull['mail_subject'] : $vbulletin->options['bbtitle']),0,50);
	print_input_row($vbphrase['email_from'],'email_from',(isset($commbull['email_from']) ? $commbull['email_from'] : $vbulletin->options['webmasteremail']),0);
	print_input_row($vbphrase['referal_tag'],'referal_tag',(isset($commbull['referal_tag']) ? $commbull['referal_tag'] : ''),true,50);
	makeinputplus($vbphrase['activedays'],'activedays',isset($commbull['activedays'])?$commbull['activedays']:0,4);

	print_input_row($vbphrase['mailatonce'],'mailsatonce',(isset($commbull['mailsatonce']) ? $commbull['mailsatonce'] : 300),true,10);
	print_table_header($vbphrase['auto_nextpage_title']);
	print_yes_no_row($vbphrase['auto_nextpage'],'auto_nextpage',(isset($commbull['auto_nextpage']) ? $commbull['auto_nextpage'] : 0));
	print_input_row($vbphrase['auto_timer'],'auto_timer',(isset($commbull['auto_timer']) ? $commbull['auto_timer'] : 1),0,5);

	echo "<tr>
	<td class=alt1><p>$vbphrase[showstartinfo]:</p></td>\n<td class=alt1>
	  <table><tr>
	  <td class=alt1><font size='1'>$vbphrase[day]</td>
	  <td class=alt1><font size='1'>$vbphrase[month]</td>
	  <td class=alt1><font size='1'>$vbphrase[year]</td>
	  </tr>\n<tr>
	  <td class=alt1><select name='fromday'>".makedateselect(1,31,isset($commbull['fromday']) ? $commbull['fromday'] : date('d',$commbull['lastsent']))."</select></td>
	  <td class=alt1><select name='frommonth'>".makedateselect(1,12,isset($commbull['frommonth']) ? $commbull['frommonth'] : date('m',$commbull['lastsent']))."</select></td>
	  <td class=alt1><select name='fromyear'>".makedateselect(1999,date('Y'),isset($commbull['fromyear']) ? $commbull['fromyear'] : date('Y',$commbull['lastsent']))."</select></td></tr>
	  </table>
	</td></tr>";

	print_table_header($vbphrase['itemstoinclude']);

	// only include threads that have been started or replied to since this date
	print_yes_no_row("$vbphrase[threadsstarted]<br /><font size='1'>$vbphrase[threadstarted_note]",'includedate',(isset($commbull['includedate']) ? $commbull['includedate'] : 0));
	$n=1;
	print_yes_no_row($vbphrase['url2css'] ,'fixcss',(isset($commbull['fixcss']) ? $commbull['fixcss'] : 0));
	print_yes_no_row("$vbphrase[ignore_admin]<br /><font size='1'>$vbphrase[ignore_admin_note]",'ignore_admin',(isset($commbull['ignore_admin']) ? $commbull['ignore_admin'] : 0));
	#print_yes_no_row($vbphrase['usevbmailqueue'].($vbulletin->options['usemailqueue'] == 0 ? '<br /><font size="1" style="color:#000000; font-weight:bold;">'.$vbphrase['usevbmailqueue_note'].'</font>':''),'usevbmailqueue',(isset($commbull['usevbmailqueue']) ? $commbull['usevbmailqueue'] : 0));
	construct_hidden_code('usevbmailqueue',1);

	print_table_break();
	print_table_header($vbphrase['threadsblock']. "$n");
	makeinputplus("$vbphrase[numthreads]:<br /><font size='1'>$vbphrase[disable]","numtopics$n",(isset($commbull['numtopics1']) ? $commbull['numtopics1'] : 5),3);
	makeordercode($n,$commbull['topicorder1']);
	print_yes_no_row($vbphrase['hotthreads'].'?',"hotonly$n",(isset($commbull['hotonly1']) ? $commbull['hotonly1'] : 0));
	print_yes_no_row($vbphrase['reusethreads'].'?',"reuse$n",(isset($commbull['reuse1']) ? $commbull['reuse1'] : 0));

	$n=2;
	print_table_break();
	print_table_header($vbphrase['threadsblock']. "$n");
	makeinputplus("$vbphrase[numthreads]:<br /><font size='1'>$vbphrase[disable]","numtopics$n",(isset($commbull['numtopics2']) ? $commbull['numtopics2'] : 5),3);
	makeordercode($n,$commbull['topicorder2']);
	print_yes_no_row($vbphrase['hotthreads'].'?',"hotonly$n",(isset($commbull['hotonly2']) ? $commbull['hotonly2'] : 0));
	print_yes_no_row($vbphrase['reusethreads'].'?',"reuse$n",(isset($commbull['reuse2']) ? $commbull['reuse2'] : 0));

	$n=3;
	print_table_break();
	print_table_header($vbphrase['threadsblock']. "$n");
	makeinputplus("$vbphrase[numthreads]:<br /><font size='1'>$vbphrase[disable]","numtopics$n",(isset($commbull['numtopics3']) ? $commbull['numtopics3'] : 5),3);
	makeordercode($n,$commbull['topicorder3']);
	print_yes_no_row($vbphrase['hotthreads'].'?',"hotonly$n",(isset($commbull['hotonly3']) ? $commbull['hotonly3'] : 0));
	print_yes_no_row($vbphrase['reusethreads'].'?',"reuse$n",(isset($commbull['reuse3']) ? $commbull['reuse3'] : 0));

	$n=4;
	print_table_break();
	print_table_header($vbphrase['threadsblock']. "$n");
	makeinputplus("$vbphrase[numthreads]:<br /><font size='1'>$vbphrase[disable]","numtopics$n",(isset($commbull['numtopics4']) ? $commbull['numtopics4'] : 0),3);
	makeordercode($n,$commbull['topicorder4']);
	print_yes_no_row($vbphrase['hotthreads'].'?',"hotonly$n",(isset($commbull['hotonly4']) ? $commbull['hotonly4'] : 0));

	print_table_break();
	print_table_header($vbphrase['post_count']);
	makeinputplus($vbphrase['post_character_count'],'post_character_count',isset($commbull['post_character_count']) ? $commbull['post_character_count'] : 80,3);
	print_yes_no_row($vbphrase['include_forum_title'],'include_forum_title',isset($commbull['include_forum_title'])?$commbull['include_forum_title']:0);

	print_table_break();
	print_table_header($vbphrase['polls']);
	makeinputplus("$vbphrase[numpolls]:<br /><font size='1'>$vbphrase[disable]",'numpolls',(isset($commbull['numpolls']) ? $commbull['numpolls'] : 5),3);

	print_table_break();

	print_table_header($vbphrase['events']);
	print_label_row("<b>$vbphrase[calendarinfo]:</b>",'&nbsp;');

	$calendars = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "calendar WHERE 1");
	while($calendar = $db->fetch_array($calendars))
	{
		$titleval = "<b>$calendar[title]</b>";
		print_yes_no_row($titleval,'calendar['.$calendar['calendarid'].']',(isset($commbull['calendar'][$calendar['calendarid']]) ? $commbull['calendar'][$calendar['calendarid']] : 1));
	}

	//makeinputplus("$vbphrase[calendarid]:<br /><font size='1'>$vbphrase[disable]","calendarid",(isset($calendarid) ? $calendarid : 1),3);
	makeinputplus("$vbphrase[numevents]:<br /><font size='1'>$vbphrase[disable]",'numevents',(isset($commbull['numevents']) ? $commbull['numevents'] : 10),3);
	makeinputplus("$vbphrase[numbdays]:<br /><font size='1'>$vbphrase[disable]",'numbirthdays',(isset($commbull['numbirthdays']) ? $commbull['numbirthdays'] : 10),3);

	print_table_break();
	print_table_header($vbphrase['otherinfo']);
	print_yes_no_row($vbphrase['lateststats'].'?','dostats',(isset($commbull['dostats']) ? $commbull['dostats'] : 1));
	print_yes_no_row($vbphrase['includeuserinfo'].'?','douserinfo',(isset($commbull['douserinfo']) ? $commbull['douserinfo'] : 1));

	print_table_break();
	print_table_header($vbphrase['layout']);
	print_input_row($vbphrase['sectionsep'],'sc',(isset($commbull['sc']) ? $commbull['sc'] : '-'),0,5);
	print_input_row($vbphrase['repeatchar'],'rsc',(isset($commbull['rsc']) ? $commbull['rsc'] : 75),0,5);
	print_input_row($vbphrase['listchar']."<br /><font size='1'>$vbphrase[someideas]<br />        > +",'lic',(isset($commbull['lic']) ? $commbull['lic'] : 'o'),0,5);

	print_table_break();
	print_table_header($vbphrase['includeforuminfo']);
	print_label_row("<b>$vbphrase[followingforuminfo]:</b>",'&nbsp;');

	require_once(DIR . '/includes/functions_forumlist.php');
	require_once(DIR . '/includes/functions_databuild.php');
	//cache_forums();

	//build_forum_permissions(1);
	cache_ordered_forums(1);

	$forums = array();
	if (is_array($vbulletin->forumcache))
	{
		foreach($vbulletin->forumcache AS $forumid => $forum)
		{

			$forums["$forum[forumid]"] = construct_depth_mark($forum['depth'], '--') . ' ' . $forum['title'];
			if ($forum['parentid'] == -1)
			{
				print_cells_row(array($vbphrase['title'], ''),1,'tcat');
			}

			$titleval = "<b>" . construct_depth_mark($forum['depth'],'- - ') . "$forum[title]</b>";
			print_yes_no_row($titleval,'forum['.$forum['forumid'].']',(isset($commbull['forum'][$forum['forumid']]) ? $commbull['forum'][$forum['forumid']] : 1));
		}
		reset($vbulletin->iforumcache);
	}
	print_table_break();

	print_table_header($vbphrase['mailusers']);
	print_label_row("<b>$vbphrase[sendusers]:</b>",'&nbsp;');
	$groups = $db->query_read("SELECT usergroupid AS id,title FROM " . TABLE_PREFIX . "usergroup");
	while ($group = $db->fetch_array($groups)) { print_yes_no_row($group['title'],"group[$group[id]]",(isset($commbull['group'][$group['id']]) ? $commbull['group'][$group['id']] : 1)); }

	print_table_break();
	print_table_header($vbphrase['extramaterial_title']);
	print_yes_no_row($vbphrase['newlines'],'newlines',(isset($commbull['newlines']) ? $commbull['newlines'] : 1));
	print_textarea_row($vbphrase['extramaterial'],'extramaterial',$commbull['extramaterial'],10,60);

	print_table_break();
	print_table_header($vbphrase['mailheaders_title']);
	print_textarea_row($vbphrase['mailheaders_desc'],'mailheaders',$commbull['mailheaders'],10,60);

	
	print_table_break();
	print_table_header($vbphrase['postcopy']);
	print_yes_no_row($vbphrase['newthread'],'postcopy',(isset($commbull['postcopy']) ? $commbull['postcopy'] : 0));
	print_input_row($vbphrase['whichforum'],'pfid',(isset($commbull['pfid']) ? $commbull['pfid'] : 0),0,5);
	print_yes_no_row($vbphrase['usehtml'],'pftype',(isset($commbull['pftype']) ? $commbull['pftype'] : 0));
	print_input_row($vbphrase['whichuser'],'pcu',(isset($commbull['pcu']) ? $commbull['pcu'] : 0),0,25);
	print_yes_no_row($vbphrase['whichthread'],'open',(isset($commbull['open']) ? $commbull['open'] : 1));
	print_table_break();

	print_submit_row($vbphrase['update']);
	print_table_footer();

} /// action = ''

print_cp_footer();

?>