<?php

if (!function_exists('html_entity_decode'))
{

	function html_entity_decode ($string, $opt = ENT_COMPAT)
	{

		$trans_tbl = get_html_translation_table (HTML_ENTITIES);
		$trans_tbl = array_flip ($trans_tbl);

		// Translating single quotes
		if ($opt & 1)
		{

			// Add single quote to translation table;
			// doesn't appear to be there by default
			$trans_tbl["&apos;"] = "'";
		}

		// Not translating double quotes
		if (!($opt & 2))
		{

			// Remove double quote from translation table
			unset($trans_tbl["&quot;"]);
		}

		return strtr ($string, $trans_tbl);
	}

	// Just to be safe ;o)
	if (!defined("ENT_COMPAT")) define("ENT_COMPAT", 2);
	if (!defined("ENT_NOQUOTES")) define("ENT_NOQUOTES", 0);
	if (!defined("ENT_QUOTES")) define("ENT_QUOTES", 3);
}

function commbull_get_settings ()
{
	global $db;

	$sql = "SELECT data, unserialize FROM ".TABLE_PREFIX."datastore WHERE title = 'commbull'";
	$commbull_raw = $db->query_first($sql);
	if ($commbull_raw)
	{
		if ($commbull_raw['unserialize']==1) $commbull = unserialize($commbull_raw['data']);
		else
		{
			return commbull_migrate_settings($commbull_raw['data']);
		}
	}
	else $commbull = array();

	return $commbull;
} // commbull_get_settings ()

function commbull_migrate_settings ($datastore)
{
	$newdatastore = str_replace(array('$',' = ','"]\']','def_forum','def_calendar','def_group'),
	array('$commbull[\'','\'] = ','"]','def_forum\']','def_calendar\']','def_group\']'),$datastore);

	eval($newdatastore);
	unset($commbull['frommonth']);
	unset($commbull['fromday']);
	unset($commbull['fromyear']);
	return $commbull;
} // commbull_migrate_settings

function commbull_get_last_sent ()
{
	global $db;
	#if ($datastore['lastsent']) return $datastore['lastsent'];

	#if ($datastore['frommonth'] && $datastore['fromday'] && $datastore['fromyear']) {  return mktime(0,0,0,$datastore['frommonth'],$datastore['fromday'],$datastore['fromyear']);  }

	// get last sent date from adminlog
	$lastsent = $db->query_first("SELECT a.dateline, u.username
	FROM " . TABLE_PREFIX . "adminlog a
	LEFT JOIN " . TABLE_PREFIX . "user u
	USING(userid)
	WHERE script = 'commbull.php' AND action LIKE 'sent bulletin%'
	ORDER BY dateline DESC
	LIMIT 0,1");
	if ($lastsent) return $lastsent['dateline'];

	// get forum creating date
	$lastsent = $db->query_first("SELECT a.dateline, u.username
	FROM " . TABLE_PREFIX . "adminlog a
	LEFT JOIN " . TABLE_PREFIX . "user u
	USING(userid)
	ORDER BY dateline ASC
	LIMIT 0,1");
	if ($lastsent) return $lastsent['dateline'];

	// return current time, as last resort
	return time();
} // commbull_get_last_sent ()

function makeinputplus($title,$name,$value,$size)
{
	global $bgcounter;
	echo "<tr class='".iif($bgcounter++%2==0,"alt1","alt2")."'>\n<td><p>$title</p></td>\n<td><input type='text' name='$name' size='$size' value='$value'>
	<input type='button' value='&laquo;' title='-1' onclick='altervalue(this.form.$name,-1)' class='inputplus'><input type='button' value='0' title='reset to 0' onclick='altervalue(this.form.$name,-(this.form.$name.value))' class='inputplus'><input type='button' value='&raquo;' title='+1' onclick='altervalue(this.form.$name,1)' class='inputplus'></td>\n</tr>\n";
}

function makedateselect($start,$end,$value)
{
	for ($i=$start; $i<=$end; $i++)
	{
		if ($i == $value) { $selected = " selected"; }
		else { unset($selected); }
		$output .= "\t<option value='$i'$selected>$i</option>\n";
	}
	return $output;
}

function makeordercode($n,$match='')
{
	global $bgcounter, $vbphrase;

	$orig = $n;
	if ($match)
	{
		switch ($match)
		{
			case 'dateline' : $n = 1; break;
			case 'replies' : $n = 2; break;
			case 'views' : $n = 3; break;
			case 'virg' : $n = 4; break;
			default : $n = 99;
		}
	}

	echo "<tr class='".iif($bgcounter++%2==0,"alt1","alt2")."'>
	               <td><p>{$vbphrase['getthreads']}:</p></td>\n<td><p><select name='topicorder$orig'>
 	               <option value='dateline' ".($n==1?' selected':'').">{$vbphrase['mostrecent']}</option>
	               <option value='replies' ".($n==2?' selected':'').">{$vbphrase['mostreplies']}</option>
 	               <option value='views' ".($n==3?' selected':'').">{$vbphrase['mostviews']}</option>
                   <option value='virg' ".($n==4?' selected':'').">{$vbphrase['noreplies']}</option>\n";
	echo "</select></p></td></tr>\n";
} // end function ordercode

function checkerror($value,$message)
{
	if (!$value)
	{
		echo "<b>Error!</b> $message<br /><br />".construct_link_code("go back","javascript:history.back(1)");
		exit;
	}
} // end function checkerror

function create_threads ($numtopics, $topicorder, $hotonly, $reuse, $reuse2, &$tid1, $post_character_count=1, $forumids)
{
	global $vbulletin, $datesql, $db, $commbull, $vbphrase;

	if (file_exists(DIR . '/'. $vbulletin->config['Misc']['admincpdir'].'/commbull_template_htmlnew.php')) require(DIR . '/'. $vbulletin->config['Misc']['admincpdir'].'/commbull_template_htmlnew.php');
	else require(DIR . '/'. $vbulletin->config['Misc']['admincpdir'].'/commbull_template_html.php');
	require(DIR . '/'. $vbulletin->config['Misc']['admincpdir'].'/commbull_template_txt.php');

	static $count;

	if (!isset($count)) $count = 1;
	else $count++;

	if ($numtopics)
	{
		switch ($topicorder)
		{
			case "replies": $where = "t.replycount>0 AND"; $orderby = "t.replycount DESC,t.dateline"; $ds2 = 1; $title="$commbull[sc]$commbull[sc] {$vbphrase['withmostreplies']} $commbull[sc]$commbull[sc]"; break;
			case "views": $where = "t.views>1 AND"; $orderby = "t.views DESC,dateline"; $ds2 = 1; $title="$commbull[sc]$commbull[sc] {$vbphrase['withmostviews']} $commbull[sc]$commbull[sc]"; break;
			case "virg": $where = "t.replycount=0 AND"; $orderby = "t.dateline"; $title="$commbull[sc]$commbull[sc] {$vbphrase['withnoreplies']} $commbull[sc]$commbull[sc]"; break;
			case "dateline": $orderby = "t.dateline"; $title="$commbull[sc]$commbull[sc] {$vbphrase['postedmostrecently']} $commbull[sc]$commbull[sc]"; break;
		}
		if ($hotonly) { $hotconds = "(t.replycount>={$vbulletin->options['hotnumberposts']} OR t.views>={$vbulletin->options['hotnumberviews']}) AND"; }
		if (($reuse == 0) && ($tid1)) { $not1 = "AND t.threadid NOT IN($tid1)"; }
		if (($datesql) && ($ds2)) { $datesql2 = $datesql; }

		if ($commbull['include_forum_title'])
		{

			$topicquery = "SELECT t.*, f.title AS forumtitle
		FROM " . TABLE_PREFIX . "thread t, ".TABLE_PREFIX."forum f
		WHERE $hotconds $where t.forumid IN($forumids) $not1 $datesql2 AND t.visible=1 AND t.open != 10 AND f.forumid=t.forumid
		ORDER BY $orderby DESC
		LIMIT 0,$numtopics";
		}
		else
		{
			$topicquery = "SELECT t.*, '' AS forumtitle
		FROM " . TABLE_PREFIX . "thread t
		WHERE $hotconds $where t.forumid IN($forumids) $not1 $datesql2 AND t.visible=1 AND t.open != 10
		ORDER BY $orderby DESC
		LIMIT 0,$numtopics";
		}

		$threads = $db->query_read($topicquery);

		$i = 0;
		if ($db->num_rows($threads))
		{
			eval('$threadspreview = "'.addslashes($threadspreview_start_t).'";');
			eval('$HTML_threadspreview = "'.addslashes($HTML_threadspreview_start_t).'";');

			while ($thread = $db->fetch_array($threads))
			{
				// ignore virgin threads
				if ($post_character_count)
				{
					$postquery = "SELECT * FROM ".TABLE_PREFIX."post p WHERE threadid={$thread['threadid']} AND visible=1 ORDER BY dateline DESC LIMIT 1";
					$post = $db->query_first($postquery);


					$tmptext = str_replace(array("\n","\r"),array(' / ',''),strip_bbcode($post['pagetext']));
					$post = wordwrap($tmptext,$post_character_count);

					// reduce to one line
					$pos = strpos($post,"\n");
					if ($pos) $post = substr($post,0,$pos). ' ...';


				}
				else $post = '';


				$i++;
				$thread['title_decode'] = html_entity_decode($thread['title']);
				$thread['forumtitle_decode'] = html_entity_decode($thread['forumtitle']);

				// wrap at 80 charactes & replace new lines with simple "/"
				$thread['htmlpost'] = '<br />'.$post;
				$thread['textpost'] = "\n$post";
				$thread['formated_dateline'] = vbdate($vbulletin->options['dateformat'],$thread['dateline']);
				$thread['formated_lastpost_time'] = vbdate("{$vbulletin->options['timeformat']}",$thread['lastpost']);
				$thread['formated_lastpost_date'] = vbdate("{$vbulletin->options['dateformat']}",$thread['lastpost']);

				eval('$threadspreview .= "'.addslashes($threadspreview_body_t).'";');
				eval('$HTML_threadspreview .= "'.addslashes($HTML_threadspreview_body_t).'";');

				if ($reuse2 == 0)
				{
					if ($i == 1) $tid2 = $thread[threadid];
					else $tid2 .= ",".$thread[threadid];
				}

				switch ($topicorder)
				{
					case "views":
						eval('$postline = "'.addslashes($postline_views_t).'";');
						eval('$HTML_postline2 = "'.addslashes($HTML_postline_views_t).'";');
						break;

					case "replies":
						eval('$postline = "'.addslashes($postline_replies_t).'";');
						eval('$HTML_postline2 = "'.addslashes($HTML_postline_replies_t).'";');
						break;

					case "virg":
						eval('$postline = "'.addslashes($postline_virg_t).'";');
						eval('$HTML_postline2 = "'.addslashes($HTML_postline_virt_t).'";');
						break;

					case "dateline":
						eval('$postline = "'.addslashes($postline_dateline_t).'";');
						eval('$HTML_postline2 = "'.addslashes($HTML_postline_dateline_t).'";');
						break;
				}

				$threadspreview .= $postline;
				$HTML_threadspreview .= $HTML_postline2;

				eval('$threadspreview .= "'.addslashes($threadspreview_end_t).'";');
				eval('$HTML_threadspreview .= "'.addslashes($HTML_threadspreview_end_t).'";');

			} // end while

			unset($where); unset($hotconds); unset($orderby);
		} // end numros $numtopic
	}
	$tid1 = $tid2;
	return array($threadspreview,$HTML_threadspreview);
}

function commbull_send($cron_vars='',$nextitem='')
{
	global $vbulletin, $session, $db, $commbull, $vbphrase;

	if ($cron_vars)
	{
		extract($cron_vars);
		$cron_action = 1;
	}

	// results are pulled from preview form page
	else
	{
		/* subject, message, html_subject, html_message, action, POST_HTML, POST_TEXT, totalusers,
		groupids, page, nextitem_ser, pagenumber
		*/

		$POST_HTML = $_POST['POST_HTML'];
		$POST_TEXT = $_POST['POST_TEXT'];
		$subject = $_POST['subject'];
		$message = $_POST['message'];
		$html_subject = $_POST['html_subject'];
		$html_message = $_POST['html_message'];
		$totalusers = $_POST['totalusers'];
		$groupids = $_POST['groupids'];
		$page = $_POST['page']-1;
		$cron_action = $_POST['cron_action'];
		$nextitem_ser = $_POST['nextitem_ser'];
		$nextitem = unserialize($nextitem_ser);
	}

	if (!$cron_action) $totalpages = ceil($totalusers / $commbull['mailsatonce']);
	else $totalpages = 1;

	if (!isset($page)) { $start = 0; }
	else { $start = ($page)*$commbull['mailsatonce']; }

	if ($start < 0) $start = 0;

	$page++;

	#echo "start: $start; page: $page";

	$message = stripslashes($message);
	$html_message = stripslashes($html_message);
	$subject = trim($subject);
	$html_subject = trim($html_subject);

	if ($page == 1)
	{
		if (($commbull['postcopy']) && $commbull['pfid'] != 0)
		{
			$foruminfo=fetch_foruminfo($commbull['pfid']);

			// post text or HTML version to forum
			$message2 = @eregi_replace("{{[^}]*}","",($commbull['pftype'] == 0 ? $POST_TEXT : $POST_HTML));

			if ($commbull['pftype'] != 0)
			{
				$message2 = str_replace("\n",'',$message2);
				$message2 = str_replace("\r",'',$message2);
			}

			require_once(DIR . '/includes/functions_newpost.php');
			$message2 = convert_url_to_bbcode($message2);
			$message2 = addslashes($message2);

			$puser = $db->escape_string($commbull['pcu']);

			$id = $db->query_first("SELECT userid AS id FROM " . TABLE_PREFIX . "user WHERE username='$puser' LIMIT 1");

			$a = $db->query_write("INSERT INTO " . TABLE_PREFIX . "thread (threadid,title,lastpost,forumid,open,replycount,postusername,postuserid,lastposter,dateline,iconid,visible,attach) VALUES (NULL,'".addslashes(htmlspecialchars($subject))."','".time()."','$commbull[pfid]','".iif($commbull['open'],1,0)."','0','$puser','$id[id]','$puser','".time()."','1','1','0')");
			$threadid=$db->insert_id();

			$b = $db->query_write("INSERT INTO " . TABLE_PREFIX . "post (postid,threadid,title,username,userid,dateline, pagetext,allowsmilie,showsignature,ipaddress,iconid,visible) VALUES (NULL,'$threadid','".addslashes(htmlspecialchars($subject))."','$puser','$id[id]','".time()."','$message2','1','0','0','1','1')");
			$postid=$db->insert_id();

			$db->query_write("UPDATE ".TABLE_PREFIX."thread SET firstpostid=$postid, lastpostid=$postid WHERE threadid=$threadid");

			$c = $db->query_write("UPDATE " . TABLE_PREFIX . "forum SET replycount=replycount+1,threadcount=threadcount+1,lastpost='".time()."',lastposter='$puser' WHERE forumid IN ($foruminfo[parentlist])");
			if ($foruminfo[countposts])
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "user SET posts=posts+1 WHERE userid='$id[id]'");
			}
			if ($a && $b && $c && !$cron_action)
			{
				echo "<b>{$vbphrase['sendmessage']}</b><br /><hr>";
			}
		} // end if postcopy && pfid != 0
	} // end if page = 1
	#	exit;
	$message = eregi_replace("\[[^]]*\]","",$message);
	$message = str_replace("{{","",$message);
	$message = str_replace("}}","",$message);
	$passmessage = trim($message);
	$message = addslashes($message);
	$message = str_replace("\\'","'",$message);
	$message = str_replace("\r\n","\n",$message);

	$html_message = eregi_replace("\[[^]]*\]","",$html_message);
	$html_message = str_replace("{{","",$html_message);
	$html_message = str_replace("}}","",$html_message);
	$HTML_passmessage = trim($html_message);
	$html_message = addslashes($html_message);
	$html_message = str_replace("\\'","'",$html_message);

	if(file_exists('./includes/functions_vbseo.php'))
	{
		include_once('./includes/functions_vbseo.php');
		$html_message = make_crawlable($html_message);
		$html_message = preg_replace('#([^\\\\])"#', '$1\\"', $html_message);
		$GLOBALS['VBSEO_REWRITE_TEXTURLS'] = 1;
		define('VBSEO_PREPROCESSED', 1);
		$message = make_crawlable($message);
		$message = preg_replace('#([^\\\\])"#', '$1\\"', $message);
		$html_message = str_replace("</td>","</td>\n",$html_message);
	}

	if (!$cron_action)
	{
		echo "<b>{$vbphrase['sending']} .... </b>(page $page/$totalpages)<br />
		FROM: \"{$vbulletin->options['bbtitle']}\" &lt;$commbull[email_from]&gt;<br /><hr><ol>";
	}

	if (!$commbull['mailsatonce']) $commbull['mailsatonce']=300;

	#echo $commbull['mailsatonce'].'<br />';

	$userssql = "SELECT u.*, f.*, a.dateline, a.width, a.height
	FROM ".TABLE_PREFIX."userfield f, " . TABLE_PREFIX . "user u
	LEFT JOIN ".TABLE_PREFIX."customavatar a ON (a.userid = u.userid)
	WHERE u.userid=f.userid AND
		receivebulletin=1 AND
		".($commbull['activedays'] ? 'u.lastactivity > '.(time()-$commbull['activedays']*60*60*24).' AND ' : '')."

		usergroupid IN($groupids) ". ($commbull['ignore_admin'] ? '' : "AND
		(options & " . $vbulletin->bf_misc_useroptions['adminemail'] . ")")."
	ORDER BY u.userid ASC ".($cron_action?'':"LIMIT $start,$commbull[mailsatonce]");
	$users = $db->query_read($userssql);

	#echo $userssql;

	if ($cron_action) { log_cron_action('Commbull [Sending to '.$db->num_rows($users).']', $nextitem); }

	// ^^ hack

	#if ($commbull['usevbmailqueue'])
	vbmail_start();
	$vbulletin->options['usemailqueue'] = 1;

	$usercount = 0;

	if ($vbulletin->debug) echo '<b style="color:red">COMMBULL in DEBUG MODE.  Emails will NOT be sent</b><br /><br />';

	if (!$cron_action) echo "Sending from: $commbull[email_from]<br /><br />";

	// change webmaster email, temporarily
	$vbulletin->options['webmasteremail'] = $commbull['email_from'];

	while ($commbull_user = $db->fetch_array($users))
	{
		$username = $commbull_user['username'];
		//$password = $commbull_user[password];
		$posts = number_format($commbull_user['posts']);
		#$joindate = date($vbulletin->options['dateformat'],$commbull_user['joindate']);
		$joindate = vbdate($vbulletin->options['dateformat'],$commbull_user['joindate']);
		$lastactivity = vbdate("{$vbulletin->options['timeformat']}, {$vbulletin->options['dateformat']}",$commbull_user['lastactivity']);

		#$avatarinfo = $db->query_first("SELECT * FROM ".TABLE_PREFIX."customavatar WHERE userid={$commbull_user['userid']}");
		#if ($avatarinfo)
		if ($commbull_user['dateline'])
		{
			#$avatar_img = '<img src='.$vbulletin->options['bburl'].'/image.php?u='.$commbull_user['userid'].'&amp;dateline='.$avatarinfo['dateline'].'"'.($avatarinfo['width'] ? ' width="'.$avatarinfo['width'].'"':'').($avatarinfo['height'] ? ' height="'.$avatarinfo['height'].'"':'').' alt="'.$commbull_user['username'].'\'s Avatar" border="0" hspace="5" />';
			$avatar_img = '<img src='.$vbulletin->options['bburl'].'/image.php?u='.$commbull_user['userid'].'&amp;dateline='.$commbull_user['dateline'].'"'.($commbull_user['width'] ? ' width="'.$commbull_user['width'].'"':'').($commbull_user['height'] ? ' height="'.$commbull_user['height'].'"':'').' alt="'.$commbull_user['username'].'\'s Avatar" border="0" hspace="5" />';
		}
		else $avatar_img = '';

		/// defined here only to avoid erros of "used before defined"
		$mailbody = $HTML_mailbody = '';

		$commbull_unsubscribe = $vbulletin->options['bburl'].'/commbull_unsubscribe.php?do=unsubscribe&index='.urlencode(md5($commbull_user['password'].$commbull_user['salt'])).'&user='.urlencode($commbull_user['username']);

		eval ("\$mailbody = \"".$message."\";");
		eval ("\$HTML_mailbody = \"".$html_message."\";");

		if (!$cron_action) echo "<li>User: ". htmlspecialchars($commbull_user['userid']) ." - ".htmlspecialchars($username)." (<i>$commbull_user[email]</i>) .... ";

		$headers = commbull_additional_headers();

		$vbulletin->options['commbull_html'] = $commbull_user['receivebulletin_type'];
		if ($commbull_user['receivebulletin_type'] == '1')
		{
			#echo '1';
			if (!$vbulletin->debug)
			{
				#$headers = "Content-Type: text/html\n";
				#$headers = preg_replace("#(\r\n|\r|\n)#s", $delimiter, $headers.$commbull['mailheaders']);

				#if ($commbull['usevbmailqueue'])
				#{
					#echo '2';
					vbmail($commbull_user['email'],$html_subject,$HTML_mailbody,false,$vbulletin->options['webmasteremail'],$headers);

				#}
				#else
				#{
					#echo '3';
				#	$headers .= "From: {$vbulletin->options['bbtitle']} <" . $vbulletin->options['webmasteremail'] . '>' . $delimiter;
				#	($hook = vBulletinHook::fetch_hook('mail_send')) ? eval($hook) : false;
				#	mail($commbull_user['email'],$html_subject, $HTML_mailbody,$headers);
				#}

				if (!$cron_action) echo ' html ';
			}
			else if (!$cron_action) echo ' testing html ';

		}
		else
		{
			#echo '4';
			if (!$vbulletin->debug)
			{
				$headers = preg_replace("#(\r\n|\r|\n)#s", $delimiter, $headers.$commbull['mailheaders']);

				#if ($commbull['usevbmailqueue'])
				#{
					#echo '5';
					vbmail($commbull_user['email'],$subject,$mailbody,false,'',$headers);
				#}
				#else
				#{
					#echo '6';
				#	$headers .= "From: {$vbulletin->options['bbtitle']} <" . $vbulletin->options['webmasteremail'] . '>' . $delimiter;
				#	($hook = vBulletinHook::fetch_hook('mail_send')) ? eval($hook) : false;
				#	mail($commbull_user['email'],$subject,$mailbody,$headers);
				#}

				if (!$cron_action) echo ' text ';
			}
			else if (!$cron_action) echo ' testing text ';

		}
		if (!$cron_action)
		{
			echo "ok</li>\n";
			flush();
			ob_flush();
		}

		$usercount++;

		/*		else
		{
		if ($usercount++ % 100 == 0) echo '<br />';

		echo '.';
		sleep(1);
		flush();
		ob_flush();
		}*/

		if ($cron_action && $usercount % 1000 == 0) log_cron_action('Commbull ['.$usercount.' sent]', $nextitem);

	} // DB-users

	#if ($commbull['usevbmailqueue'])
	vbmail_end();

	if ($vbulletin->debug)
	{
		echo $HTML_mailbody;
		echo "<pre>$mailbody</pre>";

		echo "$cron_action && $totalusers > $commbull[mailsatonce] && $totalusers > $usersdone";
	}
	if (!$cron_action) echo "</ol>";

	$usersdone = ($page)*$commbull['mailsatonce'];



	if (!$cron_action && $totalusers > $commbull['mailsatonce'] && $totalusers > $usersdone)
	{
		// this constructs a hidden value 'do' ... we are using action ...
		print_form_header("commbull","send&page=".($page+1),0,1);
		construct_hidden_code("action","send");
		construct_hidden_code("totalusers",$totalusers);
		construct_hidden_code("groupids",$groupids);
		construct_hidden_code("subject",$subject);
		construct_hidden_code("html_subject",$html_subject);
		construct_hidden_code("message",$passmessage);
		construct_hidden_code("html_message",$HTML_passmessage);
		construct_hidden_code("page",$page+1);
		construct_hidden_code('cron_action',$cron_action);
		construct_hidden_code('nextitem_ser',$nextitem_ser);

		$nextpageval = htmlspecialchars("{$vbphrase['donextpage']} (".($page+1)."/$totalpages)");
		$timeremaining = $commbull['auto_timer'];

		if ($commbull['auto_nextpage'])
		{
?>
  <script language="javascript">
  <!--
  countdown = <?php echo $commbull['auto_timer']; ?>;
  actualcountdown = <?php echo $timeremaining; ?>;
  function submit_form()
  {
  	document.cpform.submit();
  }

  function count_down()
  {
  	actualcountdown = actualcountdown-1;
  	document.cpform.timeremaining.value=actualcountdown+ ' seconds remaining';
  	setTimeout('count_down()',1000);
  }

  setTimeout('submit_form()',<?php echo $commbull['auto_timer']*1000; ?>);
  setTimeout('count_down()',1000);
  //-->
  </script>

  <input type=text name=timeremaining value="<?php echo $timeremaining; ?> seconds remaining">
<?php
		} // end autonextpage javascript


		print_submit_row($nextpageval,0);

	}
	else
	{

		if ($cron_action)
		{
			global $nextitem;
			log_cron_action('Commbull [Finished '.$db->num_rows($users).' '.($commbull['usevbmailqueue'] ? 'queued' : 'sent'), $nextitem);
		}

		log_admin_action('',$vbulletin->userinfo['userid'],'commbull.php','sent bulletin'.($cron_action?' (cron)':''));
		if (!$cron_action) echo "<hr><br /><a href=\"index.php?s={$session[sessionhash]}\">{$vbphrase['alldone']}</a>";

		$commbull['frommonth'] = date('m');
		$commbull['fromday'] = date('d');
		$commbull['fromyear'] = date('Y');
		$sql = "UPDATE ".TABLE_PREFIX."datastore SET data = '".$db->escape_string(serialize($commbull))."', unserialize=1
			WHERE title = 'commbull'";
		$db->query_write($sql);

	}
} // commbull_send

function commbull_additional_headers ()
{
	global $commbull;
	eval('$headers = "'.addslashes($commbull['mailheaders']).'";');
	$headers = preg_replace("#(\r\n|\r|\n)#s", $delimiter, $headers);
	return $headers;
} // commbull_additional_headers ()

?>