<?php
/**
 * JomSocial SEF extension for Joomla!
 *
 * @copyright   2009 Denis Dulici
 * @license	    GNU General Public License
 * www.denisdulici.com
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_community extends SefExt
{
    var $params;

    function getUserTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, name, username FROM #__users WHERE id ='.$id);
        $rows = $database->loadRow();

		if( $this->params->get('name_inc', '1') != '1' )
			$name = ( ($this->params->get('userid_inc', '0') != '0') ? $id.'-' : '' ).$rows[2];
		else
			$name = ( ($this->params->get('userid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
		return $name;
    }
	
	function getMessageTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, subject FROM #__community_msg WHERE id ='.$id);
        $rows = $database->loadRow();
        
        $name = ( ($this->params->get('messageid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
        return $name;
    }
	
	function getGroupCatTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, name FROM #__community_groups_category WHERE id ='.$id);
        $rows = $database->loadRow();
        
        $name = ( ($this->params->get('groupcatid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
        return $name;
    }
	
	function getGroupTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, name FROM #__community_groups WHERE id ='.$id);
        $rows = $database->loadRow();
        
        $name = ( ($this->params->get('groupid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
        return $name;
    }
	
	function getGroupBulletinTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, title FROM #__community_groups_bulletins WHERE id ='.$id);
        $rows = $database->loadRow();
        
        $name = ( ($this->params->get('bulletinid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
        return $name;
    }
	
	function getGroupDiscussionTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, title FROM #__community_groups_discuss WHERE id ='.$id);
        $rows = $database->loadRow();
		
        $name = ( ($this->params->get('discussionid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
        return $name;
    }
	
	function getAlbumTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, name FROM #__community_photos_albums WHERE id ='.$id);
        $rows = $database->loadRow();
		
        $name = ( ($this->params->get('albumid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
        return $name;
    }
	
	function getPhotoTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, caption FROM #__community_photos WHERE id ='.$id);
        $rows = $database->loadRow();
       
		$name = ( ($this->params->get('photoid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
		return $name;
    }
	
	function getVideoCatTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, name FROM #__community_videos_category WHERE id ='.$id);
        $rows = $database->loadRow();
		
        $name = ( ($this->params->get('videocatid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
        return $name;
    }
	
	function getVideoTitle($id) {
        $database =& JFactory::getDBO();
        $database->setQuery('SELECT id, title, category_id FROM #__community_videos WHERE id ='.$id);
        $rows = $database->loadRow();
        
		$name = ( ($this->params->get('videoid_inc', '0') != '0') ? $id.'-' : '' ).$rows[1];
		if( $this->params->get('videocat_inc', '1') != '1' )
			return array( $name );
		else
			return array( $this->getVideoCatTitle($rows[2]), $name );
    }

    function create(&$uri) {
        // Extract variables
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();
		$nonSefVars = array();
		
        $this->params = SEFTools::getExtParams('com_community');
		
        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
		
		$view = isset($view) ? @$view : null;
		
        if(isset($view)) {
            switch($view) {
				case 'frontpage':
					$title[] = JText::_('HOME');
					unset($view);
                    break;
				case 'register':
					$title[] = JText::_('REGISTER');
					if(isset($task) && $task=='registerProfile'){
						$title[] = JText::_('PROFILE');
						unset($task);
					}
					unset($view);
                    break;
				case 'profile':
					if(isset($userid))
						$title[] = $this->getUserTitle($userid);
					$title[] = JText::_('PROFILE');
					if(isset($task)){
						switch($task){
							case 'uploadAvatar':
								$title[] = JText::_('EDIT AVATAR');
								unset($task);
								break;
							case 'edit':
								$title[] = JText::_('EDIT PROFILE');
								unset($task);
								break;
							case 'editDetails':
								$title[] = JText::_('EDIT DETAILS');
								unset($task);
								break;
							case 'privacy':
								$title[] = JText::_('EDIT PRIVACY');
								unset($task);
								break;
						}
					}
					unset($view);
                    break;
				case 'inbox':
					$title[] = JText::_('INBOX');
					if(isset($task)){
						switch($task){
							case 'read':
								if(isset($msgid)) {
									$title[] = $this->getMessageTitle($msgid);
								}
								unset($task);
								break;
							case 'sent':
								$title[] = JText::_('SENT');
								unset($task);
								break;
							case 'write':
								$title[] = JText::_('WRITE');
								unset($task);
								break;
						}
					}
                    unset($view);
                    break;
				case 'groups':
					if(empty($task)){
						if(isset($userid))
							$title[] = $this->getUserTitle($userid);
						$title[] = JText::_('GROUP');
						if(isset($categoryid)) {
							$title[] = $this->getGroupCatTitle($categoryid);
						}
					} else {
						switch($task){
							case 'mygroups':
								if(isset($userid)) {
									$title[] = $this->getUserTitle($userid);
									$title[] = JText::_('MY GROUPS TITLE');
								} else
									$title[] = JText::_('MY GROUPS TITLE');
								unset($task);
								break;
							case 'search':
								$title[] = JText::_('GROUP');
								$title[] = JText::_('SEARCH GROUP');
								unset($task);
								break;
							case 'create':
								$title[] = JText::_('GROUP');
								$title[] = JText::_('CREATE GROUP');
								unset($task);
								break;
							case 'viewgroup':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
									if( $edit == 1){
										$title[] = JText::_('TAB EDIT');
									}
								}
								unset($task);
								break;
							case 'created':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
								}
								unset($task);
								break;
							case 'invitefriends':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
									$title[] = JText::_('INVITE FRIENDS');
								}
								unset($task);
								break;
							case 'viewmembers':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
									$title[] = JText::_('GROUP MEMBERS');
								}
								unset($task);
								break;
							case 'uploadavatar':
								$title[] = JText::_('GROUP');
								if(isset($groupid))
									$title[] = $this->getGroupTitle($groupid);
								$title[] = JText::_('EDIT GROUP AVATAR');
								unset($task);
								break;
							case 'viewbulletin':
								if(isset($bulletinid)) {
									$title[] = JText::_('GROUP');
									if ( $this->params->get('group_inc', '1') != '0' && isset($groupid)){
										$title[] = $this->getGroupTitle($groupid);
									}
									$title[] = $this->getGroupBulletinTitle($bulletinid);
								}
								unset($task);
								break;
							case 'viewbulletins':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
									$title[] = JText::_('SHOW ALL BULLETINS');
								}
								unset($task);
								break;
							case 'addnews':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
									$title[] = JText::_('ADD BULLETIN');
								}
								unset($task);
								break;
							case 'viewdiscussion':
								if(isset($topicid)) {
									$title[] = JText::_('GROUP');
									if ( $this->params->get('group_inc', '1') != '0' && isset($groupid)){
										$title[] = $this->getGroupTitle($groupid);
									}
									$title[] = $this->getGroupDiscussionTitle($topicid);
								}
								unset($task);
								break;
							case 'viewdiscussions':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
									$title[] = JText::_('SHOW ALL DISCUSSIONS');
								}
								unset($task);
								break;
							case 'adddiscussion':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
									$title[] = JText::_('ADD DISCUSSION');
								}
								unset($task);
								break;
							case 'app':
								if(isset($groupid)) {
									$title[] = JText::_('GROUP');
									$title[] = $this->getGroupTitle($groupid);
									$title[] = JText::_('WALL');
								}
								unset($task);
								break;
						}
					}
                    unset($view);
                    break;
				case 'friends':
					if(isset($userid)) {
                        $title[] = $this->getUserTitle($userid);
						$title[] = JText::_('FRIENDS');
					} else {
						$title[] = JText::_('FRIENDS');
						if(isset($task)){
							switch($task){
								case 'invite':
									$title[] = JText::_('INVITE FRIENDS');
									unset($task);
									break;
								case 'sent':
									$title[] = JText::_('REQUEST SENT');
									unset($task);
									break;
								case 'pending':
									$title[] = JText::_('PENDING APPROVAL');
									unset($task);
									break;
							}
						}
					}
                    unset($view);
                    break;
				case 'search':
					if(!isset($task) && empty($task)){
						$title[] = JText::_('SEARCH');
						unset($task);
					}
					elseif ($task == 'browse'){
						$title[] = JText::_('BROWSE APPS');
						unset($task);
					}
					elseif ($task == 'advancesearch'){
						$title[] = JText::_('CUSTOM SEARCH');
						unset($task);
					}
					unset($view);
                    break;
				case 'apps':
					$title[] = JText::_('APPLICATIONS');
					if (isset($task)) {
						switch($task){
							case 'browse':
								$title[] = JText::_('BROWSE APPS');
								unset($task);
								break;
							}
					}
					unset($view);
                    break;
				case 'photos':
					if(isset($userid))
						$title[] = $this->getUserTitle($userid);
					$title[] = JText::_('PHOTOS');
					if(isset($task)){
						switch($task){
							case 'myphotos':
								$title[] = JText::_('MY PHOTOS');
								unset($task);
								break;
							case 'newalbum':
								$title[] = JText::_('ADD ALBUM');
								unset($task);
								break;
							case 'uploader':
								if(isset($albumid))
									$title[] = $this->getAlbumTitle($albumid);
								$title[] = JText::_('UPLOAD PHOTOS');
								unset($task);
								break;
							case 'album':
								if(isset($albumid))
									$title[] = $this->getAlbumTitle($albumid);
								unset($task);
								break;
							case 'editAlbum':
								if(isset($albumid))
									$title[] = $this->getAlbumTitle($albumid);
								$title[] = JText::_('EDIT');
								unset($task);
								break;
							case 'photo':
								if(isset($albumid))
									$title[] = $this->getAlbumTitle($albumid);
								if(isset($photoid))
									$title[] = $this->getPhotoTitle($photoid);
								else
									$title[] = JText::_('PHOTOS');
								unset($task);
								break;
							case 'jsonupload':
								$nonSefVars['view'] = $view;
								$nonSefVars['task'] = $task;
								$nonSefVars['tmpl'] = $tmpl;
								$nonSefVars['no_html'] = $no_html;
								break;
						}
					}
					unset($view);
                    break;
				case 'videos':
					if(isset($userid))
						$title[] = $this->getUserTitle($userid);
					$title[] = JText::_('VIDEOS');
					if(isset($catid))
						$title[] = $this->getVideoCatTitle($catid);
					if(isset($task)){
						switch($task){
							case 'myvideos':
								$title[] = JText::_('MY VIDEOS');
								unset($task);
								break;
							case 'search':
								$title[] = JText::_('SEARCH');
								unset($task);
								break;
							case 'removevideo':
								$title[] = JText::_('REMOVE');
								unset($task);
								break;
							case 'video':
								if(isset($videoid))
									$title = array_merge( $title, $this->getVideoTitle($videoid) );
								unset($task);
								break;
						}
					}
					unset($view);
                    break;
            }
        }
		
		if(isset($sort)){
			switch ($sort){
				case 'latest':
					$title[] = JText::_('SORT LATEST');
					unset($sort);
					break;
				case 'online':
					$title[] = JText::_('SORT ONLINE');
					unset($sort);
					break;
				case 'mostdiscussed':
					$title[] = JText::_('GROUP SORT MOST DISCUSSED');
					unset($sort);
					break;
				case 'mostwall':
					$title[] = JText::_('GROUP SORT MOST WALL POST');
					unset($sort);
					break;
				case 'mostmembers':
					$title[] = JText::_('GROUP SORT MOST MEMBERS');
					unset($sort);
					break;
				case 'mostactive':
					$title[] = JText::_('GROUP SORT MOST ACTIVE');
					unset($sort);
					break;
				case 'title':
					$title[] = JText::_('VIDEO SORT TITLE');
					unset($sort);
					break;
				case 'mostviews':
					$title[] = JText::_('VIDEO SORT POPULAR');
					unset($sort);
					break;
				case 'mostwalls':
					$title[] = JText::_('GROUP SORT MOST DISCUSSED');
					unset($sort);
					break;
			}
		}
		
		if(isset($format))
			$title[] = $format;
		
        if (isset($limit))       $nonSefVars['limit'] = $limit;
        if (isset($limitstart))  $nonSefVars['limitstart'] = $limitstart;
		
        $newUri = $uri;
        if (count($title) > 0) 
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);

        return $newUri;
    }
}
?>
