<?php

@session_start();
@error_reporting(7);
@ini_set('display_errors', true);
@ini_set('html_errors', false);

define('DATALIFEENGINE', true);
define('ROOT_DIR', '../..');
define('ENGINE_DIR', '..');

include ENGINE_DIR.'/data/config.php';
require_once ENGINE_DIR.'/classes/mysql.php';
require_once ENGINE_DIR.'/data/dbconfig.php';
require_once ROOT_DIR.'/language/'.$config['langs'].'/adminpanel.lng';

$config['charset'] = ($lang['charset'] != '') ? $lang['charset'] : $config['charset'];

require_once ENGINE_DIR.'/inc/functions.inc.php';
require_once ENGINE_DIR.'/classes/parse.class.php';

function decode_to_utf8($int=0)
{
                $t = '';

                if ( $int < 0 )
                {
                        return chr(0);
                }
                else if ( $int <= 0x007f )
                {
                        $t .= chr($int);
                }
                else if ( $int <= 0x07ff )
                {
                        $t .= chr(0xc0 | ($int >> 6));
                        $t .= chr(0x80 | ($int & 0x003f));
                }
                else if ( $int <= 0xffff )
                {
                        $t .= chr(0xe0 | ($int  >> 12));
                        $t .= chr(0x80 | (($int >> 6) & 0x003f));
                        $t .= chr(0x80 | ($int  & 0x003f));
                }
                else if ( $int <= 0x10ffff )
                {
                        $t .= chr(0xf0 | ($int  >> 18));
                        $t .= chr(0x80 | (($int >> 12) & 0x3f));
                        $t .= chr(0x80 | (($int >> 6) & 0x3f));
                        $t .= chr(0x80 | ($int  &  0x3f));
                }
                else
                {
                        return chr(0);
                }

                return $t;
}

function convert_unicode($t, $to = 'windows-1251')
{
                $to = strtolower($to);

                if ($to == 'utf-8') {

                        $t = preg_replace( '#%u([0-9A-F]{1,4})#ie', "decode_to_utf8(hexdec('\\1'))", utf8_encode($t) );
                        $t = urldecode ($t);

                } else {

                        $t = preg_replace( '#%u([0-9A-F]{1,4})#ie', "'&#' . hexdec('\\1') . ';'", $t );
                        $t = urldecode ($t);
                    $t = @html_entity_decode($t, ENT_NOQUOTES, $to);

                }

                return $t;
}

$parse = new ParseFilter();
$full_story = $parse->BB_Parse($parse->process(convert_unicode($_REQUEST['full_txt'], $config['charset'])), false);
$short_story = $parse->BB_Parse($parse->process(convert_unicode($_REQUEST['short_txt'], $config['charset'])), false);

$metatags = create_metatags ($short_story.$full_story);

@header("Content-type: text/css; charset=".$config['charset']);

if ($_REQUEST['key'] == 1) echo $metatags['description'];
else echo $metatags['keywords'];

?>