<?php
@session_start();
header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");                          // HTTP/1.0

error_reporting(E_ALL ^ E_NOTICE);
@ini_set('display_errors', true);
@ini_set('html_errors', false);
@ini_set('error_reporting', E_ALL ^ E_NOTICE);

define('DATALIFEENGINE', true);
define('ROOT_DIR', "..");
define('ENGINE_DIR', ROOT_DIR.'/engine');

require_once(ENGINE_DIR.'/data/config.php');
require_once(ENGINE_DIR.'/classes/mysql.php');
require_once(ENGINE_DIR.'/data/dbconfig.php');
require_once(ENGINE_DIR.'/inc/functions.inc.php');

$version_id = ($config_version_id) ? $config_version_id : $config['version_id'];

$theme = ENGINE_DIR;
require_once(dirname (__FILE__).'/template.php');

extract($_REQUEST, EXTR_SKIP);

$dle_version = "2.5";

switch ($version_id) {

case $dle_version :
        include dirname (__FILE__).'/finish.php';
        break;

case "2.5" :
        include dirname (__FILE__).'/2.5.php';
        break;

case "2.0" :
        include dirname (__FILE__).'/2.0.php';
        break;

case "1.5" :
        include dirname (__FILE__).'/1.5.php';
        break;

case "1.2" :
        include dirname (__FILE__).'/1.2.php';
        break;

case "1.0" :
        include dirname (__FILE__).'/1.0.php';
        break;

default:
        include dirname (__FILE__).'/error.php';
}

?>