<?php


class image_controller
  {
    var $source = '';
    var $allow_watermark = false;
    var $images = array ();
    var $thumbs = array ();
    var $prefix = 'dl';
    var $upload_images = array ();

    function reset_url($url)
    {
        $value = str_replace("http://", "", $url);
        $value = str_replace("www.", "",    $value);
        return reset(explode("/", $value));
    }
    function get_images ($content)
    {
      preg_match_all ('\'\\[thumb\\](.+?)\\[/thumb\\]\'ie', $content, $preg_array);
      foreach ($preg_array[1] as $item)
      {
        if ($this->reset_url($_SERVER['HTTP_HOST'])!=$this->reset_url($item))
        {
            if (!(in_array ($item, $this->thumbs)))
            {
              $this->thumbs[] = $item;
            }

            if (!(in_array ($item, $this->images)))
            {
              $this->images[] = $item;
              continue;
            }
        }
      }

      preg_match_all ('#\\[img\\](.+?)\\[/img\\]#ie', $content, $preg_array);
      if (count ($preg_array[1]) != 0)
      {
        foreach ($preg_array[1] as $item)
        {
            if ($this->reset_url($_SERVER['HTTP_HOST'])!=$this->reset_url($item))
            {
                if (!(in_array ($item, $this->images)))
                {
                    $this->images[] = $item;
                    continue;
                }
            }
        }
      }

    }

    function download ($image_url, $is_thumb = false)
    {
      global $config;
      $image_name = basename ($image_url);
      $image_arr = explode ('_', $image_name);
      if (count ($image_arr) != 0)
      {
        $image_name = end ($image_arr);
      }

      $image_name = $this->prefix . '_' . $image_name;
      if ($is_thumb)
      {
        $thumb_url = str_replace ('/uploads/posts/', '/uploads/posts/thumbs/', $image_url);
        $serv_image_url = $config['http_home_url'] . 'uploads/posts/thumbs/' . $image_name;
        $this->source = str_replace ($thumb_url, $serv_image_url, $this->source);
        if (!(in_array (basename ($serv_image_url), $this->upload_images)))
        {
          $this->upload_images[] = basename ($serv_image_url);
        }

        @copy ($thumb_url, THUMB_PATH . $image_name);
      }

      $serv_image_url = $config['http_home_url'] . 'uploads/posts/' . $image_name;
      $this->source = str_replace ($image_url, $serv_image_url, $this->source);
      @copy ($image_url, UPLOAD_PATH . $image_name);
      if (!(in_array (basename ($serv_image_url), $this->upload_images)))
      {
        $this->upload_images[] = basename ($serv_image_url);
      }

      if ($this->allow_watermark)
      {
        $thumb = new thumbnail (UPLOAD_PATH . $image_name);
        $thumb->jpeg_quality ($config['jpeg_quality']);
        $thumb->insert_watermark ($config['max_watermark']);
        $thumb->save (UPLOAD_PATH . $image_name);
        unset ($thumb);
        if ($is_thumb)
        {
          $thumb = new thumbnail (THUMB_PATH . $image_name);
          $thumb->jpeg_quality ($config['jpeg_quality']);
          $thumb->insert_watermark ($config['max_watermark']);
          $thumb->save (THUMB_PATH . $image_name);
          unset ($thumb);
        }
      }

    }

    function process ($parse)
    {
        $this->source = $parse->decodeBBCodes($this->source);
        $this->prefix = time ();

      if (trim ($this->source) != '')
      {
        $this->get_images ($this->source);
      }

      foreach ($this->images as $image_url)
      {
        $this->download ($image_url);
      }

      foreach ($this->thumbs as $image_url)
      {
        $this->download ($image_url, true);
      }
        $this->source = $parse->BB_Parse($this->source);

    }
  }

  define ('UPLOAD_PATH', ROOT_DIR . '/uploads/posts/');
  define ('THUMB_PATH', UPLOAD_PATH . 'thumbs/');

?>