<?php

@error_reporting(7);
@ini_set('display_errors', true);
@ini_set('html_errors', false);

define('DATALIFEENGINE', true);
define('ROOT_DIR', '../..');
define('ENGINE_DIR', '..');

include ENGINE_DIR.'/data/config.php';
require_once ENGINE_DIR.'/classes/mysql.php';
require_once ENGINE_DIR.'/data/dbconfig.php';

if ($_COOKIE['dle_skin']) {
        if (@is_dir(ROOT_DIR.'/templates/'.$_COOKIE['dle_skin']))
                {
                        $config['skin'] = $_COOKIE['dle_skin'];
                }
}

if ($config["lang_".$config['skin']]) {

     include_once ROOT_DIR.'/language/'.$config["lang_".$config['skin']].'/website.lng';

} else {

     include_once ROOT_DIR.'/language/'.$config['langs'].'/website.lng';

}
$config['charset'] = ($lang['charset'] != '') ? $lang['charset'] : $config['charset'];

require_once ENGINE_DIR.'/modules/functions.php';
require_once ENGINE_DIR.'/classes/parse.class.php';

$parse = new ParseFilter();


function decode_to_utf8($int=0)
{
                $t = '';

                if ( $int < 0 )
                {
                        return chr(0);
                }
                else if ( $int <= 0x007f )
                {
                        $t .= chr($int);
                }
                else if ( $int <= 0x07ff )
                {
                        $t .= chr(0xc0 | ($int >> 6));
                        $t .= chr(0x80 | ($int & 0x003f));
                }
                else if ( $int <= 0xffff )
                {
                        $t .= chr(0xe0 | ($int  >> 12));
                        $t .= chr(0x80 | (($int >> 6) & 0x003f));
                        $t .= chr(0x80 | ($int  & 0x003f));
                }
                else if ( $int <= 0x10ffff )
                {
                        $t .= chr(0xf0 | ($int  >> 18));
                        $t .= chr(0x80 | (($int >> 12) & 0x3f));
                        $t .= chr(0x80 | (($int >> 6) & 0x3f));
                        $t .= chr(0x80 | ($int  &  0x3f));
                }
                else
                {
                        return chr(0);
                }

                return $t;
}

function convert_unicode($t, $to = 'windows-1251')
{
                $to = strtolower($to);

                if ($to == 'utf-8') {

                        $t = preg_replace( '#%u([0-9A-F]{1,4})#ie', "decode_to_utf8(hexdec('\\1'))", utf8_encode($t) );
                        $t = urldecode ($t);

                } else {

                        $t = preg_replace( '#%u([0-9A-F]{1,4})#ie', "'&#' . hexdec('\\1') . ';'", $t );
                        $t = urldecode ($t);
                    $t = @html_entity_decode($t, ENT_NOQUOTES, $to);

                }

                return $t;
}

function check_name($name)
{
        global $lang, $db;

        $stop = '';

        if (strlen($name) > 20)
        {

            $stop .= $lang['reg_err_3'];
        }
        if (preg_match("/[\||\'|\<|\>|\"|\!|\?|\$|\@|\/|\\\|\&\~\*\+]/",$name))
        {

            $stop .= $lang['reg_err_4'];
        }
        if (empty($name))
        {

            $stop .= $lang['reg_err_7'];
        }
        if (!$stop)
        {

                $replace_word = array ('e' => '[e]', 'r' => '[r]', 't' => '[t]', 'y' => '[y]','u' => '[u]','i' => '[i1l!]','o' => '[o0]','p' => '[p]','a' => '[a]','s' => '[s5]','w' => 'w','q' => 'q','d' => 'd','f' => 'f','g' => '[g]','h' => '[h]','j' => 'j','k' => '[k]','l' => '[l1i!]','z' => 'z','x' => '[x%]','c' => '[c]','v' => '[vu]','b' => '[b]','n' => '[n]','m' => '[m]','' => '[u]','' => '','' => '[y]','' => '[e]','' => '[h]','' => '[r]','' => '[w]','' => '[w]','' => '[3]','' => '[x%]','' => '[]','' => '','' => '(|[i1l!]?)','' => '[b]','' => '[a]','' => '[n]','' => '[p]','' => '[o0]','' => '[n]','' => '','' => '','' => '[3]','' => '[]','' => '[4]','' => '[c]','' => '[m]','' => '[u]','' => '[t]','' => '[b]','' => '[6]','' => '(|[!1il][o0])','' => '[e]','1' => '[1il!]','2' => '2','3' => '[3]','4' => '[4]','5' => '[5s]','6' => '[6]','7' => '7','8' => '8','9' => '9','0' => '[0o]','_' => '_','#' => '#','%' => '[%x]','^' => '[^~]','(' => '[(]',')' => '[)]','=' => '=','.' => '[.]','-' => '-','[' => '[\[]');
                $name=strtolower($name);
                $name=strtr($name, $replace_word);

                $db->query ("SELECT name FROM " . USERPREFIX . "_users WHERE LOWER(name) REGEXP '[[:<:]]{$name}[[:>:]]'");

        if ($db->num_rows() > 0)
        {
                        $stop .= $lang['reg_err_20'];
                }
        }

        if (!$stop) return false; else return $stop;
}



        $name  = $db->safesql(trim(htmlspecialchars($parse->process(convert_unicode($_POST['name'], $config['charset'])))));
        $allow = check_name($name);

        if (!$allow)
        $buffer = "<font color=\"green\">".$lang['reg_ok_ajax']."</font>";
        else
        $buffer = "<font color=\"red\">".$allow."</font>";

@header("Content-type: text/css; charset=".$config['charset']);
echo $buffer;
?>