<?
/***********************************************/
/*                                             */
/*             NULLED BY yifanlu & Error 404                */
/*                                             */
/***********************************************/


  class vbplaza_math
  {
    var $math_Class = null;
    function vbplaza_math ()
    {
      if (extension_loaded ('bcmath'))
      {
        $this->math_Class = 'bcmath';
        return null;
      }

      if (extension_loaded ('big_int'))
      {
        $this->math_Class = 'big_int';
        return null;
      }

      if (extension_loaded ('GMP'))
      {
        $this->math_Class = 'GMP';
        return null;
      }

      $this->math_Class = 'Unknown';
    }

    function get_library_name ()
    {
      return $this->math_Class;
    }

    function add ($a, $b)
    {
      switch ($this->math_Class)
      {
        case 'bcmath':
        {
          @bcadd ($a, $b);
        }
      }

      return ;
    }

    function comp ($a, $b)
    {
      switch ($this->math_Class)
      {
        case 'bcmath':
        {
          @bccomp ($a, $b);
        }
      }

      return ;
    }

    function div ($a, $b)
    {
      switch ($this->math_Class)
      {
        case 'bcmath':
        {
          @bcdiv ($a, $b);
        }
      }

      return ;
    }

    function mod ($a, $b)
    {
      switch ($this->math_Class)
      {
        case 'bcmath':
        {
          @bcmod ($a, $b);
        }
      }

      return ;
    }

    function mul ($a, $b)
    {
      switch ($this->math_Class)
      {
        case 'bcmath':
        {
          @bcmul ($a, $b);
        }
      }

      return ;
    }

    function pow ($a, $b)
    {
      switch ($this->math_Class)
      {
        case 'bcmath':
        {
          @bcpow ($a, $b);
        }
      }

      return ;
    }

    function sub ($a, $b)
    {
      switch ($this->math_Class)
      {
        case 'bcmath':
        {
          @bcsub ($a, $b);
        }
      }

      return ;
    }
  }

  class vbplaza_engine
  {
    var $vbPlaza_Math = null;
    var $vbPlaza_Hash = null;
    var $is_displayed = false;
    var $is_licensed = false;
    var $script_version = null;
    var $license_name = null;
    var $license_email = null;
    var $license_url = null;
    var $license_options = null;
    var $license_date = null;
    var $license_number = null;
    var $license_key = null;
    function vbplaza_engine ()
    {
      global $vbulletin;
      $this->process_commands ();
      $this->vbPlaza_Math = new vbPlaza_Math ();
      if (VB_AREA == 'AdminCP')
      {
        if (($_POST['do'] == 'productkill' AND strstr ($_SERVER['PHP_SELF'], 'plugin.php')))
        {
          return false;
        }
      }

      if (VB_AREA == 'Forum')
      {
        if ((!isset ($_REQUEST['do']) OR empty ($_REQUEST['do'])))
        {
          $_REQUEST['do'] = 'main';
        }
      }

      if ($this->process_license ())
      {
        $this->script_version = 'Premium';
        $vbulletin->vbpcatcache = vbplaza_unserialize ($vbulletin->vbpcatcache);
        $vbulletin->vbpitemcache = vbplaza_unserialize ($vbulletin->vbpitemcache);
        $vbulletin->vbpgiftcache = vbplaza_unserialize ($vbulletin->vbpgiftcache);
        $vbulletin->vbpribboncache = vbplaza_unserialize ($vbulletin->vbpribboncache);
        return true;
      }

      $this->script_version = 'Non-Licensed';
      $this->license_authorization_failed ();
      return false;
    }

    function display_output ()
    {
      global $vbulletin;
      global $stylevar;
      global $headinclude;
      global $vboptions;
      global $onload;
      global $header;
      global $navbar;
      global $navbar2;
      global $footer;
      global $bbuserinfo;
      global $navitems;
      global $vbphrase;
      global $vbcollapse;
      global $template_hook;
      global $show;
      global $session;
      global $pmbox;
      global $pagetitle;
      global $style;
      global $current;
      global $displayedhistory;
      global $avatar;
      global $userinfo;
      global $richestusers;
      global $mostsolditems;
      global $history_userid;
      global $ad_location;
      global $notices;
      global $navbar_reloadurl;
      global $notifications_total;
      global $notifications_menubits;
      if (!$this->is_displayed)
      {
        if (!$this->verify_license_authorization ())
        {
          return null;
        }

        @require_once DIR . '/includes/functions_user.php';
        $this->process_user_history ($history_userid);
        $avatar = fetch_avatar_url ($userinfo['userid']);
        if ((empty ($avatar) OR !$vbulletin->options['avatarenabled']))
        {
          $show['avatar'] = false;
        }
        else
        {
          $show['avatar'] = true;
          $avatar['avatarpath'] = $avatar['0'];
        }

        $navbits = construct_navbits ($this->construct_navbits ($navitems));
        eval ('$navbar = "' . fetch_template ('navbar') . '";');
        ($hook = vbulletinhook::fetch_hook ('vbplaza_complete') ? eval ($hook) : false);
        if (!strstr ($vbulletin->templatecache['vbplaza_main_page'], '$footer'))
        {
          $vbulletin->templatecache['vbplaza_main_page'] = str_replace ('</body>', '$footer
</body>', $vbulletin->templatecache['vbplaza_main_page']);
        }
		
        $branded_free_license = false;
        if (intval ($this->license_options) & 1)
        {
          $branded_free_license = true;
        }

        if (!$branded_free_license)
        {
          $copyright = '<!-- Start vbBux / vbPlaza Copyright Notice -->
';
          $copyright .= '<table border="0" width="100%" align="center" cellpadding="4" cellspacing="0" class="tborder">
';
          $copyright .= '<tr><td align="center" class="tcat"><div class="smallfont"><a class="smallfont" href="http://www.vbplaza.com" target="vbplaza">vbBux / vbPlaza v' . $vbulletin->options['vbbux_vbplaza_version'] . ' coded by CMX at vbPlaza.com</a> | <a class="smallfont" href="http://www.vbteam.info" target="vbteam">Nulled By yifanlu & Error 404</a></div></td></tr>
';
          $copyright .= '</table>
';
          $copyright .= '<!-- End vbBux / vbPlaza Copyright Notice -->
';
          $footer = $copyright . $footer;
        }

        $show['inventory'] = (!$history_userid ? true : false);
        $this->is_displayed = true;
        eval ('print_output("' . fetch_template ('vbplaza_main_page') . '");');
      }

    }

    function get_domain_name ($url)
    {
      $chunks = explode ('.', $url);
      $length = count ($chunks);
      $i = 0;
      while ($i < $length - 2)
      {
        unset ($chunks['' . $i]);
        ++$i;
      }

      return implode ('.', $chunks);
    }

    function license_authorization_failed ()
    {
      global $vbulletin;
      global $vbphrase;
      global $license_error_code;
      global $license_error_notes;
      if (!$vbulletin->products['vbbux_vbplaza'])
      {
        return null;
      }

      if (empty ($vbulletin->options['vbbux_vbplaza_version']))
      {
        return null;
      }

      if (!is_member_of ($vbulletin->userinfo, 6))
      {
        print_no_permission ();
      }

      switch ($license_error_code)
      {
        case 'CMX_80010000':
        {
          $error_page = 'vbplaza_product_not_installed';
          break;
        }

        case 'CMX_80010001':
        {
          $error_page = 'vbplaza_no_large_integer_system';
          break;
        }
		
        case 'CMX_80010002':
        {
          $error_page = 'vbplaza_license_file_not_found';
          break;
        }
		
        default:
        {
          $error_page = 'vbplaza_license_authorization_failed';
          break;
        }
      }

      $this->vbplaza_display_error ($error_page);
    }

    function process_license ()
    {
      global $vbulletin;
      global $license_error_code;
      global $license_error_notes;
      $license_error_code = $license_error_notes = '';
      if (!$vbulletin->products['vbbux_vbplaza'])
      {
        $license_error_code = 'CMX_80010000';
        return false;
      }

      if ($this->vbPlaza_Math->math_Class == 'Unknown')
      {
        $license_error_code = 'CMX_80010001';
        return false;
      }
	  
      if (!file_exists (DIR . '/vbplaza/license.php'))
      {
        $license_error_code = 'CMX_80010002';
        return false;
      }

      @require_once DIR . '/vbplaza/license.php';
	  
      if (((((((isset ($vbPlaza_User_License['name']) AND isset ($vbPlaza_User_License['email'])) AND isset ($vbPlaza_User_License['url'])) AND isset ($vbPlaza_User_License['options'])) AND isset ($vbPlaza_User_License['date'])) AND isset ($vbPlaza_User_License['number'])) AND isset ($vbPlaza_User_License['key'])))
      {
        $this->license_name = $vbPlaza_User_License['name'];
        $this->license_email = $vbPlaza_User_License['email'];
        $this->license_url = $vbPlaza_User_License['url'];
        $this->license_options = $vbPlaza_User_License['options'];
        $this->license_date = $vbPlaza_User_License['date'];
        $this->license_number = $vbPlaza_User_License['number'];
        $this->license_key = $vbPlaza_User_License['key'];
        $this->is_licensed = true;
        $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
		return true;
	  }else{
	    $this->license_authorization_failed ();
      }
	}

    function vbplaza_display_error ()
    {
      $args = func_get_args ();
      if (VB_AREA == 'Forum')
      {
        $message = call_user_func_array ('fetch_error', $args);
        eval (standard_error ($message));
        return null;
      }

      call_user_func_array ('print_stop_message', $args);
    }

    function cmx_add_pkcs1_padding ($data, $blocksize)
    {
      $pad_length = $blocksize - 3 - @strlen ($data) / 2;
      $padding = @str_repeat ('FF', $pad_length);
      return '00' . '01' . $padding . '00' . $data;
    }

    function cmx_hex_to_number ($data)
    {
      switch ($this->vbPlaza_Math->math_Class)
      {
        case 'GMP':
        {
          $result = @gmp_strval ('0x' . $data, 10);
          break;
        }

        default:
        {
          $result = '0';
          $length = @strlen ($data);
          $i = 0;
          while ($i < $length - 1)
          {
            $result = $this->vbPlaza_Math->add ($result, @hexdec ($data[$i]));
            $result = $this->vbPlaza_Math->mul ($result, 16);
            ++$i;
          }

          $result = $this->vbPlaza_Math->add ($result, hexdec ($data[$length - 1]));
          break;
        }
      }

      return $result;
    }

    function cmx_number_to_hex ($number)
    {
      switch ($this->vbPlaza_Math->math_Class)
      {
        case 'GMP':
        {
          $result = @gmp_strval ($number, 16);
          break;
        }

        default:
        {
          $hexvalues = array ('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');
          $result = '';
          while ($number != '0')
          {
            $result = $hexvalues[$this->vbPlaza_Math->mod ($number, '16')] . $result;
            $number = $this->vbPlaza_Math->div ($number, '16', 0);
          }
        }
      }

      return $result;
    }

    function cmx_pow_mod ($p, $q, $r)
    {
      switch ($this->vbPlaza_Math->math_Class)
      {
        case 'GMP':
        {
          $result = @gmp_powm ($p, $q, $r);
          $result = @gmp_strval ($result, 10);
          break;
        }

        default:
        {
          $div = $q;
          $factors = array ();
          $power_of_two = 0;
          while ($this->vbPlaza_Math->comp ($div, '0') == 1)
          {
            $rem = $this->vbPlaza_Math->mod ($div, 2);
            $div = $this->vbPlaza_Math->div ($div, 2);
            if ($rem)
            {
              @array_push ($factors, $power_of_two);
            }

            ++$power_of_two;
          }

          $partial_results = array ();
          $part_res = $p;
          $idx = 0;
          foreach ($factors as $factor)
          {
            while ($idx < $factor)
            {
              $part_res = $this->vbPlaza_Math->pow ($part_res, '2');
              $part_res = $this->vbPlaza_Math->mod ($part_res, $r);
              ++$idx;
            }

            @array_push ($partial_results, $part_res);
          }

          $result = '1';
          foreach ($partial_results as $part_res)
          {
            $result = $this->vbPlaza_Math->mul ($result, $part_res);
            $result = $this->vbPlaza_Math->mod ($result, $r);
          }

          break;
        }
      }

      return $result;
    }

    function build_proper_usergroups ($item, $vbplazacategories)
    {
      global $vbulletin;
      $categoryid = $item['categoryid'];
      $categoryallowedgroups = $vbplazacategories['' . $categoryid]['allowedgroups'];
      $allowedgroups = array ();
      if ((!($item['options'] & $vbulletin->bf_misc_vbplaza_item_options['custompermissions']) AND !empty ($categoryallowedgroups)))
      {
        $usergroups = explode (',', $categoryallowedgroups);
        foreach ($usergroups as $usergroupid)
        {
          $allowedgroups['' . $usergroupid] = $usergroupid;
        }
      }

      if (!empty ($item['allowedgroups']))
      {
        $usergroups = explode (',', $item['allowedgroups']);
        foreach ($usergroups as $usergroupid)
        {
          $allowedgroups['' . $usergroupid] = $usergroupid;
        }
      }

      $categorydeniedgroups = $vbplazacategories['' . $categoryid]['deniedgroups'];
      $deniedgroups = array ();
      if ((!($item['options'] & $vbulletin->bf_misc_vbplaza_item_options['custompermissions']) AND !empty ($categorydeniedgroups)))
      {
        $usergroups = explode (',', $categorydeniedgroups);
        foreach ($usergroups as $usergroupid)
        {
          $deniedgroups['' . $usergroupid] = $usergroupid;
        }
      }

      if (!empty ($item['deniedgroups']))
      {
        $usergroups = explode (',', $item['deniedgroups']);
        foreach ($usergroups as $usergroupid)
        {
          $deniedgroups['' . $usergroupid] = $usergroupid;
        }
      }

      if (!empty ($allowedgroups))
      {
        $item['allowedgroups'] = implode (',', $allowedgroups);
      }

      $item['deniedgroups'] = implode (',', $deniedgroups);
      return $item;
    }

    function check_allowed_usergroups ($userinfo, $allowedgroups, $deniedgroups)
    {
      $isallowed = 0;
      $allowed = array ();
      if (!empty ($allowedgroups))
      {
        $allowed = explode (',', $allowedgroups);
      }

      $denied = array ();
      if (!empty ($deniedgroups))
      {
        $denied = explode (',', $deniedgroups);
      }

      if (is_member_of ($userinfo, $allowed))
      {
        $isallowed = 1;
      }

      if (is_member_of ($userinfo, $denied))
      {
        $isallowed = 0;
      }

      return $isallowed;
    }

    function construct_navbits ($navitems)
    {
      global $vbphrase;
      $navbits = array ('vbplaza.php?' . $vbulletin->session->vars['sessionurl'] => $vbphrase['vbplaza_name_title']);
      if (is_array ($navitems))
      {
        foreach ($navitems as $key => $item)
        {
          if (!empty ($item))
          {
            $navbits['' . $key] = $item;
            continue;
          }
        }
      }

      return $navbits;
    }

    function item_initialize ($item)
    {
      global $vbulletin;
      $vbulletin->input->clean_array_gpc ('p', array ('item' => TYPE_ARRAY));
      if ((!empty ($vbulletin->GPC['item']) AND is_array ($vbulletin->GPC['item'])))
      {
        foreach ($vbulletin->GPC['item'] as $index => $value)
        {
          if (is_string ($value))
          {
            $vbulletin->input->clean ($value, TYPE_STR);
          }
          else
          {
            $vbulletin->input->clean ($value, TYPE_NUM);
          }

          $item['' . $index] = $value;
          $item['cleaned']['' . $index] = 1;
        }
      }

      $item = $this->build_proper_usergroups ($item, $vbulletin->vbpcatcache);
      if ((!$item['active'] OR !$this->check_allowed_usergroups ($vbulletin->userinfo, $item['allowedgroups'], $item['deniedgroups'])))
      {
        $this->vbplaza_display_error ('vbplaza_not_allowed_to_purchase');
      }

      $item['inputfields'] = vbplaza_unserialize ($item['inputfields']);
      $item['optionsettings'] = vbplaza_unserialize ($item['optionsettings']);
      $item['stepevalcode'] = vbplaza_unserialize ($item['stepevalcode']);
      if ((!empty ($item['optionsettings']) AND is_array ($item['optionsettings'])))
      {
        foreach ($item['optionsettings'] as $key => $optionsetting)
        {
          if (!isset ($item[$optionsetting['varname']]))
          {
            $item['' . $optionsetting['varname']] = $optionsetting['value'];
            continue;
          }
        }
      }

      unset ($item[optionsettings]);
      if (empty ($item['step']))
      {
        $item['step'] = 1;
      }

      $item['nextstep'] = $item['step'] + 1;
      return $item;
    }

    function process_user_history ($userid = 0)
    {
      global $vbulletin;
      global $vbphrase;
      global $stylevar;
      global $show;
      global $userinfo;
      global $displayedhistory;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      if (0 < $userid)
      {
        $userinfo = $vbulletin->db->query_first ('
				SELECT userid, username, `' . $vbulletin->options['vbbux_points_field'] . '`, `' . $vbulletin->options['vbbux_bank_field'] . '`, vbbux_nextbankinterest, vbplaza_history
				FROM ' . TABLE_PREFIX . $vbulletin->options['vbbux_points_table'] . '
				WHERE userid = ' . $userid . '
			');
        $show['clink'] = 'vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=userhistory&amp;u=' . $userinfo['userid'];
        $show['ctitle'] = $userinfo['username'] . ' - ' . $vbphrase['vbplaza_user_history'];
      }
      else
      {
        $userinfo = $vbulletin->userinfo;
        $show['clink'] = 'vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=userhistory';
        $show['ctitle'] = $userinfo['username'] . ' - ' . $vbphrase['vbplaza_user_history'];
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_user_history_start') ? eval ($hook) : false);
      if (empty ($displayedhistory))
      {
        $userhistory = vbplaza_unserialize ($userinfo['vbplaza_history']);
        if ((!empty ($userhistory) AND is_array ($userhistory)))
        {
          krsort ($userhistory);
          $displayed = 0;
          $vbplazahistorylist = '';
          foreach ($userhistory as $historyid => $history)
          {
            $itemid = $history['itemid'];
            $history['itemname'] = $vbulletin->vbpitemcache['' . $itemid]['title'];
            $history['totalcost'] = vb_number_format ($history['finalcost'], $vbulletin->options['vbplaza_decimal_places']);
            $history['purchase_date'] = vbdate ($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $history['dateline']);
            if (empty ($history['itemname']))
            {
              $history['itemname'] = $vbphrase['vbplaza_unknown_item'];
            }

            if ($history['expires'])
            {
              $history['expiry_date'] = vbdate ($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $history['expires']);
              if ($userinfo['userid'] == $vbulletin->userinfo['userid'])
              {
                $history['expiry_date'] .= ' [<a href="vbplaza.php?do=expire&amp;id=' . $historyid . '">' . $vbphrase['vbplaza_expire_now'] . '</a>]';
              }
            }
            else
            {
              $history['expiry_date'] = $vbphrase['vbplaza_never'];
              if ($userinfo['userid'] == $vbulletin->userinfo['userid'])
              {
                $history['expiry_date'] .= ' [<a href="vbplaza.php?do=removelog&amp;id=' . $historyid . '">' . $vbphrase['vbplaza_remove_log'] . '</a>]';
              }
            }

            $this->vbplaza_fixup_extraname ($history);
            if (strstr ($history['reason'], 'Password'))
            {
              if ($vbulletin->userinfo['userid'] != $userinfo['userid'])
              {
                unset ($history[reason]);
              }
            }

            if ($displayed & 1)
            {
              $classname = 'alt2';
            }
            else
            {
              $classname = 'alt1';
            }

            ($hook = vbulletinhook::fetch_hook ('vbplaza_user_history_listbits') ? eval ($hook) : false);
            eval ('$vbplazahistorylist .= "' . fetch_template ('vbplaza_user_history_listbits') . '";');
            ++$displayed;
            if (($_REQUEST['do'] != 'userhistory' AND 4 < $displayed))
            {
              break;
              continue;
            }
          }
        }
      }

      $userinfo['points'] = vb_number_format ($userinfo[$vbulletin->options['vbbux_points_field']], $vbulletin->options['vbplaza_decimal_places']);
      $userinfo['bankpoints'] = vb_number_format ($userinfo[$vbulletin->options['vbbux_bank_field']], $vbulletin->options['vbplaza_decimal_places']);
      if (0 < $userinfo[$vbulletin->options['vbbux_bank_field']])
      {
        $userinfo['nextinterest'] = vbdate ($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $userinfo['vbbux_nextbankinterest']);
      }
      else
      {
        $userinfo['nextinterest'] = construct_phrase ($vbphrase['vbplaza_no_points_in_bank_yet'], $vbphrase['vbbux_name_title'], $vbphrase['vbbux_bank']);
      }

      $show['historylist'] = (!empty ($vbplazahistorylist) ? true : false);
      ($hook = vbulletinhook::fetch_hook ('vbplaza_user_history_complete') ? eval ($hook) : false);
      if (empty ($displayedhistory))
      {
        eval ('$displayedhistory = "' . fetch_template ('vbplaza_user_history_list') . '";');
      }

    }

    function do_cancel_sale ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      if (!$vbulletin->options['vbplaza_users_can_sell_inventory_items'])
      {
        eval (standard_error (fetch_error ('vbplaza_user_inventory_items_not_sellable')));
      }

      $vbulletin->input->clean_array_gpc ('r', array ('useritemid' => TYPE_UINT));
      $useritem = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_user_inventory WHERE useritemid = ' . $vbulletin->GPC['useritemid']);
      if (((empty ($useritem) OR !is_array ($useritem)) OR !$useritem['useritemid']))
      {
        eval (standard_error (fetch_error ('vbplaza_user_inventory_item_not_found')));
      }

      if ($useritem['userid'] != $vbulletin->userinfo['userid'])
      {
        eval (standard_error (fetch_error ('vbplaza_can_not_sell_others_user_inventory_items')));
      }

      $vbulletin->db->query_write (@vbplaza_fetch_query_sql (array ('forsale' => '0', 'sellprice' => '0.0000'), 'vbplaza_user_inventory', 'WHERE useritemid = ' . $useritem['useritemid']));
      $_REQUEST['do'] = 'inventory';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_download ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('attachmentid' => TYPE_UINT, 'd' => TYPE_UINT));
      $item = array ();
      if (0 < $vbulletin->GPC['attachmentid'])
      {
        $attachinfo = $vbulletin->db->query_first ('
				SELECT attachmentid, filename, vbbux
				FROM ' . TABLE_PREFIX . 'attachment
				WHERE attachmentid = ' . $vbulletin->GPC['attachmentid'] . '
			');
        if (0 < $attachinfo['attachmentid'])
        {
          $attachmentid = $vbulletin->GPC['attachmentid'];
          $dateline = $vbulletin->GPC['d'];
          $item['cost'] = $attachinfo['vbbux'];
          $item['name'] = $attachinfo['filename'];
          $item['tax'] = $vbulletin->options['vbbux_attachment_tax_rate'];
        }
      }

      if ((!empty ($item) AND is_array ($item)))
      {
        @require_once DIR . '/vbplaza/includes/functions_items.php';
        vbplaza_calculate_total_cost ($item);
        eval ('$current .= "' . fetch_template ('vbplaza_download_confirmation') . '";');
        $this->display_output ();
        return null;
      }

      $_REQUEST['do'] = 'main';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_edit_options ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $options = array ('0' => array ('phrasename' => $vbphrase['vbplaza_hide_gifts_postbit'], 'selectname' => 'hidegiftsinposts', 'enabled' => $vbulletin->userinfo['vbplaza_options'] & $vbulletin->bf_misc_vbplaza_options['hidegiftsinposts'], 'allowed' => $vbulletin->options['vbplaza_show_hidegifts_postbits']), '1' => array ('phrasename' => $vbphrase['vbplaza_hide_ribbons_postbit'], 'selectname' => 'hideribbonsinposts', 'enabled' => $vbulletin->userinfo['vbplaza_options'] & $vbulletin->bf_misc_vbplaza_options['hideribbonsinposts'], 'allowed' => $vbulletin->options['vbplaza_show_hideribbons_postbits']), '2' => array ('phrasename' => $vbphrase['vbplaza_do_not_receive_pm_upon_new_gift'], 'selectname' => 'nopmuponnewgift', 'enabled' => $vbulletin->userinfo['vbplaza_options'] & $vbulletin->bf_misc_vbplaza_options['nopmuponnewgift'], 'allowed' => $vbulletin->options['vbplaza_show_receivenopm_upon_newgift']), '3' => array ('phrasename' => $vbphrase['vbplaza_do_not_receive_pm_upon_new_ribbon'], 'selectname' => 'nopmuponnewribbon', 'enabled' => $vbulletin->userinfo['vbplaza_options'] & $vbulletin->bf_misc_vbplaza_options['nopmuponnewribbon'], 'allowed' => $vbulletin->options['vbplaza_show_receivenopm_upon_newribbon']), '4' => array ('phrasename' => construct_phrase ($vbphrase['vbplaza_hide_points_postbit'], $vbphrase['vbbux_points']), 'selectname' => 'hidepointsinposts', 'enabled' => $vbulletin->userinfo['vbplaza_options'] & $vbulletin->bf_misc_vbplaza_options['hidepointsinposts'], 'allowed' => $vbulletin->options['vbplaza_showhidepointsinposts']), '5' => array ('phrasename' => construct_phrase ($vbphrase['vbplaza_hide_x_changes_postbit'], $vbphrase['username']), 'selectname' => 'hideusernamechangesinposts', 'enabled' => $vbulletin->userinfo['vbplaza_options'] & $vbulletin->bf_misc_vbplaza_options['hideusernamechangesinposts'], 'allowed' => $vbulletin->options['vbplaza_showhideusernamechangesinposts']), '6' => array ('phrasename' => construct_phrase ($vbphrase['vbplaza_hide_x_changes_postbit'], $vbphrase['vbplaza_usertitle']), 'selectname' => 'hideusertitlechangesinposts', 'enabled' => $vbulletin->userinfo['vbplaza_options'] & $vbulletin->bf_misc_vbplaza_options['hideusertitlechangesinposts'], 'allowed' => $vbulletin->options['vbplaza_showhideusertitlechangesinposts']));
      $cansetoptions = false;
      foreach ($options as $option)
      {
        if ($option['allowed'] == 1)
        {
          if (0 < $option['enabled'])
          {
            $option['options'] = '<option value="1" selected="selected">' . $vbphrase['yes'] . '</option><option value="0">' . $vbphrase['no'] . '</option>';
          }
          else
          {
            $option['options'] = '<option value="1">' . $vbphrase['yes'] . '</option><option value="0" selected="selected">' . $vbphrase['no'] . '</option>';
          }

          $cansetoptions = true;
          eval ('$editvbplazaoptions .= "' . fetch_template ('vbplaza_edit_options_listbits') . '";');
          continue;
        }
      }

      if ($cansetoptions != true)
      {
        $this->vbplaza_display_error ('vbplaza_not_allowed_to_change_vbplaza_options', $vbphrase['vbplaza_name_title']);
      }

      eval ('$current = "' . fetch_template ('vbplaza_edit_options_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editoptions'] = construct_phrase ($vbphrase['vbplaza_edit_options'], $vbphrase['vbplaza_name_title']);
      $this->display_output ();
    }

    function do_expire ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('id' => TYPE_UINT));
      $userhistory = vbplaza_unserialize ($vbulletin->userinfo['vbplaza_history']);
      if ((!empty ($userhistory) AND is_array ($userhistory)))
      {
        $historyid = $vbulletin->GPC['id'];
        $userhistory['' . $historyid]['expires'] = TIMENOW - 1;
        $vbulletin->userinfo['vbplaza_history'] = serialize ($userhistory);
      }

      $_REQUEST['do'] = 'expireitems';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_expire_items ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $show;
      global $pagetitle;
      global $displayedhistory;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $userhistory = vbplaza_unserialize ($vbulletin->userinfo['vbplaza_history']);
      if ((!empty ($userhistory) AND is_array ($userhistory)))
      {
        @require_once DIR . '/vbplaza/includes/functions_items.php';
        $displayed = 0;
        $expired_items = 0;
        $update_history = false;
        $vbplazahistorylist = '';
        foreach ($userhistory as $historyid => $history)
        {
          if (($history['expires'] AND $history['expires'] < TIMENOW))
          {
            if (vbplaza_expire_item ($vbulletin->userinfo, $history))
            {
              $itemid = $history['itemid'];
              $history['itemname'] = $vbulletin->vbpitemcache['' . $itemid]['title'];
              $history['totalcost'] = vb_number_format ($history['finalcost'], $vbulletin->options['vbplaza_decimal_places']);
              $history['purchase_date'] = vbdate ($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $history['dateline']);
              $history['expiry_date'] = $vbphrase['vbplaza_now'];
              if (empty ($history['itemname']))
              {
                $history['itemname'] = $vbphrase['vbplaza_unknown_item'];
              }

              $this->vbplaza_fixup_extraname ($history);
              if ($displayed & 1)
              {
                $classname = 'alt2';
              }
              else
              {
                $classname = 'alt1';
              }

              eval ('$vbplazahistorylist .= "' . fetch_template ('vbplaza_user_history_listbits') . '";');
              ++$displayed;
              unset ($userhistory['' . $historyid]);
              $update_history = true;
            }

            ++$expired_items;
            continue;
          }
        }

        if ($update_history)
        {
          $userhistory = serialize ($userhistory);
          $vbulletin->db->query_write (@vbplaza_fetch_query_sql (array ('vbplaza_history' => $userhistory), $vbulletin->options['vbbux_points_table'], 'WHERE userid = ' . $vbulletin->userinfo['userid']));
        }

        if ($expired_items)
        {
          $show['historylist'] = (!empty ($vbplazahistorylist) ? true : false);
          eval ('$displayedhistory = "' . fetch_template ('vbplaza_user_history_list') . '";');
          $this->display_output ();
          return null;
        }

        $this->vbplaza_display_error ('vbplaza_no_items_have_expired');
        return null;
      }

      $this->vbplaza_display_error ('vbplaza_no_items_have_expired');
    }

    function do_hide_gift ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('giftid' => TYPE_UINT));
      $giftuser = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_gift_user WHERE giftid = ' . $vbulletin->GPC['giftid']);
      if ((0 < $giftuser['giftid'] AND $giftuser['touserid'] == $vbulletin->userinfo['userid']))
      {
        $giftuserdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Gift_User', $vbulletin, ERRTYPE_STANDARD);
        $giftuserdata->set_existing ($giftuser);
        $giftuserdata->set ('visible', 0);
        $giftuserdata->save ();
        unset ($giftuserdata);
        vbplaza_rebuild_gift_postbit ($giftuser['touserid']);
        eval (print_standard_redirect ('vbplaza_gift_visible_status_updated'));
      }

    }

    function do_hide_ribbon ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('ribbonid' => TYPE_UINT));
      $ribbonuser = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_ribbon_user WHERE ribbonid = ' . $vbulletin->GPC['ribbonid']);
      if ((0 < $ribbonuser['ribbonid'] AND $ribbonuser['touserid'] == $vbulletin->userinfo['userid']))
      {
        $ribbonuserdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Ribbon_User', $vbulletin, ERRTYPE_STANDARD);
        $ribbonuserdata->set_existing ($ribbonuser);
        $ribbonuserdata->set ('visible', 0);
        $ribbonuserdata->save ();
        unset ($ribbonuserdata);
        vbplaza_rebuild_ribbon_postbit ($ribbonuser['touserid']);
        eval (print_standard_redirect ('vbplaza_ribbon_visible_status_updated'));
      }

    }

    function do_inventory ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $show;
      global $pagetitle;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('page' => TYPE_UINT));
      ($hook = vbulletinhook::fetch_hook ('vbplaza_user_inventory_start') ? eval ($hook) : false);
      $user_item_data = $vbulletin->db->query_first ('
			SELECT COUNT(*) AS count
			FROM ' . TABLE_PREFIX . 'vbplaza_user_inventory
			WHERE userid = ' . $vbulletin->userinfo['userid'] . '
		');
      if (!$user_item_data['count'])
      {
        $this->vbplaza_display_error ('vbplaza_no_user_items_purchased', $vbphrase['vbplaza_name_title']);
      }

      $perpage = $vbulletin->options['vbplaza_user_inventory_per_page'];
      if (!(0 < $perpage))
      {
        $perpage = 20;
      }

      if (!(0 < $vbulletin->GPC['page']))
      {
        $vbulletin->GPC['page'] = 1;
      }

      if (1 < $vbulletin->GPC['page'])
      {
        $skip = $perpage * ($vbulletin->GPC['page'] - 1);
        $limitstr = 'LIMIT ' . $skip . ', ' . $perpage;
        $skip += 1;
      }
      else
      {
        $skip = 1;
        $limitstr = 'LIMIT 0, ' . $perpage;
      }

      $useritems = $vbulletin->db->query_read ('
			SELECT *
			FROM ' . TABLE_PREFIX . 'vbplaza_user_inventory
			WHERE userid = ' . $vbulletin->userinfo['userid'] . '
			ORDER BY dateline DESC
			' . $limitstr . '
		');
      if ((!$useritems OR !$vbulletin->db->num_rows ($useritems)))
      {
        $this->vbplaza_display_error ('vbplaza_no_user_items_purchased', $vbphrase['vbplaza_name_title']);
      }

      $show['cansell'] = ($vbulletin->options['vbplaza_users_can_sell_inventory_items'] ? true : false);
      $pagenav = construct_page_nav ($vbulletin->GPC['page'], $perpage, $user_item_data['count'], 'vbplaza.php?do=inventory', '');
      $displayed = 0;
      $vbplazauseritemlist = '';
      while ($useritem = $vbulletin->db->fetch_array ($useritems))
      {
        $useritem['itemname'] = $skip++ . ') ' . $useritem['itemname'];
        $useritem['date'] = vbdate ($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $useritem['dateline']);
        $useritem['cost'] = vb_number_format ($useritem['finalcost'], $vbulletin->options['vbplaza_decimal_places']);
        $useritem['itemlink'] = 'do=item&amp;itemid=' . $useritem['itemid'];
        if ($show['cansell'])
        {
          $show['forsale'] = ($useritem['forsale'] ? true : false);
          if ($show['forsale'])
          {
            $useritem['sellcost'] = vb_number_format ($useritem['sellprice'], $vbulletin->options['vbplaza_decimal_places']);
          }
        }

        if ($useritem['cost'] == 0)
        {
          $useritem['cost'] = $vbphrase['vbplaza_free'];
        }

        if ($displayed & 1)
        {
          $classname = 'alt1';
        }
        else
        {
          $classname = 'alt2';
        }

        $useritembits = '';
        $item_options = array ('0' => $vbphrase['no'], '1' => $vbphrase['yes']);
        foreach ($item_options as $item_value => $item_name)
        {
          $item_selected = ($useritem['active'] == $item_value ? ' selected="selected"' : '');
          $useritembits .= '<option value="' . $item_value . '"' . $item_selected . '>' . $item_name . '</option>';
        }

        ($hook = vbulletinhook::fetch_hook ('vbplaza_user_inventory_listbits') ? eval ($hook) : false);
        eval ('$vbplazauseritemlist .= "' . fetch_template ('vbplaza_user_inventory_listbits') . '";');
        ++$displayed;
      }

      $vbulletin->db->free_result ($useritems);
      if (empty ($vbplazauseritemlist))
      {
        $this->vbplaza_display_error ('vbplaza_no_user_items_purchased', $vbphrase['vbplaza_name_title']);
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_user_inventory_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_user_inventory_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=inventory'] = $vbphrase['vbplaza_inventory'];
      $this->display_output ();
    }

    function do_inventory_update ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('p', array ('useritems' => TYPE_ARRAY_BOOL));
      @require_once DIR . '/vbplaza/includes/functions_inventory.php';
      vbplaza_update_user_inventory ();
      $_REQUEST['do'] = 'inventory';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_item ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $show;
      global $pagetitle;
      global $current;
      global $tabledata;
      global $extra_fields;
      global $item;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('itemid' => TYPE_UINT, 'name' => TYPE_STR));
      if (0 < $vbulletin->GPC['itemid'])
      {
        $item = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_item WHERE itemid = ' . $vbulletin->GPC['itemid']);
      }
      else
      {
        $item = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_item WHERE varname = \'' . $vbulletin->GPC['name'] . '\'');
      }

      if ((empty ($item) OR !is_array ($item)))
      {
        $this->vbplaza_display_error ('vbplaza_item_not_found');
      }

      if (!empty ($vbulletin->userinfo['vbplaza_banneditems']))
      {
        $banned_items = explode (',', $vbulletin->userinfo['vbplaza_banneditems']);
        if ((!empty ($banned_items) AND is_array ($banned_items)))
        {
          if (in_array ($item['itemid'], $banned_items))
          {
            $this->vbplaza_display_error ('vbplaza_banned_from_this_item');
          }
        }
      }

      $categoryid = $item['categoryid'];
      $category = $vbulletin->vbpcatcache['' . $categoryid];
      if (!$category['active'])
      {
        $this->vbplaza_display_error ('vbplaza_item_not_found');
      }

      if (0 < $item['refillquantity'])
      {
        if (!$item['quantity'])
        {
          eval (standard_error (fetch_error ('vbplaza_x_out_of_stock', $vbphrase['vbplaza_item'])));
        }
      }

      $item_data = array ('itemid' => $item['itemid'], 'title' => $item['title'], 'scriptcode' => $item['scriptcode'], 'scriptlocation' => $item['scriptlocation'], 'tablename' => $item['tablename'], 'wherename' => $item['wherename'], 'wherevalue' => $item['wherevalue'], 'setname' => $item['setname'], 'settype' => $item['settype'], 'setvalue' => $item['setvalue'], 'optionsettings' => $item['optionsettings'], 'inputfields' => $item['inputfields'], 'stepevalcode' => $item['stepevalcode']);
      $item_license = sha1 (md5 ($this->license_url . md5 ($this->license_name . @serialize ($item_data)) . $this->license_number) . $this->license_key);
      if ($item['license'] != $item_license)
      {
        $this->vbplaza_display_error ('vbplaza_feature_not_licensed');
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_item_start') ? eval ($hook) : false);
      @require_once DIR . '/vbplaza/includes/functions_items.php';
      vbplaza_calculate_total_cost ($item);
      $item = $this->item_initialize ($item);
      switch ($item['scripttype'])
      {
        case 0:
        {
          include_once DIR . '/vbplaza/items/generic.php';
          do_item_generic ();
          break;
        }

        case 1:
        {
          include_once DIR . '/vbplaza/items/generic_thread.php';
          do_item_generic_thread ();
          break;
        }

        case 2:
        {
          if (!empty ($item['scriptlocation']))
          {
            if (!file_exists (DIR . '/' . $item['scriptlocation']))
            {
              $this->vbplaza_display_error ('vbplaza_item_not_found');
            }

            include_once DIR . '/' . $item['scriptlocation'];
            break;
          }
          else
          {
            if (!empty ($item['scriptcode']))
            {
              eval ($item['scriptcode']);
              break;
            }
            else
            {
              include_once DIR . '/vbplaza/items/generic.php';
              do_item_generic ();
            }
          }
        }
      }

      $categoryid = $item['categoryid'];
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=list&amp;cid=' . $categoryid] = $vbulletin->vbpcatcache['' . $categoryid]['title'];
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=item&amp;itemid=' . $item['itemid']] = $item['title'];
      $this->display_output ();
    }

    function do_item_history ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $show;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('downloads' => TYPE_BOOL, 'historyid' => TYPE_UINT, 'itemid' => TYPE_UINT, 'page' => TYPE_UINT));
      $show['userhistory'] = false;
      ($hook = vbulletinhook::fetch_hook ('vbplaza_item_history_start') ? eval ($hook) : false);
      if (!($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['canviewitemhistory']))
      {
        $this->vbplaza_display_error ('vbplaza_not_allowed_to_view_item_history');
      }

      $visiblehistory = 'AND visible = 1';
      if (is_member_of ($vbulletin->userinfo, 6))
      {
        $visiblehistory = 'AND (visible IN (0,1,2))';
      }

      if ($vbulletin->GPC['downloads'])
      {
        $itemhistory = $vbulletin->db->query_first ('
				SELECT COUNT(*) AS count
				FROM ' . TABLE_PREFIX . 'vbplaza_item_history
				WHERE (attachmentid > 0)
					' . $visiblehistory . '
				ORDER BY dateline DESC
			');
      }
      else
      {
        if (0 < $vbulletin->GPC['itemid'])
        {
          $itemhistory = $vbulletin->db->query_first ('
					SELECT COUNT(*) AS count
					FROM ' . TABLE_PREFIX . 'vbplaza_item_history
					WHERE (itemid = ' . $vbulletin->GPC['itemid'] . ')
						' . $visiblehistory . '
					ORDER BY dateline DESC
				');
        }
        else
        {
          $itemhistory = $vbulletin->db->query_first ('
					SELECT COUNT(*) AS count
					FROM ' . TABLE_PREFIX . 'vbplaza_item_history
					WHERE (itemid > 0)
						' . $visiblehistory . '
					ORDER BY dateline DESC
				');
        }
      }

      if (!$itemhistory['count'])
      {
        $this->vbplaza_display_error ('vbplaza_no_item_history_recorded', $vbphrase['vbplaza_name_title']);
      }

      $perpage = $vbulletin->options['vbplaza_item_history_per_page'];
      if (!(0 < $perpage))
      {
        $perpage = 20;
      }

      if (!(0 < $vbulletin->GPC['page']))
      {
        $vbulletin->GPC['page'] = 1;
      }

      if (1 < $vbulletin->GPC['page'])
      {
        $skip = $perpage * ($vbulletin->GPC['page'] - 1);
        $limitstr = 'LIMIT ' . $skip . ', ' . $perpage;
        $skip += 1;
      }
      else
      {
        $skip = 1;
        $limitstr = 'LIMIT 0, ' . $perpage;
      }

      if ($vbulletin->GPC['downloads'])
      {
        $purchases = $vbulletin->db->query_read ('
				SELECT *
				FROM ' . TABLE_PREFIX . 'vbplaza_item_history
				WHERE (attachmentid > 0)
					' . $visiblehistory . '
				ORDER BY dateline DESC
				' . $limitstr . '
			');
      }
      else
      {
        if (0 < $vbulletin->GPC['itemid'])
        {
          $purchases = $vbulletin->db->query_read ('
					SELECT *
					FROM ' . TABLE_PREFIX . 'vbplaza_item_history
					WHERE (itemid = ' . $vbulletin->GPC['itemid'] . ')
						' . $visiblehistory . '
					ORDER BY dateline DESC
					' . $limitstr . '
				');
          $itemid = $vbulletin->GPC['itemid'];
          $item['itemid'] = $vbulletin->vbpitemcache['' . $itemid]['itemid'];
          $item['title'] = $vbulletin->vbpitemcache['' . $itemid]['title'];
          if (!$item['itemid'])
          {
            $item['title'] = $vbphrase['vbplaza_unknown_item'];
          }
        }
        else
        {
          $purchases = $vbulletin->db->query_read ('
					SELECT *
					FROM ' . TABLE_PREFIX . 'vbplaza_item_history
					WHERE (itemid > 0)
						' . $visiblehistory . '
					ORDER BY dateline DESC
					' . $limitstr . '
				');
          $item['itemid'] = '0';
        }
      }

      if ((!$purchases OR !$vbulletin->db->num_rows ($purchases)))
      {
        $this->vbplaza_display_error ('vbplaza_no_item_history_recorded', $vbphrase['vbplaza_name_title']);
      }

      $show['inlinemod'] = false;
      if ($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['candeleteitemhistory'])
      {
        $show['inlinemod'] = true;
      }

      $pagenav = construct_page_nav ($vbulletin->GPC['page'], $perpage, $itemhistory['count'], 'vbplaza.php?do=itemhistory' . ($vbulletin->GPC['itemid'] ? '&amp;itemid=' . $vbulletin->GPC['itemid'] : ''), '');
      $displayed = 0;
      $vbplazahistorylist = '';
      while ($purchase = $vbulletin->db->fetch_array ($purchases))
      {
        $purchase['itemname'] = $skip++ . ') ' . $purchase['itemname'];
        $purchase['date'] = vbdate ($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $purchase['dateline']);
        $purchase['cost'] = vb_number_format ($purchase['finalcost'], $vbulletin->options['vbplaza_decimal_places']);
        $show['extrainfo'] = false;
        if (!empty ($purchase['extrainfo']))
        {
          $show['extrainfo'] = true;
        }

        if (0 < $purchase['attachmentid'])
        {
          $purchase['itemlink'] = 'do=itemhistory&amp;downloads=1';
        }
        else
        {
          $purchase['itemlink'] = 'do=item&amp;itemid=' . $purchase['itemid'];
        }

        $this->vbplaza_fixup_extraname ($purchase);
        if (strstr ($purchase['reason'], 'Password'))
        {
          unset ($purchase[reason]);
        }

        if ($purchase['cost'] == 0)
        {
          $purchase['cost'] = $vbphrase['vbplaza_free'];
        }

        if ($purchase['visible'] == 2)
        {
          $purchase['itemname'] = '<span style="font-style: italic;">' . $purchase['itemname'] . '</span>';
          $purchase['username'] = '<span style="font-style: italic;">' . $purchase['username'] . '</span>';
          $purchase['date'] = '<span style="font-style: italic;">' . $purchase['date'] . '</span>';
          $purchase['cost'] = '<span style="font-style: italic;">' . $purchase['cost'] . '</span>';
        }

        if ($displayed & 1)
        {
          $classname = 'alt2';
        }
        else
        {
          $classname = 'alt1';
        }

        ($hook = vbulletinhook::fetch_hook ('vbplaza_item_history_listbits') ? eval ($hook) : false);
        eval ('$vbplazahistorylist .= "' . fetch_template ('vbplaza_item_history_listbits') . '";');
        ++$displayed;
      }

      $vbulletin->db->free_result ($purchases);
      if (empty ($vbplazahistorylist))
      {
        $this->vbplaza_display_error ('vbplaza_no_item_history_recorded', $vbphrase['vbplaza_name_title']);
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_item_history_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_item_history_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=itemhistory' . ($vbulletin->GPC['itemid'] ? '&amp;itemid=' . $vbulletin->GPC['itemid'] : '')] = $vbphrase['vbplaza_item_history'];
      $this->display_output ();
    }

    function do_list ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $show;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('cid' => TYPE_UINT, 'itemid' => TYPE_UINT));
      $categoryid = $vbulletin->GPC['cid'];
      $category = $vbulletin->vbpcatcache['' . $categoryid];
      $vbplazaitemlist = '';
      if ($category['active'])
      {
        $category_data = array ('categoryid' => $category['categoryid'], 'title' => $category['title']);
        $category_license = sha1 (md5 ($this->license_url . md5 ($this->license_name . @serialize ($category_data)) . $this->license_number) . $this->license_key);
        if ($category['license'] != $category_license)
        {
          $this->vbplaza_display_error ('vbplaza_feature_not_licensed');
        }

        $show['itemwidth'] = 100 / $vbulletin->options['vbplaza_items_per_row'] - 1 . '%';
        ($hook = vbulletinhook::fetch_hook ('vbplaza_list_items_start') ? eval ($hook) : false);
        $displayed = 0;
        foreach ($vbulletin->vbpitemcache as $itemid => $item)
        {
          if ($item['categoryid'] == $vbulletin->GPC['cid'])
          {
            $item = $this->build_proper_usergroups ($item, $vbulletin->vbpcatcache);
            if ((($item['active'] AND $item['options'] & $vbulletin->bf_misc_vbplaza_item_options['showinvbplaza']) AND $this->check_allowed_usergroups ($vbulletin->userinfo, $item['allowedgroups'], $item['deniedgroups'])))
            {
              if (!($displayed % $vbulletin->options['vbplaza_items_per_row']))
              {
                $vbplazaitemlist .= '	<tr>
';
              }

              if (!$item['refillquantity'])
              {
                $item['totalitems'] = $vbphrase['vbplaza_unlimited'];
              }
              else
              {
                $item['totalitems'] = $item['quantity'];
              }

              $item['totalsold'] = $item['sold'];
              if (!($item['options'] & $vbulletin->bf_misc_vbplaza_item_options['autobuildcost']))
              {
                $item['totalcost'] = $vbphrase['vbplaza_tbd'];
              }
              else
              {
                $item['totalcost'] = vb_number_format ($item['cost'], $vbulletin->options['vbplaza_decimal_places']);
              }

              ($hook = vbulletinhook::fetch_hook ('vbplaza_list_items_listbits') ? eval ($hook) : false);
              eval ('$vbplazaitemlist .= "' . fetch_template ('vbplaza_item_listbits') . '";');
              ++$displayed;
              if ($displayed % $vbulletin->options['vbplaza_items_per_row'] == 0)
              {
                $vbplazaitemlist .= '	</tr>
';
                continue;
              }

              continue;
            }

            continue;
          }
        }
      }

      if (empty ($vbplazaitemlist))
      {
        $this->vbplaza_display_error ('vbplaza_no_items_in_category', $vbphrase['vbplaza_name_title']);
      }

      if (!$vbulletin->GPC['cid'])
      {
        $show['clink'] = 'vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main';
        $show['ctitle'] = $vbphrase['vbplaza_all_categories'];
      }
      else
      {
        $categoryid = $vbulletin->GPC['cid'];
        $show['clink'] = 'vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=list&cid=' . $categoryid;
        $show['ctitle'] = $vbulletin->vbpcatcache['' . $categoryid]['title'];
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_list_items_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_item_list') . '";');
      $categoryid = $vbulletin->GPC['cid'];
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=list&amp;cid=' . $categoryid] = $vbulletin->vbpcatcache['' . $categoryid]['title'];
      $this->display_output ();
    }

    function do_lottery_winners ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $show;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('page' => TYPE_UINT));
      ($hook = vbulletinhook::fetch_hook ('vbplaza_lottery_winners_start') ? eval ($hook) : false);
      if (!($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['canviewlotterywinners']))
      {
        $this->vbplaza_display_error ('vbplaza_not_allowed_to_view_lottery_winners');
      }

      $visiblewinner = 'AND visible = 1';
      if (is_member_of ($vbulletin->userinfo, 6))
      {
        $visiblewinner = 'AND (visible IN (0,1,2))';
      }

      $lotterywinners = $vbulletin->db->query_first ('
			SELECT COUNT(*) AS count
			FROM ' . TABLE_PREFIX . 'vbplaza_lottery_winner
			WHERE (lotteryid > 0)
				' . $visiblewinner . '
		');
      if (!$lotterywinners['count'])
      {
        $this->vbplaza_display_error ('vbplaza_no_lottery_winners_recorded');
      }

      $perpage = $vbulletin->options['vbplaza_lottery_winners_per_page'];
      if (!(0 < $perpage))
      {
        $perpage = 20;
      }

      if (!(0 < $vbulletin->GPC['page']))
      {
        $vbulletin->GPC['page'] = 1;
      }

      if (1 < $vbulletin->GPC['page'])
      {
        $skip = $perpage * ($vbulletin->GPC['page'] - 1);
        $limitstr = 'LIMIT ' . $skip . ', ' . $perpage;
        $skip += 1;
      }
      else
      {
        $skip = 1;
        $limitstr = 'LIMIT 0, ' . $perpage;
      }

      $winners = $vbulletin->db->query_read ('
			SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_lottery_winner
			WHERE (lotteryid > 0)
				' . $visiblewinner . '
			ORDER BY dateline DESC
			' . $limitstr . '
		');
      if ((!$winners OR !$vbulletin->db->num_rows ($winners)))
      {
        $this->vbplaza_display_error ('vbplaza_no_lottery_winners_recorded');
      }

      $pagenav = construct_page_nav ($vbulletin->GPC['page'], $perpage, $lotterywinners['count'], 'vbplaza.php?do=lotterywinners', '');
      $show['inlinemod'] = false;
      if ($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['candeletelotterywinners'])
      {
        $show['inlinemod'] = true;
      }

      $displayed = 0;
      $vbplazalotterywinnerlist = '';
      while ($winner = $vbulletin->db->fetch_array ($winners))
      {
        $winner['numbers'] = vbplaza_unserialize ($winner['numbers']);
        if (((empty ($winner['numbers']) OR !is_array ($winner['numbers'])) OR !count ($winner['numbers'])))
        {
          $winner['winning_numbers'] = $vbphrase['vbplaza_raffle'];
        }
        else
        {
          $winner['winning_numbers'] = '(' . implode (',', $winner['numbers']) . ')';
        }

        $winner['lotteryname'] = $skip++ . ') ' . $winner['title'];
        $winner['date'] = vbdate ($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $winner['dateline']);
        $winner['jackpot'] = vb_number_format ($winner['jackpot'], $vbulletin->options['vbplaza_decimal_places']);
        $winner['amountwon'] = vb_number_format ($winner['winningamount'], $vbulletin->options['vbplaza_decimal_places']);
        if ($winner['visible'] == 2)
        {
          $winner['lotteryname'] = '<span style="font-style: italic;">' . $winner['lotteryname'] . '</span>';
          $winner['username'] = '<span style="font-style: italic;">' . $winner['username'] . '</span>';
          $winner['winning_numbers'] = '<span style="font-style: italic;">' . $winner['winning_numbers'] . '</span>';
          $winner['date'] = '<span style="font-style: italic;">' . $winner['date'] . '</span>';
          $winner['jackpot'] = '<span style="font-style: italic;">' . $winner['jackpot'] . '</span>';
          $winner['amountwon'] = '<span style="font-style: italic;">' . $winner['amountwon'] . '</span>';
        }

        if ($displayed & 1)
        {
          $classname = 'alt2';
        }
        else
        {
          $classname = 'alt1';
        }

        ($hook = vbulletinhook::fetch_hook ('vbplaza_lottery_winners_listbits') ? eval ($hook) : false);
        eval ('$vbplazalotterywinnerlist .= "' . fetch_template ('vbplaza_lottery_winners_listbits') . '";');
        ++$displayed;
      }

      $vbulletin->db->free_result ($winners);
      if (empty ($vbplazalotterywinnerlist))
      {
        $this->vbplaza_display_error ('vbplaza_no_lottery_winners_recorded');
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_lottery_winners_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_lottery_winners_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lotterywinners'] = $vbphrase['vbplaza_lottery_winners'];
      $this->display_output ();
    }

    function do_main ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $show;
      global $current;
      global $richestusers;
      global $mostsolditems;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('categoryid' => TYPE_UINT));
      $show['richestsold'] = true;
      $show['categorywidth'] = 100 / $vbulletin->options['vbplaza_categories_per_row'] - 1 . '%';
      ($hook = vbulletinhook::fetch_hook ('vbplaza_main_start') ? eval ($hook) : false);
      $richestusercache = array ();
      if ($users = $vbulletin->db->query_read ('
			SELECT user.`userid`, user.`username`, user.`' . $vbulletin->options['vbbux_points_field'] . '`, user.`' . $vbulletin->options['vbbux_bank_field'] . '`,
				(user.`' . $vbulletin->options['vbbux_points_field'] . '` + user.`' . $vbulletin->options['vbbux_bank_field'] . '`) AS totalpoints,
				usergroup.`vbplaza_settings` AS vbplaza_settings
			FROM ' . TABLE_PREFIX . $vbulletin->options['vbbux_points_table'] . ' AS user
			LEFT JOIN ' . TABLE_PREFIX . 'usergroup AS usergroup ON (user.usergroupid = usergroup.usergroupid)
			WHERE NOT (vbplaza_settings & ' . $vbulletin->bf_ugp_vbplaza_settings['excludefromrichest'] . ')
			ORDER BY totalpoints DESC
			LIMIT 10
		'))
      {
        while ($user = $vbulletin->db->fetch_array ($users))
        {
          $richestid = $user['userid'];
          $richestusercache['' . $richestid] = $user;
        }

        $vbulletin->db->free_result ($richestusers);
      }

      $richestusers = '';
      if ((!empty ($richestusercache) AND is_array ($richestusercache)))
      {
        foreach ($richestusercache as $richestid => $user)
        {
          $userpoints = vb_number_format ($user['totalpoints'], $vbulletin->options['vbbux_decimal_places']);
          $richestusers .= '<div class="smallfont"><a href="member.php?u=' . $user['userid'] . '">' . $user['username'] . '</a> - ' . $userpoints . ' ' . $vbphrase['vbbux_points'] . '</div>
';
        }
      }

      if (empty ($richestusers))
      {
        $richestusers = construct_phrase ($vbphrase['vbplaza_no_users_with_points_yet'], $vbphrase['vbbux_points']);
      }

      $mostsoldcache = array ();
      foreach ($vbulletin->vbpitemcache as $itemid => $item)
      {
        $item = $this->build_proper_usergroups ($item, $vbulletin->vbpcatcache);
        if ((($item['active'] AND $item['options'] & $vbulletin->bf_misc_vbplaza_item_options['showinvbplaza']) AND $this->check_allowed_usergroups ($vbulletin->userinfo, $item['allowedgroups'], $item['deniedgroups'])))
        {
          $categoryid = $item['categoryid'];
          $vbulletin->vbpcatcache['' . $categoryid]['totalitems'] += 1;
          $vbulletin->vbpcatcache['' . $categoryid]['totalsold'] += $item['sold'];
          if (0 < $item['sold'])
          {
            $mostsoldcache[] = array ('sold' => $item['sold'], 'itemid' => $item['itemid'], 'title' => $item['title']);
            continue;
          }

          continue;
        }
      }

      arsort ($mostsoldcache);
      $mostsolditems = '';
      if ((!empty ($mostsoldcache) AND is_array ($mostsoldcache)))
      {
        $displayed = 1;
        foreach ($mostsoldcache as $itemsold)
        {
          if (10 < $displayed)
          {
            break;
          }

          $mostsolditems .= '<div class="smallfont"><a href="vbplaza.php?do=itemhistory&amp;itemid=' . $itemsold['itemid'] . '">' . $itemsold['title'] . '</a> - ' . construct_phrase ($vbphrase['vbplaza_sold_x_items'], $itemsold['sold']) . '</div>
';
          ++$displayed;
        }
      }

      if (empty ($mostsolditems))
      {
        $mostsolditems = $vbphrase['vbplaza_no_items_sold_yet'];
      }

      $displayed = 0;
      $vbplazacategorylist = '';
      foreach ($vbulletin->vbpcatcache as $categoryid => $category)
      {
        if ($category['active'])
        {
          $category_data = array ('categoryid' => $category['categoryid'], 'title' => $category['title']);
          $category_license = sha1 (md5 ($this->license_url . md5 ($this->license_name . @serialize ($category_data)) . $this->license_number) . $this->license_key);
          if ($category['license'] == $category_license)
          {
            if (empty ($category['totalitems']))
            {
              $category['totalitems'] = '0';
            }

            if (empty ($category['totalsold']))
            {
              $category['totalsold'] = '0';
            }

            if (0 < $category['totalitems'])
            {
              if ($displayed % $vbulletin->options['vbplaza_categories_per_row'] == 0)
              {
                $vbplazacategorylist .= '<tr>';
              }

              ($hook = vbulletinhook::fetch_hook ('vbplaza_main_category_listbits') ? eval ($hook) : false);
              eval ('$vbplazacategorylist .= "' . fetch_template ('vbplaza_category_listbits') . '";');
              ++$displayed;
              if ($displayed % $vbulletin->options['vbplaza_categories_per_row'] == 0)
              {
                $vbplazacategorylist .= '</tr>
';
                continue;
              }

              continue;
            }

            continue;
          }

          continue;
        }
      }

      if (empty ($vbplazacategorylist))
      {
        $this->vbplaza_display_error ('vbplaza_no_items_available_for_purchase', $vbphrase['vbplaza_name_title']);
      }

      if ($vbulletin->GPC['categoryid'] == 0)
      {
        $show['clink'] = 'vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main';
        $show['ctitle'] = $vbphrase['vbplaza_all_categories'];
      }
      else
      {
        $categoryid = $vbulletin->GPC['categoryid'];
        $show['clink'] = 'vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main&cid=' . $categoryid;
        $show['ctitle'] = $vbulletin->vbpcatcache['' . $categoryid]['title'];
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_main_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_category_list') . '";');
      $this->display_output ();
    }

    function do_most_sold ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_most_sold_start') ? eval ($hook) : false);
      $mostsoldcache = array ();
      foreach ($vbulletin->vbpitemcache as $itemid => $item)
      {
        $item = $this->build_proper_usergroups ($item, $vbulletin->vbpcatcache);
        if ((($item['active'] AND $item['options'] & $vbulletin->bf_misc_vbplaza_item_options['showinvbplaza']) AND $this->check_allowed_usergroups ($vbulletin->userinfo, $item['allowedgroups'], $item['deniedgroups'])))
        {
          $categoryid = $item['categoryid'];
          $vbulletin->vbpcatcache['' . $categoryid]['totalitems'] += 1;
          $vbulletin->vbpcatcache['' . $categoryid]['totalsold'] += $item['sold'];
          if (0 < $item['sold'])
          {
            $mostsoldcache[] = array ('sold' => $item['sold'], 'itemid' => $item['itemid'], 'title' => $item['title']);
            continue;
          }

          continue;
        }
      }

      arsort ($mostsoldcache);
      $vbplazamostsolditems = '';
      if ((!empty ($mostsoldcache) AND is_array ($mostsoldcache)))
      {
        $displayed = 1;
        foreach ($mostsoldcache as $mostsold)
        {
          if ($displayed & 1)
          {
            $classname = 'alt1';
          }
          else
          {
            $classname = 'alt2';
          }

          $mostsold['rank'] = $displayed;
          ($hook = vbulletinhook::fetch_hook ('vbplaza_most_sold_listbits') ? eval ($hook) : false);
          eval ('$vbplazamostsolditems .= "' . fetch_template ('vbplaza_most_sold_listbits') . '";');
          ++$displayed;
        }
      }

      if (empty ($vbplazamostsolditems))
      {
        $vbplazamostsolditems = $vbphrase['vbplaza_no_items_sold_yet'];
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_most_sold_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_most_sold_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mostsold'] = $vbphrase['vbplaza_most_sold_items'];
      $this->display_output ();
    }

    function do_name_changes ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $show;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('page' => TYPE_UINT, 'u' => TYPE_UINT));
      $show['userhistory'] = false;
      ($hook = vbulletinhook::fetch_hook ('vbplaza_name_changes_start') ? eval ($hook) : false);
      if (!($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['canviewnamechanges']))
      {
        $this->vbplaza_display_error ('vbplaza_not_allowed_to_view_name_changes');
      }

      $namechanges = $vbulletin->db->query_first ('
			SELECT COUNT(*) AS count
			FROM ' . TABLE_PREFIX . 'vbplaza_name_change
			WHERE changeuserid = ' . $vbulletin->GPC['u'] . '
			ORDER BY dateline DESC
		');
      if (!$namechanges['count'])
      {
        $this->vbplaza_display_error ('vbplaza_no_name_changes_recorded', $vbphrase['username']);
      }

      $perpage = $vbulletin->options['vbplaza_name_changes_per_page'];
      if ($vbulletin->GPC['page'] < 1)
      {
        $vbulletin->GPC['page'] = 1;
      }

      if (1 < $vbulletin->GPC['page'])
      {
        $skip = $perpage * ($vbulletin->GPC['page'] - 1);
        $limitstr = 'LIMIT ' . $skip . ', ' . $perpage;
        $skip += 1;
      }
      else
      {
        $skip = 1;
        $limitstr = 'LIMIT 0, ' . $perpage;
      }

      $changes = $vbulletin->db->query_read ('
			SELECT vbplaza_name_change.*, user.username AS changedbyusername
			FROM ' . TABLE_PREFIX . 'vbplaza_name_change AS vbplaza_name_change
			LEFT JOIN ' . TABLE_PREFIX . 'user AS user ON (vbplaza_name_change.changedbyuserid = user.userid)
			WHERE changeuserid = ' . $vbulletin->GPC['u'] . '
			ORDER BY dateline DESC
			' . $limitstr . '
		');
      if ((!$changes OR !$vbulletin->db->num_rows ($changes)))
      {
        $this->vbplaza_display_error ('vbplaza_no_name_changes_recorded', $vbphrase['username']);
      }

      $pagenav = construct_page_nav ($vbulletin->GPC['page'], $perpage, $namechanges['count'], 'vbplaza.php?do=namechanges&amp;u=' . $vbulletin->GPC['u'], '');
      $vbplazanamechangeslist = '';
      while ($namechange = $vbulletin->db->fetch_array ($changes))
      {
        $purchase['date'] = vbdate ($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $namechange['dateline']);
        ($hook = vbulletinhook::fetch_hook ('vbplaza_name_changes_listbits') ? eval ($hook) : false);
        eval ('$vbplazanamechangeslist .= "' . fetch_template ('vbplaza_name_changes_listbits') . '";');
      }

      $vbulletin->db->free_result ($changes);
      if (empty ($vbplazanamechangeslist))
      {
        $this->vbplaza_display_error ('vbplaza_no_name_changes_recorded', $vbphrase['username']);
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_name_changes_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_name_changes_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=namechanges&amp;u=' . $vbulletin->GPC['u']] = $vbphrase['vbplaza_name_changes'];
      $this->display_output ();
    }

    function do_play ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('gameid' => TYPE_UINT, 'type' => TYPE_STR));
      $item = array ();
      if (0 < $vbulletin->GPC['gameid'])
      {
        if ($vbulletin->GPC['type'] == 'ibproarcade')
        {
          $gameinfo = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'games_list WHERE gid = ' . $vbulletin->GPC['gameid']);
          $item['gameid'] = $gameinfo['gid'];
          $item['cost'] = $gameinfo['cost'];
          $item['name'] = $gameinfo['gtitle'];
          $item['tax'] = $vbulletin->options['vbplaza_ibproarcade_tax_rate'];
        }
        else
        {
          if ($vbulletin->GPC['type'] == 'v3arcade')
          {
            $gameinfo = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'arcade_games WHERE gameid = ' . $vbulletin->GPC['gameid']);
            $item['gameid'] = $gameinfo['gameid'];
            $item['cost'] = $gameinfo['cost'];
            $item['name'] = $gameinfo['title'];
            $item['tax'] = $vbulletin->options['vbplaza_v3arcade_tax_rate'];
          }
        }
      }

      if ((!empty ($item) AND is_array ($item)))
      {
        @require_once DIR . '/vbplaza/includes/functions_items.php';
        vbplaza_calculate_total_cost ($item);
        list ($arcadeurl, $arcadeparams) = explode ('?', $vbulletin->url);
        if ($arcadeurl == 'index.php')
        {
          $arcadeurl = $vbulletin->options['vbplaza_bburl'] . 'arcade.php';
        }

        eval ('$current .= "' . fetch_template ('vbplaza_arcadeplay_confirmation') . '";');
        $this->display_output ();
        return null;
      }

      $_REQUEST['do'] = 'main';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_remove_gift ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('giftid' => TYPE_UINT));
      $candelete = false;
      if ($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['candeleteanygifts'])
      {
        $giftuser = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_gift_user WHERE giftid = ' . $vbulletin->GPC['giftid']);
        if (0 < $giftuser['giftid'])
        {
          $candelete = true;
        }
      }
      else
      {
        $giftuser = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_gift_user WHERE giftid = ' . $vbulletin->GPC['giftid']);
        if ($giftuser['giftid'] == $vbulletin->GPC['giftid'])
        {
          if ($giftuser['touserid'] == $vbulletin->userinfo['userid'])
          {
            if ($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['candeleteowngifts'])
            {
              $candelete = true;
            }
          }
        }
      }

      if ($candelete)
      {
        $giftuserdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Gift_User', $vbulletin, ERRTYPE_STANDARD);
        $giftuserdata->set_existing ($giftuser);
        $giftuserdata->delete ();
        unset ($giftuserdata);
        vbplaza_rebuild_gift_postbit ($giftuser['touserid']);
        if ($vbulletin->options['vbbux_vbplaza_current_vbulletin_version'] == '3.7')
        {
          $url = unhtmlspecialchars ($vbulletin->url);
          list ($script, $parameters) = explode ('?', $url);
          $arguments = explode ('&', $parameters);
          if ((!empty ($arguments) AND is_array ($arguments)))
          {
            $proper_values = array ();
            foreach ($arguments as $index => $value)
            {
              list ($field_name, $field_value) = explode ('=', $value);
              $proper_values['' . $field_name] = $field_name . '=' . $field_value;
            }

            unset ($proper_values[tab]);
            $arguments = implode ('&', $proper_values);
            $vbulletin->url = htmlspecialchars ($script . '?' . $arguments);
          }

          $vbulletin->url .= '&amp;tab=vbbux_vbplaza';
        }

        eval (print_standard_redirect ('vbplaza_gift_deleted_successful'));
        return null;
      }

      $_REQUEST['do'] = 'main';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_remove_log ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('id' => TYPE_UINT, 'userid' => TYPE_UINT));
      $userhistory = vbplaza_unserialize ($vbulletin->userinfo['vbplaza_history']);
      if (!empty ($userhistory[$vbulletin->GPC['id']]))
      {
        unset ($userhistory[$vbulletin->GPC['id']]);
        $userhistory = serialize ($userhistory);
        $vbulletin->db->query_write (@vbplaza_fetch_query_sql (array ('vbplaza_history' => $userhistory), $vbulletin->options['vbbux_points_table'], 'WHERE userid = ' . $vbulletin->userinfo['userid']));
        $vbulletin->userinfo['vbplaza_history'] = $userhistory;
      }

      $_REQUEST['do'] = 'userhistory';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_remove_ribbon ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('ribbonid' => TYPE_UINT));
      $candelete = false;
      if ($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['candeleteanyribbons'])
      {
        $ribbonuser = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_ribbon_user WHERE ribbonid = ' . $vbulletin->GPC['ribbonid']);
        if (0 < $ribbonuser['ribbonid'])
        {
          $candelete = true;
        }
      }
      else
      {
        $ribbonuser = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_ribbon_user WHERE ribbonid = ' . $vbulletin->GPC['ribbonid']);
        if ($ribbonuser['ribbonid'] == $vbulletin->GPC['ribbonid'])
        {
          if ($ribbonuser['touserid'] == $vbulletin->userinfo['userid'])
          {
            if ($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['candeleteownribbons'])
            {
              $candelete = true;
            }
          }
        }
      }

      if ($candelete)
      {
        $ribbonuserdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Ribbon_User', $vbulletin, ERRTYPE_STANDARD);
        $ribbonuserdata->set_existing ($ribbonuser);
        $ribbonuserdata->delete ();
        unset ($ribbonuserdata);
        vbplaza_rebuild_ribbon_postbit ($ribbonuser['touserid']);
        if ($vbulletin->options['vbbux_vbplaza_current_vbulletin_version'] == '3.7')
        {
          $url = unhtmlspecialchars ($vbulletin->url);
          list ($script, $parameters) = explode ('?', $url);
          $arguments = explode ('&', $parameters);
          if ((!empty ($arguments) AND is_array ($arguments)))
          {
            $proper_values = array ();
            foreach ($arguments as $index => $value)
            {
              list ($field_name, $field_value) = explode ('=', $value);
              $proper_values['' . $field_name] = $field_name . '=' . $field_value;
            }

            unset ($proper_values[tab]);
            $arguments = implode ('&', $proper_values);
            $vbulletin->url = htmlspecialchars ($script . '?' . $arguments);
          }

          $vbulletin->url .= '&amp;tab=vbbux_vbplaza';
        }

        eval (print_standard_redirect ('vbplaza_ribbon_deleted_successful'));
        return null;
      }

      $_REQUEST['do'] = 'main';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_remove_winner ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('winnerid' => TYPE_UINT));
      if ($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['candeletelotterywinners'])
      {
        $lotterywinner = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_lottery_winner WHERE winnerid = ' . $vbulletin->GPC['winnerid']);
        if ($lotterywinner['winnerid'] == $vbulletin->GPC['winnerid'])
        {
          $candelete = true;
        }
      }

      if ($candelete)
      {
        $lotterywinnerdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Lottery_Winner', $vbulletin, ERRTYPE_STANDARD);
        $lotterywinnerdata->set_existing ($lotterywinner);
        $lotterywinnerdata->delete ();
        unset ($lotterywinnerdata);
        eval (print_standard_redirect ('vbplaza_winner_deleted_successful'));
        return null;
      }

      $_REQUEST['do'] = 'main';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_richest ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_richest_users_start') ? eval ($hook) : false);
      $richestusercache = array ();
      if ($users = $vbulletin->db->query_read ('
			SELECT user.`userid`, user.`username`, user.`' . $vbulletin->options['vbbux_points_field'] . '`, user.`' . $vbulletin->options['vbbux_bank_field'] . '`,
				(user.`' . $vbulletin->options['vbbux_points_field'] . '` + user.`' . $vbulletin->options['vbbux_bank_field'] . '`) AS totalpoints,
				usergroup.`vbplaza_settings` AS vbplaza_settings
			FROM ' . TABLE_PREFIX . $vbulletin->options['vbbux_points_table'] . ' AS user
			LEFT JOIN ' . TABLE_PREFIX . 'usergroup AS usergroup ON (user.usergroupid = usergroup.usergroupid)
			WHERE NOT (vbplaza_settings & ' . $vbulletin->bf_ugp_vbplaza_settings['excludefromrichest'] . ')
			ORDER BY totalpoints DESC
			LIMIT ' . $vbulletin->options['vbplaza_view_richest_number'] . '
		'))
      {
        while ($user = $vbulletin->db->fetch_array ($users))
        {
          $richestid = $user['userid'];
          $richestusercache['' . $richestid] = $user;
        }

        $vbulletin->db->free_result ($richestusers);
      }

      $vbplazarichestlist = '';
      if ((!empty ($richestusercache) AND is_array ($richestusercache)))
      {
        $displayed = 1;
        foreach ($richestusercache as $richestid => $richest)
        {
          if ($displayed & 1)
          {
            $classname = 'alt1';
          }
          else
          {
            $classname = 'alt2';
          }

          $richest['rank'] = $displayed;
          $richest['points'] = vb_number_format ($richest[$vbulletin->options['vbbux_points_field']], $vbulletin->options['vbplaza_decimal_places']);
          $richest['bank'] = vb_number_format ($richest[$vbulletin->options['vbbux_bank_field']], $vbulletin->options['vbplaza_decimal_places']);
          $richest['total'] = vb_number_format ($richest['totalpoints'], $vbulletin->options['vbplaza_decimal_places']);
          ($hook = vbulletinhook::fetch_hook ('vbplaza_richest_users_listbits') ? eval ($hook) : false);
          eval ('$vbplazarichestlist .= "' . fetch_template ('vbplaza_richest_users_listbits') . '";');
          ++$displayed;
        }
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_richest_users_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_richest_users_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=richest'] = $vbphrase['vbplaza_richest_users'];
      $this->display_output ();
    }

    function do_sell_item ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      if (!$vbulletin->options['vbplaza_users_can_sell_inventory_items'])
      {
        eval (standard_error (fetch_error ('vbplaza_user_inventory_items_not_sellable')));
      }

      $vbulletin->input->clean_array_gpc ('r', array ('useritemid' => TYPE_UINT));
      ($hook = vbulletinhook::fetch_hook ('vbplaza_sell_useritem_start') ? eval ($hook) : false);
      $useritem = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_user_inventory WHERE useritemid = ' . $vbulletin->GPC['useritemid']);
      if (((empty ($useritem) OR !is_array ($useritem)) OR !$useritem['useritemid']))
      {
        eval (standard_error (fetch_error ('vbplaza_user_inventory_item_not_found')));
      }

      if ($useritem['userid'] != $vbulletin->userinfo['userid'])
      {
        eval (standard_error (fetch_error ('vbplaza_can_not_sell_others_user_inventory_items')));
      }

      if ((empty ($useritem['sellprice']) OR $useritem['sellprice'] == 0))
      {
        $useritem['sellprice'] = round ($useritem['finalcost'] * 0.5, 5);
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_sell_useritem_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_sell_useritem_confirm') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=sellitem&useritemid=' . $vbulletin->GPC['useritemid']] = $vbphrase['vbplaza_sell_user_item'];
      $this->display_output ();
    }

    function do_sell_item_process ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      if (!$vbulletin->options['vbplaza_users_can_sell_inventory_items'])
      {
        eval (standard_error (fetch_error ('vbplaza_user_inventory_items_not_sellable')));
      }

      $vbulletin->input->clean_array_gpc ('p', array ('sellprice' => TYPE_NUM, 'useritemid' => TYPE_UINT));
      $useritem = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_user_inventory WHERE useritemid = ' . $vbulletin->GPC['useritemid']);
      if (((empty ($useritem) OR !is_array ($useritem)) OR !$useritem['useritemid']))
      {
        eval (standard_error (fetch_error ('vbplaza_user_inventory_item_not_found')));
      }

      if ($useritem['userid'] != $vbulletin->userinfo['userid'])
      {
        eval (standard_error (fetch_error ('vbplaza_can_not_sell_others_user_inventory_items')));
      }

      if ($vbulletin->options['vbplaza_minimum_user_inventory_sale_price'])
      {
        if ($vbulletin->GPC['sellprice'] < $vbulletin->options['vbplaza_minimum_user_inventory_sale_price'])
        {
          $minimum_price = vb_number_format ($vbulletin->options['vbplaza_minimum_user_inventory_sale_price'], $vbulletin->options['vbplaza_decimal_places']);
          eval (standard_error (fetch_error ('vbplaza_can_not_sell_user_inventory_items_less_than_x', $minimum_price, $vbphrase['vbplaza_points'])));
        }
      }

      if ($vbulletin->options['vbplaza_maximum_user_inventory_sale_price'])
      {
        if ($vbulletin->options['vbplaza_maximum_user_inventory_sale_price'] < $vbulletin->GPC['sellprice'])
        {
          $maximum_price = vb_number_format ($vbulletin->options['vbplaza_maximum_user_inventory_sale_price'], $vbulletin->options['vbplaza_decimal_places']);
          eval (standard_error (fetch_error ('vbplaza_can_not_sell_user_inventory_items_more_than_x', $maximum_price, $vbphrase['vbplaza_points'])));
        }
      }

      $vbulletin->db->query_write (@vbplaza_fetch_query_sql (array ('forsale' => '1', 'sellprice' => $vbulletin->GPC['sellprice']), 'vbplaza_user_inventory', 'WHERE useritemid = ' . $useritem['useritemid']));
      $_REQUEST['do'] = 'inventory';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_show_gift ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('giftid' => TYPE_UINT));
      $giftuser = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_gift_user WHERE giftid = ' . $vbulletin->GPC['giftid']);
      if ((0 < $giftuser['giftid'] AND $giftuser['touserid'] == $vbulletin->userinfo['userid']))
      {
        $giftuserdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Gift_User', $vbulletin, ERRTYPE_STANDARD);
        $giftuserdata->set_existing ($giftuser);
        $giftuserdata->set ('visible', 1);
        $giftuserdata->save ();
        unset ($giftuserdata);
        vbplaza_rebuild_gift_postbit ($giftuser['touserid']);
        eval (print_standard_redirect ('vbplaza_gift_visible_status_updated'));
      }

    }

    function do_show_ribbon ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('ribbonid' => TYPE_UINT));
      $ribbonuser = $vbulletin->db->query_first ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_ribbon_user WHERE ribbonid = ' . $vbulletin->GPC['ribbonid']);
      if ((0 < $ribbonuser['ribbonid'] AND $ribbonuser['touserid'] == $vbulletin->userinfo['userid']))
      {
        $ribbonuserdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Ribbon_User', $vbulletin, ERRTYPE_STANDARD);
        $ribbonuserdata->set_existing ($ribbonuser);
        $ribbonuserdata->set ('visible', 1);
        $ribbonuserdata->save ();
        unset ($ribbonuserdata);
        vbplaza_rebuild_ribbon_postbit ($ribbonuser['touserid']);
        eval (print_standard_redirect ('vbplaza_ribbon_visible_status_updated'));
      }

    }

    function do_update_options ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('p', array ('hidegiftsinposts' => TYPE_BOOL, 'hidepointsinposts' => TYPE_BOOL, 'hideribbonsinposts' => TYPE_BOOL, 'hideusernamechangesinposts' => TYPE_BOOL, 'hideusertitlechangesinposts' => TYPE_BOOL, 'nopmuponnewgift' => TYPE_BOOL, 'nopmuponnewribbon' => TYPE_BOOL));
      $vbulletin->vbplazaoptions = 0;
      if ($vbulletin->GPC['hidegiftsinposts'])
      {
        $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbplaza_options['hidegiftsinposts'];
      }

      if ($vbulletin->GPC['hideribbonsinposts'])
      {
        $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbplaza_options['hideribbonsinposts'];
      }

      if ($vbulletin->GPC['nopmuponnewgift'])
      {
        $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbplaza_options['nopmuponnewgift'];
      }

      if ($vbulletin->GPC['nopmuponnewribbon'])
      {
        $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbplaza_options['nopmuponnewribbon'];
      }

      if ($vbulletin->GPC['hidepointsinposts'])
      {
        $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbplaza_options['hidepointsinposts'];
      }

      if ($vbulletin->GPC['hideusernamechangesinposts'])
      {
        $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbplaza_options['hideusernamechangesinposts'];
      }

      if ($vbulletin->GPC['hideusertitlechangesinposts'])
      {
        $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbplaza_options['hideusertitlechangesinposts'];
      }

      $vbulletin->userinfo['vbplaza_options'] = intval ($vbulletin->vbplazaoptions);
      $vbulletin->db->query_write (@vbplaza_fetch_query_sql (array ('vbplaza_options' => $vbulletin->userinfo['vbplaza_options']), $vbulletin->options['vbbux_points_table'], 'WHERE userid = ' . $vbulletin->userinfo['userid']));
      $_REQUEST['do'] = 'editoptions';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_user_history ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $navitems;
      global $current;
      global $history_userid;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('u' => TYPE_UINT));
      if ($vbulletin->GPC['u'])
      {
        if ($vbulletin->userinfo['userid'] != $vbulletin->GPC['u'])
        {
          if (!($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['canviewotheruserhistory']))
          {
            $this->vbplaza_display_error ('vbplaza_not_allowed_to_view_others_user_history');
          }
        }
      }

      $history_userid = $vbulletin->GPC['u'];
      $otheruser = ($vbulletin->userinfo['userid'] != $vbulletin->GPC['u'] ? '&amp;u=' . $vbulletin->GPC['u'] : '');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=userhistory' . $otheruser] = $vbphrase['vbplaza_user_history'];
      $this->display_output ();
    }

    function do_user_items ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $show;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('page' => TYPE_UINT));
      ($hook = vbulletinhook::fetch_hook ('vbplaza_user_items_start') ? eval ($hook) : false);
      $user_items_data = $vbulletin->db->query_first ('
			SELECT COUNT(*) AS count
			FROM ' . TABLE_PREFIX . 'vbplaza_user_inventory
			WHERE (forsale > 0) AND (sellprice > 0) AND (userid != ' . $vbulletin->userinfo['userid'] . ')
		');
      if (!$user_items_data['count'])
      {
        $this->vbplaza_display_error ('vbplaza_no_user_items_purchaseable', $vbphrase['vbplaza_name_title']);
      }

      $perpage = $vbulletin->options['vbplaza_user_inventory_per_page'];
      if (!(0 < $perpage))
      {
        $perpage = 20;
      }

      if (!(0 < $vbulletin->GPC['page']))
      {
        $vbulletin->GPC['page'] = 1;
      }

      if (1 < $vbulletin->GPC['page'])
      {
        $skip = $perpage * ($vbulletin->GPC['page'] - 1);
        $limitstr = 'LIMIT ' . $skip . ', ' . $perpage;
        $skip += 1;
      }
      else
      {
        $skip = 1;
        $limitstr = 'LIMIT 0, ' . $perpage;
      }

      $useritems = $vbulletin->db->query_read ('
			SELECT *
			FROM ' . TABLE_PREFIX . 'vbplaza_user_inventory
			WHERE (forsale > 0) AND (sellprice > 0) AND (userid != ' . $vbulletin->userinfo['userid'] . ')
			ORDER BY dateline
			' . $limitstr . '
		');
      if ((!$useritems OR !$vbulletin->db->num_rows ($useritems)))
      {
        $this->vbplaza_display_error ('vbplaza_no_user_items_purchaseable', $vbphrase['vbplaza_name_title']);
      }

      $pagenav = construct_page_nav ($vbulletin->GPC['page'], $perpage, $user_items_data['count'], 'vbplaza.php?do=useritems', '');
      $displayed = 0;
      $vbplazauseritemslist = '';
      while ($useritem = $vbulletin->db->fetch_array ($useritems))
      {
        $useritem['item_number'] = $skip++;
        $useritem['original_cost'] = vb_number_format ($useritem['finalcost'], $vbulletin->options['vbplaza_decimal_places']);
        $useritem['cost'] = vb_number_format ($useritem['sellprice'], $vbulletin->options['vbplaza_decimal_places']);
        if ($displayed & 1)
        {
          $classname = 'alt1';
        }
        else
        {
          $classname = 'alt2';
        }

        ($hook = vbulletinhook::fetch_hook ('vbplaza_user_items_listbits') ? eval ($hook) : false);
        eval ('$vbplazauseritemslist .= "' . fetch_template ('vbplaza_user_items_listbits') . '";');
        ++$displayed;
      }

      $vbulletin->db->free_result ($items);
      if (empty ($vbplazauseritemslist))
      {
        $this->vbplaza_display_error ('vbplaza_no_user_items_purchaseable', $vbphrase['vbplaza_name_title']);
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_user_items_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_user_items_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=useritems'] = $vbphrase['vbplaza_browse_user_items'];
      $this->display_output ();
    }

    function do_user_items_update ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('p', array ('useritems' => TYPE_ARRAY));
      if ((!empty ($vbulletin->GPC['useritems']) AND is_array ($vbulletin->GPC['useritems'])))
      {
        $user_items_cache = array ();
        if ($useritems = $vbulletin->db->query_read ('
				SELECT *
				FROM ' . TABLE_PREFIX . 'vbplaza_user_inventory
				WHERE useritemid IN(' . implode (',', $vbulletin->GPC['useritems']) . ')
			'))
        {
          while ($useritem = $vbulletin->db->fetch_array ($useritems))
          {
            $useritemid = $useritem['useritemid'];
            $user_items_cache['' . $useritemid] = $useritem;
          }

          $vbulletin->db->free_result ($useritems);
        }

        if ((!empty ($user_items_cache) AND is_array ($user_items_cache)))
        {
          @require_once DIR . '/vbplaza/includes/functions_inventory.php';
          foreach ($vbulletin->GPC['useritems'] as $useritemid => $userinventoryitem)
          {
            $useritem = $user_items_cache['' . $useritemid];
            $userinfo = fetch_userinfo ($useritem['userid']);
            if ($userinfo['userid'])
            {
              vbplaza_user_inventory_status_update ($useritem, $userinfo, false);
              vbplaza_user_inventory_status_update ($useritem, $vbulletin->userinfo, true);
              $userinventorydata = &vbbux_vbplaza_datamanager_init ('vbPlaza_User_Inventory', $vbulletin, ERRTYPE_STANDARD);
              $userinventorydata->set_existing ($useritem);
              $userinventorydata->set ('dateline', TIMENOW);
              $userinventorydata->set ('finalcost', $useritem['sellprice']);
              $userinventorydata->set ('forsale', 0);
              $userinventorydata->set ('sellprice', '0.00000');
              $userinventorydata->set ('userid', $vbulletin->userinfo['userid']);
              $userinventorydata->set ('username', $vbulletin->userinfo['username']);
              $userinventorydata->save ();
              unset ($userinventorydata);
              continue;
            }
          }
        }
      }

      $_REQUEST['do'] = 'useritems';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_user_tracks ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $show;
      global $current;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      if ($vbulletin->options['vbplaza_disable_user_tracks'])
      {
        $this->vbplaza_display_error ('vbplaza_user_tracks_disabled');
      }

      $vbulletin->input->clean_array_gpc ('r', array ('page' => TYPE_UINT));
      ($hook = vbulletinhook::fetch_hook ('vbplaza_user_tracks_start') ? eval ($hook) : false);
      $user_track_data = $vbulletin->db->query_first ('
			SELECT COUNT(*) AS count
			FROM ' . TABLE_PREFIX . 'vbplaza_track_user
			WHERE userid = ' . $vbulletin->userinfo['userid'] . '
		');
      if (!$user_track_data['count'])
      {
        $this->vbplaza_display_error ('vbplaza_no_user_tracks_purchased', $vbphrase['vbplaza_name_title']);
      }

      $perpage = $vbulletin->options['vbplaza_user_tracks_per_page'];
      if (!(0 < $perpage))
      {
        $perpage = 20;
      }

      if (!(0 < $vbulletin->GPC['page']))
      {
        $vbulletin->GPC['page'] = 1;
      }

      if (1 < $vbulletin->GPC['page'])
      {
        $skip = $perpage * ($vbulletin->GPC['page'] - 1);
        $limitstr = 'LIMIT ' . $skip . ', ' . $perpage;
        $skip += 1;
      }
      else
      {
        $skip = 1;
        $limitstr = 'LIMIT 0, ' . $perpage;
      }

      $usertracks = $vbulletin->db->query_read ('
			SELECT *
			FROM ' . TABLE_PREFIX . 'vbplaza_track_user
			WHERE userid = ' . $vbulletin->userinfo['userid'] . '
			ORDER BY displayorder
			' . $limitstr . '
		');
      if ((!$usertracks OR !$vbulletin->db->num_rows ($usertracks)))
      {
        $this->vbplaza_display_error ('vbplaza_no_user_tracks_purchased', $vbphrase['vbplaza_name_title']);
      }

      $pagenav = construct_page_nav ($vbulletin->GPC['page'], $perpage, $user_track_data['count'], 'vbplaza.php?do=usertracks', '');
      $displayed = 0;
      $vbplazausertrackslist = '';
      while ($usertrack = $vbulletin->db->fetch_array ($usertracks))
      {
        $usertrack['track_number'] = $skip++;
        if ($displayed & 1)
        {
          $classname = 'alt1';
        }
        else
        {
          $classname = 'alt2';
        }

        $usertrackbits = '';
        $item_options = array ('0' => $vbphrase['no'], '1' => $vbphrase['yes'], '2' => $vbphrase['delete']);
        foreach ($item_options as $item_value => $item_name)
        {
          $item_selected = ($usertrack['active'] == $item_value ? ' selected="selected"' : '');
          $usertrackbits .= '<option value="' . $item_value . '"' . $item_selected . '>' . $item_name . '</option>';
        }

        ($hook = vbulletinhook::fetch_hook ('vbplaza_user_tracks_listbits') ? eval ($hook) : false);
        eval ('$vbplazausertrackslist .= "' . fetch_template ('vbplaza_user_tracks_listbits') . '";');
        ++$displayed;
      }

      $vbulletin->db->free_result ($tracks);
      if (empty ($vbplazausertrackslist))
      {
        $this->vbplaza_display_error ('vbplaza_no_user_tracks_purchased', $vbphrase['vbplaza_name_title']);
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_user_tracks_complete') ? eval ($hook) : false);
      eval ('$current = "' . fetch_template ('vbplaza_user_tracks_list') . '";');
      $navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=usertracks'] = $vbphrase['vbplaza_user_tracks'];
      $this->display_output ();
    }

    function do_user_tracks_update ()
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      if ($vbulletin->options['vbplaza_disable_user_tracks'])
      {
        $this->vbplaza_display_error ('vbplaza_user_tracks_disabled');
      }

      $vbulletin->input->clean_array_gpc ('p', array ('usertracks' => TYPE_ARRAY));
      if ((!empty ($vbulletin->GPC['usertracks']) AND is_array ($vbulletin->GPC['usertracks'])))
      {
        $track_ids = '';
        foreach ($vbulletin->GPC['usertracks'] as $usertrackid => $usertrack)
        {
          $track_ids .= (!empty ($track_ids) ? ',' : '') . $usertrackid;
        }

        if (!empty ($track_ids))
        {
          $user_tracks_cache = array ();
          if ($usertracks = $vbulletin->db->query_read ('
					SELECT *
					FROM ' . TABLE_PREFIX . 'vbplaza_track_user
					WHERE usertrackid IN(' . $track_ids . ')
				'))
          {
            while ($usertrack = $vbulletin->db->fetch_array ($usertracks))
            {
              $usertrackid = $usertrack['usertrackid'];
              $user_tracks_cache['' . $usertrackid] = $usertrack;
            }

            $vbulletin->db->free_result ($usertracks);
          }

          if ((!empty ($user_tracks_cache) AND is_array ($user_tracks_cache)))
          {
            foreach ($vbulletin->GPC['usertracks'] as $usertrackid => $trackuser)
            {
              $vbulletin->input->clean_array ($trackuser, array ('active' => TYPE_NUM, 'displayorder' => TYPE_UINT));
              $trackuseritem = $user_tracks_cache['' . $usertrackid];
              if ($trackuser['active'] == 2)
              {
                $trackuserdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Track_User', $vbulletin, ERRTYPE_STANDARD);
                $trackuserdata->set_existing ($trackuseritem);
                $trackuserdata->delete ();
                unset ($trackuserdata);
                continue;
              }
              else
              {
                $trackuserdata = &vbbux_vbplaza_datamanager_init ('vbPlaza_Track_User', $vbulletin, ERRTYPE_STANDARD);
                $trackuserdata->set_existing ($trackuseritem);
                $trackuserdata->set ('active', $trackuser['active']);
                $trackuserdata->set ('displayorder', $trackuser['displayorder']);
                $trackuserdata->save ();
                unset ($trackuserdata);
                continue;
              }
            }
          }
        }
      }

      $_REQUEST['do'] = 'usertracks';
      $this->vbPlaza_Hash = sha1 (sha1 (sha1 ($this->license_number . '*' . $this->license_key) . TIMENOW . '*' . COOKIE_SALT) . $_REQUEST['do'] . '*' . $_POST['do']);
    }

    function do_view_thread ()
    {
      global $vbulletin;
      global $stylevar;
      global $vbphrase;
      global $session;
      global $bbuserinfo;
      global $navitems;
      global $current;
      global $threadinfo;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $vbulletin->input->clean_array_gpc ('r', array ('p' => TYPE_UINT, 'page' => TYPE_UINT, 't' => TYPE_UINT));
      $item = array ('cost' => $threadinfo['vbbux_cost'], 'name' => $threadinfo['title'], 'p' => $vbulletin->GPC['p'], 'page' => $vbulletin->GPC['page'], 't' => $vbulletin->GPC['t'], 'tax' => '0.00');
      if (!$item['t'])
      {
        $item['t'] = $threadinfo['threadid'];
      }

      @require_once DIR . '/vbplaza/includes/functions_items.php';
      vbplaza_calculate_total_cost ($item);
      $threadurl = $vbulletin->options['vbplaza_bburl'] . 'showthread.php';
      eval ('$current .= "' . fetch_template ('vbplaza_viewthread_confirmation') . '";');
      $this->display_output ();
    }

    function build_category_license ($category)
    {
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $category_license = '';
      if ($this->is_licensed)
      {
        $category_data = array ('categoryid' => $category['categoryid'], 'title' => $category['title']);
        $category_license = sha1 (md5 ($this->license_url . md5 ($this->license_name . @serialize ($category_data)) . $this->license_number) . $this->license_key);
      }

      return $category_license;
    }

    function build_item_license ($item)
    {
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      $item_license = '';
      if ($this->is_licensed)
      {
        $item_data = array ('itemid' => $item['itemid'], 'title' => $item['title'], 'scriptcode' => $item['scriptcode'], 'scriptlocation' => $item['scriptlocation'], 'tablename' => $item['tablename'], 'wherename' => $item['wherename'], 'wherevalue' => $item['wherevalue'], 'setname' => $item['setname'], 'settype' => $item['settype'], 'setvalue' => $item['setvalue'], 'optionsettings' => $item['optionsettings'], 'inputfields' => $item['inputfields'], 'stepevalcode' => $item['stepevalcode']);
        $item_license = sha1 (md5 ($this->license_url . md5 ($this->license_name . @serialize ($item_data)) . $this->license_number) . $this->license_key);
      }

      return $item_license;
    }

    function build_licensed_categories ($vbplazacategories = array ())
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      if ($this->is_licensed)
      {
        if ((!is_array ($vbplazacategories) OR empty ($vbplazacategories)))
        {
          $vbplazacategories = array ();
          $categories = $vbulletin->db->query_read ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_category ORDER BY displayorder');
          while ($category = $vbulletin->db->fetch_array ($categories))
          {
            $categoryid = $category['categoryid'];
            $vbplazacategories['' . $categoryid] = $category;
          }

          $vbulletin->db->free_result ($categories);
        }

        $updated_categories = 0;
        foreach ($vbplazacategories as $categoryid => $category)
        {
          $category_data = array ('categoryid' => $category['categoryid'], 'title' => $category['title']);
          $category_license = sha1 (md5 ($this->license_url . md5 ($this->license_name . @serialize ($category_data)) . $this->license_number) . $this->license_key);
          if ($category['license'] != $category_license)
          {
            $vbulletin->db->query_write (@vbplaza_fetch_query_sql (array ('license' => $category_license), 'vbplaza_category', 'WHERE categoryid = ' . $category['categoryid']));
            ++$updated_categories;
            continue;
          }
        }

        if (0 < $updated_categories)
        {
          vbplaza_build_datastore ('vbplaza_category', 'categoryid', 'vbpcatcache');
        }

        return true;
      }

      return failed;
    }

    function build_licensed_items ($vbplazaitems = array ())
    {
      global $vbulletin;
      if (!$this->verify_license_authorization ())
      {
        return null;
      }

      if ($this->is_licensed)
      {
        if ((!is_array ($vbplazaitems) OR empty ($vbplazaitems)))
        {
          $vbplazaitems = array ();
          $items = $vbulletin->db->query_read ('SELECT * FROM ' . TABLE_PREFIX . 'vbplaza_item ORDER BY categoryid, displayorder');
          while ($item = $vbulletin->db->fetch_array ($items))
          {
            $itemid = $item['itemid'];
            $vbplazaitems['' . $itemid] = $item;
          }

          $vbulletin->db->free_result ($items);
        }

        $updated_items = 0;
        foreach ($vbplazaitems as $itemid => $item)
        {
          $item_data = array ('itemid' => $item['itemid'], 'title' => $item['title'], 'scriptcode' => $item['scriptcode'], 'scriptlocation' => $item['scriptlocation'], 'tablename' => $item['tablename'], 'wherename' => $item['wherename'], 'wherevalue' => $item['wherevalue'], 'setname' => $item['setname'], 'settype' => $item['settype'], 'setvalue' => $item['setvalue'], 'optionsettings' => $item['optionsettings'], 'inputfields' => $item['inputfields'], 'stepevalcode' => $item['stepevalcode']);
          $item_license = sha1 (md5 ($this->license_url . md5 ($this->license_name . @serialize ($item_data)) . $this->license_number) . $this->license_key);
          if ($item['license'] != $item_license)
          {
            $vbulletin->db->query_write (@vbplaza_fetch_query_sql (array ('license' => $item_license), 'vbplaza_item', 'WHERE itemid = ' . $item['itemid']));
            ++$updated_items;
            continue;
          }
        }

        if (0 < $updated_items)
        {
          vbplaza_build_item_datastore ();
        }

        return true;
      }

      return failed;
    }

    function verify_license_authorization ()
    {
      global $vbulletin;
      global $vbphrase;
      if (!$vbulletin->products['vbbux_vbplaza'])
      {
        return 0;
      }

      if (empty ($vbulletin->options['vbbux_vbplaza_version']))
      {
        return 0;
      }

      return 1;
    }

    function vbplaza_fixup_extraname (&$history)
    {
      global $vbulletin;
      global $vbphrase;
      if (!empty ($history['touserid']))
      {
        $history['extraname'] = ' ' . $vbphrase['vbplaza_to'] . ' <a href="member.php?u=' . $history['touserid'] . '">' . $history['tousername'] . '</a>';
        return null;
      }

      if (!empty ($history['fromuserid']))
      {
        $history['extraname'] = ' ' . $vbphrase['vbplaza_from'] . ' <a href="member.php?u=' . $history['fromuserid'] . '">' . $history['fromusername'] . '</a>';
        return null;
      }

      if (!empty ($history['threadid']))
      {
        $history['extraname'] = ' (' . $vbphrase['vbplaza_threadid'] . ': <a href="showthread.php?t=' . $history['threadid'] . '">' . $history['threadid'] . '</a>)';
        return null;
      }

      if (!empty ($history['forumid']))
      {
        $history['extraname'] = ' (' . $vbphrase['vbplaza_forumid'] . ': ' . $history['forumid'] . ')';
        return null;
      }

      if (!empty ($history['usergroupid']))
      {
        $history['extraname'] = ' (' . $vbphrase['vbplaza_usergroupid'] . ': ' . $history['usergroupid'] . ')';
      }

    }

    function process_commands ()
    {
      global $vbulletin;
      switch ($_REQUEST['do'])
      {
        case 'license_update':
        {
          $vbulletin->options['vbbux_vbplaza_license_setting'] = '';
          $vbulletin->db->query_write (@vbplaza_fetch_query_sql (array ('value' => ''), 'setting', 'WHERE varname = \'vbbux_vbplaza_license_setting\''));
          @require_once DIR . '/includes/adminfunctions.php';
          build_options ();
          true;
        }
      }

      return ;
    }

    function process_script ()
    {
      global $vbulletin;
      global $vbphrase;
      global $warning;
      global $header;
      global $footer;

      if ($_REQUEST['do'] != 'expireitems')
      {
        if (($vbulletin->options['vbbux_vbplaza_version'] != VBBUX_VBPLAZA_FUNCTIONS_VERSION OR $vbulletin->options['vbbux_vbplaza_version'] != VBBUX_VBPLAZA_ENGINE_VERSION))
        {
          $this->vbplaza_display_error ('vbplaza_product_mismatch_with_php', $vbphrase['vbbux_name_title'], $vbphrase['vbplaza_name_title']);
        }

        if (((!$vbulletin->userinfo['userid'] OR !$vbulletin->userinfo['vbplaza_storeaccess']) OR !($vbulletin->userinfo['permissions']['vbplaza_settings'] & $vbulletin->bf_ugp_vbplaza_settings['canpurchaseitems'])))
        {
          print_no_permission ();
        }
      }

      if (!$vbulletin->options['vbplaza_active'])
      {
        if ($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
        {
          eval ('$warning = "' . fetch_template ('vbplaza_inactive_warning') . '";');
          $header = $warning . $header;
          $footer .= $warning;
        }
        else
        {
          if ($_REQUEST['do'] != 'expireitems')
          {
            $this->vbplaza_display_error ('vbplaza_currently_closed', $vbphrase['vbplaza_name_title']);
          }
        }
      }

      ($hook = vbulletinhook::fetch_hook ('vbplaza_start') ? eval ($hook) : false);
      switch ($_POST['do'])
      {
        case 'dosellitem':
        {
          $this->do_sell_item_process ();
          break;
        }

        case 'inventory':
        {
          $this->do_inventory_update ();
          break;
        }

        case 'updateoptions':
        {
          $this->do_update_options ();
          break;
        }

        case 'useritems':
        {
          $this->do_user_items_update ();
          break;
        }

        case 'usertracks':
        {
          $this->do_user_tracks_update ();
        }
      }

      switch ($_REQUEST['do'])
      {
        case 'cancelsale':
        {
          $this->do_cancel_sale ();
          break;
        }

        case 'expire':
        {
          $this->do_expire ();
          break;
        }

        case 'removegift':
        {
          $this->do_remove_gift ();
          break;
        }

        case 'removelog':
        {
          $this->do_remove_log ();
          break;
        }

        case 'removeribbon':
        {
          $this->do_remove_ribbon ();
          break;
        }

        case 'removewinner':
        {
          $this->do_remove_winner ();
        }
      }

      switch ($_REQUEST['do'])
      {
        case 'download':
        {
          $this->do_download ();
          break;
        }

        case 'editoptions':
        {
          $this->do_edit_options ();
          break;
        }

        case 'expireitems':
        {
          $this->do_expire_items ();
          break;
        }

        case 'hidegift':
        {
          $this->do_hide_gift ();
          break;
        }

        case 'hideribbon':
        {
          $this->do_hide_ribbon ();
          break;
        }

        case 'inventory':
        {
          $this->do_inventory ();
          break;
        }

        case 'item':
        {
          $this->do_item ();
          break;
        }

        case 'itemhistory':
        {
          $this->do_item_history ();
          break;
        }

        case 'list':
        {
          $this->do_list ();
          break;
        }

        case 'lotterywinners':
        {
          $this->do_lottery_winners ();
          break;
        }

        case 'mostsold':
        {
          $this->do_most_sold ();
          break;
        }

        case 'namechanges':
        {
          $this->do_name_changes ();
          break;
        }

        case 'play':
        {
          $this->do_play ();
          break;
        }

        case 'richest':
        {
          $this->do_richest ();
          break;
        }

        case 'sellitem':
        {
          $this->do_sell_item ();
          break;
        }

        case 'showgift':
        {
          $this->do_show_gift ();
          break;
        }

        case 'showribbon':
        {
          $this->do_show_ribbon ();
          break;
        }

        case 'userhistory':
        {
          $this->do_user_history ();
          break;
        }

        case 'useritems':
        {
          $this->do_user_items ();
          break;
        }

        case 'usertracks':
        {
          $this->do_user_tracks ();
          break;
        }

        case 'viewthread':
        {
          $this->do_view_thread ();
        }
      }

      if (!$this->is_displayed)
      {
        $this->do_main ();
      }

      return true;
    }
  }

  define ('VBBUX_VBPLAZA_ENGINE_RUNNING', false);
  define ('VBBUX_VBPLAZA_ENGINE_VERSION', '2.2.1');
  define ('VBBUX_VBPLAZA_SERVER_HOSTNAME', 'localhost');
  define ('VBBUX_VBPLAZA_SERVER_IPADDRESS', '127.0.0.1');
?>