<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'usergroup')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// set the cost to 0 to not display their costs
	$action['cost'] = 0;

	// process all of the usergroups that the user is not currently in
	$action['options'] = '';
	foreach($vbulletin->usergroupcache AS $usergroup)
	{
		// check if the usergroup is allowed to be purchased
		if ($usergroup['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canpurchaseassecondary'])
		{
			// check if the user is a member of this usergroup
			if (!is_member_of($vbulletin->userinfo, $usergroup['usergroupid']))
			{
				// format the vbp_secondarycost
				$usergroup['vbp_secondarycost'] = vb_number_format($usergroup['vbp_secondarycost'], $vbulletin->options['vbbux_decimalplaces']);

				// add this to the list of groups available for purchase
				$action['options'] .= "<option value=\"" . $usergroup['usergroupid'] . "\">" . $usergroup['title'] . " (" . $usergroup['vbp_secondarycost'] . " " . $vbphrase['vbbux_points'] . ")</option>";
			}
		}
	}

	// check if it found any forums
	if (empty($action['options']))
	{
		// display error, there are no forums you can buy access to
		eval(standard_error(fetch_error('vbplaza_site_has_no_usergroups_available_for_purchase')));
	}

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_usergroupid'];
	$action['fieldname'] = "usergroupid";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');

	($hook = vBulletinHook::fetch_hook('vbplaza_action_secondaryusergroup_choosegroup_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (confirmation page)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_secondaryusergroup_confirm_start')) ? eval($hook) : false;

	// verify the usergroupid
	$usergroupinfo = vbplaza_verify_usergroupid($action);

	// recalculate & validate the costs
	$action['cost'] = $usergroupinfo['vbp_secondarycost'];
	$action = vbplaza_calculate_total_cost($action);
	vbplaza_validate_cost($action);

	// build the $extra_fields
	$extra_fields .= "<input type=hidden name=\"action[usergroupid]\" value=\"" . $action['usergroupid'] . "\">\n";

	($hook = vBulletinHook::fetch_hook('vbplaza_action_secondaryusergroup_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '3' (perform actual purchase)
if ($_REQUEST['step'] == '3')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_secondaryusergroup_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify the usergroupid
	$usergroupinfo = vbplaza_verify_usergroupid($action);

	// recalculate & validate the costs
	$action['cost'] = $usergroupinfo['vbp_secondarycost'];
	$action = vbplaza_calculate_total_cost($action);
	vbplaza_validate_cost($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// get all of this user's additional membergroupids
	$membergroupids = array();
	if (!empty($vbulletin->userinfo['membergroupids']))
	{
		// get the previous $membergroupids
		$membergroupids = explode(",", $vbulletin->userinfo['membergroupids']);
	}

	// add in the new usergroupid
	$membergroupids[] = $action['usergroupid'];

	// implode the array
	$newmembergroups = implode(",", $membergroupids);

	// give the user the new membergroupids
	$extrafields = array();
	$extrafields[] = "membergroupids = '" . $newmembergroups . "'";

	// update this purchase with the user
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_usergroupid'] . ": " . $action['usergroupid'] . ".";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_secondaryusergroup_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>