<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// fetch the userinfo if it was specified
	if (is_numeric($_REQUEST['userid']))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid = '" . $_REQUEST['userid'] . "'");
	}
	else if (!empty($_REQUEST['username']))
	{
		// search for the username
		$touser = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($_REQUEST['username']) . "'");
	}

	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

	// build the causes to display
	$ribboncauses = '';
	foreach($vbulletin->vbplazaribbons AS $displayid => $ribbon)
	{
		// add this ribbon to the $ribboncauses
		eval('$ribboncauses .= "' . fetch_template('vbplaza_ribbon_causebit') . '";');
	}

	// add in the ribbon causes here
	eval('$current .= "' . fetch_template('vbplaza_ribbon_causes') . '";');

	// add the private field to $extra_fields
	$action['phrasename'] = construct_phrase($vbphrase['vbplaza_private_x'], $vbphrase['vbplaza_ribbon']);
	$action['fieldname'] = "private";
	$action['options'] = "<option value='0'>" . $vbphrase['no'] . "</option><option value='1'>" . $vbphrase['yes'] . "</option>";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');

	// start building the ribbons
	$action['options'] = $firstimg = '';
	foreach($vbulletin->vbplazaribbons AS $displayid => $ribbon)
	{
		// set $firstimage if not set
		if (empty($firstimage)) { $firstimage = $ribbon['filename']; }

		// add this to the option code
		$action['options'] .= "<option value='" . $ribbon['filename'] . "'>" . $ribbon['name'] . "</option>";
	}

	// add the javascript to the $hidden_fields
	$hidden_fields .= "<SCRIPT LANGUAGE=\"JavaScript\">\n<!--\nfunction change(what)\n{\n\tvalue = what.options[what.selectedIndex].value;\n\tif (value != '')\n\t\tif (document.ribbonimage)\n\t\t\tdocument.ribbonimage.src = (\"images/ribbons/\" + value + \".gif\");\n}\n//-->\n</SCRIPT>\n";

	// add the options to the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_select_your_ribbon_color'];
	$action['fieldname'] = "ribbon";
	$before_select = "<img name=\"ribbonimage\" src=\"images/ribbons/" . $firstimage . ".gif\" border=\"0\"> ";
	$extra_select = "onChange=\"change(this);\"";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');

	// only allow the username if they are allowed to buy others ribbons
	if ($action['vbplaza_userbuyothersribbons'])
	{
		// add to the $extra_fields the username
		$action['phrasename'] = $vbphrase['vbplaza_username'];
		$action['fieldname'] = 'username';
		$action['fieldvalue'] = $touser['username'];
		eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	}

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_message'];
	$action['fieldname'] = 'ribbonmessage';
	unset($action['fieldvalue']);
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	if (!empty($extra_fields)) { $extra_fields .= "<br />"; }

	($hook = vBulletinHook::fetch_hook('vbplaza_action_ribbon_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_ribbon_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// check if it needs to verify the username
	if ($action['vbplaza_userbuyothersribbons'])
	{
		// verify that they have entered a username to change
		if (empty($action['username']))
		{
			// display error, no username entered
			eval(standard_error(fetch_error('vbplaza_username_not_entered')));
		}

		// build the proper names with html codes
		$action['username'] = htmlspecialchars_uni($action['username']);

		// check if this user exists (first search by username)
		$touser = $db->query_first("SELECT userid, usergroupid, username, vbp_ribbons, vbp_history, vbp_vbplazaoptions FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

		// if it was not found by username, search by userid
		if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
		{
			// search for the userid
			$touser = $db->query_first("SELECT userid, usergroupid, username, vbp_ribbons, vbp_history, vbp_vbplazaoptions FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
		}
	}
	else
	{
		// set the $touser as the user thats logged in
		$touser = $vbulletin->userinfo;
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// check if this is the rainbow ribbon
	if ($action['ribbon'] == 'rainbow')
	{
		// check to see if this user is protected
		$protectedusergroups = explode(",", $vbulletin->options['vbplaza_protectedusergroups']);
		if (is_member_of($touser, $protectedusergroups))
		{
			// display error, this user is protected against this action
			eval(standard_error(fetch_error('vbplaza_protected_user')));
		}
	}

	// check if the option is disabled for them to buy themself a ribbon
	if (!$action['vbplaza_userbuyselfribbons'] && ($touser['userid'] == $vbulletin->userinfo['userid']))
	{
		// display error, you cant buy yourself a ribbon
		eval(standard_error(fetch_error('vbplaza_can_not_buy_yourself_a', $vbphrase['vbplaza_ribbon'])));
	}

	// check if the option is disabled for them to buy other's a ribbon
	if (!$action['vbplaza_userbuyothersribbons'] && ($touser['userid'] != $vbulletin->userinfo['userid']))
	{
		// display error, you cant buy others a ribbon
		eval(standard_error(fetch_error('vbplaza_can_not_buy_others_a', $vbphrase['vbplaza_ribbon'])));
	}

	// check if users are not allowed to buy the same ribbon twice
	if ($vbulletin->options['vbplaza_canbuysameribbontwice'] < 1)
	{
		// check if this user has this ribbon already
		$oldribbon = $vbulletin->db->query_first("SELECT touserid, ribbonname FROM " . TABLE_PREFIX . "vbplaza_ribbon WHERE ribbonname = '" . $action['ribbon']."' AND touserid = '" . $touser['userid'] . "'");
	
		// Check to see if we already have this ribbon
		if (is_numeric($oldribbon['touserid']))
		{
			// display error, you already have this ribbon
			eval(standard_error(fetch_error('vbplaza_ribbon_already_purchased')));
		}
	}

	// check if the ribbon is private
	$visible = 1;
	if ($action['private'] == '1')
	{
		// make this ribbon not visible to all users
		$visible = 0;
	}

	// trim the message
	$action['ribbonmessage'] = trim($action['ribbonmessage']);

	// check if the message is empty
	if (empty($action['ribbonmessage']))
	{
		// set the message to no message
		$action['ribbonmessage'] = $vbphrase['vbplaza_no_message'];
	}

	// strip all of the tags
	$action['ribbonmessage'] = $vbulletin->input->clean($action['ribbonmessage'], TYPE_NOHTML);

	// Let's find the cause
	$action['ribboncause'] = '';
	foreach($vbulletin->vbplazaribbons AS $displayid => $ribbon)
	{
		// check if this is the one we want
		if ($action['ribbon'] == $ribbon['filename'])
		{
			// set this cause as the ribboncause
			$action['ribboncause'] = $ribbon['cause'];
			break;
		}
	}

	// check if the ribboncause was not found
	if (empty($action['ribboncause']))
	{
		// let users add their own ribbons via hooks
		$handled = false;
		($hook = vBulletinHook::fetch_hook('vbplaza_action_ribbon_no_cause')) ? eval($hook) : false;

		// check if its not handled yet
		if (!$handled)
		{
			// set it to no cause
			$action['ribboncause'] = $vbphrase['vbplaza_no_cause'];
		}
	}

	// insert the ribbon into the database
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "vbplaza_ribbon (ribbonid, visible, ribbonname, touserid, tousername, fromuserid, fromusername, cause, message)
		VALUES
		(
			0,
			" . $visible . ",
			'" . $vbulletin->db->escape_string($action['ribbon']) . "',
			'" . $touser['userid'] . "',
			'" . $vbulletin->db->escape_string($touser['username']) . "',
			'" . $vbulletin->userinfo['userid'] . "',
			'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
			'" . $vbulletin->db->escape_string($action['ribboncause']) . "',
			'" . $vbulletin->db->escape_string($action['ribbonmessage']) . "'
		)
	");

	// save the ribbonid into $action['ribbonid']
	$action['ribbonid'] = $vbulletin->db->insert_id();

	// rebuild the users ribbon postbit
	vbplaza_rebuild_ribbon_postbit($touser['userid']);

	// update the person that the ribbon was given to
	$extrafields = array();
	$action['touserid'] = '';
	$action['tousername'] = '';
	$action['fromuserid'] = $vbulletin->userinfo['userid'];
	$action['fromusername'] = $vbulletin->userinfo['username'];
	$action['reason'] = $action['ribboncause'];
	$action['nopointschange'] = true;
	vbplaza_user_purchase_update($touser, $action, $extrafields, true);

	// update this purchase with the user
	$action['touserid'] = $touser['userid'];
	$action['tousername'] = $touser['username'];
	unset($action['fromuserid']);
	unset($action['fromusername']);
	$action['reason'] = $action['ribboncause'];
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// check if it should send the user a PM
	if ($action['vbplaza_giveribbonssendpm'] && !($touser['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['nopmuponnewribbon'])
		&& ($touser['userid'] != $vbulletin->userinfo['userid']))
	{
		// send the user a private message
		$title = construct_phrase($vbphrase['vbplaza_ribbon_title'], $vbulletin->userinfo['username']);
		$message = construct_phrase($vbphrase['vbplaza_ribbon_message'], $vbulletin->userinfo['username'], $action['ribbon']);
		if (!empty($action['reason']))
		{
			// add on the reason for the donation
			$message .= "\n\n" . $vbphrase['vbplaza_reason'] . ": " . $action['reason'];
		}
		vbplaza_send_pm($vbulletin->userinfo, $touser, $title, $message);
	}

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_purchased_for'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
	if (!empty($action['reason']))
	{
		// add on the reason for the donation
		$action['extrainfo'] .= "<br />" . $vbphrase['vbplaza_cause'] . ": " . $action['reason'];
	}
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_ribbon_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>