<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'usergroup')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// check that the user is not a protected usergroup
	if (($vbulletin->userinfo['usergroupid'] >= 5) && ($vbulletin->userinfo['usergroupid'] <= 7))
	{
		// display error, can not change primary user group
		eval(standard_error(fetch_error('vbplaza_staff_can_not_change_primary')));
	}

	// set the cost to 0 to not display their costs
	$action['cost'] = 0;

	// process all of the usergroups that the user is not currently in
	$action['options'] = '';
	foreach($vbulletin->usergroupcache AS $usergroup)
	{
		// check if the usergroup is allowed to be purchased
		if ($usergroup['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canpurchaseasprimary'])
		{
			// check if the user is a member of this usergroup
			if ($vbulletin->userinfo['usergroupid'] != $usergroup['usergroupid'])
			{
				// format the vbp_primarycost
				$usergroup['vbp_primarycost'] = vb_number_format($usergroup['vbp_primarycost'], $vbulletin->options['vbbux_decimalplaces']);

				// add this to the list of groups available for purchase
				$action['options'] .= "<option value=\"" . $usergroup['usergroupid'] . "\">" . $usergroup['title'] . " (" . $usergroup['vbp_primarycost'] . " " . $vbphrase['vbbux_points'] . ")</option>";
			}
		}
	}

	// check if it found any forums
	if (empty($action['options']))
	{
		// display error, there are no forums you can buy access to
		eval(standard_error(fetch_error('vbplaza_site_has_no_usergroups_available_for_purchase')));
	}

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_usergroupid'];
	$action['fieldname'] = "usergroupid";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');

	($hook = vBulletinHook::fetch_hook('vbplaza_action_primaryusergroup_choosegroup_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (confirmation page)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_primaryusergroup_confirm_start')) ? eval($hook) : false;

	// verify the usergroupid
	$usergroupinfo = vbplaza_verify_usergroupid($action);

	// recalculate & validate the costs
	$action['cost'] = $usergroupinfo['vbp_primarycost'];
	$action = vbplaza_calculate_total_cost($action);
	vbplaza_validate_cost($action);

	// build the $extra_fields
	$extra_fields .= "<input type=hidden name=\"action[usergroupid]\" value=\"" . $action['usergroupid'] . "\">\n";

	($hook = vBulletinHook::fetch_hook('vbplaza_action_primaryusergroup_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '3' (perform actual purchase)
if ($_REQUEST['step'] == '3')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_primaryusergroup_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// check that the user is not a protected usergroup
	if (($vbulletin->userinfo['usergroupid'] >= 5) && ($vbulletin->userinfo['usergroupid'] <= 7))
	{
		// display error, can not change primary user group
		eval(standard_error(fetch_error('vbplaza_staff_can_not_change_primary')));
	}

	// verify the usergroupid
	$usergroupinfo = vbplaza_verify_usergroupid($action);

	// recalculate & validate the costs
	$action['cost'] = $usergroupinfo['vbp_primarycost'];
	$action = vbplaza_calculate_total_cost($action);
	vbplaza_validate_cost($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// start building the $newoldgroups
	$oldgroups = unserialize($vbulletin->userinfo['vbp_oldgroups']);
	if (!is_array($oldgroups))
	{
		// set $oldgroups to an empty array
		$oldgroups = array();
	}

	// add this to the $oldgroups
	$oldgroups[] = array('usergroupid' => $vbulletin->userinfo['usergroupid'], 'dateline' => TIMENOW);

	// give the user the primary usergroup
	$extrafields = array();
	$extrafields[] = "usergroupid = '" . $action['usergroupid'] . "'";
	$extrafields[] = "vbp_oldgroups = '" . serialize($oldgroups) . "'";

	// update this purchase with the user
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_usergroupid'] . ": " . $action['usergroupid'] . ".";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_primaryusergroup_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>