<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'access')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// verify that enableaccess is ENABLED
if (!$vbulletin->options['enableaccess'])
{
	// display error, enableaccessmask is not enabled
	eval(standard_error(fetch_error('vbplaza_enable_access_mask_disabled')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// process all of the forums that the user can not view
	$action['options'] = '';
	foreach($vbulletin->forumcache AS $foruminfo)
	{
		// check if this forum is able to be given to another user
		if (($foruminfo['vbpforumoptions'] & $vbulletin->bf_misc_vbpforumoptions['cangiveaccess'])
			&& ($foruminfo['vbp_cangiveaccesscost'] != 0))
		{
			// format the vbp_cangiveaccesscost
			$foruminfo['vbp_cangiveaccesscost'] = vb_number_format($foruminfo['vbp_cangiveaccesscost'], $vbulletin->options['vbbux_decimalplaces']);

			// add this to the needed forums
			$action['options'] .= "<option value=\"" . $foruminfo['forumid'] . "\">" . $foruminfo['title_clean'] . " (" . $foruminfo['vbp_cangiveaccesscost'] . " " . $vbphrase['vbbux_points'] . ")</option>";
		}
	}

	// check if it found any forums
	if (empty($action['options']))
	{
		// display error, there are no forums you can buy access to
		eval(standard_error(fetch_error('vbplaza_site_has_no_forums_not_accessible')));
	}

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_username'];
	$action['fieldname'] = 'username';
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');

	// add these forums to the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_forumid'];
	$action['fieldname'] = "forumid";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');

	($hook = vBulletinHook::fetch_hook('vbplaza_action_giveforumaccess_chooseforum_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (confirmation page)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_giveforumaccess_confirm_start')) ? eval($hook) : false;

	// verify the forumid
	$foruminfo = vbplaza_verify_forumid($action);

	// recalculate & validate the costs
	$action['cost'] = $foruminfo['vbp_cangiveaccesscost'];
	$action = vbplaza_calculate_total_cost($action);
	vbplaza_validate_cost($action);

	// build the $extra_fields
	$extra_fields .= "<input type=hidden name=\"action[forumid]\" value=\"" . $action['forumid'] . "\">\n";
	$extra_fields .= "<input type=hidden name=\"action[username]\" value=\"" . $action['username'] . "\">\n";

	($hook = vBulletinHook::fetch_hook('vbplaza_action_giveforumaccess_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '3' (perform actual purchase)
if ($_REQUEST['step'] == '3')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_giveforumaccess_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that they have entered a username to change
	if (empty($action['username']))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$action['username'] = htmlspecialchars_uni($action['username']);

	// check if this user exists (first search by username)
	$touser = $vbulletin->db->query_first("SELECT userid, usergroupid, username, vbp_history FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

	// if it was not found by username, search by userid
	if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
	{
		// search for the userid
		$touser = $vbulletin->db->query_first("SELECT userid, usergroupid, username, vbp_history FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// verify that they are not trying to use this action on themself
	if ($touser['userid'] == $vbulletin->userinfo['userid'])
	{
		// display error, can not do this action to yourself
		eval(standard_error(fetch_error('vbplaza_can_not_do_this_action_to_yourself')));
	}

	// check to see if this user is protected
	$protectedusergroups = explode(",", $vbulletin->options['vbplaza_protectedusergroups']);
	if (is_member_of($touser, $protectedusergroups))
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// verify the forumid
	$foruminfo = vbplaza_verify_forumid($action);

	// verify that the user can give access to this forum
	if (!($foruminfo['vbpforumoptions'] & $vbulletin->bf_misc_vbpforumoptions['cangiveaccess']) || ($foruminfo['vbp_cangiveaccesscost'] == 0))
	{
		// display error, invalid forumid
		eval(standard_error(fetch_error('vbplaza_invalid_forumid')));
	}

	// recalculate & validate the costs
	$action['cost'] = $foruminfo['vbp_cangiveaccesscost'];
	$action = vbplaza_calculate_total_cost($action);
	vbplaza_validate_cost($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// insert the user access into the database
	$vbulletin->db->query_write("
		REPLACE INTO " . TABLE_PREFIX . $action['tablename'] . "
		(userid, forumid, accessmask)
		VALUES ('" . $touser['userid'] . "', '" . $action['forumid'] . "', '1')
	");

	// setup the $extrafields
	$extrafields = array();
	$extrafields[] = "options = (options & " . (-1 ^ $vbulletin->bf_misc_useroptions['hasaccessmask']) . ")";

	// update this purchase with the user specified
	unset($action['touserid']);
	unset($action['tousername']);
	$action['fromuserid'] = $vbulletin->userinfo['userid'];
	$action['fromusername'] = $vbulletin->userinfo['username'];
	$action['nopointschange'] = true;
	vbplaza_user_purchase_update($touser, $action, $extrafields, true);

	// update this purchase with the user
	$action['touserid'] = $touser['userid'];
	$action['tousername'] = $touser['username'];
	unset($action['fromuserid']);
	unset($action['fromusername']);
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_forumid'] . ": <a href=\"forumdisplay.php?f=" . $action['forumid'] . "\">" . $action['forumid'] . "</a>. " . $vbphrase['vbplaza_purchased_for'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_giveforumaccess_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>