<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// fetch the userinfo if it was specified
	if (is_numeric($_REQUEST['userid']))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid = '" . $_REQUEST['userid'] . "'");
	}
	else if (!empty($_REQUEST['username']))
	{
		// search for the username
		$touser = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($_REQUEST['username']) . "'");
	}

	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

	// cache all of the gifts first
	$giftscache = array();
	$images = opendir("./images/gifts/");
	while ($gift = readdir($images))
	{
		// verify its valid
		if (preg_match("/.gif/", $gift))
		{
			// skip . and ..
			if (($gift != ".") && ($gift != ".."))
			{
				// cache this gift
				$giftscache[] = $gift;
			}
		}
	}

	// sort the array alphabetically
	asort($giftscache);

	// add the private field to $extra_fields
	$action['phrasename'] = construct_phrase($vbphrase['vbplaza_private_x'], $vbphrase['vbplaza_gift']);
	$action['fieldname'] = "private";
	$action['options'] = "<option value='0'>" . $vbphrase['no'] . "</option><option value='1'>" . $vbphrase['yes'] . "</option>";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');

	// build the gifts as radio buttons
	if ($action['vbplaza_usegiftradiobuttons'] > 0)
	{
		// build the extra_custom
		$extra_custom = '';
		foreach($giftscache AS $icon)
		{
			// get the real icon name without file extension
			$icon = preg_replace("/.gif/", "", $icon);

			// set $firstimage if not set
			if (empty($firstimage)) { $firstimage = $icon; }

			// add this to the option code
			$extra_custom .= "<input type=\"radio\" name=\"action[gift]\" value=\"" . $icon . "\" /> <img src=\"images/gifts/" . $icon . ".gif\" /> ";
		}

		// add a table to the $extra_custom
		$action['phrasename'] = $vbphrase['vbplaza_gift'];
		$extra_custom = "<table border=\"0\" width=\"500\" cellpadding=\"2\" cellspacing=\"0\">\n<tr><td><div class=\"smallfont\">" . $action['phrasename'] . ":<div>" . $extra_custom . "</tr>\n</table>\n";

		// add the radio buttons to the $extra_fields
		eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_custom') . '";');
	}
	else
	{
		// start building the gifts
		$action['options'] = $firstimg = '';
		foreach($giftscache AS $icon)
		{
			// get the real icon name without file extension
			$icon = preg_replace("/.gif/", "", $icon);

			// set $firstimage if not set
			if (empty($firstimage)) { $firstimage = $icon; }

			// add this to the option code
			$action['options'] .= "<option value='" . $icon . "'>" . $icon . "</option>";
		}

		// add the javascript to the $hidden_fields
		$hidden_fields .= "<SCRIPT LANGUAGE=\"JavaScript\">\n<!--\nfunction change(what)\n{\n\tvalue = what.options[what.selectedIndex].value;\n\tif (value != '')\n\t\tif (document.giftimage)\n\t\t\tdocument.giftimage.src = (\"images/gifts/\" + value + \".gif\");\n}\n//-->\n</SCRIPT>\n";

		// add the options to the $extra_fields
		$action['phrasename'] = $vbphrase['vbplaza_gift'];
		$action['fieldname'] = "gift";
		$before_select = "<img name=\"giftimage\" src=\"images/gifts/" . $firstimage . ".gif\" border=\"0\"> ";
		$extra_select = "onChange=\"change(this);\"";
		eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');
	}

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_username'];
	$action['fieldname'] = 'username';
	$action['fieldvalue'] = $touser['username'];
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	$action['phrasename'] = $vbphrase['vbplaza_giftmessage'];
	$action['fieldname'] = 'giftmessage';
	unset($action['fieldvalue']);
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	if (!empty($extra_fields)) { $extra_fields .= "<br />"; }

	($hook = vBulletinHook::fetch_hook('vbplaza_action_gift_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_gift_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// verify that they have entered a username to change
	if (empty($action['username']))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$action['username'] = htmlspecialchars_uni($action['username']);

	// check if this user exists (first search by username)
	$touser = $db->query_first("SELECT userid, usergroupid, username, vbp_gifts, vbp_history, vbp_vbplazaoptions FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

	// if it was not found by username, search by userid
	if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, usergroupid, username, vbp_gifts, vbp_history, vbp_vbplazaoptions FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// check if the option is disabled for them to buy themself a gift
	if (!$action['vbplaza_userbuyselfgifts'] && ($touser['userid'] == $vbulletin->userinfo['userid']))
	{
		// display error, you cant buy yourself a gift
		eval(standard_error(fetch_error('vbplaza_can_not_buy_yourself_a', $vbphrase['vbplaza_gift'])));
	}

	// check if the gift is private
	$visible = 1;
	if ($action['private'] == '1')
	{
		// make this gift not visible to all users
		$visible = 0;
	}

	// trim the message
	$action['giftmessage'] = trim($action['giftmessage']);

	// check if the message is empty
	if (empty($action['giftmessage']))
	{
		// set the message to no message
		$action['giftmessage'] = $vbphrase['vbplaza_no_message'];
	}

	// strip all of the tags
	$action['giftmessage'] = $vbulletin->input->clean($action['giftmessage'], TYPE_NOHTML);

	// insert the gift into the database
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "vbplaza_gift (giftid, visible, giftname, touserid, tousername, fromuserid, fromusername, message)
		VALUES
		(
			0,
			" . $visible . ",
			'" . $vbulletin->db->escape_string($action['gift']) . "',
			'" . $touser['userid'] . "',
			'" . $vbulletin->db->escape_string($touser['username']) . "',
			'" . $vbulletin->userinfo['userid'] . "',
			'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
			'" . $vbulletin->db->escape_string($action['giftmessage']) . "'
		)
	");

	// save the giftid into $action['giftid']
	$action['giftid'] = $vbulletin->db->insert_id();

	// rebuild the users gift postbit
	vbplaza_rebuild_gift_postbit($touser['userid']);

	// update the person that the gift was given to
	$extrafields = array();
	$action['touserid'] = '';
	$action['tousername'] = '';
	$action['fromuserid'] = $vbulletin->userinfo['userid'];
	$action['fromusername'] = $vbulletin->userinfo['username'];
	$action['reason'] = $action['giftmessage'];
	$action['nopointschange'] = true;
	vbplaza_user_purchase_update($touser, $action, $extrafields, true);

	// update this purchase with the user
	$action['touserid'] = $touser['userid'];
	$action['tousername'] = $touser['username'];
	unset($action['fromuserid']);
	unset($action['fromusername']);
	$action['reason'] = $action['giftmessage'];
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// check if it should send the user a PM
	if ($action['vbplaza_givegiftssendpm'] && !($touser['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['nopmuponnewgift'])
		&& ($touser['userid'] != $vbulletin->userinfo['userid']))
	{
		// send the user a private message
		$title = construct_phrase($vbphrase['vbplaza_gift_title'], $vbulletin->userinfo['username']);
		$message = construct_phrase($vbphrase['vbplaza_gift_message'], $vbulletin->userinfo['username'], $action['gift']);
		if (!empty($action['reason']))
		{
			// add on the reason for the donation
			$message .= "\n\n" . $vbphrase['vbplaza_reason'] . ": " . $action['reason'];
		}
		vbplaza_send_pm($vbulletin->userinfo, $touser, $title, $message);
	}

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_purchased_for'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
	if (!empty($action['reason']))
	{
		// add on the reason for the donation
		$action['extrainfo'] .= "<br />" . $vbphrase['vbplaza_reason'] . ": " . $action['reason'];
	}
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_gift_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>