<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'forum')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// process all of the forums that the user can not view
	$action['options'] = '';
	foreach($vbulletin->forumcache AS $foruminfo)
	{
		// check if the user can access this forum
		$forumperms = fetch_permissions($foruminfo['forumid']);
		if (!empty($foruminfo['password']) && ($foruminfo['vbpforumoptions'] & $vbulletin->bf_misc_vbpforumoptions['cangetpassword']) && ($foruminfo['vbp_cangetpasswordcost'] != 0))
		{
			// format the vbp_cangetpasswordcost
			$foruminfo['vbp_cangetpasswordcost'] = vb_number_format($foruminfo['vbp_cangetpasswordcost'], $vbulletin->options['vbbux_decimalplaces']);

			// add this to the needed forums
			$action['options'] .= "<option value=\"" . $foruminfo['forumid'] . "\">" . $foruminfo['title_clean'] . " (" . $foruminfo['vbp_cangetpasswordcost'] . " " . $vbphrase['vbbux_points'] . ")</option>";
		}

	}

	// check if it found any forums
	if (empty($action['options']))
	{
		// display error, there are no forums you can buy access to
		eval(standard_error(fetch_error('vbplaza_site_has_no_forums_need_password')));
	}

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_forumid'];
	$action['fieldname'] = "forumid";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');

	($hook = vBulletinHook::fetch_hook('vbplaza_action_forumpassword_chooseforum_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (confirmation page)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_forumpassword_confirm_start')) ? eval($hook) : false;

	// verify the forumid
	$foruminfo = vbplaza_verify_forumid($action);

	// recalculate & validate the costs
	$action['cost'] = $foruminfo['vbp_cangetpasswordcost'];
	$action = vbplaza_calculate_total_cost($action);
	vbplaza_validate_cost($action);

	// build the $extra_fields
	$extra_fields .= "<input type=hidden name=\"action[forumid]\" value=\"" . $action['forumid'] . "\">\n";

	($hook = vBulletinHook::fetch_hook('vbplaza_action_forumpassword_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '3' (perform actual purchase)
if ($_REQUEST['step'] == '3')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_forumpassword_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify the forumid
	$foruminfo = vbplaza_verify_forumid($action);

	// check that this forum needs a password
	if (empty($foruminfo['password']))
	{
		// display error, this forum does not need a password
		eval(standard_error(fetch_error('vbplaza_forum_does_not_need_password')));
	}

	// verify that the user can give access to this forum
	if (!($foruminfo['vbpforumoptions'] & $vbulletin->bf_misc_vbpforumoptions['cangetpassword']) || ($foruminfo['vbp_cangetpasswordcost'] == 0))
	{
		// display error, invalid forumid
		eval(standard_error(fetch_error('vbplaza_invalid_forumid')));
	}

	// recalculate & validate the costs
	$action['cost'] = $foruminfo['vbp_cangetpasswordcost'];
	$action = vbplaza_calculate_total_cost($action);
	vbplaza_validate_cost($action);

	// update this purchase with the user
	$action['touserid'] = $touser['userid'];
	$action['tousername'] = $touser['username'];
	unset($action['fromuserid']);
	unset($action['fromusername']);
	$action['reason'] = $vbphrase['vbplaza_forum_password'] . ": " . $foruminfo['password'];
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_forumid'] . ": <a href=\"forumdisplay.php?f=" . $action['forumid'] . "\">" . $action['forumid'] . "</a>.";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	// set the purchase notes to the password
	$show['purchasenotes'] = true;
	$action['purchasenotes'] = $vbphrase['vbplaza_the_forum_password_is'] . " " . $foruminfo['password'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_forumpassword_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>