<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'thread')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// build the $extra_fields
	$action['nowrap'] = true;
	$action = vbplaza_build_inputfields($action);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_debumpthread_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_debumpthread_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// verify the threadid
	if (!is_numeric($action['threadid']))
	{
		// try to get the threadid from a URL
		list($mainurl, $parameters) = explode("?", $action['threadid']);

		// separate the paramters
		$variables = explode("?", $parameters);

		// process each variable
		$threadid = $postid = 0;
		foreach($variables AS $variable)
		{
			// make sure there is no # inside the variable
			list($realvar, $extravar) = explode("#", $variable);

			// check if the first 2 characters are t=
			if (substr($variable, 0, 2) == 't=')
			{
				// get the threadid
				list($vartype, $action['threadid']) = explode("=", $realvar);
				break;
			}
			else if (substr($variable, 0, 2) == 'p=')
			{
				// get the postid
				list($vartype, $action['postid']) = explode("=", $realvar);
				break;
			}
		}
		// check if it has found a thread id
		if (!is_numeric($action['threadid']))
		{
			// check if it has found a real postid
			if (is_numeric($action['postid']))
			{
				// try to dump the post to get the threadid
				$post = $vbulletin->db->query_first("
					SELECT * FROM " . TABLE_PREFIX . "post
					WHERE postid = '" . $action['postid'] . "'
				");

				// verify it has found the threadid now
				if (!is_numeric($post['threadid']))
				{
					// display error, invalid threadid
					eval(standard_error(fetch_error('vbplaza_invalid_threadid')));
				}
				else
				{
					// set the threadid
					$action['threadid'] = $post['threadid'];
				}
			}
			else
			{
				// display error, invalid threadid
				eval(standard_error(fetch_error('vbplaza_invalid_threadid')));
			}
		}
	}

	// try to find the thread from the database
	$thread = $vbulletin->db->query_first("
		SELECT threadid, open, forumid
		FROM " . TABLE_PREFIX . "thread
		WHERE threadid = '" . $action['threadid'] . "'
	");

	// verify the thread exists
	if (!$thread || empty($thread))
	{
		// display error, this thread does not exist
		eval(standard_error(fetch_error('vbplaza_thread_does_not_exist')));
	}

	// get the parentlist
	$parentlist = fetch_forum_parent_list($thread['forumid']);
	$parentlist = explode(",", $parentlist);

	// display forumcache
	if (empty($parentlist) || !is_array($parentlist))
	{
		// display error, this thread does not exist
		eval(standard_error(fetch_error('vbplaza_thread_does_not_exist')));
	}

	// process each forum in the list
	$candebump = false;
	foreach($parentlist AS $forumid)
	{
		// check if the user can debump threads in this forum
		if ($vbulletin->forumcache[$forumid]['vbpforumoptions'] & $vbulletin->bf_misc_vbpforumoptions['candebumpthreads'])
		{
			// set that they can debump threads in this forum
			$candebump = true;
			break;
		}
	}

	// check if this forum is allowed to have threads debumped
	if ($candebump != true)
	{
		// display error, can not debump threads in this forum
		eval(standard_error(fetch_error('vbplaza_thread_can_not_debump_here')));
	}

	// update the thread to TIMENOW
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . $action['tablename'] . "
		SET
			lastpost = " . (TIMENOW - 86400) . "
		WHERE threadid = '" . $action['threadid'] . "'
	");

	// update this purchase with the user
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_threadid'] . ": <a href=\"showthread.php?t=" . $action['threadid'] . "\">" . $action['threadid'] . "</a>.";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_debumpthread_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>