<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// set that it needs formdata
	$show['needsformdata'] = true;

	// build the hidden fields
	$hidden_fields .= "<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"2097152\" />\n";

	// build the $extra_fields
	$action['type'] = 'file';
	$action['nowrap'] = true;
	$action['upload'] = true;
	$action['phrasename'] = $vbphrase['vbplaza_upload_avatar_your_computer'];
	$extra_input = "onChange=\"check_yes('avatar_yes')\"";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');

	($hook = vBulletinHook::fetch_hook('vbplaza_action_customavatar_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_customavatar_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// get the permissions for the user found
	$vbulletin->userinfo['permissions'] = cache_permissions($vbulletin->userinfo);

	// need to fix some permissions for it to work properly
	if ((!($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar']))
		|| ($vbulletin->userinfo['vbp_genericperm'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar']))
	{
		// set it so they can use an avatar
		$vbulletin->userinfo['permissions']['genericpermissions'] |= $vbulletin->bf_ugp_genericpermissions['canuseavatar'];

		// check if it is not always using the default settings
		if (!$vbulletin->options['vbplaza_alwaysusedefavatar'])
		{
			// build the $ids to query from the database
			if (empty($vbulletin->userinfo['membergroupids']))
			{
				// build the $ids simply
				$ids = "0," . $vbulletin->userinfo['usergroupid'];
			}
			else
			{
				// add in the membergroupids too
				$ids = "0," . $vbulletin->userinfo['membergroupids'] . "," . $vbulletin->userinfo['usergroupid'];
			}

			// grab these $usergroups from the database
			$usergroups = $vbulletin->db->query_read("SELECT avatarmaxwidth, avatarmaxheight, avatarmaxsize FROM " . TABLE_PREFIX . "usergroup WHERE usergroupid IN (" . $ids . ")");
			while ($usergroup = $vbulletin->db->fetch_array($usergroups))
			{
				// check if the width in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['avatarmaxwidth'] < $usergroup['avatarmaxwidth'])
				{
					// set this value for the avatarmaxwidth
					$vbulletin->userinfo['permissions']['avatarmaxwidth'] = $usergroup['avatarmaxwidth'];
				}

				// check if the height in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['avatarmaxheight'] < $usergroup['avatarmaxheight'])
				{
					// set this value for the avatarmaxheight
					$vbulletin->userinfo['permissions']['avatarmaxheight'] = $usergroup['avatarmaxheight'];
				}

				// check if the size in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['avatarmaxsize'] < $usergroup['avatarmaxsize'])
				{
					// set this value for the avatarmaxsize
					$vbulletin->userinfo['permissions']['avatarmaxsize'] = $usergroup['avatarmaxsize'];
				}
			}
		}

		// check if the settings are not -1
		if ($vbulletin->userinfo['permissions']['avatarmaxwidth'] == -1)
		{
			// force the value to be the setting in the configuration
			$vbulletin->userinfo['permissions']['avatarmaxwidth'] = $vbulletin->options['vbplaza_defavatarmaxwidth'];
		}
		if ($vbulletin->userinfo['permissions']['avatarmaxheight'] == -1)
		{
			// force the value to be the setting in the configuration
			$vbulletin->userinfo['permissions']['avatarmaxheight'] = $vbulletin->options['vbplaza_defavatarmaxheight'];
		}
		if ($vbulletin->userinfo['permissions']['avatarmaxsize'] == -1)
		{
			// force the value to be the setting in the configuration
			$vbulletin->userinfo['permissions']['avatarmaxsize'] = $vbulletin->options['vbplaza_defavatarmaxsize'];
		}
	}

	// check one last time that the settings are not negative
	if ($vbulletin->userinfo['permissions']['avatarmaxwidth'] < 0)
	{
		// this is here to force it to not have a PHP error
		$vbulletin->userinfo['permissions']['avatarmaxwidth'] = 80;
	}
	if ($vbulletin->userinfo['permissions']['avatarmaxheight'] < 0)
	{
		// this is here to force it to not have a PHP error
		$vbulletin->userinfo['permissions']['avatarmaxheight'] = 80;
	}
	if ($vbulletin->userinfo['permissions']['avatarmaxsize'] < 0)
	{
		// this is here to force it to not have a PHP error
		$vbulletin->userinfo['permissions']['avatarmaxsize'] = 20000;
	}

	// clean the uploaded file
	$vbulletin->input->clean_gpc('f', 'upload', TYPE_FILE);

	// begin custom avatar upload checking
	require_once(DIR . '/includes/class_upload.php');
	require_once(DIR . '/includes/class_image.php');
	$upload = new vB_Upload_Userpic($vbulletin);
	$upload->data =& datamanager_init('Userpic_Avatar', $vbulletin, ERRTYPE_STANDARD, 'userpic');
	$upload->image =& vB_Image::fetch_library($vbulletin);
	$upload->maxwidth = $vbulletin->userinfo['permissions']['avatarmaxwidth'];
	$upload->maxheight = $vbulletin->userinfo['permissions']['avatarmaxheight'];
	$upload->maxuploadsize = $vbulletin->userinfo['permissions']['avatarmaxsize'];
	$upload->allowanimation = ($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['cananimateavatar']) ? true : false;
	if (!$upload->process_upload($vbulletin->GPC['avatarurl']))
	{
		// display the vB error code
		eval(standard_error($upload->fetch_error()));
	}

	// init user data manager
	$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
	$userdata->set_existing($vbulletin->userinfo);
	$userdata->set('avatarid', $vbulletin->GPC['avatarid']);
	($hook = vBulletinHook::fetch_hook('profile_updateavatar_complete')) ? eval($hook) : false;
	$userdata->save();

	// update this purchase with the user
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// update the quantity/sold
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_customavatar_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>