<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// build the $extra_fields
	$action['nowrap'] = true;
	$action = vbplaza_build_inputfields($action);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeusername_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeusername_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// get the newusername
	$newusername = stripslashes($action['username']);

	// verify that they have entered a username to change to
	if (empty($newusername))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$newusername = htmlspecialchars_uni($newusername);

	// verify the newusername is proper
	if (strchr($newusername, '<'))
	{
		// display error, new username is too short
		eval(standard_error(fetch_error('vbplaza_html_not_allowed')));
	}
	if (strlen($newusername) < $vbulletin->options['minuserlength'])
	{
		// display error, new username is too short
		eval(standard_error(fetch_error('vbplaza_username_too_short')));
	}
	if (strlen($newusername) > $vbulletin->options['maxuserlength'])
	{
		// display error, new username is too long
		eval(standard_error(fetch_error('vbplaza_username_too_long')));
	}
	if ($newusername != fetch_censored_text($newusername))
	{
		// display error, new username uses censored word
		eval(standard_error(fetch_error('vbplaza_username_censored')));
	}
	if (!empty($vbulletin->options['illegalusernames']))
	{
		// get the array of illegal usernames
		$usernames = preg_split('/\s+/', $vbulletin->options['illegalusernames'], -1, PREG_SPLIT_NO_EMPTY);

		// process each username
		foreach ($usernames AS $name)
		{
			// check if its contained
			if (strpos(strtolower($newusername), strtolower($name)) !== false)
			{
				// display error, new username contains illegal word/phrase
				eval(standard_error(fetch_error('vbplaza_username_illegal')));
			}
		}
	}

	$newusername = htmlspecialchars_uni($newusername);

	// finally, verify if another user already has this username
	if ($prevuser = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($newusername) . "'"))
	{
		// display error, this username is already in use
		eval(standard_error(fetch_error('vbplaza_username_already_in_use')));
	}

	// update all threads that were created by this user
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "thread
		SET
			postusername = '" . $vbulletin->db->escape_string($newusername) . "'
		WHERE postuserid = '" . $vbulletin->userinfo['userid'] . "'
	");

	// update all posts that were created by this user
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "post
		SET
			username = '" . $vbulletin->db->escape_string($newusername) . "'
		WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
	");

	// update all private messages that were created by this user
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "pmtext
		SET
			fromusername = '" . $vbulletin->db->escape_string($newusername) . "'
		WHERE fromuserid = '" . $vbulletin->userinfo['userid'] . "'
	");

	// update all usernotes that were created by this user
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "usernote
		SET
			username = '" . $vbulletin->db->escape_string($newusername) . "'
		WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
	");

	// log this change into vbplaza_namechange
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "vbplaza_namechange (changeid, dateline, changeuserid, oldusername, changedbyuserid)
		VALUES
		(
			0,
			" . TIMENOW . ",
			'" . $vbulletin->userinfo['userid'] . "',
			'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
			'" . $vbulletin->userinfo['userid'] . "'
		)
	");

	// give the user the username they want
	$extrafields = array();
	$extrafields[] = "username = '" . $vbulletin->db->escape_string($newusername) . "'";

	// update this purchase with the user
	$action['extrainfo'] = construct_phrase($vbphrase['vbplaza_old_username'], $vbphrase['username']) . ": <a href=\"member.php?u=" . $vbulletin->userinfo['userid'] . "\">" . $vbulletin->userinfo['username'] . "</a>.";
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// update the quantity/sold
	$action['extrainfo'] = construct_phrase($vbphrase['vbplaza_old_username'], $vbphrase['username']) . ": <a href=\"member.php?u=" . $vbulletin->userinfo['userid'] . "\">" . $vbulletin->userinfo['username'] . "</a>.";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeusername_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>