<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// start building the avatars
	$action['options'] = $firstimg = '';
	if ($defaultavatars = $vbulletin->db->query_read("
		SELECT avatar.*, imagecategory.title AS categorytitle
		FROM " . TABLE_PREFIX . "avatar AS avatar
		LEFT JOIN " . TABLE_PREFIX . "imagecategory AS imagecategory ON(avatar.imagecategoryid = imagecategory.imagecategoryid)
		ORDER BY imagecategoryid, displayorder
	"))
	{
		// start processing all avatars
		$oldcategoryid = 0;
		while ($defaultavatar = $vbulletin->db->fetch_array($defaultavatars))
		{
			// check if this is a new imagecategoryid
			if ($oldcategoryid != $defaultavatar['imagecategoryid'])
			{
				// check if it needs to end the previous optgroup
				if ($oldcategoryid > 0)
				{
					// end the old optgroup
					$action['options'] .= "</optgroup>";
				}

				// add this group header to the option code
				$action['options'] .= "<optgroup label=\"" . $defaultavatar['categorytitle'] . "\">";

				// update $oldcategoryid
				$oldcategoryid = $defaultavatar['imagecategoryid'];
			}

			// add this to the option code
			$action['options'] .= "<option value='" . $defaultavatar['avatarpath'] . "'>" . $defaultavatar['title'] . "</option>";

			// set $firstimage if not set
			if (empty($firstimage)) { $firstimage = $defaultavatar['avatarpath']; }
		}

		// end the optgroup
		$action['options'] .= "</optgroup>";
	}

	// free the defaultavatars
	$vbulletin->db->free_result($defaultavatars);

	// verify that it has found some default avatars
	if (empty($action['options']))
	{
		// display error, no default avatars found
		eval(standard_error(fetch_error('vbplaza_no_default_avatars_found')));
	}


	// add the javascript to the $hidden_fields
	$hidden_fields .= "<SCRIPT LANGUAGE=\"JavaScript\">\n<!--\nfunction change(what)\n{\n\tvalue = what.options[what.selectedIndex].value;\n\tif (value != '')\n\t\tif (document.avatarimage)\n\t\t\tdocument.avatarimage.src = (value);\n}\n//-->\n</SCRIPT>\n";

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_username'];
	$action['fieldname'] = 'username';
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	$action['phrasename'] = $vbphrase['vbplaza_avatars'];
	$action['fieldname'] = "avatarpath";
	$before_select = "<img name=\"avatarimage\" src=\"" . $firstimage . "\" border=\"0\">";
	$extra_select = "onChange=\"change(this);\"";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');
	if (!empty($extra_fields)) { $extra_fields .= "<br />"; }

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeothersdefaultavatar_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeothersdefaultavatar_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// try to find the avatar from the avatar table
	$othersavatar = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "avatar WHERE avatarpath = '" . $vbulletin->db->escape_string($action['avatarpath']) . "'");
	if (!is_numeric($othersavatar['avatarid']))
	{
		// display error, invalid avatar id
		eval(standard_error(fetch_error('vbplaza_invalid_avatar_id')));
	}

	// verify that they have entered a username to change
	if (empty($action['username']))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$action['username'] = htmlspecialchars_uni($action['username']);

	// check if this user exists (first search by username)
	$touser = $db->query_first("SELECT userid, usergroupid, membergroupids, username, vbp_history, vbp_immunity FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

	// if it was not found by username, search by userid
	if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, usergroupid, membergroupids, username, vbp_history, vbp_immunity FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// verify that they are not trying to use this action on themself
	if ($touser['userid'] == $vbulletin->userinfo['userid'])
	{
		// display error, can not do this action to yourself
		eval(standard_error(fetch_error('vbplaza_can_not_do_this_action_to_yourself')));
	}

	// check to see if this user is protected
	$protectedusergroups = explode(",", $vbulletin->options['vbplaza_protectedusergroups']);
	if (is_member_of($touser, $protectedusergroups))
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// check if this user is immune to this operation
	if ($touser['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['changedefaultavatar'])
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// setup the $extrafields
	$extrafields = array();
	$extrafields[] = "avatarid = '" . $othersavatar['avatarid'] . "'";

	// update this purchase with the user specified
	unset($action['touserid']);
	unset($action['tousername']);
	$action['fromuserid'] = $vbulletin->userinfo['userid'];
	$action['fromusername'] = $vbulletin->userinfo['username'];
	$action['nopointschange'] = true;
	vbplaza_user_purchase_update($touser, $action, $extrafields, true);

	// update this purchase with the user
	$action['touserid'] = $touser['userid'];
	$action['tousername'] = $touser['username'];
	unset($action['fromuserid']);
	unset($action['fromusername']);
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_avatarid'] . ": " . $avatar['avatarid'] . "</a>. " . $vbphrase['vbplaza_purchased_for'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeothersdefaultavatar_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>