<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// verify that this user is an admin
if (!is_member_of($vbulletin->userinfo, $vbulletin->options['vbplaza_adminusergroups']))
{
	// display error, admin only
	eval(standard_error(fetch_error('vbplaza_admin_access_only')));
}

// set it to show the section header
$show['customheader'] = true;
$action['customheader'] = $vbphrase['vbplaza_make_admin_donation'];

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// build the $extra_fields
	$action['phrasename'] = $vbphrase['username'];
	$action['fieldname'] = 'username';
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	$action['phrasename'] = $vbphrase['vbplaza_donation_amount'];
	$action['fieldname'] = 'donateamount';
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	$action['phrasename'] = $vbphrase['vbplaza_donation_reason'];
	$action['fieldname'] = 'reason';
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');

	($hook = vBulletinHook::fetch_hook('vbplaza_action_admindonate_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_admindonate_process_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// strip out all comma's
	$action['donateamount'] = str_replace(",", "", $action['donateamount']);

	// verify the donateamount to transfer is positive
	if (!is_numeric($action['donateamount']))
	{
		// display error, invalid transfer amount
		eval(standard_error(fetch_error('vbplaza_invalid_transfer_amount')));
	}

	// verify that they have entered a username to change
	if (empty($action['username']))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$action['username'] = htmlspecialchars_uni($action['username']);

	// check if this user exists (first search by username)
	$touser = $db->query_first("SELECT userid, usergroupid, username, `" . $vbulletin->options['vbbux_pointsfield'] . "`, vbp_history FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

	// if it was not found by username, search by userid
	if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, usergroupid, username, `" . $vbulletin->options['vbbux_pointsfield'] . "`, vbp_history FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// verify the user has enough points to cover the theft
	if (($touser[$vbulletin->options['vbbux_pointsfield']] + $action['donateamount']) < 0)
	{
		// display error, not enough points
		eval(standard_error(fetch_error('vbplaza_they_dont_have_enough_points')));
	}

	// update this purchase with the user
	unset($extrafields);
	unset($action['touserid']);
	unset($action['tousername']);
	$action['fromuserid'] = $vbulletin->userinfo['userid'];
	$action['fromusername'] = $vbulletin->userinfo['username'];
	$action['finalcost'] = $action['donateamount'];
	vbplaza_user_purchase_update($touser, $action, $extrafields, true);

	// check if it should send the user a PM
	if ($action['vbplaza_admindonatesendpm'])
	{
		// send the user a private message
		$title = construct_phrase($vbphrase['vbplaza_admin_donation_title'], $vbulletin->userinfo['username']);
		$message = construct_phrase($vbphrase['vbplaza_admin_donation_message'], $vbulletin->userinfo['username'], $action['donateamount']);
		if (!empty($action['reason']))
		{
			// strip all of the tags
			$action['reason'] = $vbulletin->input->clean($action['reason'], TYPE_NOHTML);

			// add on the reason for the donation
			$message .= "\n\n" . $vbphrase['vbplaza_reason'] . ": " . $action['reason'];
		}
		vbplaza_send_pm($vbulletin->userinfo, $touser, $title, $message);
	}

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_donated_to'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
	if (!empty($action['reason']))
	{
		// add on the reason for the donation
		$action['extrainfo'] .= "<br />" . $vbphrase['vbplaza_reason'] . ": " . $action['reason'];
	}
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_admindonate_process_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>