<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if ($vbulletin->options['vbbux_enabled'] == 1)
	{
		// check if the user has this permission due to vbPlaza
		if ($vbulletin->userinfo['vbp_genericperm'] & $vbulletin->bf_ugp_genericpermissions['canprofilepic'])
		{
			// get the permissions for the user found
			$vbulletin->userinfo['permissions'] = cache_permissions($vbulletin->userinfo);

			// set it so they can use a profilepic
			$vbulletin->userinfo['permissions']['genericpermissions'] |= $vbulletin->bf_ugp_genericpermissions['canprofilepic'];

			// process each usergroup
			foreach($vbulletin->usergroupcache AS $usergroupid => $usergroup)
			{
				// check if the width in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['profilepicmaxwidth'] < $usergroup['profilepicmaxwidth'])
				{
					// set this value for the profilepicmaxwidth
					$vbulletin->userinfo['permissions']['profilepicmaxwidth'] = $usergroup['profilepicmaxwidth'];
				}

				// check if the height in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['profilepicmaxheight'] < $usergroup['profilepicmaxheight'])
				{
					// set this value for the profilepicmaxheight
					$vbulletin->userinfo['permissions']['profilepicmaxheight'] = $usergroup['profilepicmaxheight'];
				}

				// check if the size in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['profilepicmaxsize'] < $usergroup['profilepicmaxsize'])
				{
					// set this value for the profilepicmaxsize
					$vbulletin->userinfo['permissions']['profilepicmaxsize'] = $usergroup['profilepicmaxsize'];
				}
			}
		}

		// check if its deleting a profile pic
		if ($vbulletin->GPC['deleteprofilepic'])
		{
			// remove some points for the user removing a profile picture
			if ($vbulletin->options['vbbux_perprofilepicsub'] !=  0)
			{
				// verify the user has enough points to remove this
				if ($vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']] < $vbulletin->options['vbbux_perprofilepicsub'])
				{
					// display error, not enough points
					eval(standard_error(fetch_error('vbplaza_not_enough_points')));
				}
			}
		}

		// check for any previous profile pictures
		$previousprofilepic = $db->query_first("
			SELECT userid, dateline, height, width
			FROM " . TABLE_PREFIX . "customprofilepic
			WHERE userid = " . $vbulletin->userinfo['userid']
		);
	}
}
?>