<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if ($vbulletin->options['vbbux_enabled'] == 1)
	{
		// check if the user has this permission due to vbPlaza
		if ($vbulletin->userinfo['vbp_genericperm'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar'])
		{
			// get the permissions for the user found
			$vbulletin->userinfo['permissions'] = cache_permissions($vbulletin->userinfo);

			// set it so they can use a avatar
			$vbulletin->userinfo['permissions']['genericpermissions'] |= $vbulletin->bf_ugp_genericpermissions['canuseavatar'];

			// process each usergroup
			foreach($vbulletin->usergroupcache AS $usergroupid => $usergroup)
			{
				// check if the width in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['avatarmaxwidth'] < $usergroup['avatarmaxwidth'])
				{
					// set this value for the avatarmaxwidth
					$vbulletin->userinfo['permissions']['avatarmaxwidth'] = $usergroup['avatarmaxwidth'];
				}

				// check if the height in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['avatarmaxheight'] < $usergroup['avatarmaxheight'])
				{
					// set this value for the avatarmaxheight
					$vbulletin->userinfo['permissions']['avatarmaxheight'] = $usergroup['avatarmaxheight'];
				}

				// check if the size in this usergroup is > than the value already set
				if ($vbulletin->userinfo['permissions']['avatarmaxsize'] < $usergroup['avatarmaxsize'])
				{
					// set this value for the avatarmaxsize
					$vbulletin->userinfo['permissions']['avatarmaxsize'] = $usergroup['avatarmaxsize'];
				}
			}
		}
	}
}
?>