<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if ($vbulletin->options['vbbux_enabled'] == 1)
	{
		// set the flag that its enabled
		$show['vbbux_enabled'] = true;

		// set the flag to show/hide points in postbits
		$show['pointsinpostbit'] = ($vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['hidepointsinposts']) ? false : true;

		// add the points to the userinfo
		$vbulletin->userinfo['points'] = vb_number_format($vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']], $vbulletin->options['vbbux_decimalplaces']);
		$vbulletin->userinfo['bank'] = vb_number_format($vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']], $vbulletin->options['vbbux_decimalplaces']);
		$vbulletin->userinfo['totalpoints'] = vb_number_format($vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']] + $vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']], $vbulletin->options['vbbux_decimalplaces']);

		// check if the user is owed interest
		if ($vbulletin->userinfo['vbp_nextbankinterest'] && $vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']] && ($vbulletin->userinfo['vbp_nextbankinterest'] < TIMENOW))
		{
			// calculate the interest amount
			$interestamt = ($vbulletin->options['vbbux_bankinterestpercent'] / 100) + 1.0;

			// calculate the next interest interval
			$interestint = $vbulletin->options['vbbux_bankinterestinterval'] + TIMENOW;

			// send the query to give the points
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
				SET
					`" . $vbulletin->options['vbbux_bankfield'] . "` = `" . $vbulletin->options['vbbux_bankfield'] . "` * " . $interestamt . ",
					vbp_nextbankinterest = " . $interestint . "
				WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
					AND vbp_receivespoints = '1'
			");
		}

		// check if the user has any fields that expire
		if (!empty($vbulletin->userinfo['vbp_history']))
		{
			// try to unserialize the data
			$userhistory = unserialize($vbulletin->userinfo['vbp_history']);

			// verify $userhistory is an array
			if (is_array($userhistory))
			{
				// process each history action to see if any are expired
				$expiredoptions = false;
				foreach($userhistory AS $history)
				{
					// check if this option is one that expires
					if ($history['expires'] && ($history['expires'] < TIMENOW))
					{
						// set expiredoptions true
						$expiredoptions = true;
					}
				}

				// check if any options expired
				if ($expiredoptions)
				{
					// check if it should display the expired page
					if ($vbulletin->options['vbplaza_showexpirepage'])
					{
						// jump to the store
						if (THIS_SCRIPT != 'vbplaza')
						{
							// build $headinclude
							eval('$headinclude = "' . fetch_template('headinclude') . '";');

							// this user has options that should expire, jump to the vbplaza to expire them.
							$vbulletin->url = $vbulletin->options['bburl'] . '/vbplaza.php?do=expireitems';
							eval(print_standard_redirect('vbplazaoptionexpired', true, true));
						}
						else
						{
							// force the store's 'do' to expireitems
							$_REQUEST['do'] = 'expireitems';
						}
					}
					else
					{
						// require the functions necessary to expire inline
						require_once(DIR . '/includes/functions_vbplaza.php');

						// first cache all of the vbplaza options
						$vbplazaoptions = vbplaza_cache_items();

						// now expire the options manually
						$savehistory = false;
						foreach($userhistory AS $key => $history)
						{
							// check if this option is one that expires
							if ($history['expires'] && ($history['expires'] < TIMENOW))
							{
								// expire the option inline
								if (vbplaza_expire_item($vbulletin->userinfo, $history, $vbplazaoptions))
								{
									// unset this from the user history
									unset($userhistory["$key"]);

									// set it to re-save the history
									$savehistory = true;
								}
							}
						}

						// check if it should resave the history
						if ($savehistory == true)
						{
							// re-serialize the $userhistory
							$userhistory = serialize($userhistory);

							// send off the query
							$vbulletin->db->query_write("
								UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
								SET vbp_history = '" . $vbulletin->db->escape_string($userhistory) . "'
								WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
							");
						}
					}
				}
			}
		}
	}

	// check if it's enabled first
	if ($vbulletin->options['vbplaza_enabled'] == 1)
	{
		// set the flag that its enabled
		$show['vbplaza_enabled'] = true;

		// check if the user has the option to bypass flood control
		if ($vbulletin->userinfo['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['bypasspostflood'])
		{
			// set the setting so they can bypass flood control
			$vbulletin->options['floodchecktime'] = 0;
		}

		// check if the user can see deletion notices
		if ($vbulletin->userinfo['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['seedeletionnotices'])
		{
			// set the setting so they can see deletion notices
			$vbulletin->userinfo['permissions']['forumpermissions'] |= $vbulletin->bf_ugp_forumpermissions['canseedelnotice'];
		}

		// check if the user can bypass pm flood control
		if ($vbulletin->userinfo['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['bypasspmflood'])
		{
			// set the setting so they can bypass pm flood control
			$vbulletin->options['pmfloodtime'] = 0;
		}

		// check if the user can bypass search flood control
		if ($vbulletin->userinfo['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['bypasssearchflood'])
		{
			// set the setting so they can bypass search flood control
			$vbulletin->options['searchfloodtime'] = 0;
		}

		// check if the user can use message tracking
		if ($vbulletin->userinfo['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['canusemessagetracking'])
		{
			// add this to the user's pmpermissions
			$vbulletin->userinfo['permissions']['pmpermissions'] |= $vbulletin->bf_ugp_pmpermissions['cantrackpm'];
		}

		// check if the user can deny pm receipts
		if ($vbulletin->userinfo['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['candenypmreceipts'])
		{
			// add this to the user's pmpermissions
			$vbulletin->userinfo['permissions']['pmpermissions'] |= $vbulletin->bf_ugp_pmpermissions['candenypmreceipts'];
		}

		// check if this user has purchased  any generic permissions
		if ($vbulletin->userinfo['vbp_genericperm'] != 0)
		{
			// add this user's other purchased generic permissions
			$vbulletin->userinfo['permissions']['genericpermissions'] |= $vbulletin->userinfo['vbp_genericperm'];
		}

		// check if this user has purchased any signature permissions
		if ($vbulletin->userinfo['vbp_signatureperm'] != 0)
		{
			// add this user's other purchased any signature permissions
			$vbulletin->userinfo['permissions']['signaturepermissions'] |= $vbulletin->userinfo['vbp_signatureperm'];
		}

		// check if this moderator has purchased anymore permissions
		if (($vbulletin->userinfo['vbp_modperm'] != 0) && is_array($vbulletin->forumcache))
		{
			// need this to globally add the permissions for this mod
			global $imodcache;

			// add this user's purchased global moderation permissions
			$vbulletin->userinfo['permissions']['moderatorpermissions'] |= intval($vbulletin->userinfo['vbp_modperm']);

			// add these global flags to all forums
			foreach($vbulletin->forumcache AS $forum)
			{
				// update the cache for this users permission for this forum
				$imodcache[$forum['forumid']][$vbulletin->userinfo['userid']]['permissions'] = intval($vbulletin->userinfo['vbp_modperm']);
			}
		}

		// check some other permissions
		if ($vbulletin->userinfo['vbp_genericperm'] & $vbulletin->bf_ugp_genericpermissions['canprofilepic'])
		{
			// add this to get to edit the profile picture
			$vbulletin->userinfo['permissions']['forumpermissions'] |= $vbulletin->bf_ugp_forumpermissions['canview'];
		}
	}

	// explode the vbplaza_adminusergroups into an array for is_member_of check
	if (!empty($vbulletin->options['vbplaza_adminusergroups']))
	{
		// explode them into an array
		$vbulletin->options['vbplaza_adminusergroups'] = explode(",", $vbulletin->options['vbplaza_adminusergroups']);
	}
}
?>