<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbplaza_ribbons');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('vbplaza', 'forum', 'cpuser', 'cpoption');
$specialtemplates = array('vbplazacategory', 'vbplazaoptions');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_vbplaza.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// check if the admin requires super administrator access for 'ribbons'
// NOTE: To enable this enter the below line into your config.php
// $config['vbPlaza']['ribbons']['requiresuperadmin'] = true;
if ($vbulletin->config['vbPlaza']['ribbons']['requiresuperadmin'])
{
	// check if the user is a super administrator
	$userids = explode(',', str_replace(' ', '', $vbulletin->config['SpecialUsers']['superadministrators']));
	if (!in_array($vbulletin->userinfo['userid'], $userids))
	{
		print_stop_message('vbplaza_no_permission_admin_ribbons');
	}
}

// check that moderators are allowed to use these
if ($vbulletin->options['vbplaza_modcpenabled'] == 0)
{
	// display the header
	print_cp_header('vbPlaza v' . $vbulletin->options['vbplaza_version'] . ' Moderator');

	// display message that these functions are disabled
	print_form_header('vbplaza_ribbons', 'vbplazadisabled');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_disabled_by_administrator'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_disabled_by_administrator_message']);
	print_table_footer(2, "");

	// display the footer
	print_cp_footer();
	exit;
}

// display the header
print_cp_header('vbPlaza Ribbons v' . $vbulletin->options['vbplaza_version'] . ' Moderator');

// check if an action is set
if (!isset($_REQUEST['do']))
{
	// force it to find ribbons
	$_REQUEST['do'] = 'findribbons';
}

// check if its searching the ribbons
if ($_REQUEST['do'] == 'searchribbons')
{
	// build the search terms if any
	$searchterms = array();
	if (is_numeric($_REQUEST['userid']))
	{
		// add this to the search terms
		$searchterms[] = "touserid = '" . $_REQUEST['userid'] . "'";
	}
	if (!empty($_REQUEST['username']))
	{
		// add this to the search terms
		$searchterms[] = "tousername LIKE '%" . $db->escape_string($_REQUEST['username']) . "%'";
	}

	// check if there are any searchterms
	if (!empty($searchterms))
	{
		// implode the string
		$wherestr = "WHERE " . implode(" OR ", $searchterms);
	}

	// verify that $_REQUEST['page'] is set
	$perpage = 50;
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check out how many ribbons are found like this
	$allribbons = $db->query_first("
		SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_ribbon
		" . $wherestr . "
	");

	// check if any rows were found
	if ($allribbons['count'] > 0)
	{
		// build the total page
		$totalpages = ceil($allribbons['count'] / $perpage);

		// select the rows from the database
		$ribbons = $db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon
			" . $wherestr . "
			ORDER BY ribbonid DESC
			" . $limitstr . "
		");

		// process each ribbon
		$ribboncache = array();
		while ($ribbon = $db->fetch_array($ribbons))
		{
			// add this ribbon
			$ribboncache["$ribbon[ribbonid]"] = $ribbon;
		}

		// free the ribbons
		$vbulletin->db->free_result($ribbons);

		// check if its not the first page
		if ($_REQUEST['page'] != 1)
		{
			$prv = $_REQUEST['page'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchribbons&ribbonid=" . $_REQUEST['ribbonid'] . "&ribbonname=" . $_REQUEST['ribbonname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchribbons&ribbonid=" . $_REQUEST['ribbonid'] . "&ribbonname=" . $_REQUEST['ribbonname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$prv'\">";
		}
		if ($_REQUEST['page'] != $totalpages)
		{
			$nxt = $_REQUEST['page'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchribbons&ribbonid=" . $_REQUEST['ribbonid'] . "&ribbonname=" . $_REQUEST['ribbonname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchribbons&ribbonid=" . $_REQUEST['ribbonid'] . "&ribbonname=" . $_REQUEST['ribbonname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$totalpages'\">";
		}

		// display message that the refill was successful
		print_form_header('vbplaza_ribbons', 'searchribbons');
		print_description_row(construct_link_code($vbphrase['restart'], "vbplaza_ribbons.php?do=findribbons"), 0, 4, 'thead', $stylevar['right']);
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_ribbons'] . "</font>", 4);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_ribbon']), $vbphrase['vbplaza_ribbon_name'], $vbphrase['vbplaza_ribbon_purchased_for'], $vbphrase['vbplaza_ribbon_purchaser']), 1, 'tcat');

		// process each row
		foreach($ribboncache AS $ribbonid => $ribbon)
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = $ribbon['ribbonid'];
			$cell[] = $ribbon['ribbonname'];
			$cell[] = "<a href=\"user.php?do=edit&amp;u=" . $ribbon['touserid'] . "\">" . $ribbon['tousername'] . "</a>";
			$cell[] = "<a href=\"user.php?do=edit&amp;u=" . $ribbon['fromuserid'] . "\">" . $ribbon['fromusername'] . "</a>";
			print_cells_row($cell);
		}

		// finish off the footer
		print_table_footer(4, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		// display message that nothing was found
		print_form_header('vbplaza_ribbons', 'searchribbons');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_ribbons'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_ribbons_found']);
		print_table_footer(2, "");
	}
}

// check if its fixing all ribbons
if ($_REQUEST['do'] == 'fixallribbons')
{
	// check if percyle is given
	if (is_numeric($_REQUEST['percycle']) && ($_REQUEST['startat'] < $_REQUEST['lastuserid']))
	{
		// check for startat
		if (empty($_REQUEST['startat'])) { $_REQUEST['startat'] = 0; }

		// get all of the ribbons from the ribbons table
		if ($ribbons = $db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon
			WHERE (touserid > " . $_REQUEST['startat'] . ") AND (touserid < " . ($_REQUEST['startat'] + $_REQUEST['percycle']) . ")
			ORDER BY touserid, ribbonid DESC
		"))
		{
			// initialize the query stuff
			$curuser = $curribboncount = 0;
			$curribbons = array();

			// process all of the ribbons
			while ($ribbon = $db->fetch_array($ribbons))
			{
				// check if this userid is the same as previous
				if ($curuser != $ribbon['touserid'])
				{
					// update $curuser
					if ($curuser > 0)
					{
						// serialize the new ribbons field
						$curribbons = serialize($curribbons);

						// perform the query
						$db->query_write("
							UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
							SET
								vbp_ribbons = '" . $db->escape_string($curribbons) . "'
							WHERE userid = '" . $curuser . "'
						");
					}

					// update $curuser
					$curuser = $ribbon['touserid'];

					// clear out some variables
					$curribboncount = 0;
					$curribbons = array();
				}


				// check if it can still add this to the count
				if ($curribboncount < $vbulletin->options['vbplaza_maxribbonsdisplayed'])
				{
					// trim the cause
					$ribbon['cause'] = trim($ribbon['cause']);

					// check if the cause is empty
					if (empty($ribbon['cause']))
					{
						// set the cause to no cause
						$ribbon['cause'] = $vbphrase['vbplaza_no_cause'];
					}

					// add this ribbon into the array
					$curribbons[$ribbon['ribbonid']] = array(
						'ribbonid'	=>	$ribbon['ribbonid'],
						'ribbonname'	=>	$ribbon['ribbonname'],
						'userid'	=>	$ribbon['fromuserid'],
						'username'	=>	$ribbon['fromusername'],
						'cause'		=>	$ribbon['cause']
					);

					// increase $curribboncount
					$curribboncount++;
				}
			}

			// check if there is 1 more user to update
			if (!empty($curribbons))
			{
				// serialize the new ribbons field
				$curribbons = serialize($curribbons);

				// perform the query
				$db->query_write("
					UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
					SET
						vbp_ribbons = '" . $db->escape_string($curribbons) . "'
					WHERE userid = '" . $curuser . "'
				");
			}
		}

		// free the ribbons
		$vbulletin->db->free_result($ribbons);

		// increase $_REQUEST['startat']
		$_REQUEST['startat'] += $_REQUEST['percycle'];

		// now check if it needs to redirect again
		if ($_REQUEST['startat'] < $_REQUEST['lastuserid'])
		{
			// need to redirect again
			print_cp_redirect("vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=fixallribbons&amp;percycle=" . $_REQUEST['percycle'] . "&amp;startat=" . ($_REQUEST['startat'] + $_REQUEST['percycle']) . "&amp;lastuserid=" . $_REQUEST['lastuserid']);
		}
	}

	// display cause that the ribbon fixing was successful
	print_form_header('vbplaza_ribbons', 'optionlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_fix_all_ribbons'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its fixing the ribbons
if ($_REQUEST['do'] == 'fixupribbons')
{
	// get the very last userid available
	$lastuser = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user ORDER BY userid DESC LIMIT 1");

	// display a confirmation
	print_form_header('vbplaza_ribbons', 'fixallribbons');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_fix_all_ribbons'] . "</font>", 2);
	construct_hidden_code('lastuserid', $lastuser['userid']);
	print_description_row($vbphrase['vbplaza_fix_all_ribbons_warning']);
	print_input_row($vbphrase['vbplaza_number_of_users_to_process_per_cycle'], 'percycle', '1000');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_fix_all_ribbons'] . "\" accesskey=\"s\" />");
}

// check if it is searching the ribbons
if ($_REQUEST['do'] == 'findribbons')
{
	// display that there are no categories found
	print_form_header('vbplaza_ribbons', 'searchribbons');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_ribbons'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_search_criteria']);
	print_input_row($vbphrase['username'], 'username', '');
	print_input_row($vbphrase['userid'], 'userid', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_search_ribbons'] . "\" accesskey=\"s\" />");
}

// display the footer
print_cp_footer();
?>