<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// build the $extra_fields
	$action['nowrap'] = true;
	$action = vbplaza_build_inputfields($action);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_stealothersreputation_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_stealothersreputation_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// verify that they have entered a username to change
	if (empty($action['username']))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$action['username'] = htmlspecialchars_uni($action['username']);

	// check if this user exists (first search by username)
	$touser = $db->query_first("SELECT userid, usergroupid, membergroupids, username, reputation, vbp_history, vbp_immunity FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

	// if it was not found by username, search by userid
	if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, usergroupid, membergroupids, username, reputation, vbp_history, vbp_immunity FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// verify that they are not trying to use this action on themself
	if ($touser['userid'] == $vbulletin->userinfo['userid'])
	{
		// display error, can not do this action to yourself
		eval(standard_error(fetch_error('vbplaza_can_not_do_this_action_to_yourself')));
	}

	// check to see if this user is protected
	$protectedusergroups = explode(",", $vbulletin->options['vbplaza_protectedusergroups']);
	if (is_member_of($touser, $protectedusergroups))
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// check if this user is immune to this operation
	if ($touser['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['changereputation'])
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// verify that the user has enough points to steal from
	if (!is_numeric($action['vbplaza_stealreputationamount']) || ($touser['reputation'] < $action['vbplaza_stealreputationamount']))
	{
		// display error, user does not have enough reputation
		eval(standard_error(fetch_error('vbplaza_user_does_not_have_enough_reputation')));
	}

	// setup the $extrafields
	$extrafields = array();
	$extrafields[] = "reputation = reputation - " . $action['vbplaza_stealreputationamount'];

	// update this purchase with the user specified
	unset($action['touserid']);
	unset($action['tousername']);
	$action['fromuserid'] = $vbulletin->userinfo['userid'];
	$action['fromusername'] = $vbulletin->userinfo['username'];
	$action['nopointschange'] = true;
	vbplaza_user_purchase_update($touser, $action, $extrafields, true);

	// give the user the reputation
	$extrafields = array();
	$extrafields[] = "reputation = reputation + " . $action['vbplaza_stealreputationamount'];

	// update this purchase with the user
	$action['touserid'] = $touser['userid'];
	$action['tousername'] = $touser['username'];
	unset($action['fromuserid']);
	unset($action['fromusername']);
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_stolen_reputation_from'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>. " . $vbphrase['vbplaza_changed_to'] . " ". $newusertitle . ".";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_stealothersreputation_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>