<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// build the $extra_fields
	$action['nowrap'] = true;
	$action = vbplaza_build_inputfields($action);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeusertitle_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeusertitle_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// get the newusertitle
	$newusertitle = stripslashes($action['usertitle']);

	// verify that they have entered a user title to change to
	if (empty($newusertitle))
	{
		// display error, no user title entered
		eval(standard_error(fetch_error('vbplaza_user_title_not_entered')));
	}

	// verify the newusertitle does not have any HTML code in it
	if (strchr($newusertitle, '<'))
	{
		// display error, new username is too short
		eval(standard_error(fetch_error('vbplaza_html_not_allowed')));
	}

	// check if bbcode is allowed
	if ($action['vbplaza_usertitle_allow_bbcode'])
	{
		// parse any bbcode first
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
		$newusertitle = $bbcode_parser->parse($newusertitle, 'nonforum');
	}

	// strip out the html to check out the actual user title
	$newusertitle_stripped = $vbulletin->input->clean($newusertitle, TYPE_NOHTML);

	// verify the actual text is proper
	if (strlen($newusertitle_stripped) < $vbulletin->options['minuserlength'])
	{
		// display error, new usertitle is too short
		eval(standard_error(fetch_error('vbplaza_usertitle_too_short')));
	}
	if (strlen($newusertitle_stripped) > $vbulletin->options['ctMaxChars'])
	{
		// display error, new usertitle is too long
		eval(standard_error(fetch_error('vbplaza_usertitle_too_long')));
	}
	if ($newusertitle_stripped != fetch_censored_text($newusertitle_stripped))
	{
		// display error, new usertitle uses censored word
		eval(standard_error(fetch_error('vbplaza_usertitle_censored')));
	}
	if (!empty($vbulletin->options['illegalusernames']))
	{
		// get the array of illegal usernames
		$usernames = preg_split('/\s+/', $vbulletin->options['illegalusernames'], -1, PREG_SPLIT_NO_EMPTY);

		// process each username
		foreach ($usernames AS $name)
		{
			// check if its contained
			if (strpos(strtolower($newusertitle_stripped), strtolower($name)) !== false)
			{
				// display error, new username contains illegal word/phrase
				eval(standard_error(fetch_error('vbplaza_username_illegal')));
			}
		}
	}

	// give the user the title change
	$extrafields = array();
	$extrafields[] = "customtitle = 1";
	$extrafields[] = "usertitle = '" . $vbulletin->db->escape_string($newusertitle) . "'";

	// update this purchase with the user
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_changed_to'] . " ". $newusertitle . ".";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeusertitle_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>