<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// set it to show the section header
$show['customheader'] = true;
$action['customheader'] = construct_phrase($vbphrase['vbplaza_welcome_to_bank'], $vbphrase['vbbux_name']);

// show deposit/withdraw
$show['bankoptions'] = true;

// do not show the cost of the item
unset($action['cost']);

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// there are no $extra_fields
	$extra_fields = '';

	// build some extra fields to display
	$action['interestrate'] = vb_number_format($vbulletin->options['vbbux_bankinterestpercent'], $vbulletin->options['vbbux_decimalplaces']);
	if ($vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']] > 0)
	{
		// start building the time left variables
		$action['timeleft'] = intval($vbulletin->userinfo['vbp_nextbankinterest'] - TIMENOW);
		$action['days'] = intval($action['timeleft'] / 86400);
		$action['timeleft'] -= intval($action['days'] * 86400);
		$action['hours'] = intval($action['timeleft'] / 3600);
		$action['timeleft'] -= intval($action['hours'] * 3600);
		$action['minutes'] = intval($action['timeleft'] / 60);
		$action['timeleft'] -= intval($action['minutes'] * 60);
		$action['seconds'] = $action['timeleft'];

		// set the amount the next interest payment will be
		$interestamt = ($vbulletin->options['vbbux_bankinterestpercent'] / 100) + 0.0;
		$action['amount'] = $vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']] *  $interestamt;
		$action['amount'] = vb_number_format($action['amount'], $vbulletin->options['vbbux_decimalplaces']);

		// build the proper next interest time
		$action['nextinterest'] = construct_phrase($vbphrase['vbplaza_next_bank_interest_time_left'], $action['days'], $action['hours'], $action['minutes'], $action['seconds'], $action['amount'], $vbphrase['vbbux_points']);
	}
	else
	{
		// set the nextinterest to no points in the bank yet
		$action['nextinterest'] = construct_phrase($vbphrase['vbplaza_no_points_in_bank_yet'], $vbphrase['vbbux_name'], $vbphrase['vbbux_bank']);
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_action_bank_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_bank_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_bank_process_start')) ? eval($hook) : false;

	// strip out all comma's
	$action['amount'] = str_replace(",", "", $action['amount']);

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// check if its depositing or withdrawing
	if (is_numeric($action['depositamount']))
	{
		// setup the amount
		$action['amount'] = $action['depositamount'];
	}
	else if (is_numeric($action['withdrawamount']))
	{
		// setup the amount
		$action['amount'] = $action['withdrawamount'];
	}

	// verify the amount to transfer is positive
	if (!is_numeric($action['amount']) || ($action['amount'] < 0))
	{
		// display error, invalid transfer amount
		eval(standard_error(fetch_error('vbplaza_invalid_transfer_amount')));
	}

	// check if the amount is very very close to the pointsfields
	if ($action['amount'] == round($vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']], 2))
	{
		// force the amount to be the exact same
		$action['amount'] = $vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']];
	}

	// check if its withdrawing
	if ($_REQUEST['purchase'] == $vbphrase['vbplaza_withdraw'])
	{
		// verify the bank has this much first
		if (!$action['amount'] || !is_numeric($action['amount']) || ($action['amount'] > $vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']]))
		{
			// display error, not enough points in the bank
			eval(standard_error(fetch_error('vbplaza_not_enough_points_in_bank')));
		}

		// check if it should reset the vbp_nextbankinterest to 0
		$extrafields = array();
		if (($vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']] - $action['amount']) == 0)
		{
			// set the $bankintereststr to the proper query
			$extrafields[] = "vbp_nextbankinterest = 0";
		}

		// add the points change to the bankfield now
		$extrafields[] = "`" . $vbulletin->options['vbbux_bankfield'] . "` = `" . $vbulletin->options['vbbux_bankfield'] . "` - " . $action['amount'];

		// update this purchase with the user specified
		$action['removal'] = false;
		$action['touserid'] = $vbulletin->userinfo['userid'];
		$action['tousername'] = $vbulletin->userinfo['username'];
		$action['finalcost'] = $action['amount'];
		vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields, true);

		// update the current bank amount (current points already handled)
		$vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']] -= $action['amount'];

		// set the history log that it was a withdraw
		$action['extrainfo'] = $vbphrase['vbplaza_withdraw'];
	}
	else
	{
		// verify the user has this much first
		if (!$action['amount'] || !is_numeric($action['amount']) || ($action['amount'] > $vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']]))
		{
			// display error, not enough points on hand
			eval(standard_error(fetch_error('vbplaza_not_enough_points')));
		}

		// check if it should reset the vbp_nextbankinterest to 0
		$extrafields = array();
		if (($vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']] - $action['amount']) == 0)
		{
			// set the $bankintereststr to the proper query
			$extrafields[] = "vbp_nextbankinterest = " . (TIMENOW + $vbulletin->options['vbbux_bankinterestinterval']);
		}

		// add the points change to the bankfield now
		$extrafields[] = "`" . $vbulletin->options['vbbux_bankfield'] . "` = `" . $vbulletin->options['vbbux_bankfield'] . "` + " . $action['amount'];

		// update this purchase with the user specified
		$action['removal'] = true;
		$action['touserid'] = $vbulletin->userinfo['userid'];
		$action['tousername'] = $vbulletin->userinfo['username'];
		$action['finalcost'] = $action['amount'];
		vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields, true);

		// update the current bank amount (current points already handled)
		$vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']] += $action['amount'];

		// set the history log that it was a deposit
		$action['extrainfo'] = $vbphrase['vbplaza_deposit'];
	}

	// update the quantity/sold
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_bank_process_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>