<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// check if the user already has this option
if (($_REQUEST['step'] < '11') && ($vbulletin->userinfo['vbp_arcadepass'] != 0))
{
	// set it to jump to the remove option
	$_REQUEST['step'] = '11';
	$nextstep = $_REQUEST['step'] + 1;
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// there are no $extra_fields
	$extra_fields = '';

	($hook = vBulletinHook::fetch_hook('vbplaza_action_arcadepass_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_arcadepass_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// give the user the title change
	$extrafields = array();
	$extrafields[] = "vbp_arcadepass = " . (TIMENOW + ($action['expirydate'] * 86400));

	// update this purchase with the user
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// update the quantity/sold
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_arcadepass_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}

// process step '11' (remove purchase step)
if ($_REQUEST['step'] == '11')
{
	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_remove'] . " " . $action['name'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_arcadepass_removal_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_removal') . '";');
}

// process step '12' (perform actual remove)
if ($_REQUEST['step'] == '12')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_arcadepass_removal_start')) ? eval($hook) : false;

	// update this purchase with the user
	$extrafields = array();
	$extrafields[] = "vbp_arcadepass = 0";
	$action['removal'] = true;
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_remove'] . " " . $action['name'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_arcadepass_removal_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_removed') . '";');
}
?>