<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if ($vbulletin->options['vbplaza_enabled'] == 1)
	{
		// read the user gifts to display for 'showthread'
		if (THIS_SCRIPT == 'member')
		{
			// get all of the gifts for this user from the database
			if ($gifts = $vbulletin->db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "vbplaza_gift
				WHERE touserid = '" . $userinfo['userid'] . "'
				ORDER BY giftid DESC
			"))
			{
				// start the gifts table
				$userinfo['gifts'] = '';

				// process each gift as a row
				$show['candelete'] = false;
				while ($gift = $vbulletin->db->fetch_array($gifts))
				{
					// check if this member is allowed to delete all gifts
					$candeletethis = false;
					if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteanygifts'])
					{
						// set that it can delete
						$show['candelete'] = true;
						$candeletethis = true;
					}
					else if ($gift['touserid'] == $vbulletin->userinfo['userid'])
					{
						// check if this member is allowed to delete their own gifts
						if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteowngifts'])
						{
							// set that it can delete
							$show['candelete'] = true;
							$candeletethis = true;
						}
					}

					// check if this gift is $visible
					if (($gift['visible'] == 1) || (($gift['visible'] == 0) && ($gift['touserid'] == $vbulletin->userinfo['userid'])))
					{
						// set it to show the gifts
						$show['gifts'] = true;

						// add this gift
						$userinfo['gifts'] .= "<tr><td class=\"alt1\"><img src=\"images/gifts/" . $gift['giftname'] . ".gif\" border=\"0\"></td><td class=\"alt1\">";
						if ($gift['fromuserid'] > 0)
						{
							// add this user with a link to their profile
							$userinfo['gifts'] .= "<a href=\"member.php?u=" . $gift['fromuserid'] . "\">" . $gift['fromusername'] . "</a>";
						}
						$userinfo['gifts'] .= "</td><td class=\"alt1\">" . $gift['message'] . "</td>";
						if ($gift['visible'] == 1)
						{
							// add the visible image
							$userinfo['gifts'] .= "<td class=\"alt1\">";
							if ($gift['touserid'] == $vbulletin->userinfo['userid'])
							{
								// add the gift with the option to hide it
								$userinfo['gifts'] .= "<a href=\"vbplaza.php?$session[sessionurl]do=hidegift&amp;giftid=$gift[giftid]\"><img src=\"images/misc/visible.gif\" border=\"0\"></a>";
							}
							else
							{
								// just add the image normally
								$userinfo['gifts'] .= "<img src=\"images/misc/visible.gif\" border=\"0\">";
							}
							$userinfo['gifts'] .= "</td><td class=\"alt1\" align=\"right\">";
						}
						else
						{
							// add the invisible image
							$userinfo['gifts'] .= "<td class=\"alt1\">";
							if ($gift['touserid'] == $vbulletin->userinfo['userid'])
							{
								// add the gift with the option to hide it
								$userinfo['gifts'] .= "<a href=\"vbplaza.php?$session[sessionurl]do=showgift&amp;giftid=$gift[giftid]\"><img src=\"images/misc/invisible.gif\" border=\"0\"></a>";
							}
							else
							{
								// just add the image normally
								$userinfo['gifts'] .= "<img src=\"images/misc/invisible.gif\" border=\"0\">";
							}
							$userinfo['gifts'] .= "</td><td class=\"alt1\" align=\"right\">";
						}
						if ($candeletethis)
						{
							// add the delete link
							$userinfo['gifts'] .= "<a href=\"vbplaza.php?$session[sessionurl]do=removegift&amp;giftid=$gift[giftid]\"><img src=\"images/misc/delete.gif\" border=\"0\"></a>";
						}
						$userinfo['gifts'] .= "</td></tr>\n";
					}
				}

				// check if it has found any gifts
				if ($show['gifts'] == true)
				{
					// build the template for the gifts info
					eval('$show[\'gifts\'] = "' . fetch_template('vbplaza_member_gifts_info') . '";');
				}
			}

			// free the gifts
			$vbulletin->db->free_result($gifts);

			// get all of the ribbons for this user from the database
			if ($ribbons = $vbulletin->db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon
				WHERE touserid = '" . $userinfo['userid'] . "'
				ORDER BY ribbonid DESC
			"))
			{
				// start the ribbons table
				$userinfo['ribbons'] = '';

				// process each ribbon as a row
				$show['candelete'] = false;
				while ($ribbon = $vbulletin->db->fetch_array($ribbons))
				{
					// check if this member is allowed to delete all ribbons
					$candeletethis = false;
					if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteanyribbons'])
					{
						// set that it can delete
						$show['candelete'] = true;
						$candeletethis = true;
					}
					else if ($ribbon['touserid'] == $vbulletin->userinfo['userid'])
					{
						// check if this member is allowed to delete their own ribbons
						if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteownribbons'])
						{
							// set that it can delete
							$show['candelete'] = true;
							$candeletethis = true;
						}
					}

					// check if this ribbon is $visible
					if (($ribbon['visible'] == 1) || (($ribbon['visible'] == 0) && ($ribbon['touserid'] == $vbulletin->userinfo['userid'])))
					{
						// set it to show the ribbons
						$show['ribbons'] = true;

						// add this ribbon
						$userinfo['ribbons'] .= "<tr><td class=\"alt1\"><img src=\"images/ribbons/" . $ribbon['ribbonname'] . ".gif\" border=\"0\"></td><td class=\"alt1\">";
						if ($ribbon['fromuserid'] > 0)
						{
							// add this user with a link to their profile
							$userinfo['ribbons'] .= "<a href=\"member.php?u=" . $ribbon['fromuserid'] . "\">" . $ribbon['fromusername'] . "</a>";
						}
						$userinfo['ribbons'] .= "</td><td class=\"alt1\">" . $ribbon['cause'] . "<br />(" . $vbphrase['vbplaza_message'] . ": " . $ribbon['message'] . ")</td>";
						if ($ribbon['visible'] == 1)
						{
							// add the visible image
							$userinfo['ribbons'] .= "<td class=\"alt1\">";
							if ($ribbon['touserid'] == $vbulletin->userinfo['userid'])
							{
								// add the ribbon with the option to hide it
								$userinfo['ribbons'] .= "<a href=\"vbplaza.php?$session[sessionurl]do=hideribbon&amp;ribbonid=$ribbon[ribbonid]\"><img src=\"images/misc/visible.gif\" border=\"0\"></a>";
							}
							else
							{
								// just add the image normally
								$userinfo['ribbons'] .= "<img src=\"images/misc/visible.gif\" border=\"0\">";
							}
							$userinfo['ribbons'] .= "</td><td class=\"alt1\" align=\"right\">";
						}
						else
						{
							// add the invisible image
							$userinfo['ribbons'] .= "<td class=\"alt1\">";
							if ($ribbon['touserid'] == $vbulletin->userinfo['userid'])
							{
								// add the ribbon with the option to hide it
								$userinfo['ribbons'] .= "<a href=\"vbplaza.php?$session[sessionurl]do=showribbon&amp;ribbonid=$ribbon[ribbonid]\"><img src=\"images/misc/invisible.gif\" border=\"0\"></a>";
							}
							else
							{
								// just add the image normally
								$userinfo['ribbons'] .= "<img src=\"images/misc/invisible.gif\" border=\"0\">";
							}
							$userinfo['ribbons'] .= "</td><td class=\"alt1\" align=\"right\">";
						}
						if ($candeletethis)
						{
							// add the delete link
							$userinfo['ribbons'] .= "<a href=\"vbplaza.php?$session[sessionurl]do=removeribbon&amp;ribbonid=$ribbon[ribbonid]\"><img src=\"images/misc/delete.gif\" border=\"0\"></a>";
						}
						$userinfo['ribbons'] .= "</td></tr>\n";
					}
				}

				// check if it has found any ribbons
				if ($show['ribbons'] == true)
				{
					// build the template for the ribbons info
					eval('$show[\'ribbons\'] = "' . fetch_template('vbplaza_member_ribbons_info') . '";');
				}
			}

			// free the ribbons
			$vbulletin->db->free_result($ribbons);
		}
		else if (is_numeric($userinfo['userid']))
		{
			// check if this user has any gifts
			if (!empty($userinfo['vbp_gifts'])
				&& !($vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['hidegiftsinposts']))
			{
				// unserialize the gifts
				$gifts = unserialize($userinfo['vbp_gifts']);

				// verify that gifts is an array
				$userinfo['giftsdisplay'] = '';
				if (is_array($gifts))
				{
					// set it to show the gifts
					$show['gifts'] = true;

					// process each gift
					$displayed = 0;	
					foreach($gifts AS $gift)
					{
						// check if this has reached the max amount of displayed gifts
						if ($displayed > $vbulletin->options['vbplaza_maxgiftsdisplayed'])
						{
							// break out of this for loop
							break;
						}

						// check for a line break
						if (($displayed > 0) && (($displayed % $vbulletin->options['vbplaza_maxgiftsperrow']) == 0))
						{
							// add in a carriage return
							$userinfo['giftsdisplay'] .= "<br />";
						}

						// remove any " if they are found
						$gift['message'] = str_replace("\"", "", $gift['message']);

						// add this gift
						$userinfo['giftsdisplay'] .= "<a href=\"vbplaza.php?$session[sessionurl]do=givegift&amp;userid=" . $userinfo['userid'] . "\"><img src=\"images/gifts/" . $gift['giftname'] . ".gif\" title=\"" . $gift['message'] . " - " . $gift['username'] . "\" border=\"0\"></a> ";

						// increase $displayed
						$displayed++;
					}
				}
			}

			// check if this user has any ribbons
			if (!empty($userinfo['vbp_ribbons'])
				&& !($vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['hideribbonsinposts']))
			{
				// unserialize the ribbons
				$ribbons = unserialize($userinfo['vbp_ribbons']);

				// verify that ribbons is an array
				$userinfo['ribbonsdisplay'] = '';
				if (is_array($ribbons))
				{
					// set it to show the ribbons
					$show['ribbons'] = true;

					// process each ribbon
					$displayed = 0;	
					foreach($ribbons AS $ribbon)
					{
						// check if this has reached the max amount of displayed ribbons
						if ($displayed > $vbulletin->options['vbplaza_maxribbonsdisplayed'])
						{
							// break out of this for loop
							break;
						}

						// check for a line break
						if (($displayed > 0) && (($displayed % $vbulletin->options['vbplaza_maxribbonsperrow']) == 0))
						{
							// add in a carriage return
							$userinfo['ribbonsdisplay'] .= "<br />";
						}

						// remove any " if they are found
						$ribbon['cause'] = str_replace("\"", "", $ribbon['cause']);

						// add this ribbon
						$userinfo['ribbonsdisplay'] .= "<a href=\"vbplaza.php?$session[sessionurl]do=giveribbon&amp;userid=" . $userinfo['userid'] . "\"><img src=\"images/ribbons/" . $ribbon['ribbonname'] . ".gif\" title=\"" . $ribbon['cause'] . " - " . $ribbon['username'] . "\" border=\"0\"></a> ";

						// increase $displayed
						$displayed++;
					}
				}
			}
		}
	}
}
?>