<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if ($this->registry->options['vbplaza_enabled'] == 1)
	{
		// add the points to the userinfo
		$post['points'] = vb_number_format($post[$this->registry->options['vbbux_pointsfield']], $this->registry->options['vbbux_decimalplaces']);
		$post['bank'] = vb_number_format($post[$this->registry->options['vbbux_bankfield']], $this->registry->options['vbbux_decimalplaces']);
		$post['totalpoints'] = vb_number_format($post[$this->registry->options['vbbux_pointsfield']] + $post[$this->registry->options['vbbux_bankfield']], $this->registry->options['vbbux_decimalplaces']);

		// clear out some variables
		$filtername = $filtertitle = '';
		unset($post['namestyle']);
		unset($post['titlestyle']);

		// check if it should show username changes for this user
		if (!($this->registry->userinfo['vbp_vbplazaoptions'] & $this->registry->bf_misc_vbpvbplazaoptions['hideusernamechangesinposts']))
		{
			// start building the $filtername
			if (!empty($post['vbp_nameglowcolor']))
			{
				// add the glow filter
				$filtername .= "glow(Color=" . $post['vbp_nameglowcolor'] . ",Strength=" . $this->registry->options['vbplaza_glowstrengthvalue'] . ")";
			}

			// check if the user has a shadowed username
			if (!empty($post['vbp_nameshadowcolor']))
			{
				// add the shadow filter
				$filtername .= "shadow(Color=" . $post['vbp_nameshadowcolor'] . ",Strength=" . $this->registry->options['vbplaza_shadowstrengthvalue'] . ")";
			}

			// if there's a filter, add it to the $post['namestyle']
			if (!empty($filtername))
			{
				// add the filters
				$post['namestyle'] .= "filter:" . $filtername . "; width: 100%;";
			}

			// check if the user has a bold username
			if ($post['vbp_displayflags'] & $this->registry->bf_misc_vbpdisplayflags['boldusername'])
			{
				// add the boldness
				$post['namestyle'] .= "font-weight:bold;";
			}

			// check if the user has an italic username
			if ($post['vbp_displayflags'] & $this->registry->bf_misc_vbpdisplayflags['italicusername'])
			{
				// add the italics
				$post['namestyle'] .= "font-style:italic;";
			}

			// check if username font type was purchased
			if (!empty($post['vbp_namefonttype']))
			{
				// add the font type
				$post['namestyle'] .= "font-family:" . $post['vbp_namefonttype'] . ";";
			}

			// check if the user has a colored username
			if (!empty($post['vbp_nametextcolor']))
			{
				// check if it needs to remove the username HTML markup
				if ($this->registry->options['vbplaza_usernamehtmlmarkup'])
				{
					// strip all tags from $post['musername']
					$post['musername'] = strip_tags($post['musername'], '<img>');
				}

				// update the musername
				$post['musername'] = "<font color=\"" . $post['vbp_nametextcolor'] . "\">" . $post['musername'] . "</font>";
			}

			// check if the user has an underlined username
			if ($post['vbp_displayflags'] & $this->registry->bf_misc_vbpdisplayflags['underlinedusername'])
			{
				// update the musername
				$post['musername'] = "<u>" . $post['musername'] . "</u>";
			}
		}

		// check if it should show user title changes for this user
		if (!($this->registry->userinfo['vbp_vbplazaoptions'] & $this->registry->bf_misc_vbpvbplazaoptions['hideusertitlechangesinposts']))
		{
			// start building the $filtertitle
			if (!empty($post['vbp_titleglowcolor']))
			{
				// add the glow filter
				$filtertitle .= "glow(Color=" . $post['vbp_titleglowcolor'] . ",Strength=" . $this->registry->options['vbplaza_glowstrengthvalue'] . ")";
			}

			// check if the user has a shadowed username
			if (!empty($post['vbp_titleshadowcolor']))
			{
				// add the shadow filter
				$filtertitle .= "shadow(Color=" . $post['vbp_titleshadowcolor'] . ",Strength=" . $this->registry->options['vbplaza_shadowstrengthvalue'] . ")";
			}

			// if there's a filter, add it to the $post['namestyle']
			if (!empty($filtertitle))
			{
				// add the filters
				$post['titlestyle'] .= "filter:" . $filtertitle . "; width: 100%;";
			}

			// check if bold user title was purchased
			if ($post['vbp_displayflags'] & $this->registry->bf_misc_vbpdisplayflags['boldusertitle'])
			{
				// add the boldness
				$post['titlestyle'] .= "font-weight:bold;";
			}

			// check if italics user title was purchased
			if ($post['vbp_displayflags'] & $this->registry->bf_misc_vbpdisplayflags['italicusertitle'])
			{
				// add the italics
				$post['titlestyle'] .= "font-style:italic;";
			}

			// check if user title font type was purchased
			if (!empty($post['vbp_titlefonttype']))
			{
				// add the font type
				$post['titlestyle'] .= "font-family:" . $post['vbp_titlefonttype'] . ";";
			}

			// check if underline user title was purchased
			if ($post['vbp_displayflags'] & $this->registry->bf_misc_vbpdisplayflags['underlinedusertitle'])
			{
				// add the underline
				$post['titlestyle'] .= "text-decoration:underline;";
			}

			// check if the user title font color was purchased
			if (!empty($post['vbp_titletextcolor']))
			{
				// add the color
				$post['titlestyle'] .= "color:" . $post['vbp_titletextcolor'] . ";";
			}
		}
	}
}
?>