<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if ($vbulletin->options['vbbux_enabled'] == 1)
	{
		// verify that this setting is enabled
		if (($vbulletin->options['vbbux_pointsforattachments']) && ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canchargefordownloads']))
		{
			// clean some variables
			$vbulletin->input->clean_array_gpc('r', array(
				'imagecost' => TYPE_UINT,
				'imagecosturl' => TYPE_UINT,
			));

			// check that there are some attachments
			if (!empty($vbulletin->GPC['attachment']['name']) && is_array($vbulletin->GPC['attachment']['name']))
			{
				// check all of the uploaded files
				foreach ($vbulletin->GPC['attachment']['name'] AS $key => $attachname)
				{
					// get the file size
					$attachsize = $vbulletin->GPC['attachment']['size']['0'];

					// now update the cost if there is one
					if (is_numeric($vbulletin->GPC['imagecost']) && ($vbulletin->GPC['imagecost'] != 0))
					{
						// send off the query to update the cost of this image
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . "attachment
							SET
								imagecost = '" . $vbulletin->GPC['imagecost'] . "'
							WHERE posthash = '" . $vbulletin->GPC['posthash'] . "' AND filesize = '" . $attachsize . "' AND filename = '" . $vbulletin->db->escape_string($attachname) . "'
						");
					}
				}
			}

			// check that there are some attachments via url
			if (!empty($vbulletin->GPC['attachmenturl']) && is_array($vbulletin->GPC['attachmenturl']))
			{
				// check all of the uploaded files via url
				foreach ($vbulletin->GPC['attachmenturl'] AS $key => $attachlink)
				{
					// find the last '/' in the link
					$pos = strrpos($attachlink, '/') + 1;

					// build the proper filename in the database
					$attachname = substr($attachlink, $pos, strlen($attachlink) - $pos);

					// now update the cost if there is one
					if (is_numeric($vbulletin->GPC['imagecosturl']) && ($vbulletin->GPC['imagecosturl'] != 0))
					{
						// send off the query to update the cost of this image
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . "attachment
							SET
								imagecost = '" . $vbulletin->GPC['imagecosturl'] . "'
							WHERE posthash = '" . $vbulletin->GPC['posthash'] . "' AND filename = '" . $vbulletin->db->escape_string($attachname) . "'
						");
					}
				}
			}
		}
	}
}
?>