<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if ($vbulletin->options['vbbux_enabled'] == 1)
	{
		// check if points per profile view are enabled
		if ($vbulletin->options['vbbux_perprofileview'] != 0)
		{
			// dont award points for viewing your own profile
			if ($vbulletin->userinfo['userid'] != $userinfo['userid'])
			{
				// verify that there is some points to add
				if ($vbulletin->options['vbbux_perprofileview'] != 0)
				{
					// set the amount of points to give
					$givepoints = $vbulletin->options['vbbux_perprofileview'];

					// only verify this check if the $givepoints is negative
					if ($givepoints < 0)
					{
						// verify they have enough points to do this action
						if (($userinfo[$vbulletin->options['vbbux_pointsfield']] + $givepoints) < 0)
						{
							// display error, not enough points
							eval(standard_error(fetch_error('vbplaza_not_enough_points')));
						}
					}

					// add the points so its current when it gets displayed
					$userinfo[$vbulletin->options['vbbux_pointsfield']] += $givepoints;

					// send the query to give the points
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
						SET
							`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` + " . $givepoints . "
						WHERE userid = '" . $userinfo['userid'] . "'
							AND vbp_receivespoints = '1'
					");
				}
			}
		}

		// build the variables used for the templates
		$userinfo['points'] = vb_number_format($userinfo[$vbulletin->options['vbbux_pointsfield']], $vbulletin->options['vbbux_decimalplaces']);
		$userinfo['bank'] = vb_number_format($userinfo[$vbulletin->options['vbbux_bankfield']], $vbulletin->options['vbbux_decimalplaces']);
		$userinfo['totalpoints'] = vb_number_format($userinfo[$vbulletin->options['vbbux_pointsfield']] + $userinfo[$vbulletin->options['vbbux_bankfield']], $vbulletin->options['vbbux_decimalplaces']);

		// build the template for the vbbux member info
		eval('$show[\'vbbuxuserinfo\'] = "' . fetch_template('vbplaza_member_vbbux_info') . '";');
	}

	// check if the vbplaza is enabled
	if ($vbulletin->options['vbplaza_enabled'] == 1)
	{
		// clear out some variables
		$filtername = $filtertitle = '';
		unset($userinfo['namestyle']);
		unset($userinfo['titlestyle']);

		// start building the $filtername
		if (!empty($userinfo['vbp_nameglowcolor']))
		{
			// add the glow filter
			$filtername .= "glow(Color=" . $userinfo['vbp_nameglowcolor'] . ",Strength=" . $vbulletin->options['vbplaza_glowstrengthvalue'] . ")";
		}

		// check if the user has a shadowed username
		if (!empty($userinfo['vbp_nameshadowcolor']))
		{
			// add the shadow filter
			$filtername .= "shadow(Color=" . $userinfo['vbp_nameshadowcolor'] . ",Strength=" . $vbulletin->options['vbplaza_shadowstrengthvalue'] . ")";
		}

		// if there's a filter, add it to the $userinfo['namestyle']
		if (!empty($filtername))
		{
			// add the filters
			$userinfo['namestyle'] .= "filter:" . $filtername . "; width: 100%;";
		}

		// check if the user has a bold username
		if ($userinfo['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['boldusername'])
		{
			// add the boldness
			$userinfo['namestyle'] .= "font-weight:bold;";
		}

		// check if the user has an italic username
		if ($userinfo['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['italicusername'])
		{
			// add the italics
			$userinfo['namestyle'] .= "font-style:italic;";
		}

		// check if username font type was purchased
		if (!empty($userinfo['vbp_namefonttype']))
		{
			// add the font type
			$userinfo['namestyle'] .= "font-family:" . $userinfo['vbp_namefonttype'] . ";";
		}

		// check if the user has an underlined username
		if ($userinfo['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['underlinedusername'])
		{
			// add the underline
			$userinfo['namestyle'] .= "text-decoration:underline;";
		}

		// check if the user has a colored username
		if (!empty($userinfo['vbp_nametextcolor']))
		{
			// check if it needs to remove the username HTML markup
			if ($vbulletin->options['vbplaza_usernamehtmlmarkup'])
			{
				// strip all tags from $userinfo['musername']
				$userinfo['musername'] = strip_tags($userinfo['musername'], '<img>');
			}

			// update the musername
			$userinfo['namestyle'] .= "color:" . $userinfo['vbp_nametextcolor'] . ";";
		}

		// start building the $filtertitle
		if (!empty($userinfo['vbp_titleglowcolor']))
		{
			// add the glow filter
			$filtertitle .= "glow(Color=" . $userinfo['vbp_titleglowcolor'] . ",Strength=" . $vbulletin->options['vbplaza_glowstrengthvalue'] . ")";
		}

		// check if the user has a shadowed username
		if (!empty($userinfo['vbp_titleshadowcolor']))
		{
			// add the shadow filter
			$filtertitle .= "shadow(Color=" . $userinfo['vbp_titleshadowcolor'] . ",Strength=" . $vbulletin->options['vbplaza_shadowstrengthvalue'] . ")";
		}

		// if there's a filter, add it to the $userinfo['namestyle']
		if (!empty($filtertitle))
		{
			// add the filters
			$userinfo['titlestyle'] .= "filter:" . $filtertitle . "; width: 100%;";
		}
		// check if bold user title was purchased
		if ($userinfo['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['boldusertitle'])
		{
			// add the boldness
			$userinfo['titlestyle'] .= "font-weight:bold;";
		}

		// check if italics user title was purchased
		if ($userinfo['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['italicusertitle'])
		{
			// add the italics
			$userinfo['titlestyle'] .= "font-style:italic;";
		}

		// check if user title font type was purchased
		if (!empty($userinfo['vbp_titlefonttype']))
		{
			// add the font type
			$userinfo['titlestyle'] .= "font-family:" . $userinfo['vbp_titlefonttype'] . ";";
		}

		// check if underline user title was purchased
		if ($userinfo['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['underlinedusertitle'])
		{
			// add the underline
			$userinfo['titlestyle'] .= "text-decoration:underline;";
		}

		// check if the user title font color was purchased
		if (!empty($userinfo['vbp_titletextcolor']))
		{
			// add the color
			$userinfo['titlestyle'] .= "color:" . $userinfo['vbp_titletextcolor'] . ";";
		}

		// check if they are allowed to view user history
		if (($vbulletin->userinfo['userid'] == $userinfo['userid']) || ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canviewotheruserhistory']))
		{
			// set it to $show['userhistory']
			$show['userhistory'] = true;
		}

		// check if they are allowed to view name changes
		if (($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canviewnamechanges'])
			|| ($vbulletin->userinfo['userid'] == $userinfo['userid']))
		{
			// set it to $show['namechanges']
			$show['namechanges'] = true;
		}
	}
}
?>