<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbplaza');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('vbplaza', 'forum', 'cpuser', 'cpoption');
$specialtemplates = array('vbplazacategory', 'vbplazaoptions');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_vbplaza.php');
require_once(DIR . '/includes/adminfunctions_template.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// check if the admin requires super administrator access for 'modcp'
// NOTE: To enable this enter the below line into your config.php
// $config['vbPlaza']['modcp']['requiresuperadmin'] = true;
if ($vbulletin->config['vbPlaza']['modcp']['requiresuperadmin'])
{
	// check if the user is a super administrator
	$userids = explode(',', str_replace(' ', '', $vbulletin->config['SpecialUsers']['superadministrators']));
	if (!in_array($vbulletin->userinfo['userid'], $userids))
	{
		print_stop_message('vbplaza_no_permission_admin_vbplaza');
	}
}

// check that moderators are allowed to use these
if ($vbulletin->options['vbplaza_modcpenabled'] == 0)
{
	// display the header
	print_cp_header('vbPlaza v' . $vbulletin->options['vbplaza_version'] . ' Moderator');

	// display message that these functions are disabled
	print_form_header('vbplaza', 'vbplazadisabled');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_disabled_by_administrator'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_disabled_by_administrator_message']);
	print_table_footer(2, "");

	// display the footer
	print_cp_footer();
	exit;
}

// cache the vbplazaoptions
unset($vbplazaoptions);
if ($items = $db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "vbplaza_item
	WHERE category != '11'
	ORDER BY displayorder
"))
{
	// start processing the items
	while ($item = $db->fetch_array($items))
	{
		// cache this item
		$vbplazaoptions[$item[itemid]] = $item;
	}
}

// free the items
$vbulletin->db->free_result($items);

// display the header
print_cp_header('vbPlaza v' . $vbulletin->options['vbplaza_version'] . ' Moderator');

// check if an action is set
if (!isset($_REQUEST['do']))
{
	// force it to list the items
	$_REQUEST['do'] = 'optionlist';
}

// update the category settings
if ($_POST['do'] == 'updatecategory')
{
	// check if its deleting an option
	if (isset($_POST['delete']))
	{
		// get the category name
		$category = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category WHERE categoryid = '" . $_POST['categoryid'] . "'");

		// verify they want to delete the category
		if (!isset($_POST['verify']))
		{
			// display message to verify that you want to delete this category
			print_form_header('vbplaza', 'updatecategory');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_delete_category_warning'] . " - " . $category['name'] . "</font>", 2);
			print_description_row($vbphrase['vbplaza_delete_category_warning_message']);
			construct_hidden_code('verify', '1');
			construct_hidden_code('categoryid', $_POST['categoryid']);
			print_table_footer(2, "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_category']) . "\" accesskey=\"s\" />");
		}
		else
		{
			// verify the category is deletable
			if (is_numeric($_POST['categoryid']) && ($_REQUEST['categoryid'] >= 101))
			{
				// delete this category from the vbplaza_category table
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_category WHERE categoryid = '" . $_POST['categoryid'] . "'");
			}

			// update the datastore
			vbplaza_update_datastore(true);

			// do the redirect now
			define('CP_REDIRECT', 'vbplaza.php?do=categorylist');
			print_stop_message('saved_settings_successfully');
		}
	}
	else
	{
		// update the category's settings
		if (is_numeric($_POST['categoryid']) && is_array($_POST['category']))
		{
			// build the querystr
			$querstr = '';
			foreach($_POST['category'] AS $key => $field)
			{
				// check if it should add a comma
				if (isset($querystr)) { $querystr .= ", "; }

				// check if this key is the allowed/denied groups are found
				if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
				{
					// dont allow them to update these fields
					continue;
				}

				// add this field
				$querystr .= "$key = '" . addslashes($field) . "'";
			}

			// if there is a querystr, run it
			if (isset($querystr))
			{
				// send the query to update
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_category
					SET
						" . $querystr . "
					WHERE categoryid = '" . $_POST['categoryid'] . "'
				");
			}
		}

		// update the datastore
		vbplaza_update_datastore(true);

		// do the redirect now
		define('CP_REDIRECT', 'vbplaza.php?do=categorylist');
		print_stop_message('saved_settings_successfully');
	}
}

// update the settings
if ($_POST['do'] == 'updateoption')
{
	// check if its deleting an option
	if (isset($_POST['delete']))
	{
		// verify they want to delete the option
		if (!isset($_POST['verify']))
		{
			// display message to verify that you want to delete this option
			print_form_header('vbplaza', 'updateoption');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_delete_option_warning'] . " - " . $vbplazaoptions[$_POST['itemid']]['name'] . "</font>", 2);
			print_description_row($vbphrase['vbplaza_delete_option_warning_message']);
			construct_hidden_code('verify', '1');
			construct_hidden_code('itemid', $_POST['itemid']);
			print_table_footer(2, "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_option']) . "\" accesskey=\"s\" />");
		}
		else
		{
			// verify the item is deletable
			if (is_numeric($_POST['itemid']) && (($_REQUEST['itemid'] >= 501) || (($_REQUEST['itemid'] >= 71) && ($_REQUEST['itemid'] <= 109))))
			{
				// delete this item from the vbplazaoptions table
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_item WHERE itemid = '" . $_POST['itemid'] . "'");
			}

			// update the datastore
			vbplaza_update_datastore(true);

			// do the redirect now
			define('CP_REDIRECT', 'vbplaza.php?do=optionlist');
			print_stop_message('saved_settings_successfully');
		}
	}
	else
	{
		// update the item's settings
		require_once(DIR . '/includes/functions_misc.php');
		if (is_numeric($_POST['itemid']) && is_array($_POST['item']))
		{
			// build the querystr
			$querstr = '';
			foreach($_POST['item'] AS $key => $field)
			{
				// check if it should add a comma
				if (isset($querystr)) { $querystr .= ", "; }

				// check if this is the inputfields field
				if ($key == 'inputfields')
				{
					// process all inputfields to remove any empty ones
					foreach($_POST['item']['inputfields'] AS $fieldkey => $inputfield)
					{
						// check if the phrasename is valid
						if (empty($inputfield['phrasename']))
						{
							// unset this inputfield
							unset($_POST['item']['inputfields'][$fieldkey]);
						}
					}

					// serialize the inputfields
					$field = serialize($_POST['item']['inputfields']);
				}

				// check if this is the optionsettings field
				if ($key == 'optionsettings')
				{
					// process all optionsettings to remove any empty ones
					foreach($_POST['item']['optionsettings'] AS $fieldkey => $optionsetting)
					{
						// check if the phrasename is valid
						if (!$optionsetting['type'] || empty($optionsetting['varname']))
						{
							// unset this optionsetting
							unset($_POST['item']['optionsettings'][$fieldkey]);
						}
					}

					// serialize the optionsettings
					$field = serialize($_POST['item']['optionsettings']);
				}

				// check if this key is the refilldateline
				if ($key == 'refilldateline')
				{
					// rebuild the unix time stamp
					$field = vbmktime($field['hour'], $field['minute'], $field['second'], $field['month'], $field['day'], $field['year']);

					// verify that the $field is valid
					if ($field < 0)
					{
						// force it to the current time
						$field = TIMENOW;
					}
				}

				// check if this key is the allowed/denied groups
				if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
				{
					// dont allow them to update these fields
					continue;
				}

				// add this field
				$querystr .= "$key = '" . addslashes($field) . "'";
			}

			// if there is a querystr, run it
			if (isset($querystr))
			{
				// send the query to update
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_item
					SET
						" . $querystr . "
					WHERE itemid = '" . $_POST['itemid'] . "'
				");
			}
		}

		// update the datastore
		vbplaza_update_datastore(true);

		// do the redirect now
		define('CP_REDIRECT', 'vbplaza.php?do=optionlist');
		print_stop_message('saved_settings_successfully');
	}
}

// fix the display order
if ($_POST['do'] == 'categoryupdate')
{
	// check that order is an array
	if (is_array($_POST['categoryorder']) && is_array($_POST['categoryactive']))
	{
		// process all of the vbplazacategories
		$categories = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category");
		while ($category = $db->fetch_array($categories))
		{
			// check if this display order was set
			if (!isset($_POST['categoryorder']["$category[categoryid]"]))
			{
				continue;
			}

			// send the query to update
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "vbplaza_category
				SET
					active = '" . $_POST['categoryactive']["$category[categoryid]"] . "',
					displayorder = '" . $_POST['categoryorder']["$category[categoryid]"] . "'
				WHERE categoryid = '" . $category['categoryid'] . "'
			");
		}

		// free the categories
		$vbulletin->db->free_result($categories);
	}

	// update the datastore
	vbplaza_update_datastore(true);

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza.php?do=categorylist');
	print_stop_message('saved_settings_successfully');
}

// fix the display order
if ($_POST['do'] == 'optionsupdate')
{
	// check that order is an array
	if (is_array($_POST['item']))
	{
		// process each item
		foreach($_POST['item'] AS $itemid => $item)
		{
			// process each field
			$queryfields = array();
			foreach($item AS $key => $field)
			{
				// add this to the $queryfields
				if (is_string($field))
				{
					// add this to the $queryfields serialized
					$queryfields[] = $key . " = '" . $db->escape_string($field) . "'";
				}
				else
				{
					// add this to the $queryfields
					$queryfields[] = $key . " = '" . $field . "'";
				}
			}

			// build the queryfields
			$querystr = implode(", ", $queryfields);
			if (!empty($querystr))
			{
				// send the query to update
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_item
					SET
						" . $querystr . "
					WHERE itemid = '" . $itemid . "'
				");
			}
		}
	}

	// update the datastore
	vbplaza_update_datastore(true);

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza.php?do=optionlist');
	print_stop_message('saved_settings_successfully');
}

// check if it should update the arcade codes
if ($_POST['do'] == 'updatearcadecosts')
{
	// check that games is an array
	if (is_array($_POST['games']))
	{
		// process each game
		foreach($_POST['games'] AS $gameid => $game)
		{
			// process each field
			$queryfields = array();
			foreach($game AS $key => $field)
			{
				// add this to the $queryfields
				if (is_string($field))
				{
					// add this to the $queryfields serialized
					$queryfields[] = $key . " = '" . $db->escape_string($field) . "'";
				}
				else
				{
					// add this to the $queryfields
					$queryfields[] = $key . " = '" . $field . "'";
				}
			}

			// build the queryfields
			$querystr = implode(",", $queryfields);
			if (!empty($querystr))
			{
				// send the query for ibproarcade
				if ($_POST['arcadetype'] == 'ibproarcade')
				{
					// send the query to update
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "games_list
						SET
							" . $querystr . "
						WHERE gid = '" . $gameid . "'
					");
				}
				// send the query for v3arcade
				else if ($_POST['arcadetype'] == 'v3arcade')
				{
					// send the query to update
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "arcade_games
						SET
							" . $querystr . "
						WHERE gameid = '" . $gameid . "'
					");
				}
			}
		}
	}

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza.php?do=arcadecosts');
	print_stop_message('saved_settings_successfully');
}

// check if its refilling the items
if ($_POST['do'] == 'refillalloptions')
{
	// perform the query
	$db->query_write("UPDATE " . TABLE_PREFIX . "vbplaza_item SET quantity = defquantity, refilldateline = ". (TIMENOW + $vbulletin->options['vbplaza_defaultrefillrate']));

	// update the datastore
	vbplaza_update_datastore(true);

	// display message that the refill was successful
	print_form_header('vbplaza', 'optionlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_refill_all_items'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its searching the item history
if ($_REQUEST['do'] == 'searchitemhistory')
{
	// build the search terms if any
	$searchterms = array();
	if (is_numeric($_REQUEST['userid']))
	{
		// add this to the search terms
		$searchterms[] = "userid = '" . $_REQUEST['userid'] . "'";
	}
	if (!empty($_REQUEST['username']))
	{
		// add this to the search terms
		$searchterms[] = "username LIKE '%" . $db->escape_string($_REQUEST['username']) . "%'";
	}
	if (is_numeric($_REQUEST['itemid']))
	{
		// add this to the search terms
		$searchterms[] = "itemid = '" . $_REQUEST['itemid'] . "'";
	}
	if (!empty($_REQUEST['itemname']))
	{
		// add this to the search terms
		$searchterms[] = "itemname LIKE '%" . $db->escape_string($_REQUEST['itemname']) . "%'";
	}

	// check if there are any searchterms
	if (!empty($searchterms))
	{
		// implode the string
		$wherestr = "WHERE " . implode(" OR ", $searchterms);
	}

	// verify that $_REQUEST['page'] is set
	$perpage = 50;
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check out how many items are found like this
	$itemhistory = $db->query_first("
		SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_itemhistory
		" . $wherestr . "
	");

	// check if any rows were found
	if ($itemhistory['count'] > 0)
	{
		// build the total page
		$totalpages = ceil($itemhistory['count'] / $perpage);

		// select the rows from the database
		$items = $db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_itemhistory
			" . $wherestr . "
			ORDER BY dateline DESC
			" . $limitstr . "
		");

		// process each item
		$itemcache = array();
		while ($item = $db->fetch_array($items))
		{
			// add this item
			$itemcache["$item[itemid]"] = $item;
		}

		// free the items
		$vbulletin->db->free_result($items);

		// check if its not the first page
		if ($_REQUEST['page'] != 1)
		{
			$prv = $_REQUEST['page'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchitemhistory&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchitemhistory&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$prv'\">";
		}
		if ($_REQUEST['page'] != $totalpages)
		{
			$nxt = $_REQUEST['page'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchitemhistory&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchitemhistory&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$totalpages'\">";
		}

		// display message that the refill was successful
		print_form_header('vbplaza', 'searchitemhistory');
		print_description_row(construct_link_code($vbphrase['restart'], "vbplaza.php?do=itemhistory"), 0, 5, 'thead', $stylevar['right']);
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_item_history'] . "</font>", 5);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_history']), construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_item']), $vbphrase['vbplaza_item_name'], $vbphrase['vbplaza_item_purchaser'], $vbphrase['vbplaza_item_purchase_date']), 1, 'tcat');

		// process each row
		foreach($itemcache AS $itemid => $item)
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = $item['historyid'];
			$cell[] = $item['itemid'];
			$cell[] = $item['itemname'];
			$cell[] = $item['username'];
			$cell[] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $item['dateline']);
			print_cells_row($cell);
		}

		// finish off the footer
		print_table_footer(5, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		// display message that nothing was found
		print_form_header('vbplaza', 'searchitemhistory');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_item_history'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_item_history_found']);
		print_table_footer(2, "");
	}
}

// check if it should update all arcade costs
if ($_POST['do'] == 'updateallarcadecosts')
{
	// verify that they have entered a valid value
	if (is_numeric($_POST['globalcost']) && ($_POST['globalcost'] > 0))
	{
		// update the proper arcade
		if ($_POST['arcadetype'] == 'ibproarcade')
		{
			// send the query to update
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "games_list
				SET
					cost = '" . $_POST['globalcost'] . "'
			");
		}
		else if ($_POST['arcadetype'] == 'v3arcade')
		{
			// send the query to update
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "arcade_games
				SET
					cost = '" . $_POST['globalcost'] . "'
			");
		}
	}

	// display a confirmation
	print_form_header('vbplaza', 'updatearcadecosts');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_update_all_arcade_games_cost'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if it should rebuild the options sold from the item history
if ($_POST['do'] == 'buildoptionssold')
{
	// cache all of the item history
	$historycache = array();
	$histories = $db->query_write("SELECT * FROM " . TABLE_PREFIX . "vbplaza_itemhistory");
	while ($history = $db->fetch_array($histories))
	{
		// cache this history entry
		$historycache[] = $history;
	}

	// verify it found some history entries
	if (!empty($historycache) && is_array($historycache))
	{
		// first clear out the statistics
		$itemstats = array();
		foreach($vbplazaoptions AS $itemid => $item)
		{
			// setup the stats that need saving
			$itemstats[$itemid]['sold'] = 0;
		}

		// start totalling up all of the statistics
		foreach($historycache AS $historyid => $history)
		{
			// increase the itemstats for this item
			$itemstats[$history['itemid']]['sold']++;
		}

		// verify it has some items to update
		if (!empty($itemstats) && is_array($itemstats))
		{
			// now send off the query to update the sold for all of the times found
			foreach($itemstats AS $itemid => $item)
			{
				// send off the query to update this item
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_item
					SET
						sold = '" . $item['sold'] . "'
					WHERE itemid = '" . $itemid . "'
				");
			}

			// update the datastore
			vbplaza_update_datastore(true);
		}
	}

	// display message that the rebuild item stats was successful
	print_form_header('vbplaza', 'rebuildoptionssold');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_rebuild_items_sold'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its refilling the items
if ($_REQUEST['do'] == 'refilloptions')
{
	// display a confirmation
	print_form_header('vbplaza', 'refillalloptions');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_refill_all_items'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_refill_all_items_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_refill_all_items'] . "\" accesskey=\"s\" />");
}

// check if its doing a rebuild options sold
if ($_REQUEST['do'] == 'rebuildoptionssold')
{
	// start the rebuild items sold
	print_form_header('vbplaza', 'buildoptionssold');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_rebuild_items_sold'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_rebuild_items_sold_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_rebuild_items_sold'] . "\" accesskey=\"s\" />");
}

// check if it's editing all arcade gamecosts
if ($_REQUEST['do'] == 'allarcadecosts')
{
	// check to see if they have a compatible version arcade installed
	$arcadefound = false;
	if ($arcades = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = 'ibproarcade' OR productid = 'v3arcade'"))
	{
		// process all that were found
		while ($arcade = $db->fetch_array($arcades))
		{
			// check if ibproarcade was found
			if ($arcade['productid'] == 'ibproarcade')
			{
				// check if its a new enough version
				$arcadefound = true;
				if (is_newer_version($arcade['version'], '2.5.5 Beta 0'))
				{
					// display a confirmation
					print_form_header('vbplaza', 'updateallarcadecosts');
					print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_ibproarcade']) . "</font>", 2);
					construct_hidden_code('arcadetype', $arcade['productid']);
					print_description_row(construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost_warning'], $vbphrase['vbplaza_ibproarcade']));
					print_input_row($vbphrase['vbplaza_cost'], 'globalcost', '');
					print_table_footer(2, $deleteoption . "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
				}
				else
				{
					// display that they do not have a high enough version ibproarcade installed
					print_form_header('vbplaza', 'allarcadecosts');
					print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_ibproarcade']) . "</font>", 2);
					print_description_row(construct_phrase($vbphrase['vbplaza_arcade_ibproarcade_version_not_high_enough'], $vbphrase['vbbux_name']));
					print_table_footer(2, "");
				}
			}
			// check if v3arcade was found
			else if ($arcade['productid'] == 'v3arcade')
			{
				// check if its a new enough version
				$arcadefound = true;
				if (is_newer_version($arcade['version'], '1.0.5 Beta 0'))
				{
					// display a confirmation
					print_form_header('vbplaza', 'updateallarcadecosts');
					print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_v3arcade']) . "</font>", 2);
					construct_hidden_code('arcadetype', $arcade['productid']);
					print_description_row(construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost_warning'], $vbphrase['vbplaza_v3arcade']));
					print_input_row($vbphrase['vbplaza_cost'], 'globalcost', '');
					print_table_footer(2, $deleteoption . "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
				}
				else
				{
					// display that they do not have a high enough version v3arcade installed
					print_form_header('vbplaza', 'allarcadecosts');
					print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_v3arcade']) . "</font>", 2);
					print_description_row(construct_phrase($vbphrase['vbplaza_arcade_v3arcade_version_not_high_enough'], $vbphrase['vbbux_name']));
					print_table_footer(2, "");
				}
			}
		}
	}

	// free the arcades
	$vbulletin->db->free_result($arcades);

	// check if the arcade was found
	if ($arcadefound != true)
	{
		// display that they do not have and arcade installed
		print_form_header('vbplaza', 'allarcadecosts');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_arcade']) . "</font>", 2);
		print_description_row($vbphrase['vbplaza_arcade_not_installed']);
		print_table_footer(2, "");
	}
}

// check if it's editing the arcade game costs
if ($_REQUEST['do'] == 'arcadecosts')
{
	// check to see if they have a compatible version arcade installed
	$arcadeinfo = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = 'ibproarcade' OR productid = 'v3arcade'");

	// check if ibproarcade was found
	if ($arcadeinfo['productid'] == 'ibproarcade')
	{
		// check if its a new enough version
		if (is_newer_version($arcadeinfo['version'], '2.5.5 Beta 0'))
		{
			// cache all of the games inside the arcade
			if ($games = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "games_list ORDER BY gtitle"))
			{
				// process all games
				$gamescache = array();
				while ($game = $db->fetch_array($games))
				{
					// cache this game
					$gamescache[] = $game;
				}

				// display a confirmation
				print_form_header('vbplaza', 'updatearcadecosts');
				print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 3);
				construct_hidden_code('arcadetype', $arcadeinfo['productid']);
				print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_arcade_game_name'], $vbphrase['vbplaza_cost']), 1, 'tcat');
				foreach($gamescache AS $game)
				{
					// fill the cells
					$cell = array();
					$cell[] = $game['gid'];
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"games[" . $game['gid'] . "][gtitle]\" value=\"" . $game['gtitle'] . "\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_arcade_game_name'] . "\" />";
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"games[" . $game['gid'] . "][cost]\" value=\"" . $game['cost'] . "\" tabindex=\"1\" size=\"15\" title=\"" . $vbphrase['vbplaza_cost'] . "\" />";
					print_cells_row($cell);
				}
				print_table_footer(3, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
			}
			else
			{
				// display a confirmation
				print_form_header('vbplaza', 'updatearcadecosts');
				print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
				print_description_row($vbphrase['vbplaza_arcade_no_games_found']);
				print_table_footer(2, "");
			}

			// free the games
			$vbulletin->db->free_result($games);
		}
		else
		{
			// display that they do not have a high enough version ibproarcade installed
			print_form_header('vbplaza', 'updatearcadecosts');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
			print_description_row(construct_phrase($vbphrase['vbplaza_arcade_ibproarcade_version_not_high_enough'], $vbphrase['vbbux_name']));
			print_table_footer(2, "");
		}
	}
	// check if v3arcade was found
	else if ($arcadeinfo['productid'] == 'v3arcade')
	{
		// check if its a new enough version
		if (is_newer_version($arcadeinfo['version'], '1.0.5 Beta 0'))
		{
			// cache all of the games inside the arcade
			if ($games = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "arcade_games ORDER BY title"))
			{
				// process all games
				$gamescache = array();
				while ($game = $db->fetch_array($games))
				{
					// cache this game
					$gamescache[] = $game;
				}

				// display a confirmation
				print_form_header('vbplaza', 'updatearcadecosts');
				print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 3);
				construct_hidden_code('arcadetype', $arcadeinfo['productid']);
				print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_arcade_game_name'], $vbphrase['vbplaza_cost']), 1, 'tcat');
				foreach($gamescache AS $game)
				{
					// fill the cells
					$cell = array();
					$cell[] = $game['gameid'];
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"games[" . $game['gameid'] . "][title]\" value=\"" . $game['title'] . "\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_arcade_game_name'] . "\" />";
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"games[" . $game['gameid'] . "][cost]\" value=\"" . $game['cost'] . "\" tabindex=\"1\" size=\"15\" title=\"" . $vbphrase['vbplaza_cost'] . "\" />";
					print_cells_row($cell);
				}
				print_table_footer(3, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
			}
			else
			{
				// display a confirmation
				print_form_header('vbplaza', 'updatearcadecosts');
				print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
				print_description_row($vbphrase['vbplaza_arcade_no_games_found']);
				print_table_footer(2, "");
			}

			// free the games
			$vbulletin->db->free_result($games);
		}
		else
		{
			// display that they do not have a high enough version arcade installed
			print_form_header('vbplaza', 'updatearcadecosts');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
			print_description_row($vbphrase['vbplaza_arcade_v3arcade_version_not_high_enough']);
			print_table_footer(2, "");
		}
	}
	// neither were found, display links to get them!
	else
	{
		// display that they do not have and arcade installed
		print_form_header('vbplaza', 'updatearcadecosts');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_arcade_not_installed']);
		print_table_footer(2, "");
	}
}


// check if its editing a category
if ($_REQUEST['do'] == 'editcategory')
{
	// build delete button if possible
	$deleteoption = '';
	if ($_REQUEST['categoryid'] >= 101)
	{
		// setup up the $deleteoption
		$deleteoption = "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_category']) . "\" accesskey=\"s\" /> &nbsp; ";
	}

	// cache the category
	$category = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category WHERE categoryid = '" . $_REQUEST['categoryid'] . "'");
	print_form_header('vbplaza', 'updatecategory');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_edit'] . " " . $category['name'] . "</font>", 2);
	construct_hidden_code('categoryid', $_REQUEST['categoryid']);
	print_yes_no_row($vbphrase['vbplaza_active'], 'category[active]', $category['active']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_category']), 'category[name]', $category['name']);
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_category']), 'category[description]', $category['description']);
	print_input_row($vbphrase['display_order'], 'category[displayorder]', $category['displayorder']);
	print_input_row($vbphrase['vbplaza_category_image_location'], 'category[imagelocation]', $category['imagelocation']);
	print_table_footer(2, $deleteoption . "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
}

// check if its editing an item
if ($_REQUEST['do'] == 'editoption')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category ORDER BY displayorder");
	while ($category = $db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// build categoryname rows
	$categoryselect = array($vbphrase[vbplaza_none]);
	foreach($vbplazacategories AS $category)
	{
		// add this category
		$categoryselect[$category['categoryid']] = $category['name'];
	}

	// build delete button if possible
	$deleteoption = '';
	if (($_REQUEST['itemid'] >= 501) || (($_REQUEST['itemid'] >= 71) && ($_REQUEST['itemid'] <= 109)))
	{
		// setup up the $deleteoption
		$deleteoption = "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_option']) . "\" accesskey=\"s\" /> &nbsp; ";
	}

	// get the item info
	$item = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_item WHERE itemid = '" . $_REQUEST['itemid'] . "'");
	print_form_header('vbplaza', 'updateoption');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_edit'] . " " . $item['name'] . "</font>", 2);
	construct_hidden_code('itemid', $_REQUEST['itemid']);
	print_yes_no_row($vbphrase['vbplaza_active'], 'item[active]', $item['active']);
	print_yes_no_row($vbphrase['vbplaza_item_can_change_always'], 'item[changealways]', $item[changealways]);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_item_show_in_store'], $vbphrase['vbplaza_name']), 'item[showinstore]', $item[showinstore]);
	print_yes_no_row($vbphrase['vbplaza_item_log_history'], 'item[loghistory]', $item['loghistory']);
	print_select_row(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_category']), 'item[category]', $categoryselect, $item['category']);
	print_input_row($vbphrase['vbplaza_item_name'], 'item[name]', $item['name']);
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']), 'item[description]', $item['description']);
	print_input_row($vbphrase['display_order'], 'item[displayorder]', $item['displayorder']);
	print_input_row($vbphrase['vbplaza_flood_check'], 'item[floodcheck]', $item['floodcheck']);
	print_input_row($vbphrase['vbplaza_item_cost'], 'item[cost]', $item['cost']);
	print_yes_no_row($vbphrase['vbplaza_item_cost_auto_calculated'], 'item[autobuildcost]', $item[autobuildcost]);
	print_input_row($vbphrase['vbplaza_item_tax'], 'item[tax]', $item['tax']);
	print_input_row($vbphrase['vbplaza_item_expirydate'], 'item[expirydate]', $item['expirydate']);
	print_time_row($vbphrase['vbplaza_item_refilldateline'], 'item[refilldateline]', $item['refilldateline']);
	print_input_row($vbphrase['vbplaza_item_defquantity'], 'item[defquantity]', $item['defquantity']);
	print_input_row($vbphrase['vbplaza_item_quantity'], 'item[quantity]', $item['quantity']);
	print_input_row($vbphrase['vbplaza_items_sold'], 'item[sold]', $item['sold']);
	print_yes_no_row($vbphrase['vbplaza_override_category_permissions'], 'item[overridepermissions]', $item['overridepermissions']);
	print_input_row($vbphrase['vbplaza_item_image_location'], 'item[imagelocation]', $item['imagelocation']);
	print_input_row($vbphrase['vbplaza_item_script_location'], 'item[scriptlocation]', $item['scriptlocation']);
	print_table_break('');

	// display the advanced table settings
	print_table_header($vbphrase['vbplaza_table_settings_advanced_only']);
	print_input_row($vbphrase['vbplaza_item_table_name'], 'item[tablename]', $item['tablename']);
	print_input_row($vbphrase['vbplaza_where_name'], 'item[wherename]', $item['wherename']);
	print_input_row($vbphrase['vbplaza_where_value'], 'item[wherevalue]', $item['wherevalue']);
	print_select_row($vbphrase['vbplaza_set_type'], 'item[settype]', array('0' => $vbphrase['vbplaza_none'], '1' => $vbphrase['vbplaza_string'], '2' => $vbphrase['vbplaza_bitfield'], '3' => $vbphrase['vbplaza_add_integer']), $item['settype']);
	print_input_row($vbphrase['vbplaza_set_name'], 'item[setname]', $item['setname']);
	print_input_row($vbphrase['vbplaza_set_value'], 'item[setvalue]', $item['setvalue']);
	print_table_break('');

	// display the advanced input field settings
	print_table_header($vbphrase['vbplaza_input_field_settings_advanced_only'], 4);
	print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_phrase_name'], $vbphrase['vbplaza_field_name'], $vbphrase['vbplaza_field_value']), 1, 'tcat');
	$inputfields = unserialize($item['inputfields']);
	for ($i = 0; $i < $vbulletin->options['vbplaza_optionfields']; $i++)
	{
		// clear out the cells
		$cell = array();

		// check if there is any data in this field
		$cell[] = $i + 1;
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields][" . $i . "][phrasename]\" value=\"" . $inputfields[$i]['phrasename'] . "\" tabindex=\"1\" size=\"40\" title=\"" . $vbphrase['vbplaza_phrase_name'] . "\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields][" . $i . "][inputname]\" value=\"" . $inputfields[$i]['inputname'] . "\" tabindex=\"2\" size=\"40\" title=\"" . $vbphrase['vbplaza_field_name'] . "\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields][" . $i . "][inputvalue]\" value=\"" . $inputfields[$i]['inputvalue'] . "\" tabindex=\"3\" size=\"40\" title=\"" . $vbphrase['vbplaza_field_value'] . "\" />";
		print_cells_row($cell);
	}
	print_table_break('');

	// display the advanced option settings
	$numoptions = 1;
	print_table_header($vbphrase['vbplaza_option_settings_advanced_only'], 6);
	print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_type'], $vbphrase['vbplaza_varname'], $vbphrase['vbplaza_option_title'], construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']), $vbphrase['vbplaza_value']), 1, 'tcat');
	$item['optionsettings'] = unserialize($item['optionsettings']);
	if (is_array($item['optionsettings']) && !empty($item['optionsettings']))
	{
		// process each entry option setting
		foreach($item['optionsettings'] AS $key => $optionsetting)
		{
			// verify the setting is valid
			if ($optionsetting['type'] && !empty($optionsetting['varname']))
			{
				// clear out the cells
				$cell = array();

				// display this option setting
				$cell[] = $numoptions;
				$optiontypes = array('0' => 'Choose One', '1' => 'Yes/No', '2' => 'Number', '3' => 'Free');
				$cell[] = "<select name=\"item[optionsettings][" . $numoptions . "][type]\" class=\"bginput\">\n" . construct_select_options($optiontypes, $optionsetting['type']) . "\t</select>";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][varname]\" value=\"" . $optionsetting['varname'] . "\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_varname'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][title]\" value=\"" . $optionsetting['title'] . "\" tabindex=\"2\" size=\"30\" title=\"" . $vbphrase['vbplaza_option_title'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][description]\" value=\"" . $optionsetting['description'] . "\" tabindex=\"3\" size=\"40\" title=\"" . construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']) . "\" />";
				if ($optionsetting['type'] == '1')
				{
					// display it as a yes/no field
					$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
					$cell[] = "<select name=\"item[optionsettings][" . $numoptions . "][value]\" class=\"bginput\">\n" . construct_select_options($activemods, $optionsetting['value']) . "\t</select>";
				}
				else
				{
					// display it as an input
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][value]\" value=\"" . $optionsetting['value'] . "\" tabindex=\"4\" size=\"10\" title=\"" . $vbphrase['vbplaza_value'] . "\" />";
				}
				print_cells_row($cell);

				// increase $numoptions
				$numoptions++;
			}
		}
	}

	// clear out the cells
	$cell = array();

	// always add 1 more spot to this field for expansion
	$cell[] = $numoptions;
	$optiontypes = array('0' => 'Choose One', '1' => 'Yes/No', '2' => 'Number', '3' => 'Free');
	$cell[] = "<select name=\"item[optionsettings][" . $numoptions . "][type]\" class=\"bginput\">\n" . construct_select_options($optiontypes, '0') . "\t</select>";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][varname]\" value=\"\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_varname'] . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][title]\" value=\"\" tabindex=\"2\" size=\"30\" title=\"" . $vbphrase['vbplaza_option_title'] . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][description]\" value=\"\" tabindex=\"3\" size=\"40\" title=\"" . construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']) . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][value]\" value=\"\" tabindex=\"4\" size=\"10\" title=\"" . $vbphrase['vbplaza_value'] . "\" />";
	print_cells_row($cell);
	print_table_break('');

	// finish off the table form
	print_table_footer(2, $deleteoption . "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
}

// check if it is searching the item history
if ($_REQUEST['do'] == 'itemhistory')
{
	// display that there are no categories found
	print_form_header('vbplaza', 'searchitemhistory');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_item_history'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_search_criteria']);
	print_input_row($vbphrase['username'], 'username', '');
	print_input_row($vbphrase['userid'], 'userid', '');
	print_input_row(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_item']), 'itemid', '');
	print_input_row($vbphrase['vbplaza_item_name'], 'itemname', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_search_item_history'] . "\" accesskey=\"s\" />");
}

// check if it is listing the categories
if ($_REQUEST['do'] == 'categorylist')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category WHERE categoryid != '11' ORDER BY displayorder");
	while ($category = $db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// start the output
	print_form_header('vbplaza', 'categoryupdate');

	// verify it has found some categories
	if (is_array($vbplazacategories) && !empty($vbplazacategories))
	{
		// start printing the cells
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_category_list'] . "</font>", 4);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_category']), construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_category']), $vbphrase['vbplaza_active'], $vbphrase['display_order']), 1, 'tcat');

		// process all cached categories
		foreach($vbplazacategories AS $category)
		{
			// verify the category is valid
			if (is_numeric($category['categoryid']))
			{
				// clear out the cells
				$cell = array();

				// setup and display the cells
				$cell[] = "<a href=\"vbplaza.php?do=editcategory&amp;categoryid=" . $category['categoryid'] . "\">" . $category['name'] . "</a>";
				$cell[] = $category['description'];
				$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
				$cell[] = "<select name=\"categoryactive[$category[categoryid]]\" class=\"bginput\">\n" . construct_select_options($activemods, $category['active']) . "\t</select>";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"categoryorder[$category[categoryid]]\" value=\"$category[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
				print_cells_row($cell);
			}
		}

		// finish off the table
		print_table_footer(4, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
	}
	else
	{
		// display that there are no categories found
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_category_list'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_categories_found']);
		print_table_footer(2, "");
	}
}

// check if it is listing the options
if ($_REQUEST['do'] == 'optionlist')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category WHERE categoryid != '11' ORDER BY displayorder");
	while ($category = $db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// start the output
	print_form_header('vbplaza', 'optionsupdate');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_update'] . "</font>", 9);

	// process all of the categories
	foreach($vbplazacategories AS $category)
	{
		// display a header for this item
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $category['name'] . "</font>", 9, false, '', 'left', true);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_item']), $vbphrase['vbplaza_item_name'], $vbphrase['vbplaza_cost'], $vbphrase['vbplaza_tax'], $vbphrase['vbplaza_sold'], $vbphrase['vbplaza_quantity'], $vbphrase['vbplaza_flood_check'], $vbphrase['vbplaza_active'], $vbphrase['display_order']), 1, 'tcat');

		// process all of the cached items
		foreach($vbplazaoptions AS $item)
		{
			// check if it should display this item
			if (is_numeric($item['itemid']) && ($item['category'] == $category['categoryid']))
			{
				// clear out the cells
				$cell = array();

				// check that is has a name at all
				if (empty($item['name']))
				{
					// set the name to something
					$item['name'] = $vbphrase['vbplaza_no_name'];
				}

				// setup and display the cells
				$cell[] = $item['itemid'];
				$cell[] = "<a href=\"vbplaza.php?do=editoption&amp;itemid=" . $item['itemid'] . "\">" . $item['name'] . "</a>";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][cost]\" value=\"$item[cost]\" size=\"10\" title=\"" . $vbphrase['vbplaza_item_cost'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][tax]\" value=\"$item[tax]\" size=\"8\" title=\"" . $vbphrase['vbplaza_item_tax'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][sold]\" value=\"$item[sold]\" size=\"5\" title=\"" . $vbphrase['vbplaza_items_sold'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][quantity]\" value=\"$item[quantity]\" size=\"5\" title=\"" . $vbphrase['vbplaza_item_quantity'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][floodcheck]\" value=\"$item[floodcheck]\" size=\"5\" title=\"" . $vbphrase['vbplaza_flood_check'] . "\" />";
				$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
				$cell[] = "<select name=\"item[$item[itemid]][active]\" class=\"bginput\">\n" . construct_select_options($activemods, $item['active']) . "\t</select>";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][displayorder]\" value=\"$item[displayorder]\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
				print_cells_row($cell);
			}
		}
	}

	// finish off the table
	print_table_footer(9, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
}

// display the footer
print_cp_footer();
?>