<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	exit;
}

// 1st patch to the postbit template
$vbplaza_templates['postbit']['0'] = array(
	'action' => 'replace',
	'find' => '<div id="postmenu_$post[postid]">',
	'data' => '<!-- vbPlaza start -->
<div id="postmenu_$post[postid]" <if condition="$post[\'namestyle\']">style="$post[namestyle]"</if>>
<!-- vbPlaza end -->'
);

// 2nd patch to the postbit template
$vbplaza_templates['postbit']['1'] = array(
	'action' => 'replace',
	'find' => '<if condition="$post[\'usertitle\']"><div class="smallfont">$post[usertitle]</div></if>',
	'data' => '<!-- vbPlaza start -->
<if condition="$post[\'usertitle\']"><div class="smallfont" <if condition="$post[\'titlestyle\']">style="$post[titlestyle]"</if>>$post[usertitle]</div></if>
<!-- vbPlaza end -->'
);

// 3rd patch to the postbit template
$vbplaza_templates['postbit']['2'] = array(
	'action' => 'replace',
	'find' => '$vbphrase[posts]: $post[posts]',
	'data' => '<!-- vbPlaza start -->
<if condition="$show[\'pointsinpostbit\']"><br />
$vbphrase[vbbux_points]: $post[points]<br />
$vbphrase[vbbux_bank]: $post[bank]<br />
<phrase 1="$vbphrase[vbbux_points]">$vbphrase[vbbux_total_points]</phrase>: $post[totalpoints]<br />
<a href="vbplaza.php?do=donate&amp;userid=$post[userid]">$vbphrase[vbplaza_donate]</a><br />
</if>
<!-- vbPlaza end -->'
);

// 4th patch to the postbit template
$vbplaza_templates['postbit']['3'] = array(
	'action' => 'addbelow',
	'find' => '<div>$post[icqicon] $post[aimicon] $post[msnicon] $post[yahooicon] $post[skypeicon]</div>',
	'data' => '<!-- vbPlaza start -->
				<if condition="$post[\'giftsdisplay\']"><div class="smallfont">$post[giftsdisplay]</div></if>
				<if condition="$post[\'ribbonsdisplay\']"><div class="smallfont">$post[ribbonsdisplay]</div></if>
<!-- vbPlaza end -->'
);

// the exact same changes are needed for postbit_legacy
$vbplaza_templates['postbit_legacy'] =& $vbplaza_templates['postbit'];

// 1st patch to the navbar template
$vbplaza_templates['navbar']['0'] = array(
	'action' => 'addbelow',
	'find' => '		<if condition="$show[\'popups\']">',
	'data' => '<!-- vbPlaza start -->
			<if condition="$show[\'member\']">
				<if condition="$vboptions[\'vbplaza_enabled\']"><td id="vbplazamenu" class="vbmenu_control"><a href="$show[nojs_link]#vbplazamenu">$vbphrase[vbplaza_name] $vbphrase[vbplaza_menu]</a> <script type="text/javascript"> vbmenu_register("vbplazamenu"); </script></td></if>
			</if>
<!-- vbPlaza end -->'
);

// 2nd patch to the navbar template
$vbplaza_templates['navbar']['1'] = array(
	'action' => 'addabove',
	'find' => '<!-- / NAVBAR POPUP MENUS -->',
	'data' => '<!-- vbPlaza start -->
	<if condition="$show[\'member\']">
	<!-- vbplaza tools menu -->
	<div class="vbmenu_popup" id="vbplazamenu_menu" style="display:none">
		<table cellpadding="4" cellspacing="1" border="0">

		<tr><td class="thead"><a href="vbplaza.php?$session[sessionurl]">$vbphrase[vbplaza_name] $vbphrase[vbplaza_main]</a></td></tr>
		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=action&amp;itemid=48">$vbphrase[vbplaza_lottery]</a></td></tr>
		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=action&amp;itemid=27">$vbphrase[vbplaza_give_gifts]</a></td></tr>
		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=action&amp;itemid=118">$vbphrase[vbplaza_give_ribbons]</a></td></tr>
		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=action&amp;itemid=13">$vbphrase[vbbux_bank]</a></td></tr>
		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=action&amp;itemid=7">$vbphrase[vbplaza_donate]</a></td></tr>
		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=action&amp;itemid=16">$vbphrase[vbplaza_thief]</a></td></tr>

		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=richestusers">$vbphrase[vbbux_richest_users]</a></td></tr>
		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=userhistory">$vbphrase[vbplaza_history]</a></td></tr>
		<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=mostsold">$vbphrase[vbplaza_most_sold]</a></td></tr>

		<if condition="is_member_of($vbulletin->userinfo, $vboptions[\'vbplaza_adminusergroups\'])">
			<tr><td class="thead">$vbphrase[vbplaza_admin_only]</a></td></tr>
			<tr><td class="vbmenu_option"><a href="vbplaza.php?$session[sessionurl]do=action&amp;itemid=12">$vbphrase[vbplaza_admin_donate]</a></td></tr>
		</if>

		</table>
	</div>
	<!-- / vbplaza tools menu -->
	</if>
<!-- vbPlaza end -->'
);

// 1st patch to the MEMBERINFO template
$vbplaza_templates['MEMBERINFO']['0'] = array(
	'action' => 'replace',
	'find' => '<div class="bigusername">$userinfo[musername] $userinfo[onlinestatus]</div>',
	'data' => '<!-- vbPlaza start -->
				<div class="bigusername" <if condition="$userinfo[\'namestyle\']">style="$userinfo[namestyle]"</if>>$userinfo[musername] $userinfo[onlinestatus]</div>
<!-- vbPlaza end -->'
);

// 2nd patch to the MEMBERINFO template
$vbplaza_templates['MEMBERINFO']['1'] = array(
	'action' => 'replace',
	'find' => '<if condition="$userinfo[\'usertitle\']"><div class="smallfont">$userinfo[usertitle]</div></if>',
	'data' => '<!-- vbPlaza start -->
				<if condition="$userinfo[\'usertitle\']"><div class="smallfont" <if condition="$userinfo[\'titlestyle\']">style="$userinfo[titlestyle]"</if>>$userinfo[usertitle]</div></if>
<!-- vbPlaza end -->'
);

// 3rd patch to the MEMBERINFO template
$vbplaza_templates['MEMBERINFO']['2'] = array(
	'action' => 'addabove',
	'find' => '<if condition="$vboptions[\'usereferrer\']">',
	'data' => '<!-- vbPlaza start -->
			<if condition="$vboptions[\'vbbux_enabled\']">$show[vbbuxuserinfo]</if>
			<if condition="$show[\'gifts\']">$show[gifts]</if>
			<if condition="$show[\'ribbons\']">$show[ribbons]</if>
<!-- vbPlaza end -->'
);

// 1st patch to the forumrules template
$vbplaza_templates['forumrules']['0'] = array(
	'action' => 'addbelow',
	'find' => '<div><phrase 1="$htmlcodeon">$vbphrase[html_code_is_x]</phrase></div>',
	'data' => '<!-- vbPlaza start -->
		<if condition="$vboptions[\'vbbux_enabled\']">
			<if condition="!$show[\'codeonly\']">
			<hr />
			<div><phrase 1="$vbphrase[vbbux_points]" 2="$foruminfo[points_perview]">$vbphrase[vbbux_points_perview]</phrase></div>
			<div><phrase 1="$vbphrase[vbbux_points]" 2="$foruminfo[points_perthread]">$vbphrase[vbbux_points_perthread]</phrase></div>
			<div><phrase 1="$vbphrase[vbbux_points]" 2="$foruminfo[points_perreply]">$vbphrase[vbbux_points_perreply]</phrase></div>
			</if>
		</if>
<!-- vbPlaza end -->'
);

// 1st patch to the USERCP_SHELL template
$vbplaza_templates['USERCP_SHELL']['0'] = array(
	'action' => 'addabove',
	'find' => '<if condition="$show[\'avatarlink\']">',
	'data' => '<!-- vbPlaza start -->
<if condition="$vboptions[\'vbplaza_enabled\']">
	<tr>
		<td class="$navclass[vbplaza]" nowrap="nowrap"><a class="smallfont" href="vbplaza.php?$session[sessionurl]do=editvbpoptions"><phrase 1="$vbphrase[vbplaza_name]">$vbphrase[edit_vbplaza_options]</phrase></a></td>
	</tr>
</if>
<!-- vbPlaza end -->'
);

// 1st patch to the threadbit template
$vbplaza_templates['threadbit']['0'] = array(
	'action' => 'replace',
	'find' => '		$thread[title_editable]
		<div>',
	'data' => '<!-- vbPlaza start -->
		$thread[title_editable]
		<div <if condition="$thread[\'titlestyle\']">style="$thread[titlestyle]"</if>>
<!-- vbPlaza end -->'
);

// 2nd patch to the threadbit template (for version 3.5.x)
$vbplaza_templates['threadbit']['1a'] = array(
	'action' => 'replace',
	'version' => '3.5',
	'find' => '			<if condition="$show[\'gotonewpost\']">
				<strong><a href="showthread.php?$session[sessionurl]t=$thread[threadid]$thread[highlight]" id="thread_title_$thread[realthreadid]">$thread[threadtitle]</a></strong>
			<else />
				<a href="showthread.php?$session[sessionurl]t=$thread[threadid]$thread[highlight]" id="thread_title_$thread[realthreadid]">$thread[threadtitle]</a>
			</if>',
	'data' => '<!-- vbPlaza start -->
			<if condition="$show[\'gotonewpost\']">
				<strong><a href="showthread.php?$session[sessionurl]t=$thread[threadid]$thread[highlight]" id="thread_title_$thread[realthreadid]" <if condition="$thread[\'titlestyle\']">style="$thread[titlestyle]"</if>>$thread[threadtitle]</a></strong>
			<else />
				<a href="showthread.php?$session[sessionurl]t=$thread[threadid]$thread[highlight]" id="thread_title_$thread[realthreadid]" <if condition="$thread[\'titlestyle\']">style="$thread[titlestyle]"</if>>$thread[threadtitle]</a>
			</if>
<!-- vbPlaza end -->'
);

// 2nd patch to the threadbit template (for version 3.6.x)
$vbplaza_templates['threadbit']['1b'] = array(
	'action' => 'replace',
	'version' => '3.6',
	'find' => '<a href="showthread.php?$session[sessionurl]t=$thread[threadid]$thread[highlight]" id="thread_title_$thread[realthreadid]"<if condition="$show[\'gotonewpost\']"> style="font-weight:bold"</if>>$thread[threadtitle]</a>',
	'data' => '<a href="showthread.php?$session[sessionurl]t=$thread[threadid]$thread[highlight]" id="thread_title_$thread[realthreadid]"<if condition="$thread[\'titlestyle\']">style="$thread[titlestyle]"</if>>$thread[threadtitle]</a>'
);

// 1st patch to the memberlist_resultsbit template
$vbplaza_templates['memberlist_resultsbit']['0'] = array(
	'action' => 'replace',
	'find' => '		<a href="member.php?$session[sessionurl]u=$userinfo[userid]">$userinfo[musername]</a>
		<if condition="$show[\'usertitlecol\']"><div class="smallfont">$userinfo[usertitle]</div></if>',
	'data' => '<!-- vbPlaza start -->
		<div <if condition="$userinfo[\'namestyle\']">style="$userinfo[namestyle]"</if>><a href="member.php?$session[sessionurl]u=$userinfo[userid]" <if condition="$userinfo[\'namestyle\']">style="$userinfo[namestyle]"</if>>$userinfo[musername]</a></div>
		<if condition="$show[\'usertitlecol\']"><div class="smallfont" <if condition="$userinfo[\'titlestyle\']">style="$userinfo[titlestyle]"</if>>$userinfo[usertitle]</div></if>
<!-- vbPlaza end -->'
);

// function to attempt to auto patch the templates
function vbplaza_auto_patch_templates($savechanges = false)
{
	global $vbulletin, $vbplaza_templates, $rebuild;

	// get the current version of the templates
	$tempvers = substr($vbulletin->options['templateversion'], 0, 3);

	// cache all of the styles first off
	$stylecache = array();
	$styles = $vbulletin->db->query_read("SELECT styleid, title, parentid, displayorder, userselect FROM " . TABLE_PREFIX . "style");
	while ($style = $vbulletin->db->fetch_array($styles))
	{
		// cache this style
		$stylecache["$style[styleid]"] = $style;
	}

	// free the styles
	$vbulletin->db->free_result($styles);

	// process each of the templates
	$fullchangelog = array();
	$rebuild['styles'] = false;
	foreach($vbplaza_templates AS $templatename => $changes)
	{
		// grab the existing templates for this $templatename
		$get_existing = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "template
			WHERE title = '" . $vbulletin->db->escape_string($templatename) . "'
			AND templatetype = 'template'
		");
		$exists = array();
		while ($curtemplate = $vbulletin->db->fetch_array($get_existing))
		{
			$exists["$curtemplate[styleid]"] = $curtemplate;
		}
		$vbulletin->db->free_result($get_existing);

		// check all styles to see if the changes are done
		foreach($stylecache AS $style)
		{
			// get the $styleid
			$styleid = $style['styleid'];

			// verify that it is not the MASTER style
			if ($styleid == '-1') { continue; }

			// check if this style has this template already
			if (!empty($exists["$styleid"]))
			{
				// set the existing template info first
				$template = $exists["$styleid"];
			}
			else
			{
				// use the -1 styleid for this template as a base
				$template = $exists["-1"];

				// update some fields for a newly inserted template
				$template['templateid'] = 0;
				$template['styleid'] = $styleid;
			}

			// convert any wrong characters in the template
			//$template['template_un'] = str_replace("\n\n", "\n", $template['template_un']);

			// process each of the template changes
			$changesmade = false;
			foreach($changes AS $changeid => $change)
			{
				// check if this template has a version
				if (!empty($change['version']))
				{
					// check if the versions match
					if (substr($template['version'], 0, 3) != $change['version']) { continue; }
				}

				// convert carriage returns into proper "\r\n"
				$change['data'] = str_replace("\r\n", "\n", $change['data']);
				$change['data'] = str_replace("\n", "\r\n", $change['data']);
				$change['find'] = str_replace("\r\n", "\n", $change['find']);
				$change['find'] = str_replace("\n", "\r\n", $change['find']);

				// check if the change is already found
				if (strstr($template['template_un'], $change['data']))
				{
					// save these changes into the $fullchangelog
					$fullchangelog["$styleid"]["$templatename"]["$changeid"] = 'already done';
				}
				// if not, try to find the spot to modify
				else if (strstr($template['template_un'], $change['find']))
				{
					// process the proper action type
					switch($change['action'])
					{
						// add the change above
						case('addabove'):
						{
							// perform the add above now
							$template['template_un'] = str_replace($change['find'], $change['data'] . "\r\n" . $change['find'], $template['template_un']);
							break;
						}
						// add the change below
						case('addbelow'):
						{
							// perform the add below now
							$template['template_un'] = str_replace($change['find'], $change['find'] . "\r\n" . $change['data'], $template['template_un']);
							break;
						}
						// default is to replace
						default:
						{
							// perform the replace now
							$template['template_un'] = str_replace($change['find'], $change['data'], $template['template_un']);
							break;
						}
					}

					// set that it should have $changesmade
					$changesmade = true;

					// save these changes into the $fullchangelog
					$fullchangelog["$styleid"]["$templatename"]["$changeid"] = 'found';
				}
				else
				{
					// save these changes into the $fullchangelog
					$fullchangelog["$styleid"]["$templatename"]["$changeid"] = 'not found';
				}
			}

			// check if it had changes made
			if ($changesmade == true)
			{
				// compile the template now
				$template['template'] = compile_template($template['template_un']);

				// check if it should do the changes found
				if ($savechanges == true)
				{
					// check if the template already exists (i.e. is already customized)
					if ($template['templateid'] > 0)
					{
						// simply update this template
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . "template SET
								title = '" . $vbulletin->db->escape_string($template['title']) . "',
								template = '" . $vbulletin->db->escape_string($template['template']) . "',
								template_un = '" . $vbulletin->db->escape_string($template['template_un']) . "',
								dateline = " . TIMENOW . ",
								username = '" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
								version = '" . $vbulletin->db->escape_string($template['version']) . "',
								product = '" . $vbulletin->db->escape_string($template['product']) . "'
							WHERE templateid = " . $template['templateid'] . "
						");
					}
					else
					{
						// insert this template change
						$vbulletin->db->query_write("
							INSERT INTO " . TABLE_PREFIX . "template
								(styleid, title, template, template_un, dateline, username, version, product)
							VALUES
								(" . $template['styleid'] . ",
								'" . $vbulletin->db->escape_string($template['title']) . "',
								'" . $vbulletin->db->escape_string($template['template']) . "',
								'" . $vbulletin->db->escape_string($template['template_un']) . "',
								" . TIMENOW . ",
								'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
								'" . $vbulletin->db->escape_string($template['version']) . "',
								'" . $vbulletin->db->escape_string($template['product']) . "')
						");
					}

					// set it to rebuild the styles
					$rebuild['styles'] = true;
				}
			}
		}
	}

	// verify $fullchangelog is valid
	$output = '';
	$found = $notfound = $alreadydone = 0;
	if (!empty($fullchangelog) && is_array($fullchangelog))
	{
		// display the results for the full changes
		foreach($fullchangelog AS $styleid => $templatechanges)
		{
			// verify $templatechanges is valid
			if (!empty($templatechanges) && is_array($templatechanges))
			{
				// process each one of the $templatechanges
				$output .= "Style: " . $styleid . " - " . $stylecache["$styleid"]['title'] . "<br />";
				foreach($templatechanges AS $templatename => $changes)
				{
					// verify $changes is valid
					if (!empty($changes) && is_array($changes))
					{
						// process each one of the $changes
						foreach($changes AS $changeid => $status)
						{
							// display the output appropriately
							if ($status == 'not found')
							{
								// make not found bold
								$notfound++;
								$output .= "<b><font color=\"red\">Template: '" . $templatename . "' Change: " . $changeid . " was " . $status . "</font></b><br />";
							}
							else if ($status == 'found')
							{
								// make found intalic
								$found++;
								$output .= "<b>Template: '" . $templatename . "' Change: " . $changeid . " was " . ($rebuild['styles'] ? 'implemented' : $status) . "</b><br />";
							}
							else
							{
								// display it normally
								$alreadydone++;
								$output .= "<i>Template: '" . $templatename . "' Change: " . $changeid . " was " . $status . "</i><br />";
							}
						}
					}
				}
				$output .= "<br />";
			}
		}

		// finish off the info
		$output .= "<br />";
	}

	// display some statistics
	$output .= "<b>Templates Changes Found: " . $found . " template changes were " . ($rebuild['styles'] ? 'implemented' : 'found') . ".</b><br />";
	$output .= "<b>Templates Changes NOT Found: " . $notfound . " template changes were not found.</b><br />";
	$output .= "<b>Templates Changes Already Updated: " . $alreadydone . " template changes were already updated.</b><br /><br />";

	// check if it needs to rebuild the styles
	if ($rebuild['styles'] == true)
	{
		// rebuild all of the styles
		$output .= "<b>Rebuilding all of the styles</b> ...<br /><br />";
	}

	// return the $output
	return $output;
}
?>