<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbplaza_ribbons');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('vbplaza', 'forum', 'cpuser', 'cpoption', 'user');
$specialtemplates = array('vbplazaribbon');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_vbplaza.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// check if the admin requires super administrator access for 'ribbons'
// NOTE: To enable this enter the below line into your config.php
// $config['vbPlaza']['ribbons']['requiresuperadmin'] = true;
if ($vbulletin->config['vbPlaza']['ribbons']['requiresuperadmin'])
{
	// check if the user is a super administrator
	$userids = explode(',', str_replace(' ', '', $vbulletin->config['SpecialUsers']['superadministrators']));
	if (!in_array($vbulletin->userinfo['userid'], $userids))
	{
		print_stop_message('vbplaza_no_permission_admin_ribbons');
	}
}

// cache the vbplazaribbons
$vbplazaribbons = array();
if ($ribbons = $vbulletin->db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "vbplaza_ribbonitem
	ORDER BY displayorder, name
"))
{
	// start processing the ribbons
	while ($ribbon = $vbulletin->db->fetch_array($ribbons))
	{
		// cache this ribbon
		$vbplazaribbons["$ribbon[displayorder]"] = $ribbon;
	}
}

// free the ribbons
$vbulletin->db->free_result($ribbons);

// display the header
print_cp_header('vbPlaza Ribbons v' . $vbulletin->options['vbplaza_version'] . ' Admin');

// check if an action is set
if (!isset($_REQUEST['do']))
{
	// force it to list the ribbons
	$_REQUEST['do'] = 'ribbonlist';
}

// check if it's removing a ribbon
if ($_POST['do'] == 'removeribbon')
{
	// check if the ribbonid is valid
	if ($_POST['ribbonid'] > 0)
	{
		// delete this ribbon from the database
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_ribbonitem WHERE ribbonid = '" . $_POST['ribbonid'] . "'");

		// update the datastore for ribbons
		vbplaza_update_datastore_ribbons();
	}

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza_ribbons.php?do=ribbonlist');
	print_stop_message('saved_settings_successfully');
}

// check if it's trying to delete a ribbon
if ($_REQUEST['do'] == 'deleteribbon')
{
	// build the $ribbonselect
	$ribbonselect = array();
	foreach ($vbplazaribbons AS $displayid => $ribbon)
	{
		// add this ribbon to the $ribbonselect
		$ribbonselect["$ribbon[ribbonid]"] = $ribbon['name'];
	}

	// display a confirmation
	print_form_header('vbplaza_ribbons', 'removeribbon');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_ribbon']) . "</font>", 2);
	print_description_row(construct_phrase($vbphrase['vbplaza_delete_x_warning'], $vbphrase['vbplaza_ribbon']));
	print_select_row(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_ribbon']), 'ribbonid', $ribbonselect, '0');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");
}

// try to insert a new ribbon
if ($_POST['do'] == 'insertribbon')
{
	// verify that some fields were given for sure
	if (empty($_POST['ribbon']['name']))
	{
		// display message that you did not enter an ribbon name
		print_form_header('vbplaza_ribbons', 'addribbon');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['vbplaza_ribbon']) . "</font>", 2);
		print_description_row(construct_phrase($vbphrase['vbplaza_add_no_x_name'], $vbphrase['vbplaza_ribbon']));
		print_table_footer(2, "");
	}
	else if (empty($_POST['ribbon']['description']))
	{
		// display message that you did not enter an ribbon name
		print_form_header('vbplaza_ribbons', 'addribbon');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['vbplaza_ribbon']) . "</font>", 2);
		print_description_row(construct_phrase($vbphrase['vbplaza_add_no_x_description'], $vbphrase['vbplaza_ribbon']));
		print_table_footer(2, "");
	}
	else
	{
		// start building the querystr
		$queryfields = array();
		foreach ($_POST['ribbon'] AS $key => $field)
		{
			// add this to the $queryfields
			if (is_string($field))
			{
				// add this to the $queryfields serialized
				$queryfields[] = $key . " = '" . $vbulletin->db->escape_string($field) . "'";
			}
			else
			{
				// add this to the $queryfields
				$queryfields[] = $key . " = '" . $field . "'";
			}
		}

		// build the queryfields
		$querystr = implode(", ", $queryfields);
		if (!empty($querystr))
		{
			// first insert a new ribbon into the database
			$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "vbplaza_ribbonitem (ribbonid) VALUES (0)");

			// get the $ribbonid for this insertion
			$ribbonid = $vbulletin->db->insert_id();

			// verify that it inserted properly
			if ($ribbonid > 0)
			{
				// send the query to update the ribbon fields
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_ribbonitem
					SET
						" . $querystr . "
					WHERE ribbonid = '" . $ribbonid . "'
				");
			}
		}

		// update the datastore for ribbons
		vbplaza_update_datastore_ribbons();

		// do the redirect now
		define('CP_REDIRECT', 'vbplaza_ribbons.php?do=ribbonlist');
		print_stop_message('saved_settings_successfully');
	}
}

// check if it's adding a new ribbon
if ($_REQUEST['do'] == 'addribbon')
{
	// display the info to add a new ribbon
	print_form_header('vbplaza_ribbons', 'insertribbon');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['vbplaza_ribbon']) . "</font>", 2);
	print_yes_no_row($vbphrase['vbplaza_active'], 'ribbon[active]', '1');
	print_input_row($vbphrase['display_order'], 'ribbon[displayorder]', '500');
	print_input_row(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_ribbon']), 'ribbon[name]', '');
	print_input_row($vbphrase['vbplaza_filename'], 'ribbon[filename]', '');
	print_input_row($vbphrase['vbplaza_cause'], 'ribbon[cause]', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['vbplaza_ribbon']) . "\" accesskey=\"s\" />");
}

// check if it's updating the ribbons
if ($_POST['do'] == 'ribbonupdate')
{
	// check that ribbon is valid
	if (!empty($_POST['ribbon']) && is_array($_POST['ribbon']))
	{
		// process each ribbon
		foreach ($_POST['ribbon'] AS $ribbonid => $ribbon)
		{
			// process each field
			$queryfields = array();
			foreach ($ribbon AS $key => $field)
			{
				// add this to the $queryfields
				if (is_string($field))
				{
					// add this to the $queryfields serialized
					$queryfields[] = $key . " = '" . $vbulletin->db->escape_string($field) . "'";
				}
				else
				{
					// add this to the $queryfields
					$queryfields[] = $key . " = '" . $field . "'";
				}
			}

			// build the queryfields
			$querystr = implode(", ", $queryfields);
			if (!empty($querystr))
			{
				// send the query to update
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_ribbonitem
					SET
						" . $querystr . "
					WHERE ribbonid = '" . $ribbonid . "'
				");
			}
		}
	}

	// update the datastore for ribbons
	vbplaza_update_datastore_ribbons();

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza_ribbons.php?do=ribbonlist');
	print_stop_message('saved_settings_successfully');
}

// check if it's doing a ribbon removal
if ($_REQUEST['do'] == 'removeribbon')
{
	// perform the query
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_ribbon WHERE ribbonid = '" . $_REQUEST['ribbonid'] . "'");

	// rebuild the user's ribbons
	vbplaza_rebuild_ribbon_postbit($_REQUEST['userid']);

	// redirect to the search ribbons again
	define('CP_REDIRECT', 'vbplaza_ribbons.php?do=finduserribbons');
	print_stop_message('saved_settings_successfully');
}

// check if it's searching the ribbons
if ($_REQUEST['do'] == 'searchribbons')
{
	// build the search terms if any
	$searchterms = array();
	if (is_numeric($_REQUEST['userid']))
	{
		// add this to the search terms
		$searchterms[] = "touserid = '" . $_REQUEST['userid'] . "'";
	}
	if (!empty($_REQUEST['username']))
	{
		// add this to the search terms
		$searchterms[] = "tousername LIKE '%" . $vbulletin->db->escape_string($_REQUEST['username']) . "%'";
	}

	// check if there are any searchterms
	if (!empty($searchterms))
	{
		// implode the string
		$wherestr = "WHERE " . implode(" OR ", $searchterms);
	}

	// verify that $_REQUEST['page'] is set
	$perpage = 50;
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check out how many ribbons are found like this
	$allribbons = $vbulletin->db->query_first("
		SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_ribbon
		" . $wherestr . "
	");

	// check if any rows were found
	if ($allribbons['count'] > 0)
	{
		// build the total page
		$totalpages = ceil($allribbons['count'] / $perpage);

		// select the rows from the database
		$ribbons = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon
			" . $wherestr . "
			ORDER BY ribbonid DESC
			" . $limitstr . "
		");

		// process each ribbon
		$ribboncache = array();
		while ($ribbon = $vbulletin->db->fetch_array($ribbons))
		{
			// cache this ribbon
			$ribboncache["$ribbon[ribbonid]"] = $ribbon;
		}

		// free the ribbons
		$vbulletin->db->free_result($ribbons);

		// check if it's not the first page
		if ($_REQUEST['page'] != 1)
		{
			$prv = $_REQUEST['page'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchribbons&ribbonid=" . $_REQUEST['ribbonid'] . "&ribbonname=" . $_REQUEST['ribbonname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchribbons&ribbonid=" . $_REQUEST['ribbonid'] . "&ribbonname=" . $_REQUEST['ribbonname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$prv'\">";
		}
		if ($_REQUEST['page'] != $totalpages)
		{
			$nxt = $_REQUEST['page'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchribbons&ribbonid=" . $_REQUEST['ribbonid'] . "&ribbonname=" . $_REQUEST['ribbonname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchribbons&ribbonid=" . $_REQUEST['ribbonid'] . "&ribbonname=" . $_REQUEST['ribbonname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$totalpages'\">";
		}

		// display message that the refill was successful
		print_form_header('vbplaza_ribbons', 'searchribbons');
		print_description_row(construct_link_code($vbphrase['restart'], "vbplaza_ribbons.php?do=finduserribbons"), 0, 5, 'thead', $stylevar['right']);
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_ribbons'] . "</font>", 5);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_ribbon']), $vbphrase['vbplaza_ribbon_name'], $vbphrase['vbplaza_ribbon_purchased_for'], $vbphrase['vbplaza_ribbon_purchaser'], $vbphrase['delete']), 1, 'tcat');

		// process each row
		foreach ($ribboncache AS $ribbonid => $ribbon)
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = $ribbon['ribbonid'];
			$cell[] = $ribbon['ribbonname'];
			$cell[] = "<a href=\"user.php?do=edit&amp;u=" . $ribbon['touserid'] . "\">" . $ribbon['tousername'] . "</a>";
			$cell[] = "<a href=\"user.php?do=edit&amp;u=" . $ribbon['fromuserid'] . "\">" . $ribbon['fromusername'] . "</a>";
			$cell[] = "<a href=\"vbplaza_ribbons.php?do=removeribbon&amp;ribbonid=" . $ribbon['ribbonid'] . "&amp;userid=" . $ribbon['touserid'] . "\">" . $vbphrase['delete'] . "</a>";
			print_cells_row($cell);
		}

		// finish off the footer
		print_table_footer(5, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		// display message that nothing was found
		print_form_header('vbplaza_ribbons', 'searchribbons');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_ribbons'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_ribbons_found']);
		print_table_footer(2, "");
	}
}

// check if it's fixing all ribbons
if ($_REQUEST['do'] == 'fixallribbons')
{
	// check if percyle is given
	if (is_numeric($_REQUEST['percycle']) && ($_REQUEST['startat'] < $_REQUEST['lastuserid']))
	{
		// check for startat
		if (empty($_REQUEST['startat'])) { $_REQUEST['startat'] = 0; }

		// get all of the ribbons from the ribbons table
		if ($ribbons = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon
			WHERE (touserid > " . $_REQUEST['startat'] . ") AND (touserid < " . ($_REQUEST['startat'] + $_REQUEST['percycle']) . ")
			ORDER BY touserid, ribbonid DESC
		"))
		{
			// initialize the query stuff
			$curuser = $curribboncount = 0;
			$curribbons = array();

			// process all of the ribbons
			while ($ribbon = $vbulletin->db->fetch_array($ribbons))
			{
				// check if this userid is the same as previous
				if ($curuser != $ribbon['touserid'])
				{
					// update $curuser
					if ($curuser > 0)
					{
						// serialize the new ribbons field
						$curribbons = serialize($curribbons);

						// perform the query
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
							SET
								vbp_ribbons = '" . $vbulletin->db->escape_string($curribbons) . "'
							WHERE userid = '" . $curuser . "'
						");
					}

					// update $curuser
					$curuser = $ribbon['touserid'];

					// clear out some variables
					$curribboncount = 0;
					$curribbons = array();
				}


				// check if it can still add this to the count
				if ($curribboncount < $vbulletin->options['vbplaza_maxribbonsdisplayed'])
				{
					// trim the cause
					$ribbon['cause'] = trim($ribbon['cause']);

					// check if the cause is empty
					if (empty($ribbon['cause']))
					{
						// set the cause to no cause
						$ribbon['cause'] = $vbphrase['vbplaza_no_cause'];
					}

					// add this ribbon into the array
					$curribbons[$ribbon['ribbonid']] = array(
						'ribbonid'	=>	$ribbon['ribbonid'],
						'ribbonname'	=>	$ribbon['ribbonname'],
						'userid'	=>	$ribbon['fromuserid'],
						'username'	=>	$ribbon['fromusername'],
						'cause'		=>	$ribbon['cause']
					);

					// increase $curribboncount
					$curribboncount++;
				}
			}

			// check if there is 1 more user to update
			if (!empty($curribbons))
			{
				// serialize the new ribbons field
				$curribbons = serialize($curribbons);

				// perform the query
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
					SET
						vbp_ribbons = '" . $vbulletin->db->escape_string($curribbons) . "'
					WHERE userid = '" . $curuser . "'
				");
			}
		}

		// free the ribbons
		$vbulletin->db->free_result($ribbons);

		// increase $_REQUEST['startat']
		$_REQUEST['startat'] += $_REQUEST['percycle'];

		// now check if it needs to redirect again
		if ($_REQUEST['startat'] < $_REQUEST['lastuserid'])
		{
			// need to redirect again
			print_cp_redirect("vbplaza_ribbons.php?" . $vbulletin->session->vars['sessionurl'] . "do=fixallribbons&amp;percycle=" . $_REQUEST['percycle'] . "&amp;startat=" . ($_REQUEST['startat'] + $_REQUEST['percycle']) . "&amp;lastuserid=" . $_REQUEST['lastuserid']);
		}
	}

	// display cause that the ribbon fixing was successful
	print_form_header('vbplaza_ribbons', 'optionlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_fix_all_ribbons'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if it's deleting all user ribbons
if ($_POST['do'] == 'deletealluserribbons')
{
	// delete all of the ribbons from the database
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_ribbon");

	// delete all of the ribbons from the postbit
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_ribbons = ''");

	// display message that deleting all ribbons was successful
	print_form_header('vbplaza_ribbons', 'optionlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_delete_all_ribbons'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if it's fixing the ribbons
if ($_REQUEST['do'] == 'fixupribbons')
{
	// get the very last userid available
	$lastuser = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user ORDER BY userid DESC LIMIT 1");

	// display a confirmation
	print_form_header('vbplaza_ribbons', 'fixallribbons');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_fix_all_ribbons'] . "</font>", 2);
	construct_hidden_code('lastuserid', $lastuser['userid']);
	print_description_row($vbphrase['vbplaza_fix_all_ribbons_warning']);
	print_input_row($vbphrase['vbplaza_number_of_users_to_process_per_cycle'], 'percycle', '1000');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_fix_all_ribbons'] . "\" accesskey=\"s\" />");
}

// check if it's deleting user ribbons
if ($_REQUEST['do'] == 'deleteuserribbons')
{
	// display a confirmation
	print_form_header('vbplaza_ribbons', 'deletealluserribbons');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_delete_all_ribbons'] . "</font>", 2);
	construct_hidden_code('lastuserid', $lastuser['userid']);
	print_description_row($vbphrase['vbplaza_delete_all_ribbons_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");
}

// check if it is searching the user ribbons
if ($_REQUEST['do'] == 'finduserribbons')
{
	// display search fields for search ribbons
	print_form_header('vbplaza_ribbons', 'searchribbons');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_ribbons'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_search_criteria']);
	print_input_row($vbphrase['username'], 'username', '');
	print_input_row($vbphrase['userid'], 'userid', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_search_ribbons'] . "\" accesskey=\"s\" />");
}

// check if it's listing the ribbons
if ($_REQUEST['do'] == 'ribbonlist')
{
	// display the results now
	print_form_header('vbplaza_ribbons', 'ribbonupdate');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_ribbon_list'] . "</font>", 6);
	print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_type'], $vbphrase['vbplaza_filename'], $vbphrase['vbplaza_cause'], $vbphrase['vbplaza_active'], $vbphrase['display_order']), 1, 'tcat');

	// process all of the subscriptions
	foreach ($vbplazaribbons AS $ribbonid => $ribbon)
	{
		// print the cells
		$cell = array();
		$cell[] = $ribbon['ribbonid'];
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"ribbon[" . $ribbonid . "][name]\" value=\"" . $ribbon['name'] . "\" size=\"8\" title=\"" . $vbphrase['title'] . "\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"ribbon[" . $ribbonid . "][filename]\" value=\"" . $ribbon['filename'] . "\" size=\"15\" title=\"" . $vbphrase['vbbux_name'] . " " . $vbphrase['vbbux_points'] . "\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"ribbon[" . $ribbonid . "][cause]\" value=\"" . $ribbon['cause'] . "\" size=\"70\" title=\"" . $vbphrase['display_order'] . "\" />";
		$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
		$cell[] = "<select name=\"ribbon[" . $ribbonid . "][active]\" class=\"bginput\">\n" . construct_select_options($activemods, $ribbon['active']) . "\t</select>";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"ribbon[" . $ribbonid . "][displayorder]\" value=\"$ribbon[displayorder]\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
		print_cells_row($cell);
	}

	// finish off the table
	print_table_footer(6, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
}

// display the footer
print_cp_footer();
?>