<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbplaza_gifts');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('vbplaza', 'forum', 'cpuser', 'cpoption', 'user');
$specialtemplates = array('vbplazacategory', 'vbplazaoptions');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_vbplaza.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// check if the admin requires super administrator access for 'gifts'
// NOTE: To enable this enter the below line into your config.php
// $config['vbPlaza']['gifts']['requiresuperadmin'] = true;
if ($vbulletin->config['vbPlaza']['gifts']['requiresuperadmin'])
{
	// check if the user is a super administrator
	$userids = explode(',', str_replace(' ', '', $vbulletin->config['SpecialUsers']['superadministrators']));
	if (!in_array($vbulletin->userinfo['userid'], $userids))
	{
		print_stop_message('vbplaza_no_permission_admin_gifts');
	}
}

// display the header
print_cp_header('vbPlaza Gifts v' . $vbulletin->options['vbplaza_version'] . ' Admin');

// check if an action is set
if (!isset($_REQUEST['do']))
{
	// force it to find gifts
	$_REQUEST['do'] = 'findgifts';
}

// check if its doing a gift removal
if ($_REQUEST['do'] == 'removegift')
{
	// perform the query
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_gift WHERE giftid = '" . $_REQUEST['giftid'] . "'");

	// rebuild the user's gifts
	vbplaza_rebuild_gift_postbit($_REQUEST['userid']);

	// redirect to the search gifts again
	define('CP_REDIRECT', 'vbplaza_gifts.php?do=findgifts');
	print_stop_message('saved_settings_successfully');
}

// check if its searching the gifts
if ($_REQUEST['do'] == 'searchgifts')
{
	// build the search terms if any
	$searchterms = array();
	if (is_numeric($_REQUEST['userid']))
	{
		// add this to the search terms
		$searchterms[] = "touserid = '" . $_REQUEST['userid'] . "'";
	}
	if (!empty($_REQUEST['username']))
	{
		// add this to the search terms
		$searchterms[] = "tousername LIKE '%" . $vbulletin->db->escape_string($_REQUEST['username']) . "%'";
	}

	// check if there are any searchterms
	if (!empty($searchterms))
	{
		// implode the string
		$wherestr = "WHERE " . implode(" OR ", $searchterms);
	}

	// verify that $_REQUEST['page'] is set
	$perpage = 50;
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check out how many gifts are found like this
	$allgifts = $vbulletin->db->query_first("
		SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_gift
		" . $wherestr . "
	");

	// check if any rows were found
	if ($allgifts['count'] > 0)
	{
		// build the total page
		$totalpages = ceil($allgifts['count'] / $perpage);

		// select the rows from the database
		$gifts = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_gift
			" . $wherestr . "
			ORDER BY giftid DESC
			" . $limitstr . "
		");

		// process each gift
		$giftcache = array();
		while ($gift = $vbulletin->db->fetch_array($gifts))
		{
			// cache this gift
			$giftcache["$gift[giftid]"] = $gift;
		}

		// free the gifts
		$vbulletin->db->free_result($gifts);

		// check if its not the first page
		if ($_REQUEST['page'] != 1)
		{
			$prv = $_REQUEST['page'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_gifts.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchgifts&giftid=" . $_REQUEST['giftid'] . "&giftname=" . $_REQUEST['giftname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_gifts.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchgifts&giftid=" . $_REQUEST['giftid'] . "&giftname=" . $_REQUEST['giftname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$prv'\">";
		}
		if ($_REQUEST['page'] != $totalpages)
		{
			$nxt = $_REQUEST['page'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbplaza_gifts.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchgifts&giftid=" . $_REQUEST['giftid'] . "&giftname=" . $_REQUEST['giftname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbplaza_gifts.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchgifts&giftid=" . $_REQUEST['giftid'] . "&giftname=" . $_REQUEST['giftname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$totalpages'\">";
		}

		// display message that the refill was successful
		print_form_header('vbplaza_gifts', 'searchgifts');
		print_description_row(construct_link_code($vbphrase['restart'], "vbplaza_gifts.php?do=findgifts"), 0, 5, 'thead', $stylevar['right']);
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_gifts'] . "</font>", 5);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_gift']), $vbphrase['vbplaza_gift_name'], $vbphrase['vbplaza_gift_purchased_for'], $vbphrase['vbplaza_gift_purchaser'], $vbphrase['delete']), 1, 'tcat');

		// process each row
		foreach($giftcache AS $giftid => $gift)
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = $gift['giftid'];
			$cell[] = $gift['giftname'];
			$cell[] = "<a href=\"user.php?do=edit&amp;u=" . $gift['touserid'] . "\">" . $gift['tousername'] . "</a>";
			$cell[] = "<a href=\"user.php?do=edit&amp;u=" . $gift['fromuserid'] . "\">" . $gift['fromusername'] . "</a>";
			$cell[] = "<a href=\"vbplaza_gifts.php?do=removegift&amp;giftid=" . $gift['giftid'] . "&amp;userid=" . $gift['touserid'] . "\">" . $vbphrase['delete'] . "</a>";
			print_cells_row($cell);
		}

		// finish off the footer
		print_table_footer(5, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		// display message that nothing was found
		print_form_header('vbplaza_gifts', 'searchgifts');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_gifts'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_gifts_found']);
		print_table_footer(2, "");
	}
}

// check if its fixing all gifts
if ($_REQUEST['do'] == 'fixallgifts')
{
	// check if percyle is given
	if (is_numeric($_REQUEST['percycle']) && ($_REQUEST['startat'] < $_REQUEST['lastuserid']))
	{
		// check for startat
		if (empty($_REQUEST['startat'])) { $_REQUEST['startat'] = 0; }

		// get all of the gifts from the gifts table
		if ($gifts = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_gift
			WHERE (touserid > " . $_REQUEST['startat'] . ") AND (touserid < " . ($_REQUEST['startat'] + $_REQUEST['percycle']) . ")
			ORDER BY touserid, giftid DESC
		"))
		{
			// initialize the query stuff
			$curuser = $curgiftcount = 0;
			$curgifts = array();

			// process all of the gifts
			while ($gift = $vbulletin->db->fetch_array($gifts))
			{
				// check if this userid is the same as previous
				if ($curuser != $gift['touserid'])
				{
					// update $curuser
					if ($curuser > 0)
					{
						// serialize the new gifts field
						$curgifts = serialize($curgifts);

						// perform the query
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
							SET
								vbp_gifts = '" . $vbulletin->db->escape_string($curgifts) . "'
							WHERE userid = '" . $curuser . "'
						");
					}

					// update $curuser
					$curuser = $gift['touserid'];

					// clear out some variables
					$curgiftcount = 0;
					$curgifts = array();
				}


				// check if it can still add this to the count
				if ($curgiftcount < $vbulletin->options['vbplaza_maxgiftsdisplayed'])
				{
					// trim the message
					$gift['message'] = trim($gift['message']);

					// check if the message is empty
					if (empty($gift['message']))
					{
						// set the message to no message
						$gift['message'] = $vbphrase['vbplaza_no_message'];
					}

					// add this gift into the array
					$curgifts[$gift['giftid']] = array(
						'giftid'	=>	$gift['giftid'],
						'giftname'	=>	$gift['giftname'],
						'userid'	=>	$gift['fromuserid'],
						'username'	=>	$gift['fromusername'],
						'message'	=>	$gift['message']
					);

					// increase $curgiftcount
					$curgiftcount++;
				}
			}

			// check if there is 1 more user to update
			if (!empty($curgifts))
			{
				// serialize the new gifts field
				$curgifts = serialize($curgifts);

				// perform the query
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
					SET
						vbp_gifts = '" . $vbulletin->db->escape_string($curgifts) . "'
					WHERE userid = '" . $curuser . "'
				");
			}
		}

		// free the gifts
		$vbulletin->db->free_result($gifts);

		// increase $_REQUEST['startat']
		$_REQUEST['startat'] += $_REQUEST['percycle'];

		// now check if it needs to redirect again
		if ($_REQUEST['startat'] < $_REQUEST['lastuserid'])
		{
			// need to redirect again
			print_cp_redirect("vbplaza_gifts.php?" . $vbulletin->session->vars['sessionurl'] . "do=fixallgifts&amp;percycle=" . $_REQUEST['percycle'] . "&amp;startat=" . ($_REQUEST['startat'] + $_REQUEST['percycle']) . "&amp;lastuserid=" . $_REQUEST['lastuserid']);
		}
	}

	// display message that the gift fixing was successful
	print_form_header('vbplaza_gifts', 'optionlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_fix_all_gifts'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its deleting all gifts
if ($_POST['do'] == 'deleteallgifts')
{
	// delete all of the gifts from the database
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_gift");

	// delete all of the gifts from the postbit
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_gifts = ''");

	// display message that deleting all gifts was successful
	print_form_header('vbplaza_gifts', 'optionlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_delete_all_gifts'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its fixing the gifts
if ($_REQUEST['do'] == 'fixupgifts')
{
	// get the very last userid available
	$lastuser = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user ORDER BY userid DESC LIMIT 1");

	// display a confirmation
	print_form_header('vbplaza_gifts', 'fixallgifts');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_fix_all_gifts'] . "</font>", 2);
	construct_hidden_code('lastuserid', $lastuser['userid']);
	print_description_row($vbphrase['vbplaza_fix_all_gifts_warning']);
	print_input_row($vbphrase['vbplaza_number_of_users_to_process_per_cycle'], 'percycle', '1000');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_fix_all_gifts'] . "\" accesskey=\"s\" />");
}

// check if its deleting gifts
if ($_REQUEST['do'] == 'deletegifts')
{
	// display a confirmation
	print_form_header('vbplaza_gifts', 'deleteallgifts');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_delete_all_gifts'] . "</font>", 2);
	construct_hidden_code('lastuserid', $lastuser['userid']);
	print_description_row($vbphrase['vbplaza_delete_all_gifts_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_delete_all_gifts'] . "\" accesskey=\"s\" />");
}

// check if it is searching the gifts
if ($_REQUEST['do'] == 'findgifts')
{
	// display search fields for search gifts
	print_form_header('vbplaza_gifts', 'searchgifts');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_gifts'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_search_criteria']);
	print_input_row($vbphrase['username'], 'username', '');
	print_input_row($vbphrase['userid'], 'userid', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_search_gifts'] . "\" accesskey=\"s\" />");
}

// display the footer
print_cp_footer();
?>