<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbplaza');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('vbplaza', 'forum', 'cpuser', 'cpoption', 'user', 'subscription');
$specialtemplates = array('vbplazacategory', 'vbplazaoptions');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_vbplaza.php');
require_once(DIR . '/includes/adminfunctions_forums.php');
require_once(DIR . '/includes/adminfunctions_template.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// check if the admin requires super administrator access for 'admincp'
// NOTE: To enable this enter the below line into your config.php
// $config['vbPlaza']['admincp']['requiresuperadmin'] = true;
if ($vbulletin->config['vbPlaza']['admincp']['requiresuperadmin'])
{
	// check if the user is a super administrator
	$userids = explode(',', str_replace(' ', '', $vbulletin->config['SpecialUsers']['superadministrators']));
	if (!in_array($vbulletin->userinfo['userid'], $userids))
	{
		print_stop_message('vbplaza_no_permission_admin_vbplaza');
	}
}

// cache the vbplazaoptions
unset($vbplazaoptions);
if ($items = $vbulletin->db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "vbplaza_item
	ORDER BY displayorder
"))
{
	// start processing the items
	while ($item = $vbulletin->db->fetch_array($items))
	{
		// cache this item
		$vbplazaoptions[$item[itemid]] = $item;
	}
}

// free the items
$vbulletin->db->free_result($items);

// get the current version of vBulletin
$vbulletin_version = substr($vbulletin->options['templateversion'], 0, 3);

// display the header
print_cp_header('vbPlaza v' . $vbulletin->options['vbplaza_version'] . ' Admin');

// check if an action is set
if (!isset($_REQUEST['do']))
{
	// force it to list the items
	$_REQUEST['do'] = 'itemlist';
}

// check if it's trying to rebuild post points
if ($_REQUEST['do'] == 'rebuildpostpoints')
{
	// check if percyle is given
	if (is_numeric($_REQUEST['percycle']) && ($_REQUEST['percycle'] > 0))
	{
		// check for startat
		if (empty($_REQUEST['startat'])) { $_REQUEST['startat'] = 0; }

		// clear out the data to update
		$postcache = array();

		// grab some threads/posts
		$threadposts = $vbulletin->db->query_read("
			SELECT thread.threadid, thread.firstpostid, thread.forumid, post.postid, post.pagetext, post.allowsmilie
			FROM " . TABLE_PREFIX . "thread AS thread
			LEFT JOIN " . TABLE_PREFIX . "post AS post ON (post.threadid = thread.threadid)
			WHERE (thread.threadid > " . $_REQUEST['startat'] . ") AND (thread.threadid < " . ($_REQUEST['startat'] + $_REQUEST['percycle']) . ")
			ORDER BY thread.threadid, post.postid
		");
		while ($threadpost = $vbulletin->db->fetch_array($threadposts))
		{
			// bbcode is included in the points calculations
			$threadpost['message'] = $threadpost['pagetext'];

			// check if this is the first post in the thread
			if ($threadpost['firstpostid'] == $threadpost['postid'])
			{
				// set the $type to be a thread
				$type = 'thread';
			}
			else
			{
				// set the $type to be a post
				$type = 'post';
			}

			// add this to the postcache
			$postcache["$threadpost[postid]"] = vbplaza_calculate_post_points($threadpost, $threadpost['forumid'], $type);
		}

		// free the threadposts
		$vbulletin->db->free_result($threadposts);

		// increase $_REQUEST['startat']
		$_REQUEST['startat'] += $_REQUEST['percycle'];

		// check if there are any posts to update
		if (!empty($postcache) && is_array($postcache))
		{
			// process all of the updated posts
			foreach($postcache AS $postid => $points)
			{
				// send off the query to update the points
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET vbbux = '" . $points . "' WHERE postid = '" . $postid . "'");
			}

			// need to redirect again
			print_cp_redirect("vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=rebuildpostpoints&amp;percycle=" . $_REQUEST['percycle'] . "&amp;startat=" . $_REQUEST['startat']);
		}
		else
		{
			// display message that the rebuild post points was successful
			print_form_header('vbplaza', 'rebuildpostpoints');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_rebuild_post_points'] . "</font>", 2);
			print_description_row($vbphrase['vbplaza_process_completed_successfully']);
			print_table_footer(2, "");
		}
	}
	else
	{
		// display a confirmation
		print_form_header('vbplaza', 'rebuildpostpoints');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_rebuild_post_points'] . "</font>", 2);
		construct_hidden_code('lastuserid', $lastuser['userid']);
		print_description_row($vbphrase['vbplaza_rebuild_post_points_warning']);
		print_input_row($vbphrase['vbplaza_number_of_users_to_process_per_cycle'], 'percycle', '100');
		print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_rebuild_post_points'] . "\" accesskey=\"s\" />");
	}
}

// check if its trying try to update the auto patches
if ($_POST['do'] == 'doautopatch')
{
	// force the update variables
	$_POST['update'] = '1';
	$_REQUEST['do'] = 'autopatch';
}

// check if its trying to do the autopatch
if ($_REQUEST['do'] == 'autopatch')
{
	// include the template changes
	require_once(DIR . '/includes/templates_vbplaza.php');

	// setup $doupdate properly
	$doupdate = ($_POST['update'] == '1') ? true : false;

	// display message that you did not enter an category name
	print_form_header('vbplaza', 'doautopatch');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_auto_patch_templates'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_auto_patch_templates_description']);
	$output = vbplaza_auto_patch_templates($doupdate);
	if (!empty($output))
	{
		// display the output
		print_description_row($output);
	}
	construct_hidden_code('verify', '1');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_attempt_auto_patches'] . "\" accesskey=\"s\" />");

	// check if it needs to rebuild the styles
	if ($rebuild['styles'] == true)
	{
		// rebuild all of the styles
		build_all_styles();
	}
}

// try to insert a new category
if ($_POST['do'] == 'insertcategory')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category ORDER BY displayorder");
	while ($category = $vbulletin->db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// look for a valid categoryid to use for insertion
	for ($categoryid = 101; $categoryid < 10000; $categoryid++)
	{
		// check if this category exists already
		if (empty($vbplazacategories[$categoryid]))
		{
			// break out of this for loop
			break;
		}
	}

	// verify that some fields were given for sure
	if (empty($_POST['category']['name']))
	{
		// display message that you did not enter an category name
		print_form_header('vbplaza', 'addcategory');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['category']) . "</font>", 2);
		print_description_row(construct_phrase($vbphrase['vbplaza_add_no_x_name'], $vbphrase['vbplaza_category']));
		print_table_footer(2, "");
	}
	else if (empty($_POST['category']['description']))
	{
		// display message that you did not enter an category name
		print_form_header('vbplaza', 'addcategory');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['category']) . "</font>", 2);
		print_description_row(construct_phrase($vbphrase['vbplaza_add_no_x_description'], $vbphrase['vbplaza_category']));
		print_table_footer(2, "");
	}
	else
	{
		// check if allowed/denied groups are found
		if (!isset($_POST['category']['allowedgroups'])) { $_POST['category']['allowedgroups'] = array(); }
		if (!isset($_POST['category']['deniedgroups'])) { $_POST['category']['deniedgroups'] = array(); }

		// start building the querystr
		$querystr = '';
		foreach($_POST['category'] AS $key => $field)
		{
			// check if it needs to add a comma
			if (!empty($querystr)) { $querystr .= ", "; }

			// check if this is the inputfields field
			if ($key == 'inputfields')
			{
				// process all inputfields to remove any empty ones
				foreach($_POST['category']['inputfields'] AS $fieldkey => $inputfield)
				{
					// check if the phrasename is valid
					if (empty($inputfield['phrasename']))
					{
						// unset this inputfield
						unset($_POST['category']['inputfields'][$fieldkey]);
					}
				}

				// serialize the inputfields
				$field = serialize($_POST['category']['inputfields']);
			}

			// check if this key is the allowedgroups
			if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
			{
				// check if $field is an array
				$usergroups = '';
				if (is_array($field))
				{
					// process all of the groups
					foreach($field AS $usergroupid)
					{
						// check if $usergroups is not empty
						if (!empty($usergroups)) { $usergroups .= ","; }
						$usergroups .= $usergroupid;
					}
				}

				// reset the $field
				$field = $usergroups;
			}

			// add this field to the query
			$querystr .= $key . " = '" . addslashes($field) . "'";
		}

		// first insert the new category into the database
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "vbplaza_category (categoryid) VALUES ('" . $categoryid . "')");

		// now send the query to update the fields properly
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "vbplaza_category
			SET
				" . $querystr . "
			WHERE categoryid = '" . $categoryid . "'
		");

		// update the datastore
		vbplaza_update_datastore(true);

		// do the redirect now
		define('CP_REDIRECT', 'vbplaza.php?do=categorylist');
		print_stop_message('saved_settings_successfully');
	}
}

// try to insert a new option
if ($_POST['do'] == 'insertoption')
{
	// look for a valid itemid to use for insertion
	for ($itemid = 501; $itemid < 10000; $itemid++)
	{
		// check if this option exists already
		if (empty($vbplazaoptions[$itemid]))
		{
			// break out of this for loop
			break;
		}
	}

	// verify that some fields were given for sure
	if (empty($_POST['item']['name']))
	{
		// display message that you did not enter an item name
		print_form_header('vbplaza', 'addoption');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_add_new_option'] . "</font>", 2);
		print_description_row(construct_phrase($vbphrase['vbplaza_add_no_x_name'], $vbphrase['vbplaza_item']));
		print_table_footer(2, "");
	}
	else if (empty($_POST['item']['description']))
	{
		// display message that you did not enter an option name
		print_form_header('vbplaza', 'addoption');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_add_new_option'] . "</font>", 2);
		print_description_row(construct_phrase($vbphrase['vbplaza_add_no_x_description'], $vbphrase['vbplaza_item']));
		print_table_footer(2, "");
	}
	else
	{
		// check if allowed/denied groups are found
		if (!isset($_POST['item']['allowedgroups'])) { $_POST['item']['allowedgroups'] = array(); }
		if (!isset($_POST['item']['deniedgroups'])) { $_POST['item']['deniedgroups'] = array(); }

		// check if this item is one that will refill
		if ($_POST['item']['defquantity'] > 0)
		{
			// fixup the proper refilldateline
			$_POST['item']['refilldateline'] = TIMENOW + ($_POST['item']['expirydate'] * 86400);
		}

		// start building the querystr
		$querystr = '';
		foreach($_POST['item'] AS $key => $field)
		{
			// check if it needs to add a comma
			if (!empty($querystr)) { $querystr .= ", "; }

			// check if this is the inputfields field
			if ($key == 'inputfields')
			{
				// process all inputfields to remove any empty ones
				foreach($_POST['item']['inputfields'] AS $fieldkey => $inputfield)
				{
					// check if the phrasename is valid
					if (empty($inputfield['phrasename']))
					{
						// unset this inputfield
						unset($_POST['item']['inputfields'][$fieldkey]);
					}
				}

				// serialize the inputfields
				$field = serialize($_POST['item']['inputfields']);
			}

			// check if this is the optionsettings field
			if ($key == 'optionsettings')
			{
				// process all optionsettings to remove any empty ones
				foreach($_POST['item']['optionsettings'] AS $fieldkey => $optionsetting)
				{
					// check if the phrasename is valid
					if (!$optionsetting['type'] || empty($optionsetting['varname']))
					{
						// unset this optionsetting
						unset($_POST['item']['optionsettings'][$fieldkey]);
					}
				}

				// serialize the optionsettings
				$field = serialize($_POST['item']['optionsettings']);
			}

			// check if this key is the allowedgroups
			if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
			{
				// check if $field is an array
				$usergroups = '';
				if (is_array($field))
				{
					// process all of the groups
					foreach($field AS $usergroupid)
					{
						// check if $usergroups is not empty
						if (!empty($usergroups)) { $usergroups .= ","; }
						$usergroups .= $usergroupid;
					}
				}

				// reset the $field
				$field = $usergroups;
			}

			// add this field to the query
			$querystr .= $key . " = '" . addslashes($field) . "'";
		}

		// first insert the new item into the database
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "vbplaza_item (itemid) VALUES ('" . $itemid . "')");

		// now send the query to update the fields properly
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "vbplaza_item
			SET
				" . $querystr . "
			WHERE itemid = '" . $itemid . "'
		");

		// update the datastore
		vbplaza_update_datastore(true);

		// do the redirect now
		define('CP_REDIRECT', 'vbplaza.php?do=itemlist');
		print_stop_message('saved_settings_successfully');
	}
}

// try to insert a new option
if ($_POST['do'] == 'insertoptioncopy')
{
	// look for a valid itemid to use for insertion
	for ($itemid = 501; $itemid < 10000; $itemid++)
	{
		// check if this option exists already
		if (empty($vbplazaoptions[$itemid]))
		{
			// break out of this for loop
			break;
		}
	}

	// process all of the fields
	$querystr = '';
	foreach($vbplazaoptions[$_POST['itemid']] AS $fieldname => $fieldvalue)
	{
		// skip over 'itemid'
		if ($fieldname == 'itemid') { continue; }

		// check if it needs to add a comma
		if (!empty($querystr)) { $querystr .= ", "; }

		// check if the value is a string
		if (is_string($fieldvalue))
		{
			// add this to the $querystr via escape_string
			$querystr .= $fieldname . " = '" . $vbulletin->db->escape_string($fieldvalue) . "'";
		}
		else
		{
			// add this to the $querystr
			$querystr .= $fieldname . " = " . $fieldvalue;
		}
	}

	// first insert the new item into the database
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "vbplaza_item (itemid) VALUES ('" . $itemid . "')");

	// now send the query to update the fields properly
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "vbplaza_item
		SET
			" . $querystr . "
		WHERE itemid = '" . $itemid . "'
	");

	// update the datastore
	vbplaza_update_datastore(true);

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza.php?do=itemlist');
	print_stop_message('saved_settings_successfully');
}

// update the category settings
if ($_POST['do'] == 'updatecategory')
{
	// check if its deleting an option
	if (isset($_POST['delete']))
	{
		// get the category name
		$category = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category WHERE categoryid = '" . $_POST['categoryid'] . "'");

		// verify they want to delete the category
		if (!isset($_POST['verify']))
		{
			// display message to verify that you want to delete this category
			print_form_header('vbplaza', 'updatecategory');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_delete_category_warning'] . " - " . $category['name'] . "</font>", 2);
			print_description_row($vbphrase['vbplaza_delete_category_warning_message']);
			construct_hidden_code('verify', '1');
			construct_hidden_code('categoryid', $_POST['categoryid']);
			print_table_footer(2, "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_category']) . "\" accesskey=\"s\" />");
		}
		else
		{
			// verify the category is deletable
			if (is_numeric($_POST['categoryid']) && ($_REQUEST['categoryid'] >= 101))
			{
				// delete this category from the vbplaza_category table
				$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_category WHERE categoryid = '" . $_POST['categoryid'] . "'");
			}

			// update the datastore
			vbplaza_update_datastore(true);

			// do the redirect now
			define('CP_REDIRECT', 'vbplaza.php?do=categorylist');
			print_stop_message('saved_settings_successfully');
		}
	}
	else
	{
		// update the category's settings
		if (is_numeric($_POST['categoryid']) && is_array($_POST['category']))
		{
			// check if allowed/denied groups are found
			if (!isset($_POST['category']['allowedgroups'])) { $_POST['category']['allowedgroups'] = array(); }
			if (!isset($_POST['category']['deniedgroups'])) { $_POST['category']['deniedgroups'] = array(); }

			// build the querystr
			$querstr = '';
			foreach($_POST['category'] AS $key => $field)
			{
				// check if it should add a comma
				if (isset($querystr)) { $querystr .= ", "; }

				// check if this key is the allowedgroups
				if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
				{
					// check if $field is an array
					$usergroups = '';
					if (is_array($field))
					{
						// process all of the groups
						foreach($field AS $usergroupid)
						{
							// check if $usergroups is not empty
							if (!empty($usergroups)) { $usergroups .= ","; }
							$usergroups .= $usergroupid;
						}
					}

					// reset the $field
					$field = $usergroups;
				}

				// add this field
				$querystr .= "$key = '" . addslashes($field) . "'";
			}

			// if there is a querystr, run it
			if (isset($querystr))
			{
				// send the query to update
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_category
					SET
						" . $querystr . "
					WHERE categoryid = '" . $_POST['categoryid'] . "'
				");
			}
		}

		// update the datastore
		vbplaza_update_datastore(true);

		// do the redirect now
		define('CP_REDIRECT', 'vbplaza.php?do=categorylist');
		print_stop_message('saved_settings_successfully');
	}
}

// update the settings
if ($_POST['do'] == 'updateoption')
{
	// check if its deleting an option
	if (isset($_POST['delete']))
	{
		// verify they want to delete the option
		if (!isset($_POST['verify']))
		{
			// display message to verify that you want to delete this option
			print_form_header('vbplaza', 'updateoption');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_delete_option_warning'] . " - " . $vbplazaoptions[$_POST['itemid']]['name'] . "</font>", 2);
			print_description_row($vbphrase['vbplaza_delete_option_warning_message']);
			construct_hidden_code('verify', '1');
			construct_hidden_code('itemid', $_POST['itemid']);
			print_table_footer(2, "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_option']) . "\" accesskey=\"s\" />");
		}
		else
		{
			// verify the item is deletable
			if (is_numeric($_POST['itemid']) && (($_REQUEST['itemid'] >= 501) || (($_REQUEST['itemid'] >= 71) && ($_REQUEST['itemid'] <= 109))))
			{
				// delete this item from the vbplazaoptions table
				$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_item WHERE itemid = '" . $_POST['itemid'] . "'");
			}

			// update the datastore
			vbplaza_update_datastore(true);

			// do the redirect now
			define('CP_REDIRECT', 'vbplaza.php?do=itemlist');
			print_stop_message('saved_settings_successfully');
		}
	}
	else
	{
		// update the item's settings
		require_once(DIR . '/includes/functions_misc.php');
		if (is_numeric($_POST['itemid']) && is_array($_POST['item']))
		{
			// check if allowed/denied groups are found
			if (!isset($_POST['item']['allowedgroups'])) { $_POST['item']['allowedgroups'] = array(); }
			if (!isset($_POST['item']['deniedgroups'])) { $_POST['item']['deniedgroups'] = array(); }

			// build the querystr
			$querstr = '';
			foreach($_POST['item'] AS $key => $field)
			{
				// check if it should add a comma
				if (isset($querystr)) { $querystr .= ", "; }

				// check if this is the inputfields field
				if ($key == 'inputfields')
				{
					// process all inputfields to remove any empty ones
					foreach($_POST['item']['inputfields'] AS $fieldkey => $inputfield)
					{
						// check if the phrasename is valid
						if (empty($inputfield['phrasename']))
						{
							// unset this inputfield
							unset($_POST['item']['inputfields'][$fieldkey]);
						}
					}

					// serialize the inputfields
					$field = serialize($_POST['item']['inputfields']);
				}

				// check if this is the optionsettings field
				if ($key == 'optionsettings')
				{
					// process all optionsettings to remove any empty ones
					foreach($_POST['item']['optionsettings'] AS $fieldkey => $optionsetting)
					{
						// check if the phrasename is valid
						if (!$optionsetting['type'] || empty($optionsetting['varname']))
						{
							// unset this optionsetting
							unset($_POST['item']['optionsettings'][$fieldkey]);
						}
					}

					// serialize the optionsettings
					$field = serialize($_POST['item']['optionsettings']);
				}

				// check if this key is the refilldateline
				if ($key == 'refilldateline')
				{
					// rebuild the unix time stamp
					$field = vbmktime($field['hour'], $field['minute'], $field['second'], $field['month'], $field['day'], $field['year']);

					// verify that the $field is valid
					if ($field < 0)
					{
						// force it to the current time
						$field = TIMENOW;
					}
				}

				// check if this key is the allowedgroups
				if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
				{
					// check if $field is an array
					$usergroups = '';
					if (is_array($field))
					{
						// process all of the groups
						foreach($field AS $usergroupid)
						{
							// check if $usergroups is not empty
							if (!empty($usergroups)) { $usergroups .= ","; }
							$usergroups .= $usergroupid;
						}
					}

					// reset the $field
					$field = $usergroups;
				}

				// add this field
				$querystr .= "$key = '" . addslashes($field) . "'";
			}

			// if there is a querystr, run it
			if (isset($querystr))
			{
				// send the query to update
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_item
					SET
						" . $querystr . "
					WHERE itemid = '" . $_POST['itemid'] . "'
				");
			}
		}

		// update the datastore
		vbplaza_update_datastore(true);

		// do the redirect now
		define('CP_REDIRECT', 'vbplaza.php?do=itemlist');
		print_stop_message('saved_settings_successfully');
	}
}

// check if its updating the subscriptions
if ($_POST['do'] == 'subscriptionupdate')
{
	// check that order is an array
	if (is_array($_POST['subscription']))
	{
		// process all of the subscriptions
		foreach($_POST['subscription'] AS $subscriptionid => $subscription)
		{
			// send the query to update
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "subscription
				SET
					vbp_vbbuxsub = '" . $subscription['vbp_vbbuxsub'] . "',
					displayorder = '" . $subscription['displayorder'] . "'
				WHERE subscriptionid = '" . $subscriptionid . "'
			");
		}
	}

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza.php?do=subscriptionlist');
	print_stop_message('saved_settings_successfully');
}

// check if its updating the categories
if ($_POST['do'] == 'categoryupdate')
{
	// check that order is an array
	if (is_array($_POST['categoryorder']) && is_array($_POST['categoryactive']))
	{
		// process all of the vbplazacategories
		$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category");
		while ($category = $vbulletin->db->fetch_array($categories))
		{
			// check if this display order was set
			if (!isset($_POST['categoryorder']["$category[categoryid]"]))
			{
				continue;
			}

			// send the query to update
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "vbplaza_category
				SET
					active = '" . $_POST['categoryactive']["$category[categoryid]"] . "',
					displayorder = '" . $_POST['categoryorder']["$category[categoryid]"] . "'
				WHERE categoryid = '" . $category['categoryid'] . "'
			");
		}

		// free the categories
		$vbulletin->db->free_result($categories);
	}

	// update the datastore
	vbplaza_update_datastore(true);

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza.php?do=categorylist');
	print_stop_message('saved_settings_successfully');
}

// check if its updating the options
if ($_POST['do'] == 'optionsupdate')
{
	// check that order is an array
	if (is_array($_POST['item']))
	{
		// process each item
		foreach($_POST['item'] AS $itemid => $item)
		{
			// process each field
			$queryfields = array();
			foreach($item AS $key => $field)
			{
				// add this to the $queryfields
				if (is_string($field))
				{
					// add this to the $queryfields serialized
					$queryfields[] = $key . " = '" . $vbulletin->db->escape_string($field) . "'";
				}
				else
				{
					// add this to the $queryfields
					$queryfields[] = $key . " = '" . $field . "'";
				}
			}

			// build the queryfields
			$querystr = implode(", ", $queryfields);
			if (!empty($querystr))
			{
				// send the query to update
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_item
					SET
						" . $querystr . "
					WHERE itemid = '" . $itemid . "'
				");
			}
		}
	}

	// update the datastore
	vbplaza_update_datastore(true);

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza.php?do=itemlist');
	print_stop_message('saved_settings_successfully');
}

// check if it should update the arcade codes
if ($_POST['do'] == 'updatearcadecosts')
{
	// check that games is an array
	if (is_array($_POST['games']))
	{
		// process each game
		foreach($_POST['games'] AS $gameid => $game)
		{
			// process each field
			$queryfields = array();
			foreach($game AS $key => $field)
			{
				// add this to the $queryfields
				if (is_string($field))
				{
					// add this to the $queryfields serialized
					$queryfields[] = $key . " = '" . $vbulletin->db->escape_string($field) . "'";
				}
				else
				{
					// add this to the $queryfields
					$queryfields[] = $key . " = '" . $field . "'";
				}
			}

			// build the queryfields
			$querystr = implode(",", $queryfields);
			if (!empty($querystr))
			{
				// send the query for ibproarcade
				if ($_POST['arcadetype'] == 'ibproarcade')
				{
					// send the query to update
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "games_list
						SET
							" . $querystr . "
						WHERE gid = '" . $gameid . "'
					");
				}
				// send the query for v3arcade
				else if ($_POST['arcadetype'] == 'v3arcade')
				{
					// send the query to update
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . "arcade_games
						SET
							" . $querystr . "
						WHERE gameid = '" . $gameid . "'
					");
				}
			}
		}
	}

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza.php?do=arcadecosts');
	print_stop_message('saved_settings_successfully');
}

// check if it should start the uCash Intergration
if ($_POST['do'] == 'ucashintegrate')
{
	// get the proper field that the user has installed
	unset($ucashfield);
	if (!empty($vbulletin->userinfo['uttpoints'])) { $ucashfield = 'uttpoints'; }
	else if (!empty($vbulletin->userinfo['ucash'])) { $ucashfield = 'ucash'; }

	// check if the field was found
	if (!isset($ucashfield))
	{
		// display message that you do not have uCash installed
		print_form_header('vbplaza', 'ucashintegrate');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_ucash_integration'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_ucash_not_installed']);
		print_table_footer(2, "");
	}
	else
	{
		// display message that you do not have uCash installed
		print_form_header('vbplaza', 'itemlist');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_ucash_integration'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_could_take_a_while']);
		print_table_footer(2, "");

		// process the proper database changes
		if ($ucashfield == 'uttpoints')
		{
			// write the database changes
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "forum SET vbbux_perview=uttpoints_perview, vbbux_perthread=uttpoints_perthread, vbbux_perreply=uttpoints_perreply");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET " . $vbulletin->options['vbbux_pointsfield'] . " = uttpoints");
		}
		else
		{
			// write the database changes
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "forum SET vbbux_perview=ucash_perview, vbbux_perthread=ucash_perthread, vbbux_perreply=ucash_perreply");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET " . $vbulletin->options['vbbux_pointsfield'] . " = ucash");
		}

		// display message that the integration was successful
		print_form_header('vbplaza', 'itemlist');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_ucash_integration'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_process_completed_successfully']);
		print_table_footer(2, "");
	}
}

// check if it should clear the user points
if ($_POST['do'] == 'resetpoints')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET " . $vbulletin->options['vbbux_pointsfield'] . " = 0");

	// display message that the mass give away was completed successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_mass_points_clear'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_description_row(construct_phrase($vbphrase['vbplaza_process_completed_zero_points'], $vbphrase['vbbux_name']));
	print_table_footer(2, "");
}

// check if it should clear the bank accounts
if ($_POST['do'] == 'resetbank')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET " . $vbulletin->options['vbbux_bankfield'] . " = 0");

	// display message that the mass give away was completed successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_mass_bank_clear'] . "</font>", 2);
	print_description_row(construct_phrase($vbphrase['vbplaza_process_completed_zero_bank'], $vbphrase['vbbux_name']));
	print_table_footer(2, "");
}

// check if its resetting all bank interest intervals
if ($_POST['do'] == 'resetbankintervals')
{
	// perform the queries
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_nextbankinterest = ". (TIMENOW + $vbulletin->options['vbbux_bankinterestinterval']) . " WHERE " . $vbulletin->options['vbbux_bankfield'] . " > 0");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_nextbankinterest = 0 WHERE (" . $vbulletin->options['vbbux_bankfield'] . " = 0) AND (vbp_nextbankinterest > 0)");

	// display message that the refill was successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_reset_all_bank_intervals'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its clearing all user always change items
if ($_POST['do'] == 'resetuseralwayschange')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_changealwaysitems = ''");

	// display message that the refill was successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_always_change_items'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its clearing all user history
if ($_POST['do'] == 'resetuserhistory')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_history = ''");

	// display message that the refill was successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_purchase_history'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its clearing all user display flags
if ($_POST['do'] == 'resetdisplayflags')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_displayflags = '0'");

	// display message that the refill was successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_display_flags'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its clearing all user other flags
if ($_POST['do'] == 'resetotherflags')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_otherflags = '0'");

	// display message that the refill was successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_other_flags'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its clearing all user immunity
if ($_POST['do'] == 'resetimmunity')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET vbp_immunity = '0'");

	// display message that the refill was successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_immunity'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if it should start the mass giveaway
if ($_POST['do'] == 'resetpoststopoints')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " SET " . $vbulletin->options['vbbux_pointsfield'] . " = posts");

	// display message that the mass give away was completed successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_mass_posts_to_points'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its refilling the items
if ($_POST['do'] == 'refillalloptions')
{
	// perform the query
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "vbplaza_item SET quantity = defquantity, refilldateline = ". (TIMENOW + $vbulletin->options['vbplaza_defaultrefillrate']));

	// update the datastore
	vbplaza_update_datastore(true);

	// display message that the refill was successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_refill_all_items'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its searching for users
if ($_REQUEST['do'] == 'findusers')
{
	// build the search terms if any
	$searchterms = array();
	if (is_numeric($_REQUEST['userid']))
	{
		// add this to the search terms
		$searchterms[] = "userid = '" . $_REQUEST['userid'] . "'";
	}
	if (!empty($_REQUEST['username']))
	{
		// add this to the search terms
		$searchterms[] = "username LIKE '%" . $vbulletin->db->escape_string($_REQUEST['username']) . "%'";
	}
	if (!empty($_REQUEST['displayflags']))
	{
		// check if its an array
		if (is_array($_REQUEST['displayflags']))
		{
			// process each field
			$searchbits = 0;
			foreach($_REQUEST['displayflags'] AS $key => $bool)
			{
				// see if this option is checked
				if ($bool)
				{
					// add this option to the $searchbits
					$searchbits |= $vbulletin->bf_misc_vbpdisplayflags["$key"];
				}
			}

			// reset $_REQUEST['displayflags']
			$_REQUEST['displayflags'] = $searchbits;
		}

		// check if the value is numeric
		if (is_numeric($_REQUEST['displayflags']) && ($_REQUEST['displayflags'] > 0))
		{
			// add this to the search terms
			$searchterms[] = "vbp_displayflags & " . $_REQUEST['displayflags'];
		}
	}
	if (!empty($_REQUEST['otherflags']))
	{
		// check if its an array
		if (is_array($_REQUEST['otherflags']))
		{
			// process each field
			$searchbits = 0;
			foreach($_REQUEST['otherflags'] AS $key => $bool)
			{
				// see if this option is checked
				if ($bool)
				{
					// add this option to the $searchbits
					$searchbits |= $vbulletin->bf_misc_vbpotherflags["$key"];
				}
			}

			// reset $_REQUEST['otherflags']
			$_REQUEST['otherflags'] = $searchbits;
		}

		// check if the value is numeric
		if (is_numeric($_REQUEST['otherflags']) && ($_REQUEST['otherflags'] > 0))
		{
			// add this to the search terms
			$searchterms[] = "vbp_otherflags & " . $_REQUEST['otherflags'];
		}
	}
	if (!empty($_REQUEST['immunity']))
	{
		// check if its an array
		if (is_array($_REQUEST['immunity']))
		{
			// process each field
			$searchbits = 0;
			foreach($_REQUEST['immunity'] AS $key => $bool)
			{
				// see if this option is checked
				if ($bool)
				{
					// add this option to the $searchbits
					$searchbits |= $vbulletin->bf_misc_vbpimmunity["$key"];
				}
			}

			// reset $_REQUEST['immunity']
			$_REQUEST['immunity'] = $searchbits;
		}

		// check if the value is numeric
		if (is_numeric($_REQUEST['immunity']) && ($_REQUEST['immunity'] > 0))
		{
			// add this to the search terms
			$searchterms[] = "vbp_immunity & " . $_REQUEST['immunity'];
		}
	}

	// check if there are any searchterms
	if (!empty($searchterms))
	{
		// implode the string
		$wherestr = "WHERE " . implode(" OR ", $searchterms);
	}

	// verify that $_REQUEST['page'] is set
	$perpage = 50;
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check out how many items are found like this
	$usertotals = $vbulletin->db->query_first("
		SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "user
		" . $wherestr . "
	");

	// check if any rows were found
	if ($usertotals['count'] > 0)
	{
		// build the total page
		$totalpages = ceil($usertotals['count'] / $perpage);

		// select the rows from the database
		$users = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "user
			" . $wherestr . "
			ORDER BY userid
			" . $limitstr . "
		");

		// process the users
		$usercache = array();
		while ($user = $vbulletin->db->fetch_array($users))
		{
			// add this user
			$usercache["$user[userid]"] = $user;
		}

		// free the users
		$vbulletin->db->free_result($users);

		// check if its not the first page
		if ($_REQUEST['page'] != 1)
		{
			$prv = $_REQUEST['page'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=findusers&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&displayflags=" . $_REQUEST['displayflags'] . "&otherflags=" . $_REQUEST['otherflags'] . "&immunity=" . $_REQUEST['immunity'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=findusers&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&displayflags=" . $_REQUEST['displayflags'] . "&otherflags=" . $_REQUEST['otherflags'] . "&immunity=" . $_REQUEST['immunity'] . "&page=$prv'\">";
		}
		if ($_REQUEST['page'] != $totalpages)
		{
			$nxt = $_REQUEST['page'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=findusers&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&displayflags=" . $_REQUEST['displayflags'] . "&otherflags=" . $_REQUEST['otherflags'] . "&immunity=" . $_REQUEST['immunity'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=findusers&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&displayflags=" . $_REQUEST['displayflags'] . "&otherflags=" . $_REQUEST['otherflags'] . "&immunity=" . $_REQUEST['immunity'] . "&page=$totalpages'\">";
		}

		// a little javascript for the options menus
		?>
		<script type="text/javascript">
		function js_usergroup_jump(userinfo)
		{
			var value = eval("document.cpform.u" + userinfo + ".options[document.cpform.u" + userinfo + ".selectedIndex].value");
			if (value != "")
			{
				switch (value)
				{
					case 'edit': page = "edit&u=" + userinfo; break;
					case 'kill': page = "remove&u=" + userinfo; break;
					case 'access': page = "editaccess&u=" + userinfo; break;
					default: page = "emailpassword&email=" + value; break;
				}
				window.location = "user.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=" + page;
			}
		}
		</script>
		<?php

		// start displaying the users
		print_form_header('vbplaza', 'searchusers');
		print_description_row(construct_link_code($vbphrase['restart'], "vbplaza.php?do=searchusers"), 0, 6, 'thead', $stylevar['right']);
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_users'] . "</font>", 6);
		print_cells_row(array($vbphrase['username'], $vbphrase['email'], $vbphrase['join_date'], $vbphrase['last_activity'], $vbphrase['post_count'], $vbphrase['options']), 1, 'tcat');

		// process each row
		foreach($usercache AS $userid => $user)
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = "<a href=\"user.php?do=edit&amp;u=" . $user['userid'] . "\">" . $user['username'] . "</a>";
			$cell[] = "<a href=\"mailto:" . $user['email'] . "\">" . $user['email'] . "</a>";
			$cell[] = vbdate($vbulletin->options['dateformat'], $user['joindate']);
			$cell[] = vbdate($vbulletin->options['dateformat'], $user['lastactivity']);
			$cell[] = vb_number_format($user['posts']);
			$cell[] = "\n\t<select name=\"u$user[userid]\" onchange=\"js_usergroup_jump($user[userid]);\" class=\"bginput\">
			<option value=\"edit\">$vbphrase[view] / " . $vbphrase['edit_user'] . "</option>"
			. iif(!empty($user['email']), "<option value=\"" . unhtmlspecialchars($user[email]) . "\">" . $vbphrase['send_password_to_user'] . "</option>") . "
			<option value=\"access\">" . $vbphrase['edit_access_masks'] . "</option>
			<option value=\"kill\">" . $vbphrase['delete_user'] . "</option>\n\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_usergroup_jump($user[userid]);\" />\n\t";
			print_cells_row($cell);
		}

		// finish off the footer
		print_table_footer(6, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		// display message that nothing was found
		print_form_header('vbplaza', 'searchusers');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_users'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_users_found']);
		print_table_footer(2, "");
	}
}

// check if its searching the item history
if ($_REQUEST['do'] == 'searchitemhistory')
{
	// build the search terms if any
	$searchterms = array();
	if (is_numeric($_REQUEST['userid']))
	{
		// add this to the search terms
		$searchterms[] = "userid = '" . $_REQUEST['userid'] . "'";
	}
	if (!empty($_REQUEST['username']))
	{
		// add this to the search terms
		$searchterms[] = "username LIKE '%" . $vbulletin->db->escape_string($_REQUEST['username']) . "%'";
	}
	if (is_numeric($_REQUEST['itemid']))
	{
		// add this to the search terms
		$searchterms[] = "itemid = '" . $_REQUEST['itemid'] . "'";
	}
	if (!empty($_REQUEST['itemname']))
	{
		// add this to the search terms
		$searchterms[] = "itemname LIKE '%" . $vbulletin->db->escape_string($_REQUEST['itemname']) . "%'";
	}

	// check if there are any searchterms
	if (!empty($searchterms))
	{
		// implode the string
		$wherestr = "WHERE " . implode(" OR ", $searchterms);
	}

	// verify that $_REQUEST['page'] is set
	$perpage = 50;
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check out how many items are found like this
	$itemhistory = $vbulletin->db->query_first("
		SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_itemhistory
		" . $wherestr . "
	");

	// check if any rows were found
	if ($itemhistory['count'] > 0)
	{
		// build the total page
		$totalpages = ceil($itemhistory['count'] / $perpage);

		// select the rows from the database
		$items = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_itemhistory
			" . $wherestr . "
			ORDER BY dateline DESC
			" . $limitstr . "
		");

		// process each item
		$itemcache = array();
		while ($item = $vbulletin->db->fetch_array($items))
		{
			// add this item
			$itemcache["$item[itemid]"] = $item;
		}

		// free the items
		$vbulletin->db->free_result($items);

		// check if its not the first page
		if ($_REQUEST['page'] != 1)
		{
			$prv = $_REQUEST['page'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchitemhistory&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchitemhistory&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$prv'\">";
		}
		if ($_REQUEST['page'] != $totalpages)
		{
			$nxt = $_REQUEST['page'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchitemhistory&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbplaza.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchitemhistory&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$totalpages'\">";
		}

		// start displaying the items found
		print_form_header('vbplaza', 'searchitemhistory');
		print_description_row(construct_link_code($vbphrase['restart'], "vbplaza.php?do=itemhistory"), 0, 5, 'thead', $stylevar['right']);
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_item_history'] . "</font>", 5);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_history']), construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_item']), $vbphrase['vbplaza_item_name'], $vbphrase['vbplaza_item_purchaser'], $vbphrase['vbplaza_item_purchase_date']), 1, 'tcat');

		// process each row
		foreach($itemcache AS $itemid => $item)
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = $item['historyid'];
			$cell[] = $item['itemid'];
			$cell[] = $item['itemname'];
			$cell[] = $item['username'];
			$cell[] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $item['dateline']);
			print_cells_row($cell);
		}

		// finish off the footer
		print_table_footer(5, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		// display message that nothing was found
		print_form_header('vbplaza', 'searchitemhistory');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_item_history'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_item_history_found']);
		print_table_footer(2, "");
	}
}

// check if its setting all forum settings
if ($_POST['do'] == 'setforums')
{
	// send all of the queries off
	$buildforums = false;
	if (!empty($_POST['perview']) && is_numeric($_POST['perview']))
	{
		// send off the query to set the vbbux_perview
		$buildforums = true;
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "forum SET vbbux_perview = " . $_POST['perview']);
	}
	if (!empty($_POST['perthread']) && is_numeric($_POST['perthread']))
	{
		// send off the query to set the vbbux_perthread
		$buildforums = true;
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "forum SET vbbux_perthread = " . $_POST['perthread']);
	}
	if (!empty($_POST['perreply']) && is_numeric($_POST['perreply']))
	{
		// send off the query to set the vbbux_perreply
		$buildforums = true;
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "forum SET vbbux_perreply = " . $_POST['perreply']);
	}

	// check if its needed to $buildforums
	if ($buildforums == true)
	{
		// rebuild the forum permissions
		build_forum_permissions();
	}

	// display message that the mass give away was completed successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_mass_forums_settings'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if it should update all arcade costs
if ($_POST['do'] == 'updateallarcadecosts')
{
	// verify that they have entered a valid value
	if (is_numeric($_POST['globalcost']) && ($_POST['globalcost'] > 0))
	{
		// update the proper arcade
		if ($_POST['arcadetype'] == 'ibproarcade')
		{
			// send the query to update
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "games_list
				SET
					cost = '" . $_POST['globalcost'] . "'
			");
		}
		else if ($_POST['arcadetype'] == 'v3arcade')
		{
			// send the query to update
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "arcade_games
				SET
					cost = '" . $_POST['globalcost'] . "'
			");
		}
	}

	// display a confirmation
	print_form_header('vbplaza', 'updatearcadecosts');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_update_all_arcade_games_cost'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if it should start the mass giveaway
if ($_POST['do'] == 'massgive')
{
	// build the fields to be processed
	unset($querystr);
	if (is_numeric($_POST['points']) && ($_POST['points'] > 0))
	{
		// add this to the query string
		$querystr .= $vbulletin->options['vbbux_pointsfield'] . " = " . $vbulletin->options['vbbux_pointsfield'] . " + " . $_POST['points'];
	}
	if (is_numeric($_POST['bank']) && ($_POST['bank'] > 0))
	{
		// check if its adding to it
		if (isset($querystr)) { $querystr .= ", "; }
		$querystr .= $vbulletin->options['vbbux_bankfield'] . " = " . $vbulletin->options['vbbux_bankfield'] . " + " . $_POST['bank'];
	}

	// check if usergroups are specified
	unset($wherestr);
	if (!empty($_POST['usergroups']))
	{
		// implode the array
		$usergroups = implode(",", $_POST['usergroups']);

		// setup the $wherestr
		$wherestr = "WHERE usergroupid IN(" . $usergroups . ")";
	}

	// perform the query
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
		SET
			" . $querystr . "
			" . $wherestr . "
	");

	// display message that the mass give away was completed successful
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_mass_points_giveaway'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if it should rebuild the options sold from the item history
if ($_POST['do'] == 'buildoptionssold')
{
	// cache all of the item history
	$historycache = array();
	$histories = $vbulletin->db->query_write("SELECT * FROM " . TABLE_PREFIX . "vbplaza_itemhistory");
	while ($history = $vbulletin->db->fetch_array($histories))
	{
		// cache this history entry
		$historycache[] = $history;
	}

	// verify it found some history entries
	if (!empty($historycache) && is_array($historycache))
	{
		// first clear out the statistics
		$itemstats = array();
		foreach($vbplazaoptions AS $itemid => $item)
		{
			// setup the stats that need saving
			$itemstats[$itemid]['sold'] = 0;
		}

		// start totalling up all of the statistics
		foreach($historycache AS $historyid => $history)
		{
			// increase the itemstats for this item
			$itemstats[$history['itemid']]['sold']++;
		}

		// verify it has some items to update
		if (!empty($itemstats) && is_array($itemstats))
		{
			// now send off the query to update the sold for all of the times found
			foreach($itemstats AS $itemid => $item)
			{
				// send off the query to update this item
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_item
					SET
						sold = '" . $item['sold'] . "'
					WHERE itemid = '" . $itemid . "'
				");
			}

			// update the datastore
			vbplaza_update_datastore(true);
		}
	}

	// display message that the rebuild item stats was successful
	print_form_header('vbplaza', 'rebuildoptionssold');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_rebuild_items_sold'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its clearing all user always change items
if ($_REQUEST['do'] == 'clearuseralwayschangeitems')
{
	// display a confirmation
	print_form_header('vbplaza', 'resetuseralwayschange');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_always_change_items'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_clear_user_always_change_items_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_clear_user_always_change_items'] . "\" accesskey=\"s\" />");
}

// check if its clearing all user history
if ($_REQUEST['do'] == 'clearuserhistory')
{
	// display a confirmation
	print_form_header('vbplaza', 'resetuserhistory');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_purchase_history'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_clear_user_purchase_history_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_clear_user_purchase_history'] . "\" accesskey=\"s\" />");
}

// check if its clearing all other flags
if ($_REQUEST['do'] == 'clearotherflags')
{
	// display a confirmation
	print_form_header('vbplaza', 'resetotherflags');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_other_flags'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_clear_user_other_flags_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_clear_user_other_flags'] . "\" accesskey=\"s\" />");
}

// check if its clearing all immunity
if ($_REQUEST['do'] == 'clearimmunity')
{
	// display a confirmation
	print_form_header('vbplaza', 'resetimmunity');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_immunity'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_clear_user_immunity_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_clear_user_immunity'] . "\" accesskey=\"s\" />");
}

// check if its clearing all display flags
if ($_REQUEST['do'] == 'cleardisplayflags')
{
	// display a confirmation
	print_form_header('vbplaza', 'resetdisplayflags');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_clear_user_display_flags'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_clear_user_display_flags_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_clear_user_display_flags'] . "\" accesskey=\"s\" />");
}

// check if its resetting all bank interest intervals
if ($_REQUEST['do'] == 'bankintervals')
{
	// display a confirmation
	print_form_header('vbplaza', 'resetbankintervals');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_reset_all_bank_intervals'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_reset_all_bank_intervals_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_reset_all_bank_intervals'] . "\" accesskey=\"s\" />");
}

// check if its refilling the items
if ($_REQUEST['do'] == 'refilloptions')
{
	// display a confirmation
	print_form_header('vbplaza', 'refillalloptions');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_refill_all_items'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_refill_all_items_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_refill_all_items'] . "\" accesskey=\"s\" />");
}

// check if its starting a uCash Integration
if ($_REQUEST['do'] == 'ucash')
{
	// display a confirmation
	print_form_header('vbplaza', 'ucashintegrate');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_ucash_integration'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_ucash_integration_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");
}

// check if its doing a mass forum settings
if ($_REQUEST['do'] == 'massforums')
{
	// start the mass forums feature
	print_form_header('vbplaza', 'setforums');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_mass_forums_settings'] . "</font>", 2);
	print_input_row(construct_phrase($vbphrase['vbbux_give_points_per_thread_view'], $vbphrase['vbbux_points']), 'perview', '');
	print_input_row(construct_phrase($vbphrase['vbbux_give_points_per_thread'], $vbphrase['vbbux_points']), 'perthread', '');
	print_input_row(construct_phrase($vbphrase['vbbux_give_points_per_reply'], $vbphrase['vbbux_points']), 'perreply', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");
}

// check if its doing a rebuild options sold
if ($_REQUEST['do'] == 'rebuildoptionssold')
{
	// start the rebuild options sold
	print_form_header('vbplaza', 'buildoptionssold');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_rebuild_items_sold'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_rebuild_items_sold_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_rebuild_items_sold'] . "\" accesskey=\"s\" />");
}

// check if its doing a rebuild datastore
if ($_REQUEST['do'] == 'rebuilddatastore')
{
	// update the datastore
	vbplaza_update_datastore(true);

	// display rebuild successfully	
	print_form_header('vbplaza', 'itemlist');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_rebuild_datastore'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_process_completed_successfully']);
	print_table_footer(2, "");
}

// check if its doing a mass giveaway
if ($_REQUEST['do'] == 'massgiveaway')
{
	// start the massgiveaway feature
	print_form_header('vbplaza', 'massgive');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_mass_points_giveaway'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_input_row(construct_phrase($vbphrase['vbplaza_points_to_give'], $vbphrase['vbbux_name']), 'points', '0');
	print_input_row(construct_phrase($vbphrase['vbplaza_bank_points_to_give'], $vbphrase['vbbux_name']), 'bank', '0');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");

	// start the massgiveaway for multiple usergrups
	print_form_header('vbplaza', 'massgive');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_mass_points_giveaway'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_membergroup_row($vbphrase['usergroups'], 'usergroups', 2);
	print_input_row(construct_phrase($vbphrase['vbplaza_points_to_give'], $vbphrase['vbbux_name']), 'points', '0');
	print_input_row(construct_phrase($vbphrase['vbplaza_bank_points_to_give'], $vbphrase['vbbux_name']), 'bank', '0');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");

	// start the resetpoststopoints feature
	print_form_header('vbplaza', 'resetpoststopoints');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_mass_posts_to_points'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_description_row(construct_phrase($vbphrase['vbplaza_mass_posts_to_points_warning'], $vbphrase['vbbux_name']));
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");

	// start the resetbank feature
	print_form_header('vbplaza', 'resetbank');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_mass_bank_clear'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_reset_bank_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"2\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");

	// start the resetpoints feature
	print_form_header('vbplaza', 'resetpoints');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_mass_points_clear'], $vbphrase['vbbux_name']) . "</font>", 2);
	print_description_row($vbphrase['vbplaza_reset_points_warning']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"3\" value=\"" . $vbphrase['process'] . "\" accesskey=\"s\" />");
}

// check if its adding a category
if ($_REQUEST['do'] == 'addcategory')
{
	// get the item info
	print_form_header('vbplaza', 'insertcategory');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['category']) . "</font>", 2);
	construct_hidden_code('categoryid', $_REQUEST['categoryid']);
	print_yes_no_row($vbphrase['vbplaza_active'], 'category[active]', '1');
	print_input_row(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_category']), 'category[name]', '');
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_category']), 'category[description]', '');
	print_input_row($vbphrase['display_order'], 'category[displayorder]', '500');
	print_membergroup_row($vbphrase['vbplaza_allowed_groups'], 'category[allowedgroups]', 2);
	print_membergroup_row($vbphrase['vbplaza_denied_groups'], 'category[deniedgroups]', 2);
	print_input_row($vbphrase['vbplaza_category_image_location'], 'category[imagelocation]', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['category']) . "\" accesskey=\"s\" />");
}


// check if its adding an option
if ($_REQUEST['do'] == 'addoption')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category ORDER BY displayorder");
	while ($category = $vbulletin->db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// build categoryname rows
	$categoryselect = array($vbphrase[vbplaza_none]);
	foreach($vbplazacategories AS $category)
	{
		// add this category
		$categoryselect[$category['categoryid']] = $category['name'];
	}

	// get the item info
	print_form_header('vbplaza', 'insertoption');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_add_new_option'] . "</font>", 2);
	construct_hidden_code('itemid', $_REQUEST['itemid']);
	print_yes_no_row($vbphrase['vbplaza_active'], 'item[active]', '1');
	print_yes_no_row($vbphrase['vbplaza_item_can_change_always'], 'item[changealways]', '0');
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_item_show_in_store'], $vbphrase['vbplaza_name']), 'item[showinstore]', '1');
	print_yes_no_row($vbphrase['vbplaza_item_log_history'], 'item[loghistory]', '1');
	print_select_row(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_category']), 'item[category]', $categoryselect, '0');
	print_input_row($vbphrase['vbplaza_item_name'], 'item[name]', '');
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']), 'item[description]', '');
	print_input_row($vbphrase['display_order'], 'item[displayorder]', '500');
	print_input_row($vbphrase['vbplaza_flood_check'], 'item[floodcheck]', '30');
	print_input_row($vbphrase['vbplaza_item_cost'], 'item[cost]', '0');
	print_input_row($vbphrase['vbplaza_item_cost_auto_calculated'], 'item[autobuildcost]', '1');
	print_input_row($vbphrase['vbplaza_item_tax'], 'item[tax]', '0');
	print_input_row($vbphrase['vbplaza_item_expirydate'], 'item[expirydate]', '0');
	print_input_row($vbphrase['vbplaza_item_defquantity'], 'item[defquantity]', '20');
	print_input_row($vbphrase['vbplaza_item_quantity'], 'item[quantity]', '20');
	print_input_row($vbphrase['vbplaza_items_sold'], 'item[sold]', '0');
	print_yes_no_row($vbphrase['vbplaza_override_category_permissions'], 'item[overridepermissions]', '0');
	print_membergroup_row(construct_phrase($vbphrase['vbplaza_xy'], $vbphrase['vbplaza_additional'], $vbphrase['vbplaza_allowed_groups']), 'item[allowedgroups]', 2);
	print_membergroup_row(construct_phrase($vbphrase['vbplaza_xy'], $vbphrase['vbplaza_additional'], $vbphrase['vbplaza_denied_groups']), 'item[deniedgroups]', 2);
	print_input_row($vbphrase['vbplaza_item_image_location'], 'item[imagelocation]', '');
	print_input_row($vbphrase['vbplaza_item_script_location'], 'item[scriptlocation]', '');
	print_table_break('');

	// display the advanced table settings
	print_table_header($vbphrase['vbplaza_table_settings_advanced_only']);
	print_input_row($vbphrase['vbplaza_item_table_name'], 'item[tablename]', $vbulletin->options['vbbux_pointstable']);
	print_input_row($vbphrase['vbplaza_where_name'], 'item[wherename]', '');
	print_input_row($vbphrase['vbplaza_where_value'], 'item[wherevalue]', '');
	print_select_row($vbphrase['vbplaza_set_type'], 'item[settype]', array('0' => $vbphrase['vbplaza_none'], '1' => $vbphrase['vbplaza_string'], '2' => $vbphrase['vbplaza_bitfield'], '3' => $vbphrase['vbplaza_add_integer']), '0');
	print_input_row($vbphrase['vbplaza_set_name'], 'item[setname]', '');
	print_input_row($vbphrase['vbplaza_set_value'], 'item[setvalue]', '');
	print_table_break('');

	// display the advanced input field settings
	print_table_header($vbphrase['vbplaza_input_field_settings_advanced_only'], 4);
	print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_phrase_name'], $vbphrase['vbplaza_field_name'], $vbphrase['vbplaza_field_value']), 1, 'tcat');
	$inputfields = unserialize($item['inputfields']);
	for ($i = 0; $i < $vbulletin->options['vbplaza_optionfields']; $i++)
	{
		// clear out the cells
		$cell = array();

		// check if there is any data in this field
		$cell[] = $i + 1;
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields]['" . $i . "'][phrasename]\" value=\"\" tabindex=\"1\" size=\"40\" title=\"" . $vbphrase['vbplaza_phrase_name'] . "\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields]['" . $i . "'][inputname]\" value=\"\" tabindex=\"2\" size=\"40\" title=\"" . $vbphrase['vbplaza_field_name'] . "\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields]['" . $i . "'][inputvalue]\" value=\"\" tabindex=\"3\" size=\"40\" title=\"" . $vbphrase['vbplaza_field_value'] . "\" />";
		print_cells_row($cell);
	}
	print_table_break('');

	// display the advanced option settings
	$numoptions = 1;
	$cell = array();
	print_table_header($vbphrase['vbplaza_option_settings_advanced_only'], 6);
	print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_type'], $vbphrase['vbplaza_varname'], $vbphrase['vbplaza_option_title'], construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']), $vbphrase['vbplaza_value']), 1, 'tcat');
	$cell[] = $numoptions;
	$optiontypes = array('0' => '', '1' => '/', '2' => '', '3' => '');
	$cell[] = "<select name=\"item[optionsettings][" . $numoptions . "][type]\" class=\"bginput\">\n" . construct_select_options($optiontypes, '0') . "\t</select>";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][varname]\" value=\"\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_varname'] . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][title]\" value=\"\" tabindex=\"2\" size=\"30\" title=\"" . $vbphrase['vbplaza_option_title'] . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][description]\" value=\"\" tabindex=\"3\" size=\"40\" title=\"" . construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']) . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][value]\" value=\"\" tabindex=\"4\" size=\"10\" title=\"" . $vbphrase['vbplaza_value'] . "\" />";
	print_cells_row($cell);
	print_table_break('');

	// finish off the table form
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_add_option'] . "\" accesskey=\"s\" />");
}

// check if its adding an option copy
if ($_REQUEST['do'] == 'addoptioncopy')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category ORDER BY displayorder");
	while ($category = $vbulletin->db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// build categoryname rows
	$buildoptions = array($vbphrase['vbplaza_none']);
	foreach($vbplazacategories AS $category)
	{
		// now build the options for this category
		foreach ($vbplazaoptions AS $itemid => $item)
		{
			// check if this item is in this category
			if ($category['categoryid'] == $item['category'])
			{
				// add this to the $buildoptions
				$buildoptions[$category['name']][$itemid] = $item['name'];
			}
		}
	}

	// get the item info
	print_form_header('vbplaza', 'insertoptioncopy');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_add_option_copy'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_select_option_to_copy']);
	print_select_row($vbphrase['vbplaza_item_name'], 'itemid', $buildoptions, '0');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_add_option_copy'] . "\" accesskey=\"s\" />");
}

// check if its editing all arcade gamecosts
if ($_REQUEST['do'] == 'allarcadecosts')
{
	// check to see if they have a compatible version arcade installed
	$arcadefound = false;
	if ($arcades = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = 'ibproarcade' OR productid = 'v3arcade'"))
	{
		// process all that were found
		while ($arcade = $vbulletin->db->fetch_array($arcades))
		{
			// check if ibproarcade was found
			if ($arcade['productid'] == 'ibproarcade')
			{
				// check if its a new enough version
				$arcadefound = true;
				if (is_newer_version($arcade['version'], '2.5.5 Beta 0'))
				{
					// display a confirmation
					print_form_header('vbplaza', 'updateallarcadecosts');
					print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_ibproarcade']) . "</font>", 2);
					construct_hidden_code('arcadetype', $arcade['productid']);
					print_description_row(construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost_warning'], $vbphrase['vbplaza_ibproarcade']));
					print_input_row($vbphrase['vbplaza_cost'], 'globalcost', '');
					print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" /> &nbsp; " . $deleteoption);
				}
				else
				{
					// display that they do not have a high enough version ibproarcade installed
					print_form_header('vbplaza', 'allarcadecosts');
					print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_ibproarcade']) . "</font>", 2);
					print_description_row(construct_phrase($vbphrase['vbplaza_arcade_ibproarcade_version_not_high_enough'], $vbphrase['vbbux_name']));
					print_table_footer(2, "");
				}
			}
			// check if v3arcade was found
			else if ($arcade['productid'] == 'v3arcade')
			{
				// check if its a new enough version
				$arcadefound = true;
				if (is_newer_version($arcade['version'], '1.0.5 Beta 0'))
				{
					// display a confirmation
					print_form_header('vbplaza', 'updateallarcadecosts');
					print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_v3arcade']) . "</font>", 2);
					construct_hidden_code('arcadetype', $arcade['productid']);
					print_description_row(construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost_warning'], $vbphrase['vbplaza_v3arcade']));
					print_input_row($vbphrase['vbplaza_cost'], 'globalcost', '');
					print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" /> &nbsp; " . $deleteoption);
				}
				else
				{
					// display that they do not have a high enough version v3arcade installed
					print_form_header('vbplaza', 'allarcadecosts');
					print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_v3arcade']) . "</font>", 2);
					print_description_row(construct_phrase($vbphrase['vbplaza_arcade_v3arcade_version_not_high_enough'], $vbphrase['vbbux_name']));
					print_table_footer(2, "");
				}
			}
		}
	}

	// free the arcades
	$vbulletin->db->free_result($arcades);

	// check if the arcade was found
	if ($arcadefound != true)
	{
		// display that they do not have and arcade installed
		print_form_header('vbplaza', 'allarcadecosts');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . construct_phrase($vbphrase['vbplaza_update_all_arcade_games_cost'], $vbphrase['vbplaza_arcade']) . "</font>", 2);
		print_description_row($vbphrase['vbplaza_arcade_not_installed']);
		print_table_footer(2, "");
	}
}

// check if its editing the arcade game costs
if ($_REQUEST['do'] == 'arcadecosts')
{
	// check to see if they have a compatible version arcade installed
	$arcadeinfo = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "product WHERE productid = 'ibproarcade' OR productid = 'v3arcade'");

	// check if ibproarcade was found
	if ($arcadeinfo['productid'] == 'ibproarcade')
	{
		// check if its a new enough version
		if (is_newer_version($arcadeinfo['version'], '2.5.5 Beta 0'))
		{
			// cache all of the games inside the arcade
			if ($games = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "games_list ORDER BY gtitle"))
			{
				// process all games
				$gamescache = array();
				while ($game = $vbulletin->db->fetch_array($games))
				{
					// cache this game
					$gamescache[] = $game;
				}

				// display a confirmation
				print_form_header('vbplaza', 'updatearcadecosts');
				print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 3);
				construct_hidden_code('arcadetype', $arcadeinfo['productid']);
				print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_arcade_game_name'], $vbphrase['vbplaza_cost']), 1, 'tcat');
				foreach($gamescache AS $game)
				{
					// fill the cells
					$cell = array();
					$cell[] = $game['gid'];
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"games[" . $game['gid'] . "][gtitle]\" value=\"" . $game['gtitle'] . "\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_arcade_game_name'] . "\" />";
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"games[" . $game['gid'] . "][cost]\" value=\"" . $game['cost'] . "\" tabindex=\"1\" size=\"15\" title=\"" . $vbphrase['vbplaza_cost'] . "\" />";
					print_cells_row($cell);
				}
				print_table_footer(3, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
			}
			else
			{
				// display a confirmation
				print_form_header('vbplaza', 'updatearcadecosts');
				print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
				print_description_row($vbphrase['vbplaza_arcade_no_games_found']);
				print_table_footer(2, "");
			}

			// free the games
			$vbulletin->db->free_result($games);
		}
		else
		{
			// display that they do not have a high enough version ibproarcade installed
			print_form_header('vbplaza', 'updatearcadecosts');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
			print_description_row(construct_phrase($vbphrase['vbplaza_arcade_ibproarcade_version_not_high_enough'], $vbphrase['vbbux_name']));
			print_table_footer(2, "");
		}
	}
	// check if v3arcade was found
	else if ($arcadeinfo['productid'] == 'v3arcade')
	{
		// check if its a new enough version
		if (is_newer_version($arcadeinfo['version'], '1.0.5 Beta 0'))
		{
			// cache all of the games inside the arcade
			if ($games = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "arcade_games ORDER BY title"))
			{
				// process all games
				$gamescache = array();
				while ($game = $vbulletin->db->fetch_array($games))
				{
					// cache this game
					$gamescache[] = $game;
				}

				// display a confirmation
				print_form_header('vbplaza', 'updatearcadecosts');
				print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 3);
				construct_hidden_code('arcadetype', $arcadeinfo['productid']);
				print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_arcade_game_name'], $vbphrase['vbplaza_cost']), 1, 'tcat');
				foreach($gamescache AS $game)
				{
					// fill the cells
					$cell = array();
					$cell[] = $game['gameid'];
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"games[" . $game['gameid'] . "][title]\" value=\"" . $game['title'] . "\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_arcade_game_name'] . "\" />";
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"games[" . $game['gameid'] . "][cost]\" value=\"" . $game['cost'] . "\" tabindex=\"1\" size=\"15\" title=\"" . $vbphrase['vbplaza_cost'] . "\" />";
					print_cells_row($cell);
				}
				print_table_footer(3, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
			}
			else
			{
				// display a confirmation
				print_form_header('vbplaza', 'updatearcadecosts');
				print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
				print_description_row($vbphrase['vbplaza_arcade_no_games_found']);
				print_table_footer(2, "");
			}

			// free the gamees
			$vbulletin->db->free_result($games);
		}
		else
		{
			// display that they do not have a high enough version arcade installed
			print_form_header('vbplaza', 'updatearcadecosts');
			print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
			print_description_row($vbphrase['vbplaza_arcade_v3arcade_version_not_high_enough']);
			print_table_footer(2, "");
		}
	}
	// neither were found, display links to get them!
	else
	{
		// display that they do not have and arcade installed
		print_form_header('vbplaza', 'updatearcadecosts');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_arcade_costs_editor'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_arcade_not_installed']);
		print_table_footer(2, "");
	}
}

// check if its editing a category
if ($_REQUEST['do'] == 'editcategory')
{
	// build delete button if possible
	$deleteoption = '';
	if ($_REQUEST['categoryid'] >= 101)
	{
		// setup up the $deleteoption
		$deleteoption = "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_category']) . "\" accesskey=\"s\" /> &nbsp; ";
	}

	// cache the category
	$category = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category WHERE categoryid = '" . $_REQUEST['categoryid'] . "'");
	$allowedarray = array('usergroupid' => 0, 'membergroupids' => $category['allowedgroups']);
	$deniedarray = array('usergroupid' => 0, 'membergroupids' => $category['deniedgroups']);
	print_form_header('vbplaza', 'updatecategory');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_edit'] . " " . $category['name'] . "</font>", 2);
	construct_hidden_code('categoryid', $_REQUEST['categoryid']);
	print_yes_no_row($vbphrase['vbplaza_active'], 'category[active]', $category['active']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_category']), 'category[name]', $category['name']);
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_category']), 'category[description]', $category['description']);
	print_input_row($vbphrase['display_order'], 'category[displayorder]', $category['displayorder']);
	print_membergroup_row($vbphrase['vbplaza_allowed_groups'], 'category[allowedgroups]', 2, $allowedarray);
	print_membergroup_row($vbphrase['vbplaza_denied_groups'], 'category[deniedgroups]', 2, $deniedarray);
	print_input_row($vbphrase['vbplaza_category_image_location'], 'category[imagelocation]', $category['imagelocation']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" /> &nbsp; " . $deleteoption);
}

// check if its editing an item
if ($_REQUEST['do'] == 'editoption')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category ORDER BY displayorder");
	while ($category = $vbulletin->db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// build categoryname rows
	$categoryselect = array($vbphrase[vbplaza_none]);
	foreach($vbplazacategories AS $category)
	{
		// add this category
		$categoryselect[$category['categoryid']] = $category['name'];
	}

	// build delete button if possible
	$deleteoption = '';
	if (($_REQUEST['itemid'] >= 501) || (($_REQUEST['itemid'] >= 71) && ($_REQUEST['itemid'] <= 109)))
	{
		// setup up the $deleteoption
		$deleteoption = "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_option']) . "\" accesskey=\"s\" /> &nbsp; ";
	}

	// get the item info
	$item = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_item WHERE itemid = '" . $_REQUEST['itemid'] . "'");
	$allowedarray = array('usergroupid' => 0, 'membergroupids' => $item['allowedgroups']);
	$deniedarray = array('usergroupid' => 0, 'membergroupids' => $item['deniedgroups']);
	print_form_header('vbplaza', 'updateoption');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_edit'] . " " . $item['name'] . "</font>", 2);
	construct_hidden_code('itemid', $_REQUEST['itemid']);
	print_yes_no_row($vbphrase['vbplaza_active'], 'item[active]', $item['active']);
	print_yes_no_row($vbphrase['vbplaza_item_can_change_always'], 'item[changealways]', $item[changealways]);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_item_show_in_store'], $vbphrase['vbplaza_name']), 'item[showinstore]', $item[showinstore]);
	print_yes_no_row($vbphrase['vbplaza_item_log_history'], 'item[loghistory]', $item['loghistory']);
	print_select_row(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_category']), 'item[category]', $categoryselect, $item['category']);
	print_input_row($vbphrase['vbplaza_item_name'], 'item[name]', $item['name']);
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']), 'item[description]', $item['description']);
	print_input_row($vbphrase['display_order'], 'item[displayorder]', $item['displayorder']);
	print_input_row($vbphrase['vbplaza_flood_check'], 'item[floodcheck]', $item['floodcheck']);
	print_input_row($vbphrase['vbplaza_item_cost'], 'item[cost]', $item['cost']);
	print_yes_no_row($vbphrase['vbplaza_item_cost_auto_calculated'], 'item[autobuildcost]', $item[autobuildcost]);
	print_input_row($vbphrase['vbplaza_item_tax'], 'item[tax]', $item['tax']);
	print_input_row($vbphrase['vbplaza_item_expirydate'], 'item[expirydate]', $item['expirydate']);
	print_time_row($vbphrase['vbplaza_item_refilldateline'], 'item[refilldateline]', $item['refilldateline']);
	print_input_row($vbphrase['vbplaza_item_defquantity'], 'item[defquantity]', $item['defquantity']);
	print_input_row($vbphrase['vbplaza_item_quantity'], 'item[quantity]', $item['quantity']);
	print_input_row($vbphrase['vbplaza_items_sold'], 'item[sold]', $item['sold']);
	print_yes_no_row($vbphrase['vbplaza_override_category_permissions'], 'item[overridepermissions]', $item['overridepermissions']);
	print_membergroup_row(construct_phrase($vbphrase['vbplaza_xy'], $vbphrase['vbplaza_additional'], $vbphrase['vbplaza_allowed_groups']), 'item[allowedgroups]', 2, $allowedarray);
	print_membergroup_row(construct_phrase($vbphrase['vbplaza_xy'], $vbphrase['vbplaza_additional'], $vbphrase['vbplaza_denied_groups']), 'item[deniedgroups]', 2, $deniedarray);
	print_input_row($vbphrase['vbplaza_item_image_location'], 'item[imagelocation]', $item['imagelocation']);
	print_input_row($vbphrase['vbplaza_item_script_location'], 'item[scriptlocation]', $item['scriptlocation']);
	print_table_break('');

	// display the advanced table settings
	print_table_header($vbphrase['vbplaza_table_settings_advanced_only']);
	print_input_row($vbphrase['vbplaza_item_table_name'], 'item[tablename]', $item['tablename']);
	print_input_row($vbphrase['vbplaza_where_name'], 'item[wherename]', $item['wherename']);
	print_input_row($vbphrase['vbplaza_where_value'], 'item[wherevalue]', $item['wherevalue']);
	print_select_row($vbphrase['vbplaza_set_type'], 'item[settype]', array('0' => $vbphrase['vbplaza_none'], '1' => $vbphrase['vbplaza_string'], '2' => $vbphrase['vbplaza_bitfield'], '3' => $vbphrase['vbplaza_add_integer']), $item['settype']);
	print_input_row($vbphrase['vbplaza_set_name'], 'item[setname]', $item['setname']);
	print_input_row($vbphrase['vbplaza_set_value'], 'item[setvalue]', $item['setvalue']);
	print_table_break('');

	// display the advanced input field settings
	print_table_header($vbphrase['vbplaza_input_field_settings_advanced_only'], 4);
	print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_phrase_name'], $vbphrase['vbplaza_field_name'], $vbphrase['vbplaza_field_value']), 1, 'tcat');
	$inputfields = unserialize($item['inputfields']);
	for ($i = 0; $i < $vbulletin->options['vbplaza_optionfields']; $i++)
	{
		// clear out the cells
		$cell = array();

		// check if there is any data in this field
		$cell[] = $i + 1;
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields][" . $i . "][phrasename]\" value=\"" . $inputfields[$i]['phrasename'] . "\" tabindex=\"1\" size=\"40\" title=\"" . $vbphrase['vbplaza_phrase_name'] . "\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields][" . $i . "][inputname]\" value=\"" . $inputfields[$i]['inputname'] . "\" tabindex=\"2\" size=\"40\" title=\"" . $vbphrase['vbplaza_field_name'] . "\" />";
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[inputfields][" . $i . "][inputvalue]\" value=\"" . $inputfields[$i]['inputvalue'] . "\" tabindex=\"3\" size=\"40\" title=\"" . $vbphrase['vbplaza_field_value'] . "\" />";
		print_cells_row($cell);
	}
	print_table_break('');

	// display the advanced option settings
	$numoptions = 1;
	print_table_header($vbphrase['vbplaza_option_settings_advanced_only'], 6);
	print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_type'], $vbphrase['vbplaza_varname'], $vbphrase['vbplaza_option_title'], construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_item']), $vbphrase['vbplaza_value']), 1, 'tcat');
	$item['optionsettings'] = unserialize($item['optionsettings']);
	if (is_array($item['optionsettings']) && !empty($item['optionsettings']))
	{
		// process each entry option setting
		foreach($item['optionsettings'] AS $key => $optionsetting)
		{
			// verify the setting is valid
			if ($optionsetting['type'] && !empty($optionsetting['varname']))
			{
				// clear out the cells
				$cell = array();

				// display this option setting
				$cell[] = $numoptions;
				$optiontypes = array('0' => ' ', '1' => '/', '2' => '', '3' => '');
				$cell[] = "<select name=\"item[optionsettings][" . $numoptions . "][type]\" class=\"bginput\">\n" . construct_select_options($optiontypes, $optionsetting['type']) . "\t</select>";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][varname]\" value=\"" . $optionsetting['varname'] . "\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_varname'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][title]\" value=\"" . $optionsetting['title'] . "\" tabindex=\"2\" size=\"30\" title=\"" . $vbphrase['vbplaza_option_title'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][description]\" value=\"" . $optionsetting['description'] . "\" tabindex=\"3\" size=\"40\" title=\"" . construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']) . "\" />";
				if ($optionsetting['type'] == '1')
				{
					// display it as a yes/no field
					$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
					$cell[] = "<select name=\"item[optionsettings][" . $numoptions . "][value]\" class=\"bginput\">\n" . construct_select_options($activemods, $optionsetting['value']) . "\t</select>";
				}
				else
				{
					// display it as an input
					$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][value]\" value=\"" . $optionsetting['value'] . "\" tabindex=\"4\" size=\"10\" title=\"" . $vbphrase['vbplaza_value'] . "\" />";
				}
				print_cells_row($cell);

				// increase $numoptions
				$numoptions++;
			}
		}
	}

	// clear out the cells
	$cell = array();

	// always add 1 more spot to this field for expansion
	$cell[] = $numoptions;
	$optiontypes = array('0' => ' ', '1' => '/', '2' => '', '3' => '');
	$cell[] = "<select name=\"item[optionsettings][" . $numoptions . "][type]\" class=\"bginput\">\n" . construct_select_options($optiontypes, '0') . "\t</select>";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][varname]\" value=\"\" tabindex=\"1\" size=\"30\" title=\"" . $vbphrase['vbplaza_varname'] . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][title]\" value=\"\" tabindex=\"2\" size=\"30\" title=\"" . $vbphrase['vbplaza_option_title'] . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][description]\" value=\"\" tabindex=\"3\" size=\"40\" title=\"" . construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_option']) . "\" />";
	$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[optionsettings][" . $numoptions . "][value]\" value=\"\" tabindex=\"4\" size=\"10\" title=\"" . $vbphrase['vbplaza_value'] . "\" />";
	print_cells_row($cell);
	print_table_break('');

	// finish off the table form
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" /> &nbsp; " . $deleteoption);
}

// check if it is searching users
if ($_REQUEST['do'] == 'searchusers')
{
	// display search fields for search users
	print_form_header('vbplaza', 'findusers');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_users'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_search_criteria']);
	print_input_row($vbphrase['username'], 'username', '');
	print_input_row($vbphrase['userid'], 'userid', '');
	print_table_header($vbphrase['vbplaza_display_flags']);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_bold_x'], $vbphrase['username']), 'displayflags[boldusername]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_italic_x'], $vbphrase['username']), 'displayflags[italicusername]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_underline_x'], $vbphrase['username']), 'displayflags[underlinedusername]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_bold_x'], $vbphrase['user_title']), 'displayflags[boldusertitle]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_italic_x'], $vbphrase['user_title']), 'displayflags[italicusertitle]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_underline_x'], $vbphrase['user_title']), 'displayflags[underlinedusertitle]', 0);
	print_yes_no_row($vbphrase['vbplaza_horizontal_postbit'], 'displayflags[horizontalpostbit]', 0);
	print_yes_no_row($vbphrase['vbplaza_legacy_postbit'], 'displayflags[legacypostbit]', 0);
	print_table_header($vbphrase['vbplaza_other_flags']);
	print_yes_no_row($vbphrase['vbplaza_bypass_post_flood'], 'otherflags[bypasspostflood]', 0);
	print_yes_no_row($vbphrase['vbplaza_give_unlimited_rep'], 'otherflags[giveunlimitedrep]', 0);
	print_yes_no_row($vbphrase['vbplaza_see_deletion_notices'], 'otherflags[seedeletionnotices]', 0);
	print_yes_no_row($vbphrase['vbplaza_bypass_pm_flood'], 'otherflags[bypasspmflood]', 0);
	print_yes_no_row($vbphrase['vbplaza_bypass_search_flood'], 'otherflags[bypasssearchflood]', 0);
	print_yes_no_row($vbphrase['vbplaza_can_use_message_tracking'], 'otherflags[canusemessagetracking]', 0);
	print_yes_no_row($vbphrase['vbplaza_can_deny_pm_receipts'], 'otherflags[candenypmreceipts]', 0);
	print_yes_no_row($vbphrase['vbplaza_arcade_access'], 'otherflags[arcadeaccess]', 0);
	print_table_header($vbphrase['vbplaza_immunity']);
	print_yes_no_row($vbphrase['vbplaza_thief'], 'immunity[thief]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_change_x'], $vbphrase['user_title']), 'immunity[changeusertitle]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_change_x'], $vbphrase['vbplaza_default_avatar']), 'immunity[changedefaultavatar]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_remove_x'], $vbphrase['vbplaza_default_avatar']), 'immunity[removedefaultavatar]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_change_x'], $vbphrase['vbplaza_custom_avatar']), 'immunity[changecustomavatar]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_remove_x'], $vbphrase['vbplaza_custom_avatar']), 'immunity[removecustomavatar]', 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_change_x'], $vbphrase['reputation']), 'immunity[changereputation]', 0);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_search_users'] . "\" accesskey=\"s\" />");
}

// check if it is searching the item history
if ($_REQUEST['do'] == 'itemhistory')
{
	// display search fields for search item history
	print_form_header('vbplaza', 'searchitemhistory');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_search_item_history'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_search_criteria']);
	print_input_row($vbphrase['username'], 'username', '');
	print_input_row($vbphrase['userid'], 'userid', '');
	print_input_row(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_item']), 'itemid', '');
	print_input_row($vbphrase['vbplaza_item_name'], 'itemname', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_search_item_history'] . "\" accesskey=\"s\" />");
}

// check if its listing the subscriptions
if ($_REQUEST['do'] == 'subscriptionlist')
{
	// check for all subscriptions
	$subcache = array();
	if ($subscriptions = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "subscription ORDER BY displayorder"))
	{
		// cache all of the results
		while ($subscription = $vbulletin->db->fetch_array($subscriptions))
		{
			// extra step for vbulletin 3.6
			if ($vbulletin_version == '3.6')
			{
				// setup the title properly
				$subscription['title'] = htmlspecialchars_uni($vbphrase['sub' . $subscription['subscriptionid'] . '_title']);
			}

			// add this to the cache
			$subcache[$subscription['subscriptionid']] = $subscription;
		}
	}

	// free the subscriptions
	$vbulletin->db->free_result($subscriptions);

	// check if any subscriptions were found
	if (!empty($subcache) && is_array($subcache))
	{
		// display the results now
		print_form_header('vbplaza', 'subscriptionupdate');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_subscription_list'] . "</font>", 3);
		print_cells_row(array($vbphrase['title'], $vbphrase['vbbux_name'] . " " . $vbphrase['vbbux_points'], $vbphrase['display_order']), 1, 'tcat');

		// process all of the subscriptions
		foreach($subcache AS $subscriptionid => $subscription)
		{
			// print the cells
			$cell = array();
			$cell[] = "<strong>" . $subscription['title'] . "</strong>";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"subscription[" . $subscriptionid . "][vbp_vbbuxsub]\" value=\"" . $subscription['vbp_vbbuxsub'] . "\" size=\"20\" title=\"" . $vbphrase['vbbux_name'] . " " . $vbphrase['vbbux_points'] . "\" />";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"subscription[" . $subscriptionid . "][displayorder]\" value=\"" . $subscription['displayorder'] . "\" size=\"5\" title=\"" . $vbphrase['display_order'] . "\" />";
			print_cells_row($cell);
		}

		// finish off the table
		print_table_footer(3, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
	}
	else
	{
		// display that there are no subscriptions found
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_subscription_list'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_subscriptions_found']);
		print_table_footer(2, "");
	}
}

// check if it is listing the categories
if ($_REQUEST['do'] == 'categorylist')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category ORDER BY displayorder");
	while ($category = $vbulletin->db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// start the output
	print_form_header('vbplaza', 'categoryupdate');

	// verify it has found some categories
	if (is_array($vbplazacategories) && !empty($vbplazacategories))
	{
		// start printing the cells
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_category_list'] . "</font>", 4);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_name'], $vbphrase['vbplaza_category']), construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_category']), $vbphrase['vbplaza_active'], $vbphrase['display_order']), 1, 'tcat');

		// process all cached categories
		foreach($vbplazacategories AS $category)
		{
			// verify the category is valid
			if (is_numeric($category['categoryid']))
			{
				// clear out the cells
				$cell = array();

				// setup and display the cells
				$cell[] = "<a href=\"vbplaza.php?do=editcategory&amp;categoryid=" . $category['categoryid'] . "\">" . $category['name'] . "</a>";
				$cell[] = $category['description'];
				$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
				$cell[] = "<select name=\"categoryactive[$category[categoryid]]\" class=\"bginput\">\n" . construct_select_options($activemods, $category['active']) . "\t</select>";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"categoryorder[$category[categoryid]]\" value=\"$category[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
				print_cells_row($cell);
			}
		}

		// finish off the table
		print_table_footer(4, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
	}
	else
	{
		// display that there are no categories found
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_category_list'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_categories_found']);
		print_table_footer(2, "");
	}
}

// check if it is listing the options
if ($_REQUEST['do'] == 'itemlist')
{
	// cache the categories
	unset($vbplazacategories);
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category ORDER BY displayorder");
	while ($category = $vbulletin->db->fetch_array($categories))
	{
		// cache this category
		$vbplazacategories[$category[categoryid]] = $category;
	}

	// free the categories
	$vbulletin->db->free_result($categories);

	// start the output
	print_form_header('vbplaza', 'optionsupdate');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_quick_update'] . "</font>", 9);

	// process all of the categories
	foreach($vbplazacategories AS $category)
	{
		// display a header for this item
		print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $category['name'] . "</font>", 9, false, '', 'left', true);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_item']), $vbphrase['vbplaza_item_name'], $vbphrase['vbplaza_cost'], $vbphrase['vbplaza_tax'], $vbphrase['vbplaza_sold'], $vbphrase['vbplaza_quantity'], $vbphrase['vbplaza_flood_check'], $vbphrase['vbplaza_active'], $vbphrase['display_order']), 1, 'tcat');

		// process all of the cached items
		foreach($vbplazaoptions AS $item)
		{
			// check if it should display this item
			if (is_numeric($item['itemid']) && ($item['category'] == $category['categoryid']))
			{
				// clear out the cells
				$cell = array();

				// check that is has a name at all
				if (empty($item['name']))
				{
					// set the name to something
					$item['name'] = $vbphrase['vbplaza_no_name'];
				}

				// setup and display the cells
				$cell[] = "<a href=\"vbplaza.php?do=editoption&amp;itemid=" . $item['itemid'] . "\">" . $item['itemid'] . "</a>";
				$cell[] = "<a href=\"vbplaza.php?do=editoption&amp;itemid=" . $item['itemid'] . "\">" . $item['name'] . "</a>";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][cost]\" value=\"$item[cost]\" size=\"10\" title=\"" . $vbphrase['vbplaza_item_cost'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][tax]\" value=\"$item[tax]\" size=\"8\" title=\"" . $vbphrase['vbplaza_item_tax'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][sold]\" value=\"$item[sold]\" size=\"5\" title=\"" . $vbphrase['vbplaza_items_sold'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][quantity]\" value=\"$item[quantity]\" size=\"5\" title=\"" . $vbphrase['vbplaza_item_quantity'] . "\" />";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][floodcheck]\" value=\"$item[floodcheck]\" size=\"5\" title=\"" . $vbphrase['vbplaza_flood_check'] . "\" />";
				$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
				$cell[] = "<select name=\"item[$item[itemid]][active]\" class=\"bginput\">\n" . construct_select_options($activemods, $item['active']) . "\t</select>";
				$cell[] = "<input type=\"text\" class=\"bginput\" name=\"item[$item[itemid]][displayorder]\" value=\"$item[displayorder]\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
				print_cells_row($cell);
			}
		}
	}

	// finish off the table
	print_table_footer(9, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
}

// display the footer
print_cp_footer();
?>