<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if (($vbulletin->options['vbbux_enabled'] == 1) && ($vbulletin->options['vbbux_arcadeintegration'] == 1))
	{
		// check first if the game costs points to play
		if (isset($game['cost']) && ($game['cost'] != 0))
		{
			// first check that the user does not have an arcade pass
			if (($vbulletin->userinfo['vbp_arcadepass'] == 0) && !($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canplayarcadefree']))
			{
				// first do the normal checks to see if the user will be allowed to play
				$canplay = true;

				// Again, check to see if this user is all-powerful.
				if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canoverridepermissions']))
				{
					// Minimum post check.
					if ($vbulletin->userinfo['posts'] < $game['minpoststotal']) { $canplay = false; }

					// Minimum average posts per day check.
					$game['membershiplength'] = (TIMENOW - $vbulletin->userinfo['joindate'])/86400;
					$game['postsperday'] = $vbulletin->userinfo['posts'] / $game['membershiplength'];
					if ($game['postsperday'] < $game['minpostsperday']) { $canplay = false; }
		
					// Minimum posts today check.
					if ($game['minpoststhisday'])
					{
						$postcheck = $db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "post WHERE userid=" . $vbulletin->userinfo['userid'] . " AND dateline<" . TIMENOW . " AND dateline>" . (TIMENOW-(24*60*60)));
						if ($postcheck['count'] < $game['minpoststhisday']) { $canplay = false; }
					}

					// Minimum membership length check.
					if (floor($game['membershiplength']) < $game['minreglength']) { $canplay = false; }

					// Minimum reputation check.
					if ($vbulletin->options['reputationenable'])
					{
						if ($vbulletin->userinfo['reputation'] < $game['minrep']) { $canplay = false; }
					}
				}

				// only subtract the points if the user is going to be allowed to play
				if ($canplay == true)
				{
					// check if the confirmation page is needed
					if ($vbulletin->options['vbplaza_arcadeplayconfirm'] > 0)
					{
						// check if the user has confirmed it already
						if ($_POST['confirm'] != 1)
						{
							// display the arcadeplay template
							exec_header_redirect("vbplaza.php?do=play&amp;gameid=" . $_REQUEST['gameid'] . "&type=v3arcade");
						}
					}

					// take the cost from the $game['cost']
					$givepoints = $game['cost'];

					// check if this usergroup gets a discount (discount is on the base price, not the taxed price)
					if ($vbulletin->userinfo['permissions']['vbp_discountrate'] > 0)
					{
						// verify the discountrate is < 100
						if ($vbulletin->userinfo['permissions']['vbp_discountrate'] <= 100)
						{
							// generate the overall discount rate
							$discountrate = ((100 - $vbulletin->userinfo['permissions']['vbp_discountrate']) / 100);

							// calculate the item cost with the discounted rate
							$givepoints = $givepoints * $discountrate;
						}
					}

					// verify they have enough points to do this action
					if (($vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']] - $givepoints) < 0)
					{
						// display error, not enough points
						eval(standard_error(fetch_error('vbplaza_not_enough_points')));
					}

					// send the query to remove the points
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
						SET
							`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` - " . $givepoints . "
						WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
							AND vbp_receivespoints = '1'
					");
				}
			}
		}
	}
}
?>