<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// check if it's enabled first
	if (($vbulletin->options['vbbux_enabled'] == 1) && ($vbulletin->options['vbbux_arcadeintegration'] == 1))
	{
		// check if the user has an arcadepass
		if (($vbulletin->userinfo['vbp_arcadepass'] != 0) || ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canplayarcadefree']))
		{
			// update the $game['description'] to show the cost to play as Free
			$game['description'] .= "<div name=\"smallfont\">" . construct_phrase($vbphrase['vbplaza_cost_to_play'], $vbphrase['vbplaza_free'], '') . "</div>";
		}
		else
		{
			// check if this usergroup gets a discount (discount is on the base price, not the taxed price)
			if ($vbulletin->userinfo['permissions']['vbp_discountrate'] > 0)
			{
				// verify the discountrate is < 100
				if ($vbulletin->userinfo['permissions']['vbp_discountrate'] <= 100)
				{
					// generate the overall discount rate
					$discountrate = ((100 - $vbulletin->userinfo['permissions']['vbp_discountrate']) / 100);

					// calculate the item cost with the discounted rate
					$game['cost'] = $game['cost'] * $discountrate;
				}
			}

			// convert the $game['cost'] to the proper number of decimals
			$game['cost'] = vb_number_format($game['cost'], $vbulletin->options['vbbux_decimalplaces']);

			// update the $game['description'] to show the cost to play
			$game['description'] .= "<div name=\"smallfont\">" . construct_phrase($vbphrase['vbplaza_cost_to_play'], $game['cost'], $vbphrase['vbbux_points']) . "</div>";
		}
	}
}
?>