<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// some globals are needed
	global $vbulletin;

	// check if it's enabled first
	if (($vbulletin->options['vbbux_enabled'] == 1) && ($vbulletin->options['vbbux_arcadeintegration'] == 1))
	{
		// check if the user is logged in
		if ($vbulletin->userinfo['userid'] > 0)
		{
			// check if the game costs to play
			if (isset($game['cost']) && ($game['cost'] != 0))
			{
				// first check that the user does not have an arcade pass
				if (($vbulletin->userinfo['vbp_arcadepass'] == 0) && !($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canplayarcadefree']))
				{
					// check if the confirmation page is needed
					if ($vbulletin->options['vbplaza_arcadeplayconfirm'] > 0)
					{
						// check if the user has confirmed it already
						if ($_POST['confirm'] != 1)
						{
							// display the arcadeplay template
							exec_header_redirect("vbplaza.php?do=play&amp;gameid=" . $_REQUEST['gameid'] . "&type=ibproarcade");
						}
					}

					// take the cost from the $game['cost']
					$givepoints = $game['cost'];

					// check if this usergroup gets a discount (discount is on the base price, not the taxed price)
					if ($vbulletin->userinfo['permissions']['vbp_discountrate'] > 0)
					{
						// verify the discountrate is < 100
						if ($vbulletin->userinfo['permissions']['vbp_discountrate'] <= 100)
						{
							// generate the overall discount rate
							$discountrate = ((100 - $vbulletin->userinfo['permissions']['vbp_discountrate']) / 100);

							// calculate the item cost with the discounted rate
							$givepoints = $givepoints * $discountrate;
						}
					}

					// verify they have enough points to do this action
					if (($vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']] - $givepoints) < 0)
					{
						// display error, not enough points
						eval(standard_error(fetch_error('vbplaza_not_enough_points')));
					}

					// send the query to remove the points
					$vbulletin->db->query_write("
						UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
						SET
							`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` - " . $givepoints . "
						WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
							AND vbp_receivespoints = '1'
					");

					// check if the jackpot should be increased
					if ($game['jackpot_type'] == -1)
					{
						// calculate how much to increase the jackpot by
						$jackpotinc = (($givepoints * $vbulletin->options['vbplaza_arcadejackpotinc']) / 100);

						// send the query to increase the jackpot
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . "games_list
							SET
								jackpot = jackpot + " . $jackpotinc . "
							WHERE gid = '" . $game['gid'] . "'
						");
					}
				}
			}
		}
	}
}
?>