<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// some globals are needed
	global $vbulletin, $vbphrase;

	// check if it's enabled first
	if (($vbulletin->options['vbbux_enabled'] == 1) && ($vbulletin->options['vbbux_arcadeintegration'] == 1))
	{
		// check if the user is logged in
		if ($vbulletin->userinfo['userid'] > 0)
		{
			// check if the user has an arcadepass
			if (($vbulletin->userinfo['vbp_arcadepass'] != 0) || ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canplayarcadefree']))
			{
				// update the $the_game['cost'] to show the cost to play as Free
				$the_game['cost'] = $vbphrase['vbplaza_free'];

				// check if they are still allowed to win jackpots
				if ($vbulletin->options['vbplaza_arcadepasscanwinjackpot'] == 1)
				{
					// check if the jackpot raises over time
					if ($the_game['jackpot_type'] == -1)
					{
						// convert the $the_game['jackpot'] to the jackpot amount
						$the_game['jackpot'] = vb_number_format($the_game['jackpot'], $vbulletin->options['vbbux_decimalplaces']);
					}
					else
					{
						// convert the $the_game['jackpot_type'] to the jackpot amount
						$the_game['jackpot'] = vb_number_format($the_game['jackpot_type'], $vbulletin->options['vbbux_decimalplaces']);
					}
				}
				else
				{
					// set that there is no jackpot for this user
					$the_game['jackpot'] = $vbphrase['vbplaza_no_jackpot'];
				}
			}
			else
			{
				// check if this usergroup gets a discount (discount is on the base price, not the taxed price)
				if ($vbulletin->userinfo['permissions']['vbp_discountrate'] > 0)
				{
					// verify the discountrate is < 100
					if ($vbulletin->userinfo['permissions']['vbp_discountrate'] <= 100)
					{
						// generate the overall discount rate
						$discountrate = ((100 - $vbulletin->userinfo['permissions']['vbp_discountrate']) / 100);

						// calculate the item cost with the discounted rate
						$the_game['cost'] = $the_game['cost'] * $discountrate;
					}
				}

				// convert the $the_game['cost'] to the proper number of decimals
				$the_game['cost'] = vb_number_format($the_game['cost'], $vbulletin->options['vbbux_decimalplaces']);

				// check if the jackpot raises over time
				if ($the_game['jackpot_type'] == -1)
				{
					// convert the $the_game['jackpot'] to the jackpot amount
					$the_game['jackpot'] = vb_number_format($the_game['jackpot'], $vbulletin->options['vbbux_decimalplaces']);
				}
				else
				{
					// convert the $the_game['jackpot_type'] to the jackpot amount
					$the_game['jackpot'] = vb_number_format($the_game['jackpot_type'], $vbulletin->options['vbbux_decimalplaces']);
				}
			}
		}
		else
		{
			// set that there is no cost per game for this user
			$the_game['cost'] = $vbphrase['vbplaza_no_cost'];

			// set that there is no jackpot for this user
			$the_game['jackpot'] = $vbphrase['vbplaza_no_jackpot'];
		}
	}
}
?>