<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

/***************************************************************************************/
/* Run through some generic checks that have to be true to use this generaction script */
/***************************************************************************************/
// verify the setname
$action['setname'] = vbplaza_verify_set_name($action, $action['setname']);

// verify the setvalue
$action['setvalue'] = vbplaza_verify_set_value($action, $action['setvalue']);

// verify the wherename
$action['wherename'] = vbplaza_verify_where_name($action, $action['wherename']);

// verify the wherevalue
$action['wherevalue'] = vbplaza_verify_where_value($action, $action['wherevalue']);

/*****************************************************/
/* Base checks have been validated, start the script */
/*****************************************************/

// unset $extra_fields
unset($extra_fields);

// process the action type and get the data from cache is possible
switch($action['tablename'])
{
	// user table cache
	case('user'):
	{
		// setup the pointer to the userinfo in memory
		$tabledata = $vbulletin->userinfo;
		break;
	}
	// all other cases, query the database
	default:
	{
		// retrieve the data from the database
		$tabledata = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . $action['tablename']);
		if (!$tabledata || empty($tabledata))
		{
			// display error, table not found in the database
			eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
		}
		break;
	}
}

// check if this user has any changealways features
$canalwayschange = false;
$changealways = explode(",", $vbulletin->userinfo['vbp_changealwaysitems']);
if ((is_array($changealways) && in_array($action['itemid'], $changealways)) || ($action['changealways']))
{
	// set it so that this feature can always change
	$canalwayschange = true;
}

// process the fieldtype
switch($action['settype'])
{
	// process an input field
	case(1):
	{
		// check if the user already has this option
		if (($_REQUEST['step'] < '11') && !empty($tabledata[$action['setname']]))
		{
			// set it so this option can be removed
			$canremove = true;

			// verify if the user can always change this
			if (!$canalwayschange)
			{
				// change the step to allow to remove this feature
				$_REQUEST['step'] = '11';
				$nextstep = $_REQUEST['step'] + 1;
			}
			else
			{
				// set this item to cost 0 because they are simply changing it
				$action['cost'] = 0;
			}
		}
		break;
	}
	// process a flags field
	case(2):
	{
		// check if the user already has this option
		if (($_REQUEST['step'] < '11') && ($tabledata[$action['setname']] & intval($action['setvalue'])))
		{
			// set it so this option can be removed
			$canremove = true;

			// verify if the user can always change this
			if (!$canalwayschange)
			{
				// change the step to allow to remove this feature
				$_REQUEST['step'] = '11';
				$nextstep = $_REQUEST['step'] + 1;
			}
			else
			{
				// set this item to cost 0 because they are simply changing it
				$action['cost'] = 0;
			}
		}
		break;
	}
	// process an add integer field
	case(3): { break; }
	// unrecognized fieldtype
	default:
	{
		// display error, unrecognized fieldtype
		eval(standard_error(fetch_error('vbplaza_unrecognized_set_type')));
	}
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// user is trying to purchase, validate the costs
	vbplaza_validate_cost($action);

	// process all of the $action['inputfields']
	$action = vbplaza_build_inputfields($action);

	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_genericaction_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');

	// check if this option is removable
	if ($canremove)
	{
		// change the step to allow to remove this feature
		$_REQUEST['step'] = '11';
		$nextstep = $_REQUEST['step'] + 1;

		// add a blank line after the above $current
		$current .= "<br />";
	}
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_genericaction_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// user is trying to purchase, validate the costs
	vbplaza_validate_cost($action);

	// process the fieldtype
	unset($querystr);
	switch($action['settype'])
	{
		// process an input field
		case(1):
		{
			// build the query field to set
			$querystr = $action['setname'] . " = '" . htmlspecialchars_uni($action['setvalue']) . "'";
			break;
		}
		// process a flags field
		case(2):
		{
			// build the query field to set
			$querystr = $action['setname'] . " = (" . $action['setname'] . " | " . intval($action['setvalue']) . ")";
			break;
		}
		// process an add integer field
		case(3):
		{
			// build the query field to set
			$querystr = $action['setname'] . " = (" . $action['setname'] . " + " . intval($action['setvalue']) . ")";
			break;
		}
	}

	// check if the $action['tablename'] is the same as the vbbux_pointstable (so it can update all values in 1 query)
	if ($action['tablename'] == $vbulletin->options['vbbux_pointstable'])
	{
		// set the fields that are necessary
		$extrafields = array();
		$extrafields[] = $querystr;

		// update this purchase with the user
		vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);
	}
	else
	{
		// table fields being modified are not in the same one as the vbbux_pointstable
		// so send the query to do the modifications first
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . $action['tablename'] . "
			SET
				" . $querystr . "
			WHERE " . $action['wherename'] . " = '" . $wherevalue . "'
		");

		// update this purchase with the user
		vbplaza_user_purchase_update($vbulletin->userinfo, $action);
	}

	// update the quantity/sold
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_genericaction_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}

// process step '11' (remove purchase step)
if ($_REQUEST['step'] == '11')
{
	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_remove'] . " " . $action['name'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_genericaction_removal_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_removal') . '";');
}

// process step '12' (perform actual remove)
if ($_REQUEST['step'] == '12')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_genericaction_removal_start')) ? eval($hook) : false;

	// process the fieldtype
	unset($querystr);
	switch($action['settype'])
	{
		// process an input field
		case(1):
		{
			// verify that they do not have this field already removed
			if (empty($tabledata[$action['setname']]))
			{
				// display error, you do not have this installed
				eval(standard_error(fetch_error('vbplaza_item_already_removed')));
			}

			// build the query field to set
			$querystr = $action['setname'] . " = ''";
			break;
		}
		// process a flags field
		case(2):
		{
			// verify that they do not have this field already removed
			if (!($tabledata[$action['setname']] & intval($action['setvalue'])))
			{
				// display error, you do not have this installed
				eval(standard_error(fetch_error('vbplaza_item_already_removed')));
			}

			// build the query field to set
			$querystr = $action['setname'] . " = (" . $action['setname'] . " & " . (-1 ^ $action['setvalue']) . ")";
			break;
		}
	}

	// check if the $action['tablename'] is the same as the vbbux_pointstable (so it can update all values in 1 query)
	$extrafields = array();
	if ($action['tablename'] != $vbulletin->options['vbbux_pointstable'])
	{
		// table fields being modified are not in the same one as the vbbux_pointstable
		// so send the query to do the modifications first
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . $action['tablename'] . "
			SET
				" . $querystr . "
			WHERE " . $action['wherename'] . " = '" . $wherevalue . "'
		");
	}
	else
	{
		// add this to the $extrafields
		$extrafields[] = $querystr;
	}

	// update this purchase with the user
	$action['removal'] = true;
	vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields);

	// setup the $pagetitle
	$pagetitle = $vbphrase['vbplaza_remove'] . " " . $action['name'];

	($hook = vBulletinHook::fetch_hook('vbplaza_action_genericaction_removal_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_removed') . '";');
}
?>