<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// set it to show the section header
$show['customheader'] = true;
$action['customheader'] = $vbphrase['vbplaza_attempt_thief'];

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// fetch the userinfo if it was specified
	if (is_numeric($_REQUEST['userid']))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE userid = '" . $_REQUEST['userid'] . "'");
	}

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['username'];
	$action['fieldname'] = 'username';
	$action['fieldvalue'] = $touser['username'];
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	$action['phrasename'] = $vbphrase['vbplaza_thief_amount'];
	$action['fieldname'] = 'thiefamount';
	$action['fieldvalue'] = '';
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');

	($hook = vBulletinHook::fetch_hook('vbplaza_action_thief_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_thief_process_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// strip out all comma's
	$action['thiefamount'] = str_replace(",", "", $action['thiefamount']);

	// verify the thiefamount to transfer is positive
	if (!is_numeric($action['thiefamount']) || ($action['thiefamount'] < 0))
	{
		// display error, invalid transfer amount
		eval(standard_error(fetch_error('vbplaza_invalid_transfer_amount')));
	}

	// verify the user attempting to steal has this many points at least first
	if ($vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']] < $action['thiefamount'])
	{
		// display error, not enough points
		eval(standard_error(fetch_error('vbplaza_not_enough_points')));
	}

	// verify that they have entered a username to change
	if (empty($action['username']))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$action['username'] = htmlspecialchars_uni($action['username']);

	// check if this user exists (first search by username)
	$touser = $db->query_first("SELECT userid, usergroupid, username, `" . $vbulletin->options['vbbux_pointsfield'] . "`, vbp_history, vbp_immunity FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

	// if it was not found by username, search by userid
	if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, usergroupid, username, `" . $vbulletin->options['vbbux_pointsfield'] . "`, vbp_history, vbp_immunity FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// verify the user has enough points to cover the theft
	if ($touser[$vbulletin->options['vbbux_pointsfield']] < $action['thiefamount'])
	{
		// display error, not enough points
		eval(standard_error(fetch_error('vbplaza_they_dont_have_enough_points')));
	}

	// check if the staff protection is enabled
	if ($action['vbplaza_thieffailsforstaff'])
	{
		// check if the $touser is staff
		if (($touser['usergroupid'] >= 5) && ($touser['usergroupid'] <= 7))
		{
			// display error, this user is protected against this action
			eval(standard_error(fetch_error('vbplaza_protected_user')));
		}
	}

	// check if this user is immune to this operation
	if ($touser['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['thief'])
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// check if they are allowed to steal this many points
	if ($action['thiefamount'] >= intval($action['vbplaza_thiefmaxtheftamount']))
	{
		// display error, you can not steal this many points
		eval(standard_error(fetch_error('vbplaza_can_not_steal_this_many_points')));
	}

	// simple calculation for now to check whether or not the thief was successful
	$randnum = rand(0, 100);
	$thiefsuccessful = false;
	if ($randnum < $action['vbplaza_thiefsuccessrate'])
	{
		// set this flag that Thief was successful
		$thiefsuccessful = true;
	}

	// take the money from the user if the Thief was successful
	if ($thiefsuccessful)
	{
		// add this purchase to the touser's history
		$extrafields = array();
		$action['removal'] = true;
		$action['touserid'] = $vbulletin->userinfo['userid'];
		$action['tousername'] = $vbulletin->userinfo['username'];
		unset($action['fromuserid']);
		unset($action['fromusername']);
		$action['finalcost'] = $action['thiefamount'];
		$action['reason'] = $vbphrase['vbplaza_thief_attempt_successful_from'] . " <a href=\"member.php?u=". $vbulletin->userinfo['userid'] . "\">" . $vbulletin->userinfo['username'] . "</a>.";
		vbplaza_user_purchase_update($touser, $action, $extrafields, true);

		// should the user lose any reputation for this thievery
		$extrafields = array();
		if ($action['vbplaza_thiefreputationlosswon'] != 0)
		{
			// subtract from the users reputation
			$reputation = $vbulletin->userinfo['reputation'] - $action['vbplaza_thiefreputationlosswon'];
			if ($reputation < 0) { $reputation = 0; }

			// subtract from the users reputation
			$extrafields[] = "reputation = '" . $reputation . "'";
		}

		// update this purchase with the user
		$action['removal'] = false;
		unset($action['touserid']);
		unset($action['tousername']);
		$action['fromuserid'] = $touser['userid'];
		$action['fromusername'] = $touser['username'];
		$action['finalcost'] = $action['thiefamount'];
		$action['reason'] = $vbphrase['vbplaza_thief_attempt_successful_from'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
		vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields, true);

		// update some more notes variables
		$action['purchasenotes'] = $vbphrase['vbplaza_thief_successful'] . " " . $action['thiefamount'] . " " . $vbphrase['vbbux_points'] . " " . $vbphrase['vbplaza_from'] . " <a href=\"member.php?u=" . $touser['userid'] . "\">" . $touser['username'] . "</a>.";
		$action['extrainfo'] = $vbphrase['vbplaza_thief_attempt_successful_from'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
	}
	else
	{
		// check if the theftee should receive the points
		if ($action['vbplaza_thieffailstouser'])
		{
			// update this purchase with the user
			$extrafields = array();
			unset($action['touserid']);
			unset($action['tousername']);
			$action['fromuserid'] = $vbulletin->userinfo['userid'];
			$action['fromusername'] = $vbulletin->userinfo['username'];
			$action['finalcost'] = $action['thiefamount'];
			$action['removal'] = false;
			$action['reason'] = $vbphrase['vbplaza_thief_attempt_unsuccessful_from'] . " <a href=\"member.php?u=". $vbulletin->userinfo['userid'] . "\">" . $vbulletin->userinfo['username'] . "</a>.";
			vbplaza_user_purchase_update($touser, $action, $extrafields, true);
		}

		// should the user lose any reputation for this thievery
		$extrafields = array();
		if ($action['vbplaza_thiefreputationlosslost'] != 0)
		{
			// subtract from the users reputation
			$reputation = $vbulletin->userinfo['reputation'] - $action['vbplaza_thiefreputationlosslost'];
			if ($reputation < 0) { $reputation = 0; }

			// subtract from the users reputation
			$extrafields[] = "reputation = '" . $reputation . "'";
		}

		// check if the theftee should receive the points
		if ($action['vbplaza_thieffailstouser'])
		{
			// add this purchase to the user's history
			$action['touserid'] = $touser['userid'];
			$action['tousername'] = $touser['username'];
			unset($action['fromuserid']);
			unset($action['fromusername']);
		}
		else
		{
			// add this purchase to the user's history
			unset($action['touserid']);
			unset($action['tousername']);
			$action['fromuserid'] = $vbulletin->userinfo['userid'];
			$action['fromusername'] = $vbulletin->userinfo['username'];
		}

		// update this purchase with the user
		$action['removal'] = true;
		$action['finalcost'] = $action['thiefamount'];
		$action['reason'] = $vbphrase['vbplaza_thief_attempt_unsuccessful_from'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
		vbplaza_user_purchase_update($vbulletin->userinfo, $action, $extrafields, true);

		// update some more notes variables
		$action['purchasenotes'] = $vbphrase['vbplaza_thief_failed'] . " " . $action['thiefamount'] . " " . $vbphrase['vbbux_points'] . ".";
		$action['extrainfo'] = $vbphrase['vbplaza_thief_attempt_unsuccessful_from'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
	}

	// update the quantity/sold
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_thief_process_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>