<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// find all of the lotteries
	$lotteries = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE active = 1 ORDER BY lotteryid");
	if (!$lotteries)
	{
		// display error, no lotteries found
		eval(standard_error(fetch_error('vbplaza_lottery_none_found')));
	}

	// cache all of the lotteries
	$vbplazalotteries = array();
	while ($lottery = $vbulletin->db->fetch_array($lotteries))
	{
		// cache this lottery
		$vbplazalotteries[] = $lottery;
	}

	// free the lotteries
	$vbulletin->db->free_result($lotteries);

	// set the cost to 0 to not display their costs
	$action['cost'] = 0;

	// process all lotteries found
	$action['options'] = '';
	foreach($vbplazalotteries AS $lottery)
	{
		// format the ticketcost
		$lottery['ticketcost'] = vb_number_format($lottery['ticketcost'], $vbulletin->options['vbbux_decimalplaces']);

		// add this lottery to the valid ones
		$action['options'] .= "<option value=\"" . $lottery['lotteryid'] . "\">" . $lottery['name'] . " (" . $lottery['ticketcost'] . " " . $vbphrase['vbbux_points'] . ")</option>";
	}

	// build the $extra_fields
	$before_select .= "<div class=\"smallfont\"><a href=\"vbplaza.php?do=lotterywinners\">" . $vbphrase['vbplaza_previous_lottery_winners'] . "</a></div><br />";
	$action['phrasename'] = $vbphrase['vbplaza_lottery_name'];
	$action['fieldname'] = "lotteryid";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');
	if (!empty($extra_fields)) { $extra_fields .= "<br />"; }

	($hook = vBulletinHook::fetch_hook('vbplaza_action_lottery_choosetype_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (confirming price for lottery)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_lottery_confirm_start')) ? eval($hook) : false;

	// verify that the lottery exists
	if (!is_numeric($action['lotteryid']))
	{
		// display error, lottery does not exist
		eval(standard_error(fetch_error('vbplaza_lottery_does_not_exist')));
	}

	// search for the lottery
	$lottery = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE lotteryid = '" . $action['lotteryid'] . "' AND active = 1");

	// check if the lottery was found
	if (!is_numeric($lottery['lotteryid']))
	{
		// display error, lottery does not exist
		eval(standard_error(fetch_error('vbplaza_lottery_does_not_exist')));
	}

	// recalculate the costs
	$action['cost'] = $lottery['ticketcost'];
	$action = vbplaza_calculate_total_cost($action);

	// re-validate the cost with the new total now
	vbplaza_validate_cost($action);

	// build the totals for the amounts
	$action['ticketprice'] = number_format($lottery['ticketcost'], $vbulletin->options['vbplaza_decimalplaces']);
	$action['jackpot'] = number_format($lottery['jackpot'], $vbulletin->options['vbplaza_decimalplaces']);
	$action['enddate'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $lottery['enddateline']);

	// build the $extra_fields
	$extra_custom .= "<div class=\"smallfont\"><a href=\"vbplaza.php?do=lotterywinners\">" . $vbphrase['vbplaza_previous_lottery_winners'] . "</a></div><br />";
	$extra_custom .= "<input type=hidden name=\"action[lotteryid]\" value=\"" . $lottery['lotteryid'] . "\">\n";
	$extra_custom .= "<div class=\"smallfont\">" . $vbphrase['vbplaza_lottery_name'] . ": " . $lottery['name'] . "</div>";
	$extra_custom .= "<div class=\"smallfont\">" . $vbphrase['vbplaza_jackpot_amount'] . ": " . $action['jackpot'] . "</div>";
	$extra_custom .= "<div class=\"smallfont\">" . $vbphrase['vbplaza_ticket_price'] . ": " . $action['ticketprice'] . "</div>";
	$extra_custom .= "<div class=\"smallfont\">" . $vbphrase['vbplaza_lottery_ends_approximately'] . ": " . $action['enddate'] . "</div>";
	$extra_custom .= "<div class=\"smallfont\">" . $vbphrase['vbplaza_max_tickets_per_user'] . ": " . $lottery['maxticketperuser'] . "</div>";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_custom') . '";');
	if ($lottery['maxticketperuser'] > 0)
	{
		// display the number of tickets to purchase
		$action['nowrap'] = true;
		$action['phrasename'] = $vbphrase['vbplaza_number_of_tickets_to_purchase'];
		$action['fieldname'] = 'ticketsamount';
		$action['fieldvalue'] = 1;
		eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_action_lottery_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '3' (perform actual purchase)
if ($_REQUEST['step'] == '3')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_lottery_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that the lottery exists
	if (!is_numeric($action['lotteryid']))
	{
		// display error, lottery does not exist
		eval(standard_error(fetch_error('vbplaza_lottery_does_not_exist')));
	}

	// search for the lottery
	$lottery = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE lotteryid = '" . $action['lotteryid'] . "' AND active = 1");

	// check if the lottery was found
	if (!is_numeric($lottery['lotteryid']))
	{
		// display error, lottery does not exist
		eval(standard_error(fetch_error('vbplaza_lottery_does_not_exist')));
	}

	// check if this lottery has a limit to how many tickets a user can have
	if ($lottery['maxticketperuser'] > 0)
	{
		// check if the user is trying to purchase too many tickets
		if ($action['ticketsamount'] > $lottery['maxticketperuser'])
		{
			// force this value down to the maxticketperuser
			$action['ticketsamount'] = $lottery['maxticketperuser'];
		}

		// count how many times this user has purchased a ticket for this lottery
		$tickets = $vbulletin->db->query_first("
			SELECT COUNT(*) AS count
			FROM " . TABLE_PREFIX . "vbplaza_lotteryticket
			WHERE lotteryid = '" . $lottery['lotteryid'] . "'
				AND userid = '" . $vbulletin->userinfo['userid'] . "'
		");

		// check if it found any tickets
		if (is_numeric($tickets['count']) && ($tickets['count'] > 0))
		{
			// check if this is equal to or more than the allowed amount
			if ($tickets['count'] >= $lottery['maxticketperuser'])
			{
				// display error, you have purchased the maximum amount of tickets
				eval(standard_error(fetch_error('vbplaza_lottery_max_tickets_purchased')));
			}
		}
	}
	else
	{
		// force $tickets['count'] to 0
		$tickets['count'] = 0;
	}

	// check how many tickets were purchased (needs to be at least 1)
	if (!is_numeric($action['ticketsamount']) || ($action['ticketsamount'] < 1))
	{
		// force it to at least 1 ticket sold
		$action['ticketsamount'] = 1;
	}
	else
	{
		// force the maximum down some
		if ($action['ticketsamount'] > 50)
		{
			// force the amount down to 50
			$action['ticketsamount'] = 50;
		}
	}

	// check if the user has purchased any tickets before
	if (is_numeric($tickets['count']) && ($tickets['count'] > 0))
	{
		// check if it needs to reset the amount of tickets to purchase down some
		if (($action['ticketsamount'] + $tickets['count']) > $lottery['maxticketperuser'])
		{
			// subtract the number of tickets the user already has
			$action['ticketsamount'] = $lottery['maxticketperuser'] - $tickets['count'];
		}
	}

	// check if the there are still more tickets this user can purchase
	if ($action['ticketsamount'] > 0)
	{
		// check if this lottery has a maximum amount of tickets that can be purchased
		if ($lottery['maxtickets'] > 0)
		{
			// check if this would be over the limit
			if (($action['ticketsamount'] + $lottery['ticketssold']) > $lottery['maxtickets'])
			{
				// force the correct amount of tickets
				$action['ticketsamount'] = $lottery['maxtickets'] - $lottery['ticketssold'];
			}
		}

		// recalculate the costs for 1 ticket
		$action['cost'] = $lottery['ticketcost'];
		$action = vbplaza_calculate_total_cost($action);

		// increase the total amount of the finalcost by how many tickets are being purchased
		$action['finalcost'] = $action['finalcost'] * $action['ticketsamount'];

		// re-validate the cost with the new total now
		vbplaza_validate_cost($action);

		// process all of the tickets
		$valuesfield = array();
		for ($i = 0; $i < $action['ticketsamount']; $i++)
		{
			// add this to the values field
			$valuesfield[] = "(0, '" . $lottery['lotteryid'] . "', '" . $vbulletin->userinfo['userid'] . "', '" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "', " . TIMENOW . ", " . $lottery['ticketcost'] . ", '" . IPADDRESS . "')";
		}

		// build the valuesstr for the INSERT
		$valuestr = "VALUES\n" . implode(",\n", $valuesfield);

		// verify that a $valuestr was built
		if (!empty($valuestr))
		{
			// insert the tickets into the database
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "vbplaza_lotteryticket (entryid, lotteryid, userid, username, dateline, ticketprice, ipaddress)
				" . $valuestr . "
			");
		}
	}
	else
	{
		// display error, you have purchased the maximum amount of tickets
		eval(standard_error(fetch_error('vbplaza_lottery_max_tickets_purchased')));
	}

	// check if it should update the jackpot too
	$jackpotstr = '';
	if ($lottery['ticketbuild'])
	{
		// make it increase the jackpot by the price of the ticketcost
		$jackpotstr = ", jackpot = jackpot + " . $action['finalcost'];
	}

	// update the ticketssold and maybe jackpot
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "vbplaza_lottery
		SET
			ticketssold = ticketssold + " . $action['ticketsamount'] . "
			" . $jackpotstr . "
		WHERE lotteryid = '" . $lottery['lotteryid'] . "'
	");

	// update this purchase with the user
	$action['expirydate'] = 0;
	$action['reason'] = $vbphrase['vbplaza_lottery_name'] . ": " . $lottery['name'] . " - " . $vbphrase['vbplaza_lottery_number_tickets'] . ": " . $action['ticketsamount'];
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_lottery_name'] . ": " . $lottery['name'] . " - " . $vbphrase['vbplaza_lottery_number_tickets'] . ": " . $action['ticketsamount'];
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	// check if it should draw a winner
	if ($lottery['maxtickets'] > 0)
	{
		// check if the amount of tickets purchased was high enough to end the lottery
		if (($action['ticketsamount'] + $lottery['ticketssold']) >= $lottery['maxtickets'])
		{
			// draw a winner now
			vbplaza_draw_lottery_winner($lottery['lotteryid']);
		}
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_action_lottery_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>