<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// build the $extra_fields
	$action['nowrap'] = true;
	$action = vbplaza_build_inputfields($action);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeotherusertitle_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeotherusertitle_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// verify that they have entered a user title to change to
	if (empty($action['usertitle']))
	{
		// display error, no user title entered
		eval(standard_error(fetch_error('vbplaza_user_title_not_entered')));
	}

	// verify that they have entered a username to change
	if (empty($action['username']))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$action['username'] = htmlspecialchars_uni($action['username']);

	// check if this user exists (first search by username)
	$touser = $db->query_first("SELECT userid, usergroupid, membergroupids, username, vbp_history, vbp_immunity FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

	// if it was not found by username, search by userid
	if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, usergroupid, membergroupids, username, vbp_history, vbp_immunity FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// verify that they are not trying to use this action on themself
	if ($touser['userid'] == $vbulletin->userinfo['userid'])
	{
		// display error, can not do this action to yourself
		eval(standard_error(fetch_error('vbplaza_can_not_do_this_action_to_yourself')));
	}

	// check to see if this user is protected
	$protectedusergroups = explode(",", $vbulletin->options['vbplaza_protectedusergroups']);
	if (is_member_of($touser, $protectedusergroups))
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// check if this user is immune to this operation
	if ($touser['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['changeusertitle'])
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// get the newusertitle
	$newusertitle = stripslashes($action['usertitle']);

	// verify the newusertitle does not have any HTML code in it
	if (strchr($newusertitle, '<'))
	{
		// display error, new username is too short
		eval(standard_error(fetch_error('vbplaza_html_not_allowed')));
	}

	// check if bbcode is allowed
	if ($action['vbplaza_usertitle_allow_bbcode'])
	{
		// parse any bbcode first
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
		$newusertitle = $bbcode_parser->parse($newusertitle, 'nonforum');
	}

	// strip out the html to check out the actual user title
	$newusertitle_stripped = $vbulletin->input->clean($newusertitle, TYPE_NOHTML);

	// verify the newusertitle is proper
	if (strlen($newusertitle_stripped) < $vbulletin->options['minuserlength'])
	{
		// display error, new usertitle is too short
		eval(standard_error(fetch_error('vbplaza_usertitle_too_short')));
	}
	if (strlen($newusertitle_stripped) > $vbulletin->options['ctMaxChars'])
	{
		// display error, new usertitle is too long
		eval(standard_error(fetch_error('vbplaza_usertitle_too_long')));
	}
	if ($newusertitle_stripped != fetch_censored_text($newusertitle_stripped))
	{
		// display error, new usertitle uses censored word
		eval(standard_error(fetch_error('vbplaza_usertitle_censored')));
	}
	if (!empty($vbulletin->options['illegalusernames']))
	{
		// get the array of illegal usernames
		$usernames = preg_split('/\s+/', $vbulletin->options['illegalusernames'], -1, PREG_SPLIT_NO_EMPTY);

		// process each username
		foreach ($usernames AS $name)
		{
			// check if its contained
			if (strpos(strtolower($newusertitle_stripped), strtolower($name)) !== false)
			{
				// display error, new username contains illegal word/phrase
				eval(standard_error(fetch_error('vbplaza_username_illegal')));
			}
		}
	}

	// setup the $extrafields
	$extrafields = array();
	$extrafields[] = "customtitle = '1'";
	$extrafields[] = "usertitle = '" . $vbulletin->db->escape_string(htmlspecialchars_uni($newusertitle)) . "'";

	// update this purchase with the user specified
	unset($action['touserid']);
	unset($action['tousername']);
	$action['fromuserid'] = $vbulletin->userinfo['userid'];
	$action['fromusername'] = $vbulletin->userinfo['username'];
	$action['nopointschange'] = true;
	vbplaza_user_purchase_update($touser, $action, $extrafields, true);

	// update this purchase with the user
	$action['touserid'] = $touser['userid'];
	$action['tousername'] = $touser['username'];
	unset($action['fromuserid']);
	unset($action['fromusername']);
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_purchased_for'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>. " . $vbphrase['vbplaza_changed_to'] . " ". $newusertitle . ".";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeotherusertitle_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>