<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	echo "This file must be run by the vbPlaza script.";
	exit;
}

// setup the $pagetitle
$pagetitle = $vbphrase['vbplaza_purchase'] . " " . $action['name'];

// unset $extra_fields
unset($extra_fields);

// process the data properly for the table specified
if ($action['tablename'] != 'user')
{
	// display error, table name is invalid
	eval(standard_error(fetch_error('vbplaza_invalid_table_name')));
}

// process step '1' (confirm purchase step)
if ($_REQUEST['step'] == '1')
{
	// set that it needs formdata
	$show['needsformdata'] = true;

	// build the hidden fields
	$hidden_fields .= "<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"2097152\" />\n";

	// build the $extra_fields
	$action['phrasename'] = $vbphrase['vbplaza_username'];
	$action['fieldname'] = 'username';
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
	$action['type'] = 'file';
	$action['nowrap'] = true;
	$action['upload'] = true;
	$action['phrasename'] = $vbphrase['vbplaza_upload_avatar_your_computer'];
	$extra_input = "onChange=\"check_yes('avatar_yes')\"";
	eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeotherscustomavatar_confirm_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmation') . '";');
}

// process step '2' (perform actual purchase)
if ($_REQUEST['step'] == '2')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeotherscustomavatar_purchase_start')) ? eval($hook) : false;

	// check and verify flood
	$action = vbplaza_action_check_for_flood($action);

	// verify that 'finalcost' is not empty somehow
	if (!is_numeric($action['finalcost']))
	{
		// display error, invalid final cost
		eval(standard_error(fetch_error('vbplaza_invalid_final_cost')));
	}

	// verify that they have entered a username to change
	if (empty($action['username']))
	{
		// display error, no username entered
		eval(standard_error(fetch_error('vbplaza_username_not_entered')));
	}

	// build the proper names with html codes
	$action['username'] = htmlspecialchars_uni($action['username']);

	// check if this user exists (first search by username)
	$touser = $db->query_first("SELECT userid, usergroupid, membergroupids, username, vbp_history, vbp_immunity, vbp_genericperm FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string($action['username']) . "'");

	// if it was not found by username, search by userid
	if (!is_numeric($touser['userid']) && (is_numeric($action['username'])))
	{
		// search for the userid
		$touser = $db->query_first("SELECT userid, usergroupid, membergroupids, username, vbp_history, vbp_immunity, vbp_genericperm FROM " . TABLE_PREFIX . "user WHERE userid = '" . $action['username'] . "'");
	}

	// check if the user was really found
	if (!is_numeric($touser['userid']))
	{
		// display error, user was not found
		eval(standard_error(fetch_error('vbplaza_user_not_found')));
	}

	// verify that they are not trying to use this action on themself
	if ($touser['userid'] == $vbulletin->userinfo['userid'])
	{
		// display error, can not do this action to yourself
		eval(standard_error(fetch_error('vbplaza_can_not_do_this_action_to_yourself')));
	}

	// check to see if this user is protected
	$protectedusergroups = explode(",", $vbulletin->options['vbplaza_protectedusergroups']);
	if (is_member_of($touser, $protectedusergroups))
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// check if this user is immune to this operation
	if ($touser['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['changecustomavatar'])
	{
		// display error, this user is protected against this action
		eval(standard_error(fetch_error('vbplaza_protected_user')));
	}

	// get the permissions for the user found
	$touser['permissions'] = cache_permissions($touser);

	// need to fix some permissions for it to work properly
	if ((!($touser['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar']))
		|| ($touser['vbp_genericperm'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar']))
	{
		// set it so they can use an avatar
		$touser['permissions']['genericpermissions'] |= $vbulletin->bf_ugp_genericpermissions['canuseavatar'];

		// check if it is not always using the default settings
		if (!$vbulletin->options['vbplaza_alwaysusedefavatar'])
		{
			// build the $ids to query from the database
			if (empty($touser['membergroupids']))
			{
				// build the $ids simply
				$ids = "0," . $touser['usergroupid'];
			}
			else
			{
				// add in the membergroupids too
				$ids = "0," . $touser['membergroupids'] . "," . $touser['usergroupid'];
			}

			// grab these $usergroups from the database
			$usergroups = $vbulletin->db->query_read("SELECT avatarmaxwidth, avatarmaxheight, avatarmaxsize FROM " . TABLE_PREFIX . "usergroup WHERE usergroupid IN (" . $ids . ")");
			while ($usergroup = $vbulletin->db->fetch_array($usergroups))
			{
				// check if the width in this usergroup is > than the value already set
				if ($touser['permissions']['avatarmaxwidth'] < $usergroup['avatarmaxwidth'])
				{
					// set this value for the avatarmaxwidth
					$touser['permissions']['avatarmaxwidth'] = $usergroup['avatarmaxwidth'];
				}

				// check if the height in this usergroup is > than the value already set
				if ($touser['permissions']['avatarmaxheight'] < $usergroup['avatarmaxheight'])
				{
					// set this value for the avatarmaxheight
					$touser['permissions']['avatarmaxheight'] = $usergroup['avatarmaxheight'];
				}

				// check if the size in this usergroup is > than the value already set
				if ($touser['permissions']['avatarmaxsize'] < $usergroup['avatarmaxsize'])
				{
					// set this value for the avatarmaxsize
					$touser['permissions']['avatarmaxsize'] = $usergroup['avatarmaxsize'];
				}
			}
		}

		// check if the settings are not -1
		if ($touser['permissions']['avatarmaxwidth'] == -1)
		{
			// force the value to be the setting in the configuration
			$touser['permissions']['avatarmaxwidth'] = $vbulletin->options['vbplaza_defavatarmaxwidth'];
		}
		if ($touser['permissions']['avatarmaxheight'] == -1)
		{
			// force the value to be the setting in the configuration
			$touser['permissions']['avatarmaxheight'] = $vbulletin->options['vbplaza_defavatarmaxheight'];
		}
		if ($touser['permissions']['avatarmaxsize'] == -1)
		{
			// force the value to be the setting in the configuration
			$touser['permissions']['avatarmaxsize'] = $vbulletin->options['vbplaza_defavatarmaxsize'];
		}
	}

	// check one last time that the settings are not negative
	if ($touser['permissions']['avatarmaxwidth'] < 0)
	{
		// this is here to force it to not have a PHP error
		$touser['permissions']['avatarmaxwidth'] = 80;
	}
	if ($touser['permissions']['avatarmaxheight'] < 0)
	{
		// this is here to force it to not have a PHP error
		$touser['permissions']['avatarmaxheight'] = 80;
	}
	if ($touser['permissions']['avatarmaxsize'] < 0)
	{
		// this is here to force it to not have a PHP error
		$touser['permissions']['avatarmaxsize'] = 20000;
	}

	// save a copy of the old userinfo
	$realuser = $vbulletin->userinfo;

	// clean the uploaded file
	$vbulletin->input->clean_gpc('f', 'upload', TYPE_FILE);

	// begin custom avatar upload checking
	require_once(DIR . '/includes/class_upload.php');
	require_once(DIR . '/includes/class_image.php');
	$upload = new vB_Upload_Userpic($vbulletin);
	$upload->data =& datamanager_init('Userpic_Avatar', $vbulletin, ERRTYPE_STANDARD, 'userpic');
	$upload->image =& vB_Image::fetch_library($vbulletin);
	$upload->userinfo = fetch_userinfo($touser['userid']);
	$upload->maxwidth = $touser['permissions']['avatarmaxwidth'];
	$upload->maxheight = $touser['permissions']['avatarmaxheight'];
	$upload->maxuploadsize = $touser['permissions']['avatarmaxsize'];
	$upload->allowanimation = ($touser['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['cananimateavatar']) ? true : false;
	if (!$upload->process_upload($vbulletin->GPC['avatarurl']))
	{
		// display the vB error code
		eval(standard_error($upload->fetch_error()));
	}

	// set the realuser back to the proper one
	$vbulletin->userinfo = $realuser;

	// setup the $extrafields
	$extrafields = array();
	$extrafields[] = "avatarid = '0'";

	// update this purchase with the user specified
	unset($action['touserid']);
	unset($action['tousername']);
	$action['fromuserid'] = $vbulletin->userinfo['userid'];
	$action['fromusername'] = $vbulletin->userinfo['username'];
	$action['nopointschange'] = true;
	vbplaza_user_purchase_update($touser, $action, $extrafields, true);

	// update this purchase with the user
	$action['touserid'] = $touser['userid'];
	$action['tousername'] = $touser['username'];
	unset($action['fromuserid']);
	unset($action['fromusername']);
	vbplaza_user_purchase_update($vbulletin->userinfo, $action);

	// update the quantity/sold
	$action['extrainfo'] = $vbphrase['vbplaza_purchased_for'] . " <a href=\"member.php?u=". $touser['userid'] . "\">" . $touser['username'] . "</a>.";
	vbplaza_update_quantity_sold($action);

	// update the datastore
	vbplaza_update_datastore(true);

	($hook = vBulletinHook::fetch_hook('vbplaza_action_changeotherscustomavatar_purchase_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_item_confirmed') . '";');
}
?>