<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbplaza');
define('VBPLAZA_RUNNING', true);
define('VBPLAZA_SCRIPT_VERSION', '1.5.8');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('vbplaza');

// get special data templates from the datastore
$specialtemplates = array('vbplazacategory', 'vbplazaoptions', 'vbplazaribbons', 'vbbuxfederalbank');

// pre-cache templates used by all actions
$globaltemplates = array(
	'vbplaza_main',
	'vbplaza_nav_categorybits',
	'vbplaza_history_list',
	'vbplaza_history_bits'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'action' => array(
		'vbplaza_item_confirmation',
		'vbplaza_item_confirmed',
		'vbplaza_item_removal',
		'vbplaza_item_removed',
		'vbplaza_item_extra_input',
		'vbplaza_item_extra_select',
		'vbplaza_item_extra_custom',
		'vbplaza_ribbon_causes',
		'vbplaza_ribbon_causebit',
		'vbplaza_bank_confirmation'
	),
	'listcat' => array(
		'vbplaza_items_vbplaza_list',
		'vbplaza_items_vbplaza_bits',
		'vbplaza_items_ibproarcade_list',
		'vbplaza_items_ibproarcade_bits'
	),
	'mostsold' => array(
		'vbplaza_mostsold_list',
		'vbplaza_mostsold_bits',
	),
	'richestusers' => array(
		'vbplaza_richest_list',
		'vbplaza_richest_bits'
	),
	'itemhistory' => array(
		'vbplaza_history_itemlist',
		'vbplaza_history_itembits'
	),
	'lotterywinners' => array(
		'vbplaza_lottery_current_list',
		'vbplaza_lottery_current_bits',
		'vbplaza_lottery_list',
		'vbplaza_lottery_bits'
	),
	'namechanges' => array(
		'vbplaza_namechanges_list',
		'vbplaza_namechanges_bits'
	),
	'editvbpoptions' => array(
		'vbplaza_edit_vbp_options',
		'vbplaza_edit_option_select'
	),
	'download' => array('vbplaza_download_confirmation'),
	'play' => array('vbplaza_arcadeplay_confirmation')
);
$actiontemplates['donate'] =& $actiontemplates['action'];
$actiontemplates['givegift'] =& $actiontemplates['action'];
$actiontemplates['giveribbon'] =& $actiontemplates['action'];
$actiontemplates['updatevbpoptions'] =& $actiontemplates['editvbpoptions'];

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_vbplaza.php');
require_once(DIR . '/includes/functions_user.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// verify the user is registered and signed in
if (!$vbulletin->userinfo['userid'] || !$vbulletin->userinfo['vbp_storeaccess'])
{
	// display error, no permission (must be registered)
	print_no_permission();
}

// check if their usergroup is allowed to access vbPlaza
if (!($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canpurchaseoptions']))
{
	// display error, no permission for this usergroup
	eval(standard_error(fetch_error('vbplaza_no_permission_purchase_options', $vbphrase['vbplaza_name'])));
}

// check the setup of the special templates
vbplaza_setup_special_template('vbplazacategory');
vbplaza_setup_special_template('vbplazaoptions');
vbplaza_setup_special_template('vbplazaribbons');

// check to see if any options need refilled
vbplaza_check_and_refill_options($vbulletin->vbplazaoptions);

// verify that the user has the latest version XML file imported
if ($vbulletin->options['vbplaza_version'] != VBPLAZA_SCRIPT_VERSION)
{
	// display error, store currently closed
	eval(standard_error(fetch_error('vbplaza_product_mismatch_with_php', $vbphrase['vbbux_name'], $vbphrase['vbplaza_name'])));
}

($hook = vBulletinHook::fetch_hook('vbplaza_start')) ? eval($hook) : false;

// check if the store is currently open
if (!$vbulletin->options['vbplaza_enabled'])
{
	// check that the user is not an admin
	if (!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
	{
		// display error, store currently closed
		eval(standard_error(fetch_error('vbplaza_currently_closed', $vbphrase['vbplaza_name'])));
	}
	else
	{
		// show the vbplaza disabled warning message so that admins don't leave the vbplaza turned off by accident
		eval('$warning = "' . fetch_template('vbplaza_inactive_warning') . '";');
		$header = $warning . $header;
		$footer .= $warning;
	}
}

// force the action if not set
if (!isset($_REQUEST['do']) || empty($_REQUEST['do']))
{
	// force it to do the main action
	$_REQUEST['do'] = 'main';
}

// check if the user is using the quick donate feature
if ($_REQUEST['do'] == 'donate')
{
	// force it to do an action to donate
	$_REQUEST['do'] = 'action';
	$_REQUEST['itemid'] = 7;
}

// check if the user is using the quick give gift feature
if ($_REQUEST['do'] == 'givegift')
{
	// force it to do an action to give gift
	$_REQUEST['do'] = 'action';
	$_REQUEST['itemid'] = 27;
}

// check if the user is using the quick give ribbon feature
if ($_REQUEST['do'] == 'giveribbon')
{
	// force it to do an action to give ribbon
	$_REQUEST['do'] = 'action';
	$_REQUEST['itemid'] = 118;
}

// check if its trying to play an arcade game
if ($_REQUEST['do'] == 'play')
{
	// check which type of arcade it is
	$action = array();
	if ($_REQUEST['gameid'] > 0)
	{
		// check if the type is ibproarcade
		if ($_REQUEST['type'] == 'ibproarcade')
		{
			// get the information about the arcade game
			$gameinfo = $vbulletin->db->query_first("
				SELECT * FROM " . TABLE_PREFIX . "games_list
				WHERE gid = '" . $_REQUEST['gameid'] . "'
			");

			// setup the $action info
			$action['gameid'] = $gameinfo['gid'];
			$action['cost'] = $gameinfo['cost'];
			$action['name'] = $gameinfo['gtitle'];
		}
		// check if the type is v3arcade
		else if ($_REQUEST['type'] == 'v3arcade')
		{
			// get the information about the arcade game
			$gameinfo = $vbulletin->db->query_first("
				SELECT * FROM " . TABLE_PREFIX . "arcade_games
				WHERE gameid = '" . $_REQUEST['gameid'] . "'
			");

			// setup the $action info
			$action['gameid'] = $gameinfo['gameid'];
			$action['cost'] = $gameinfo['cost'];
			$action['name'] = $gameinfo['title'];
		}
	}

	// verify that it found an arcade game
	if (!empty($action) && is_array($action))
	{
		// set the item's tax value
		$action['tax'] = $vbulletin->options['vbbux_attachmenttax'];

		// calculate the total cost
		$action = vbplaza_calculate_total_cost($action);

		// build the $arcadeurl
		$arcadeurl = $vbulletin->url;

		// Generate a standard confirmation.
		eval('$current .= "' . fetch_template('vbplaza_arcadeplay_confirmation') . '";');
	}
	else
	{
		// force it to main if it gets here
		$_REQUEST['do'] = 'main';
	}
}

// check if its trying to download an attachment
if ($_REQUEST['do'] == 'download')
{
	// check if there is a supplied attachmentid
	if (is_numeric($_REQUEST['attachmentid']))
	{
		// get the information about the attachment
		$attachment = $vbulletin->db->query_first("
			SELECT attachmentid, filename, imagecost FROM " . TABLE_PREFIX . "attachment
			WHERE attachmentid = '" . $_REQUEST['attachmentid'] . "'
		");

		// verify that it found the attachment
		if (is_numeric($attachment['attachmentid']))
		{
			// make sure to use the proper cost
			if ($vbulletin->options['vbbux_perattachmentdownload'] != 0)
			{
				// setup the cost using this amount of points
				$action['cost'] = $vbulletin->options['vbbux_perattachmentdownload'];
			}
			else
			{
				// otherwise use this amount of points in the attachment table
				$action['cost'] = $attachment['imagecost'];
			}

			// set the item's tax value
			$action['tax'] = $vbulletin->options['vbbux_attachmenttax'];

			// calculate the total cost
			$action = vbplaza_calculate_total_cost($action);

			// update the name so it knows the filename
			$action['name'] = $attachment['filename'];

			// Generate a standard confirmation.
			eval('$current .= "' . fetch_template('vbplaza_download_confirmation') . '";');
		}
		else
		{
			// force it to main if it gets here
			$_REQUEST['do'] = 'main';
		}
	}
	else
	{
		// force it to main if it gets here
		$_REQUEST['do'] = 'main';
	}
}

// check if it should do the richest/most sold scripts
if ($_REQUEST['do'] == 'main')
{
	// always show some history on the main page
	$show['history'] = true;

	// always show it on the main page
	$show['richestmostsold'] = true;
}
else
{
	// check for this setting otherwise
	if ($vbulletin->options['vbplaza_richestmostsoldonall'])
	{
		// setting set to always show richest/most sold
		$show['richestmostsold'] = true;
	}
}

// only need to do this if doing richest/most sold
if ($show['richestmostsold'])
{
	// check if there are any exceptions
	$exceptions = array();
	if (!$vbulletin->options['vbbux_richestshowadmins'])
	{
		// add it to not look for admins in the richest users
		$exceptions[] = '6';
	}
	if (!$vbulletin->options['vbbux_richestshowsmods'])
	{
		// add it to not look for super moderators in the richest users
		$exceptions[] = '5';
	}
	if (!$vbulletin->options['vbbux_richestshowmods'])
	{
		// add it to not look for moderators in the richest users
		$exceptions[] = '7';
	}

	// now build the exceptions string
	$wherestr = '';
	if (is_array($exceptions))
	{
		// process each exception
		foreach($exceptions AS $usergroupid)
		{
			// check if its a valid usergroupid
			if (is_numeric($usergroupid))
			{
				// check if its empty
				if (!empty($wherestr)) { $wherestr .= " AND "; }

				// add this usergroup to the where string
				$wherestr .= "(usergroupid != '" . $usergroupid . "')";
			}
		}

		// check that its not empy
		if (!empty($wherestr)) { $wherestr = "(" . $wherestr . ") AND"; }
	}

	// cache the top 10 richest users
	$richestusercache = array();
	if ($richestusers = $vbulletin->db->query_read("
		SELECT `userid`, `username`, `" . $vbulletin->options['vbbux_bankfield'] . "`, `" . $vbulletin->options['vbbux_pointsfield'] . "`,
			(`" . $vbulletin->options['vbbux_bankfield'] . "` + `" . $vbulletin->options['vbbux_pointsfield'] . "`) AS totalpoints
		FROM " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
		WHERE " . $wherestr . " ((`" . $vbulletin->options['vbbux_bankfield'] . "` + `" . $vbulletin->options['vbbux_pointsfield'] . "`) > 0)
		ORDER BY totalpoints DESC
		LIMIT 10
	"))
	{
		// cache these 10 richest users
		while ($richestuser = $vbulletin->db->fetch_array($richestusers))
		{
			// cache this user
			$richestusercache[] = $richestuser;
		}
	}

	// free the richestusers
	$vbulletin->db->free_result($richestusers);

	// verify that it has found some richestusers
	if (is_array($richestusercache) && !empty($richestusercache))
	{
		// build the $toptenrichest
		$toptenrichest = '';
		foreach($richestusercache AS $richest)
		{
			// build the $userpoints variable
			$userpoints = vb_number_format($richest['totalpoints'], $vbulletin->options['vbbux_decimalplaces']);

			// add this user
			$toptenrichest .= "<a href=\"member.php?u=" . $richest['userid'] . "\">" . $richest['username'] . "</a> - " . $userpoints . " " . $vbphrase['vbbux_points'] . "<br />";
		}
	}
	else
	{
		// set the $toptenrichest to no users have points yet
		$toptenrichest = construct_phrase($vbphrase['vbplaza_no_users_have_points_yet'], $vbphrase['vbbux_points']);
	}

	// first sort out the top sold items
	$mostsoldcache = array();
	foreach($vbulletin->vbplazaoptions AS $option)
	{
		// build the proper usergroups info
		$option = vbplaza_build_proper_usergroups($option, $vbulletin->vbplazacategory);

		// verify this user is allowed to buy this item
		if (vbplaza_check_allowed($vbulletin->userinfo, $option['allowedgroups'], $option['deniedgroups']))
		{
			// verify the option has sold some quantity
			if ($option['sold'] > 0)
			{
				// verify option is to be shown in store
				if ($option['showinstore'])
				{
					// check if the $option['name'] is empty
					if (empty($option['name']))
					{
						// set the $option['name'] to Unknown
						$option['name'] = $vbphrase['vbplaza_unknown_item'];
					}

					// insert this item into the array
					$mostsoldcache[] = array(
						'sold'		=>	$option['sold'],
						'itemid'	=>	$option['itemid'],
						'name'		=>	$option['name']
					);
				}
			}
		}
	}

	// sort the items in reverse order
	arsort($mostsoldcache);

	// verify that there are some items sold
	if (!empty($mostsoldcache))
	{
		// cache the top 10 most sold
		$displayed = 1;
		$topsolditems = '';
		foreach($mostsoldcache AS $mostsold)
		{
			// add this item
			if ($displayed++ > 10) { break; }
			$topsolditems .= "<a href=\"vbplaza.php?do=itemhistory&amp;itemid=" . $mostsold['itemid'] . "\">" . $mostsold['name'] . "</a> - " . $vbphrase['vbplaza_sold'] . " " . $mostsold['sold'] . " " . $vbphrase['vbplaza_times'] . "<br />";
		}
	}
	else
	{
		// set this item to be none sold yet
		$topsolditems = $vbphrase['vbplaza_no_items_sold_yet'];
	}
}

// process the action if its doing one
unset($action);
if ($_REQUEST['do'] == 'action')
{
	// verify $vbulletin->vbplazaoptions is an array
	if (!is_array($vbulletin->vbplazaoptions))
	{
		// display error, action was not found
		eval(standard_error(fetch_error('vbplaza_action_not_found')));
	}

	// verify this action is really available
	foreach($vbulletin->vbplazaoptions AS $option)
	{
		// verify the option is active
		if ($option['active'] == 1)
		{
			// check if the itemid matches
			if ($option['itemid'] == $_REQUEST['itemid'])
			{
				// set this action
				$action = $option;
			}
		}
	}

	// check if an action was specified
	if (!isset($action))
	{
		// display error, action was not found
		eval(standard_error(fetch_error('vbplaza_action_not_found')));
	}

	// check if it should set the $_POST arguments too
	if (!empty($_POST['action']) && is_array($_POST['action']))
	{
		// merge the array's
		$action = array_merge($action, $_POST['action']);
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_action_start')) ? eval($hook) : false;

	// build the proper usergroups info
	$action = vbplaza_build_proper_usergroups($action, $vbulletin->vbplazacategory);

	// calculate and verify results
	$action = vbplaza_calculate_total_cost($action);

	// verify this user is allowed to buy this item
	if (!vbplaza_check_allowed($vbulletin->userinfo, $action['allowedgroups'], $action['deniedgroups']))
	{
		// display error, usergroup not allowed to purchase this item
		eval(standard_error(fetch_error('vbplaza_not_allowed_to_purchase')));
	}

	// fixup the fields into correct forum
	$action = vbplaza_action_fixup_fields_settings($action);

	// set the first step = 1 if its not set
	if (!isset($_REQUEST['step']) || empty($_REQUEST['step'])) { $_REQUEST['step'] = '1'; }

	// calculate the nextstep
	$nextstep = $_REQUEST['step'] + 1;

	// check if this item has a scriptlocation
	if (!empty($action['scriptlocation']))
	{
		// for now assume these options are not removable, and run the validate cost function
		vbplaza_validate_cost($action);

		// include the script
		require_once('./' . $action['scriptlocation']);
	}
	else
	{
		// include the generalaction script
		require_once('./vbplaza/generalaction.php');
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_action_complete')) ? eval($hook) : false;

	// add this to $navitems
	$navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listcat&amp;categoryid=' . $_REQUEST['categoryid']] = $action['name'];
}

// check if its removing a log entry
if ($_REQUEST['do'] == 'removelog')
{
	// verify that the user is not trying to remove someone else's history log
	if (is_numeric($_REQUEST['userid']) && ($_REQUEST['userid'] > 0))
	{
		// display error, no history yet
		eval(standard_error(fetch_error('vbplaza_can_not_remove_others_user_history', $vbphrase['vbplaza_user_history'])));
	}

	// verify the user has history
	if (empty($vbulletin->userinfo['vbp_history']))
	{
		// display error, no history yet
		eval(standard_error(fetch_error('vbplaza_no_history_recorded', $vbphrase['vbplaza_name'])));
	}

	// unserialize the data
	$userhistory = unserialize($vbulletin->userinfo['vbp_history']);

	($hook = vBulletinHook::fetch_hook('vbplaza_remove_log_process')) ? eval($hook) : false;

	// check if this field is capable of getting the log removed
	if (!$userhistory[$_REQUEST['id']]['expires'])
	{
		// unset this in the user's history
		unset($userhistory[$_REQUEST['id']]);

		// reserialize the data
		$userhistory = serialize($userhistory);

		// update the vbp_history in the database
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
			SET
				vbp_history = '" . $vbulletin->db->escape_string($userhistory) . "'
			WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
		");

		// update the history so it displays the current user history
		$vbulletin->userinfo['vbp_history'] = $userhistory;
	}

	// force it to redisplay userhistory
	$_REQUEST['do'] = 'userhistory';
}

// check if its forcing an option to expire
if ($_REQUEST['do'] == 'expirenow')
{
	// unserialize the userhistory
	$userhistory = unserialize($vbulletin->userinfo['vbp_history']);

	// verify it has found this id
	if (!empty($userhistory[$_REQUEST['id']]))
	{
		// force this option to expire
		$userhistory[$_REQUEST['id']]['expires'] = TIMENOW - 1;

		// reserialize the data
		$vbulletin->userinfo['vbp_history'] = serialize($userhistory);

		// force it to goto expireitems
		$_REQUEST['do'] = 'expireitems';
	}
}

// check if it is expiring some user options
if ($_REQUEST['do'] == 'expireitems')
{
	// unserialize the userhistory
	$userhistory = unserialize($vbulletin->userinfo['vbp_history']);

	($hook = vBulletinHook::fetch_hook('vbplaza_expire_items_start')) ? eval($hook) : false;

	// process each user history
	$expiredoptions = array();
	foreach($userhistory AS $key => $history)
	{
		// check if this option is expired
		if ($history['expires'] && ($history['expires'] < TIMENOW))
		{
			// attempt to unset this from the userhistory
			unset($userhistory["$key"]);

			// add this option to the $expiredoptions
			$expiredoptions[] = $history;
		}
	}

	// if there was some items found, expire them
	if (isset($expiredoptions))
	{
		// cache all of the items
		$vbulletin->vbplazaoptions = vbplaza_cache_items('', '');

		// process each expired item
		$removeuseroptions = '';
		foreach($expiredoptions AS $history)
		{
			// setup the history info
			$history['itemname'] = $vbulletin->vbplazaoptions[$history['itemid']]['name'];
			$history['totalcost'] = vb_number_format($history['finalcost'], $vbulletin->options['vbplaza_decimalplaces']);
			$history['purchase_date'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $history['dateline']);
			$history['expiry_date'] = $vbphrase['vbplaza_now'];

			// check if the $history['itemname'] is empty
			if (empty($history['itemname']))
			{
				// set the $history['itemname'] to Unknown
				$history['itemname'] = $vbphrase['vbplaza_unknown_item'];
			}

			// fixup the extraname
			$history = vbplaza_fixup_extraname($history);

			// attempt to expire this option
			if (vbplaza_expire_item($vbulletin->userinfo, $history, $vbulletin->vbplazaoptions))
			{
				// add this history to the $vbplazahistorylist
				eval('$vbplazahistorylist .= "' . fetch_template('vbplaza_history_bits') . '";');
			}
		}

		// serialize the userhistory
		$userinfo = $vbulletin->userinfo;
		$userhistory = serialize($userhistory);
		$vbulletin->userinfo['vbp_history'] = $userhistory;

		// reset this users vbp_history
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
			SET
				vbp_history = '" . $vbulletin->db->escape_string($userhistory) . "'
			WHERE userid = '" . $vbulletin->userinfo['userid']. "'
		");

		($hook = vBulletinHook::fetch_hook('vbplaza_expire_items_complete')) ? eval($hook) : false;

		// check if nothing was expired
		if (!empty($vbplazahistorylist))
		{
			// force it to show the history list
			$show['historylist'] = true;

			// lastly build the final $current variable to be displayed
			eval('$current = "' . fetch_template('vbplaza_history_list') . '";');
		}
		else
		{
			// change the request to userhistory
			$_REQUEST['do'] = 'userhistory';
		}
	}
}

// check if it should display the user history
$processallhistory = false;
if ($_REQUEST['do'] == 'userhistory')
{
	// check if there is a userid specified, and its not the currently logged in user
	if (is_numeric($_REQUEST['userid']) && ($_REQUEST['userid'] != $vbulletin->userinfo['userid']))
	{
		// check if they are allowed to view others user history
		if (!($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canviewotheruserhistory']))
		{
			// display error, no permission for this usergroup
			eval(standard_error(fetch_error('vbplaza_not_allowed_to_view_others_user_history')));
		}

		// get this user's history from the database
		$userinfo = $vbulletin->db->query_first("SELECT userid, username, vbp_history FROM " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . " WHERE userid = '" . $_REQUEST['userid'] . "'");
	}
	else
	{
		// force it to be the currently logged in user
		$userinfo = $vbulletin->userinfo;
	}

	// always show some history on the user history page
	$show['history'] = true;

	// set it to process all history
	$processallhistory = true;

	// add this to $navitems
	$navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=userhistory'] = $vbphrase['vbplaza_user_history'];
}

// verify that it should generate the history
if ($show['history'])
{
	// disable it from showing history
	$show['historylist'] = false;

	($hook = vBulletinHook::fetch_hook('vbplaza_user_history_start')) ? eval($hook) : false;

	// check that $userinfo is setup
	if (empty($userinfo))
	{
		// force it to be the currently logged in user
		$userinfo = $vbulletin->userinfo;
	}

	// unserialize the data
	$userhistory = unserialize($userinfo['vbp_history']);

	// verify the users has history
	if (!empty($userhistory) && is_array($userhistory))
	{
		// sort all items in reverse
		krsort($userhistory);

		// process each history item
		$historyentry = 0;
		$vbplazahistorylist = '';
		foreach($userhistory AS $key => $history)
		{
			// setup the history info
			$history['itemname'] = $vbulletin->vbplazaoptions[$history['itemid']]['name'];
			$history['totalcost'] = vb_number_format($history['finalcost'], $vbulletin->options['vbplaza_decimalplaces']);
			$history['purchase_date'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $history['dateline']);

			// check if the $history['itemname'] is empty
			if (empty($history['itemname']))
			{
				// set the $history['itemname'] to Unknown
				$history['itemname'] = $vbphrase['vbplaza_unknown_item'];
			}

			// build the proper expiring time
			if ($history['expires'])
			{
				// build the expiry date
				$history['expiry_date'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $history['expires']);

				// only add the remove link for currently logged in users
				if ($userinfo['userid'] == $vbulletin->userinfo['userid'])
				{
					// add the removelog link
					$history['expiry_date'] .= " [<a href=\"vbplaza.php?do=expirenow&amp;id=" . $key . "\">" . $vbphrase['vbplaza_expire_now'] . "</a>]";
				}
			}
			else
			{
				// put that it expires never
				$history['expiry_date'] = $vbphrase['vbplaza_never'];

				// only add the remove link for currently logged in users
				if ($userinfo['userid'] == $vbulletin->userinfo['userid'])
				{
					// add the removelog link
					$history['expiry_date'] .= " [<a href=\"vbplaza.php?do=removelog&amp;id=" . $key . "\">" . $vbphrase['vbplaza_remove_log'] . "</a>]";
				}
			}

			// fixup the extraname
			$history = vbplaza_fixup_extraname($history);

			// check if this is the password item
			if ($history['itemid'] == '31')
			{
				// check if this userinfo is the same as the logged in user
				if ($userinfo['userid'] != $vbulletin->userinfo['userid'])
				{
					// clear out the $history['reason']
					unset($history['reason']);
				}
			}

			($hook = vBulletinHook::fetch_hook('vbplaza_user_history_process')) ? eval($hook) : false;

			// add this history to the $vbplazahistorylist
			eval('$vbplazahistorylist .= "' . fetch_template('vbplaza_history_bits') . '";');

			// increase $historyentry
			$historyentry++;

			// check if it should keep processing more
			if (!$processallhistory && ($historyentry > 4))
			{
				// break out of the history
				break;
			}
		}

		// verify that some history was found
		if ($historyentry > 0)
		{
			// enable it to show history
			$show['historylist'] = true;
		}
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_user_history_complete')) ? eval($hook) : false;

	// lastly build the final $current variable to be displayed
	eval('$displayedhistory = "' . fetch_template('vbplaza_history_list') . '";');
}

// check if it is showing the richestusers
if ($_REQUEST['do'] == 'richestusers')
{
	// check if exceptions are allowed
	$wherestr = '';
	if ($vbulletin->options['vbbux_richestexcludesall'])
	{
		// check for the exceptions
		$exceptions = array();
		if (!$vbulletin->options['vbbux_richestshowadmins'])
		{
			// add it to not look for admins in the richest users
			$exceptions[] = '6';
		}
		if (!$vbulletin->options['vbbux_richestshowsmods'])
		{
			// add it to not look for super moderators in the richest users
			$exceptions[] = '5';
		}
		if (!$vbulletin->options['vbbux_richestshowmods'])
		{
			// add it to not look for moderators in the richest users
			$exceptions[] = '7';
		}

		// now build the exceptions string
		if (is_array($exceptions))
		{
			// process each exception
			foreach($exceptions AS $usergroupid)
			{
				// check if its a valid usergroupid
				if (is_numeric($usergroupid))
				{
					// check if its empty
					if (!empty($wherestr)) { $wherestr .= " AND "; }

					// add this usergroup to the where string
					$wherestr .= "(usergroupid != '" . $usergroupid . "')";
				}
			}

			// check that its not empy
			if (!empty($wherestr)) { $wherestr = "(" . $wherestr . ") AND"; }
		}
	}

	// try to find the richest users
	if ($richestusers = $vbulletin->db->query_read("
		SELECT `userid`, `username`, `" . $vbulletin->options['vbbux_bankfield'] . "`, `" . $vbulletin->options['vbbux_pointsfield'] . "`,
			(`" . $vbulletin->options['vbbux_bankfield'] . "` + `" . $vbulletin->options['vbbux_pointsfield'] . "`) AS totalpoints
		FROM " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
		WHERE " . $wherestr . " ((`" . $vbulletin->options['vbbux_bankfield'] . "` + `" . $vbulletin->options['vbbux_pointsfield'] . "`) > 0)
		ORDER BY totalpoints DESC
		LIMIT " . $vbulletin->options['vbbux_viewrichestnumber'] . "
	"))
	{
		// cache all of the richest users
		$richestcache = array();
		while ($richestuser = $vbulletin->db->fetch_array($richestusers))
		{
			// cache this user
			$richestcache[] = $richestuser;
		}

		($hook = vBulletinHook::fetch_hook('vbplaza_richest_users_start')) ? eval($hook) : false;

		// process each user
		$rank = 1;
		$richestlist = '';
		foreach($richestcache AS $richest)
		{
			// update the values for the template
			if ($rank & 1) { $richest['class'] = "alt1"; }
			else { $richest['class'] = "alt2"; }
			$richest['rank'] = $rank++;
			$richest['points'] = vb_number_format($richest[$vbulletin->options['vbbux_pointsfield']], $vbulletin->options['vbplaza_decimalplaces']);
			$richest['bank'] = vb_number_format($richest[$vbulletin->options['vbbux_bankfield']], $vbulletin->options['vbplaza_decimalplaces']);
			$richest['total'] = vb_number_format($richest['totalpoints'], $vbulletin->options['vbplaza_decimalplaces']);

			($hook = vBulletinHook::fetch_hook('vbplaza_richest_users_process')) ? eval($hook) : false;

			// add this user to the $richestlist
			eval('$richestlist .= "' . fetch_template('vbplaza_richest_bits') . '";');
		}

		($hook = vBulletinHook::fetch_hook('vbplaza_richest_users_complete')) ? eval($hook) : false;

		// lastly build the final $current variable to be displayed
		eval('$current = "' . fetch_template('vbplaza_richest_list') . '";');
	}

	// free the richestusers
	$vbulletin->db->free_result($richestusers);

	// add this to $navitems
	$navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=richestusers'] = $vbphrase['vbplaza_richest_members'];
}

// check if it is showing the most sold
if ($_REQUEST['do'] == 'mostsold')
{
	// first sort out the top sold items
	$mostsoldcache = array();
	foreach($vbulletin->vbplazaoptions AS $option)
	{
		// build the proper usergroups info
		$option = vbplaza_build_proper_usergroups($option, $vbulletin->vbplazacategory);

		// verify this user is allowed to buy this item
		if (vbplaza_check_allowed($vbulletin->userinfo, $option['allowedgroups'], $option['deniedgroups']))
		{
			// verify this option is to be shown in the store
			if ($option['showinstore'])
			{
				// insert this item into the array
				$mostsoldcache[] = array(
					'sold'		=>	$option['sold'],
					'itemid'	=>	$option['itemid'],
					'name'		=>	$option['name']
				);
			}
		}
	}

	// sort the items in reverse order
	arsort($mostsoldcache);

	($hook = vBulletinHook::fetch_hook('vbplaza_most_sold_start')) ? eval($hook) : false;

	// process each item
	$rank = 1;
	$mostsoldlist = '';
	foreach($mostsoldcache AS $mostsold)
	{
		// update the values for the template
		if ($rank & 1) { $mostsold['class'] = "alt1"; }
		else { $mostsold['class'] = "alt2"; }
		$mostsold['rank'] = $rank++;
	
		($hook = vBulletinHook::fetch_hook('vbplaza_most_sold_process')) ? eval($hook) : false;

		// add this user to the $richestlist
		eval('$mostsoldlist .= "' . fetch_template('vbplaza_mostsold_bits') . '";');
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_most_sold_complete')) ? eval($hook) : false;

	// lastly build the final $current variable to be displayed
	eval('$current = "' . fetch_template('vbplaza_mostsold_list') . '";');

	// add this to $navitems
	$navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mostsold'] = $vbphrase['vbplaza_most_sold'];
}

// check if it should display the category
if ($_REQUEST['do'] == 'listcat')
{
	// set it to show the items
	$show['items'] = true;

	($hook = vBulletinHook::fetch_hook('vbplaza_list_category_start')) ? eval($hook) : false;

	// verify it has found some items
	if (!is_array($vbulletin->vbplazaoptions))
	{
		// display error, no options in category
		eval(standard_error(fetch_error('vbplaza_no_options_in_category', $vbphrase['vbplaza_name'])));
	}

	// check if its ibproarcade style
	$optionstyle = 0;
	if ($vbulletin->options['vbplaza_ibproarcadestyle'] == 'ibproarcade')
	{
		// set it to ibproarcade style
		$optionstyle = 1;
	}

	// sort the items by display order
	$sortedoptions = vbplaza_sort_by_display_order($vbulletin->vbplazaoptions);

	// build the $vbplazaoptionlist
	$displayed = 0;
	$vbplazaoptionlist = '';
	foreach($sortedoptions AS $option)
	{
		// check if this item is for the category specified
		if (($_REQUEST['categoryid'] == $option['category']) || ($_REQUEST['categoryid'] == 0))
		{
			// build the proper usergroups info
			$option = vbplaza_build_proper_usergroups($option, $vbulletin->vbplazacategory);

			// build the proper cost
			$option['cost'] = vb_number_format($option['cost'], $vbulletin->options['vbbux_decimalplaces']);

			// verify this user is allowed to buy this item
			if ($option['showinstore'] && vbplaza_check_allowed($vbulletin->userinfo, $option['allowedgroups'], $option['deniedgroups']))
			{
				// setup the $show['itemimage']
				$show['itemimage'] = false;
				if (!empty($option[imagelocation])) { $show['itemimage'] = true; }

				($hook = vBulletinHook::fetch_hook('vbplaza_list_category_process')) ? eval($hook) : false;

				// use the proper template to display the options
				if ($optionstyle == 1)
				{
					// check if there should be a new row started
					$show['colwidth'] = intval(100 / $vbulletin->options['vbplaza_itemsperrow']) . "%";
					if (($displayed == 0) || (($displayed % $vbulletin->options['vbplaza_itemsperrow']) == '0'))
					{
						// check if it should end the previous row too
						if ($displayed > 0)
						{
							// set it to end the previous row
							$vbplazaoptionlist .= "</tr>\n";
						}

						// have it begin the row
						$vbplazoptionlist .= "<tr>";
					}

					// add this item to the list
					eval('$vbplazaoptionlist .= "' . fetch_template('vbplaza_items_ibproarcade_bits') . '";');
				}
				else
				{
					// add this item to the list
					eval('$vbplazaoptionlist .= "' . fetch_template('vbplaza_items_vbplaza_bits') . '";');
				}

				// increase $displayed
				$displayed++;
			}
		}
	}

	// check if it indeed found some items
	if (empty($vbplazaoptionlist))
	{
		// display error, no options in category
		eval(standard_error(fetch_error('vbplaza_no_options_in_category', $vbphrase['vbplaza_name'])));
	}
	else
	{
		// set it different for categoryid = 0
		if ($_REQUEST['categoryid'] == 0)
		{
			// set the categoryname
			$show['categoryid'] = 0;
			$show['categoryname'] = $vbphrase['vbplaza_all_options'];
		}
		else
		{
			// set the categoryname
			$show['categoryid'] = $_REQUEST['categoryid'];
			$show['categoryname'] = $vbulletin->vbplazacategory[$_REQUEST['categoryid']]['name'];
		}
	}

	// check if it needs to end the last row
	if ($optionstyle == 1)
	{
		// set it to end the previous row
		$vbplazoptionlist .= "</tr>\n";

		// finalize the $displayedoptions
		eval('$displayedoptions = "' . fetch_template('vbplaza_items_ibproarcade_list') . '";');
	}
	else
	{
		// finalize the $displayedoptions
		eval('$displayedoptions = "' . fetch_template('vbplaza_items_vbplaza_list') . '";');
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_list_category_complete')) ? eval($hook) : false;

	// add this to $navitems
	$navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listcat&amp;categoryid=' . $_REQUEST['categoryid']] = $vbulletin->vbplazacategory[$_REQUEST['categoryid']]['name'];
}

// check if it should display the item history
if ($_REQUEST['do'] == 'itemhistory')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_item_history_start')) ? eval($hook) : false;

	// verify they are allowed to view item history
	if (!($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canviewitemhistory']))
	{
		// display error, not allowed to view item history
		eval(standard_error(fetch_error('vbplaza_not_allowed_to_view_item_history')));
	}

	// check if its trying to delete an item from the item history table
	if (is_numeric($_REQUEST['removehistoryid']))
	{
		// check if this user is allowed to removeitemlogs
		if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteitemhistory'])
		{
			// verify that this historyid exists
			$historylog = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_itemhistory WHERE historyid = '" . $_REQUEST['removehistoryid'] . "'");

			// verify that this history log was found, and its for this same item
			if (is_numeric($historylog['historyid']) && ($historylog['itemid'] == $_REQUEST['itemid']))
			{
				// delete this item from the item history table
				$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_itemhistory WHERE historyid = '" . $_REQUEST['removehistoryid'] . "'");
			}
		}
	}

	// check if it is viewing a specific item's history
	if (is_numeric($_REQUEST['itemid']))
	{
		// count the number of history for this item
		$optionhistory = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_itemhistory WHERE itemid = '" . $_REQUEST['itemid'] . "' ORDER BY dateline DESC");
	}
	else
	{
		// count the number of history for this item
		$optionhistory = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_itemhistory ORDER BY dateline DESC");
	}

	// verify that it has found some things
	if (!$optionhistory['count'])
	{
		// display error, no item history yet
		eval(standard_error(fetch_error('vbplaza_no_item_history_recorded', $vbphrase['vbplaza_name'])));
	}

	// setup the $perpage
	$perpage = $vbulletin->options['vbplaza_itemhistoryperpage'];

	// verify that $_REQUEST['page'] is set
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check if it is viewing a specific item's history
	if (is_numeric($_REQUEST['itemid']))
	{
		// get the item history from the database
		$purchases = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_itemhistory
			WHERE itemid = '" . $_REQUEST['itemid'] . "'
			ORDER BY dateline DESC
			" . $limitstr . "
		");

		// setup the $option info
		$option['itemid'] = $vbulletin->vbplazaoptions[$_REQUEST['itemid']]['itemid'];
		$option['itemname'] = $vbulletin->vbplazaoptions[$_REQUEST['itemid']]['name'];

		// verify that the itemid is not unknown
		if (!is_numeric($option['itemid']))
		{
			// set the itemname for this to be unknown
			$option['itemname'] = $vbphrase['vbplaza_unknown_item'];
		}
	}
	else
	{
		// get the item history from the database
		$purchases = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_itemhistory
			ORDER BY dateline DESC
			" . $limitstr . "
		");

		// setup the $option info
		$option['itemid'] = '0';
	}

	// check if anything was found
	if (!$purchases || !$vbulletin->db->num_rows($purchases))
	{
		// display error, no item history yet
		eval(standard_error(fetch_error('vbplaza_no_item_history_recorded', $vbphrase['vbplaza_name'])));
	}

	// set if the user can delete the item history
	$show['candelete'] = false;
	if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteitemhistory'])
	{
		// set it so they can delete item history
		$show['candelete'] = true;
	}

	// remove the page number from the url
	$pagenav = construct_page_nav($_REQUEST['page'], $perpage, $optionhistory['count'], "vbplaza.php?do=itemhistory&amp;itemid=" . $_REQUEST['itemid'], "");

	// start processing the history
	$vbplazahistorylist = '';
	while ($purchase = $vbulletin->db->fetch_array($purchases))
	{
		// build the proper cost & date
		$purchase['date'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $purchase['dateline']);
		$purchase['cost'] = vb_number_format($purchase['finalcost'], $vbulletin->options['vbplaza_decimalplaces']);

		// add on the logid
		$purchase['itemname'] = $skip++ . ") " . $purchase['itemname'];

		// add the extrainfo if its found
		$show['extrainfo'] = false;
		if (!empty($purchase['extrainfo'])) { $show['extrainfo'] = true; }

		($hook = vBulletinHook::fetch_hook('vbplaza_item_history_process')) ? eval($hook) : false;

		// add this item to the historylist
		eval('$vbplazahistorylist .= "' . fetch_template('vbplaza_history_itembits') . '";');
	}

	// free the purchases
	$vbulletin->db->free_result($purchases);

	// check if it indeed found some items
	if (empty($vbplazahistorylist))
	{
		// display error, no item history yet
		eval(standard_error(fetch_error('vbplaza_no_item_history_recorded', $vbphrase['vbplaza_name'])));
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_item_history_complete')) ? eval($hook) : false;

	// lastly build the final $current variable to be displayed
	eval('$current = "' . fetch_template('vbplaza_history_itemlist') . '";');

	// add this to $navitems
	$navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=itemhistory&amp;itemid=' . $_REQUEST['itemid']] = $vbphrase['vbplaza_item_history'];
}

// check if it should display the lottery winners
if ($_REQUEST['do'] == 'lotterywinners')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_lottery_winners_start')) ? eval($hook) : false;

	// verify they are allowed to view lottery winners
	if (!($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canviewlotterywinners']))
	{
		// display error, not allowed to view item history
		eval(standard_error(fetch_error('vbplaza_not_allowed_to_view_lottery_winners')));
	}

	// check if its trying to delete an item from the lottery winner table
	if (is_numeric($_REQUEST['removewinnerid']))
	{
		// check if this user is allowed to remove lottery winners
		if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeletelotterywinners'])
		{
			// verify that this winnerid exists
			$winnerlog = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lotterywinner WHERE winnerid = '" . $_REQUEST['removewinnerid'] . "'");

			// verify that this winner log was found, and its for this same lottery
			if (is_numeric($winnerlog['winnerid']) && ($winnerlog['lotteryid'] == $_REQUEST['lotteryid']))
			{
				// delete this winner from the lottery winner table
				$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_lotterywinner WHERE winnerid = '" . $_REQUEST['removewinnerid'] . "'");
			}
		}
	}

	// count the number of winners of the lottery
	$lotterywinners = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_lotterywinner");

	// verify that it has found some things
	if (!$lotterywinners['count'])
	{
		// display error, no lottery winners yet
		eval(standard_error(fetch_error('vbplaza_no_lottery_winners_recorded')));
	}

	// setup the $perpage
	$perpage = $vbulletin->options['vbplaza_lotterywinnersperpage'];

	// verify that $_REQUEST['page'] is set
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// get the lottery winners from the database
	$winners = $vbulletin->db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "vbplaza_lotterywinner
		ORDER BY dateline DESC
		" . $limitstr . "
	");

	// check if anything was found
	if (!$winners || !$vbulletin->db->num_rows($winners))
	{
		// display error, no lottery winners yet
		eval(standard_error(fetch_error('vbplaza_no_lottery_winners_recorded')));
	}

	// set if the user can delete the lottery winners
	$show['candelete'] = false;
	if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeletelotterywinners'])
	{
		// set it so they can delete lottery winners
		$show['candelete'] = true;
	}

	// remove the page number from the url
	$pagenav = construct_page_nav($_REQUEST['page'], $perpage, $lotterywinners['count'], "vbplaza.php?do=lotterywinners", "");

	// start processing the lottery winners
	$vbplazalotterylist = '';
	while ($winner = $vbulletin->db->fetch_array($winners))
	{
		// build the proper date, jackpot & amountwon
		$winner['date'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $winner['dateline']);
		$winner['jackpot'] = vb_number_format($winner['jackpot'], $vbulletin->options['vbplaza_decimalplaces']);
		$winner['amountwon'] = vb_number_format($winner['amountwon'], $vbulletin->options['vbplaza_decimalplaces']);

		// add on the logid
		$winner['lotteryname'] = $skip++ . ") " . $winner['lotteryname'];

		($hook = vBulletinHook::fetch_hook('vbplaza_lottery_winners_process')) ? eval($hook) : false;

		// add this lottery winner to the historylist
		eval('$vbplazalotterylist .= "' . fetch_template('vbplaza_lottery_bits') . '";');
	}

	// free the winners
	$vbulletin->db->free_result($winners);

	// check if it indeed found some lottery winners
	if (empty($vbplazalotterylist))
	{
		// display error, no lottery winners yet
		eval(standard_error(fetch_error('vbplaza_no_lottery_winners_recorded')));
	}

	// check if there are any active lotteries
	$lotterycache = array();
	if ($lotteries = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE active = '1'"))
	{
		// process all of the found lotteries
		while ($lottery = $vbulletin->db->fetch_array($lotteries))
		{
			// cache this lottery
			$lotterycache[] = $lottery;
		}
	}

	// free the lotteries
	$vbulletin->db->free_result($lotteries);

	($hook = vBulletinHook::fetch_hook('vbplaza_lottery_winners_complete')) ? eval($hook) : false;

	// clear out $current
	$current = '';

	// check if there is any lottery info first
	if (!empty($lotterycache) && is_array($lotterycache))
	{
		// process all of the lotteries
		$vbplazacurrentlotterylist = '';
		foreach($lotterycache AS $lottery)
		{
			// build the proper endtime & jackpot
			$lottery['endtime'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $lottery['enddateline']);
			$lottery['jackpot'] = vb_number_format($lottery['jackpot'], $vbulletin->options['vbplaza_decimalplaces']);
			$lottery['numtickets'] = $lottery['ticketssold'];

			// add this name change to the namechangeslist
			eval('$vbplazacurrentlotterylist .= "' . fetch_template('vbplaza_lottery_current_bits') . '";');
		}

		// add in the current list of lotteries
		eval('$current .= "' . fetch_template('vbplaza_lottery_current_list') . '";');
	}

	// lastly build the final $current variable to be displayed
	eval('$current .= "' . fetch_template('vbplaza_lottery_list') . '";');

	// add this to $navitems
	$navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lotterywinners'] = $vbphrase['vbplaza_lottery_winners'];
}

// check if it should display the name changes history
if ($_REQUEST['do'] == 'namechanges')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_name_changes_history_start')) ? eval($hook) : false;

	// only check permissions if the user is not viewing their own profile
	if ($vbulletin->userinfo['userid'] != $_REQUEST['userid'])
	{
		// verify they are allowed to view name changes
		if (!($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['canviewnamechanges']))
		{
			// display error, not allowed to view name changes
			eval(standard_error(fetch_error('vbplaza_not_allowed_to_view_name_changes')));
		}
	}

	// get the number of name changes for this userid
	$namechanges = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_namechange WHERE changeuserid = '" . $_REQUEST['userid'] . "' ORDER BY dateline DESC");

	// verify that it has found some things
	if (!$namechanges['count'])
	{
		// display error, no name changes yet
		eval(standard_error(fetch_error('vbplaza_no_name_changes_recorded', $vbphrase['username'])));
	}

	// setup the $perpage
	$perpage = $vbulletin->options['vbplaza_namechangesperpage'];

	// verify that $_REQUEST['page'] is set
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// get the name change history from the database
	$changes = $vbulletin->db->query_read("
		SELECT vbplaza_namechange.*, user.username AS changedbyusername
		FROM " . TABLE_PREFIX . "vbplaza_namechange AS vbplaza_namechange
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (vbplaza_namechange.changedbyuserid = user.userid)
		WHERE changeuserid = '" . $_REQUEST['userid'] . "'
		ORDER BY dateline DESC
		" . $limitstr . "
	");

	// check if anything was found
	if (!$changes || !$vbulletin->db->num_rows($changes))
	{
		// display error, no name changes yet
		eval(standard_error(fetch_error('vbplaza_no_name_changes_recorded', $vbphrase['username'])));
	}

	// remove the page number from the url
	$pagenav = construct_page_nav($_REQUEST['page'], $perpage, $namechanges['count'], "vbplaza.php?do=namechanges&amp;userid=" . $_REQUEST['userid'], "");

	// start processing the name changes
	$vbplazanamechangeslist = '';
	while ($namechange = $vbulletin->db->fetch_array($changes))
	{
		// build the proper cost & date
		$purchase['date'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $namechange['dateline']);

		($hook = vBulletinHook::fetch_hook('vbplaza_name_changes_history_process')) ? eval($hook) : false;

		// add this name change to the namechangeslist
		eval('$vbplazanamechangeslist .= "' . fetch_template('vbplaza_namechanges_bits') . '";');
	}

	// free the changes
	$vbulletin->db->free_result($changes);

	// check if it indeed found some name changes
	if (empty($vbplazanamechangeslist))
	{
		// display error, no name changes yet
		eval(standard_error(fetch_error('vbplaza_no_name_changes_recorded', $vbphrase['username'])));
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_name_changes_history_complete')) ? eval($hook) : false;

	// lastly build the final $current variable to be displayed
	eval('$current = "' . fetch_template('vbplaza_namechanges_list') . '";');

	// add this to $navitems
	$navitems['vbplaza.php?' . $vbulletin->session->vars['sessionurl'] . 'do=namechanges&amp;userid=' . $_REQUEST['userid']] = $vbphrase['vbplaza_username_change_history'];
}

// check if it's deleting a gift
if ($_REQUEST['do'] == 'removegift')
{
	// check if this user is allowed to delete any gifts
	$candelete = false;
	if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteanygifts'])
	{
		// get the information about this giftid
		$findgift = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_gift WHERE giftid = '" . $_REQUEST['giftid'] . "'");
		if (is_numeric($findgift['giftid']))
		{
			// set that it can delete this gift
			$candelete = true;
		}
	}
	else
	{
		// get the information about this giftid
		$findgift = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_gift WHERE giftid = '" . $_REQUEST['giftid'] . "'");
		if ($findgift['giftid'] == $_REQUEST['giftid'])
		{
			// check if this gift is to this user
			if ($findgift['touserid'] == $vbulletin->userinfo['userid'])
			{
				// check if this user is allowed to delete their own gifts
				if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteowngifts'])
				{
					// set that it can delete this gift
					$candelete = true;
				}
			}
		}
	}

	// check if it is allowed to delete this gift
	if ($candelete)
	{
		// remove this gift from the table
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_gift WHERE giftid = '" . $_REQUEST['giftid'] . "'");

		// rebuild this user's gift postbits
		vbplaza_rebuild_gift_postbit($findgift['touserid']);

		// redirect to back to the members profile
		eval(print_standard_redirect('vbplaza_gift_deleted_successful'));
	}

	// force it to jump to main
	$_REQUEST['do'] = 'main';
}

// check if it's hidding a gift
if ($_REQUEST['do'] == 'hidegift')
{
	// get the information about this giftid
	$findgift = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_gift WHERE giftid = '" . $_REQUEST['giftid'] . "'");
	if (is_numeric($findgift['giftid']) && ($findgift['touserid'] == $vbulletin->userinfo['userid']))
	{
		// send off the query to hide the gift
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "vbplaza_gift SET visible = '0' WHERE giftid = '" . $_REQUEST['giftid'] . "'");

		// rebuild this user's gift postbits
		vbplaza_rebuild_gift_postbit($findgift['touserid']);

		// redirect to back to the members profile
		eval(print_standard_redirect('vbplaza_gift_visible_status_updated'));
	}

	// force it to jump to main
	$_REQUEST['do'] = 'main';
}

// check if it's showing a gift
if ($_REQUEST['do'] == 'showgift')
{
	// get the information about this giftid
	$findgift = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_gift WHERE giftid = '" . $_REQUEST['giftid'] . "'");
	if (is_numeric($findgift['giftid']) && ($findgift['touserid'] == $vbulletin->userinfo['userid']))
	{
		// send off the query to hide the gift
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "vbplaza_gift SET visible = '1' WHERE giftid = '" . $_REQUEST['giftid'] . "'");

		// rebuild this user's gift postbits
		vbplaza_rebuild_gift_postbit($findgift['touserid']);

		// redirect to back to the members profile
		eval(print_standard_redirect('vbplaza_gift_visible_status_updated'));
	}

	// force it to jump to main
	$_REQUEST['do'] = 'main';
}

// check if it's deleting a ribbon
if ($_REQUEST['do'] == 'removeribbon')
{
	// check if this user is allowed to delete any ribbons
	$candelete = false;
	if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteanyribbons'])
	{
		// get the information about this ribbonid
		$findribbon = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon WHERE ribbonid = '" . $_REQUEST['ribbonid'] . "'");
		if (is_numeric($findribbon['ribbonid']))
		{
			// set that it can delete this ribbon
			$candelete = true;
		}
	}
	else
	{
		// get the information about this ribbonid
		$findribbon = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon WHERE ribbonid = '" . $_REQUEST['ribbonid'] . "'");
		if ($findribbon['ribbonid'] == $_REQUEST['ribbonid'])
		{
			// check if this ribbon is to this user
			if ($findribbon['touserid'] == $vbulletin->userinfo['userid'])
			{
				// check if this user is allowed to delete their own ribbons
				if ($vbulletin->userinfo['permissions']['vbppermissions'] & $vbulletin->bf_ugp_vbppermissions['candeleteownribbons'])
				{
					// set that it can delete this ribbon
					$candelete = true;
				}
			}
		}
	}

	// check if it is allowed to delete this ribbon
	if ($candelete)
	{
		// remove this ribbon from the table
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_ribbon WHERE ribbonid = '" . $_REQUEST['ribbonid'] . "'");

		// rebuild this user's ribbon postbits
		vbplaza_rebuild_ribbon_postbit($findribbon['touserid']);

		// redirect to back to the members profile
		eval(print_standard_redirect('vbplaza_ribbon_deleted_successful'));
	}

	// force it to jump to main
	$_REQUEST['do'] = 'main';
}

// check if it's hidding a ribbon
if ($_REQUEST['do'] == 'hideribbon')
{
	// get the information about this ribbonid
	$findribbon = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon WHERE ribbonid = '" . $_REQUEST['ribbonid'] . "'");
	if (is_numeric($findribbon['ribbonid']) && ($findribbon['touserid'] == $vbulletin->userinfo['userid']))
	{
		// send off the query to hide the ribbon
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "vbplaza_ribbon SET visible = '0' WHERE ribbonid = '" . $_REQUEST['ribbonid'] . "'");

		// rebuild this user's ribbon postbits
		vbplaza_rebuild_ribbon_postbit($findribbon['touserid']);

		// redirect to back to the members profile
		eval(print_standard_redirect('vbplaza_ribbon_visible_status_updated'));
	}

	// force it to jump to main
	$_REQUEST['do'] = 'main';
}

// check if it's showing a ribbon
if ($_REQUEST['do'] == 'showribbon')
{
	// get the information about this ribbonid
	$findribbon = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon WHERE ribbonid = '" . $_REQUEST['ribbonid'] . "'");
	if (is_numeric($findribbon['ribbonid']) && ($findribbon['touserid'] == $vbulletin->userinfo['userid']))
	{
		// send off the query to hide the ribbon
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "vbplaza_ribbon SET visible = '1' WHERE ribbonid = '" . $_REQUEST['ribbonid'] . "'");

		// rebuild this user's ribbon postbits
		vbplaza_rebuild_ribbon_postbit($findribbon['touserid']);

		// redirect to back to the members profile
		eval(print_standard_redirect('vbplaza_ribbon_visible_status_updated'));
	}

	// force it to jump to main
	$_REQUEST['do'] = 'main';
}

// check if its updating vbpoptions
if ($_POST['do'] == 'updatevbpoptions')
{
	($hook = vBulletinHook::fetch_hook('vbplaza_updatevbpoptions_start')) ? eval($hook) : false;

	// build the proper vbp_vbplazaoptions
	$vbulletin->vbplazaoptions = 0;
	if ($_POST['hidegiftsinposts']) { $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbpvbplazaoptions['hidegiftsinposts']; }
	if ($_POST['hideribbonsinposts']) { $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbpvbplazaoptions['hideribbonsinposts']; }
	if ($_POST['nopmuponnewgift']) { $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbpvbplazaoptions['nopmuponnewgift']; }
	if ($_POST['nopmuponnewribbon']) { $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbpvbplazaoptions['nopmuponnewribbon']; }
	if ($_POST['hidepointsinposts']) { $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbpvbplazaoptions['hidepointsinposts']; }
	if ($_POST['hideusernamechangesinposts']) { $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbpvbplazaoptions['hideusernamechangesinposts']; }
	if ($_POST['hideusertitlechangesinposts']) { $vbulletin->vbplazaoptions |= $vbulletin->bf_misc_vbpvbplazaoptions['hideusertitlechangesinposts']; }

	// update this users vbp_vbplazaoptions
	$vbulletin->userinfo['vbp_vbplazaoptions'] = intval($vbulletin->vbplazaoptions);

	// send off the query to update the settings
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
		SET
			vbp_vbplazaoptions = '" . intval($vbulletin->vbplazaoptions) . "'
		WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
	");

	($hook = vBulletinHook::fetch_hook('vbplaza_updatevbpoptions_complete')) ? eval($hook) : false;

	// force it to show the edit settings again for now
	$_REQUEST['do'] = 'editvbpoptions';
}

// check if it is editing vbp options
if ($_REQUEST['do'] == 'editvbpoptions')
{
	// set the $pagetitle
	$pagetitle = "vbPlaza Main";

	($hook = vBulletinHook::fetch_hook('vbplaza_editvbpoptions_start')) ? eval($hook) : false;

	// setup all of the options
	$options = array(
		'0' => array(
			'phrasename' => $vbphrase['vbplaza_hide_gifts_postbit'],
			'selectname' => 'hidegiftsinposts',
			'enabled' => $vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['hidegiftsinposts'],
			'allowed' => $vbulletin->options['vbplaza_showhidegiftsinposts']
		),
		'1' => array(
			'phrasename' => $vbphrase['vbplaza_hide_ribbons_postbit'],
			'selectname' => 'hideribbonsinposts',
			'enabled' => $vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['hideribbonsinposts'],
			'allowed' => $vbulletin->options['vbplaza_showhideribbonsinposts']
		),
		'2' => array(
			'phrasename' => $vbphrase['vbplaza_do_not_receive_pm_upon_new_gift'],
			'selectname' => 'nopmuponnewgift',
			'enabled' => $vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['nopmuponnewgift'],
			'allowed' => $vbulletin->options['vbplaza_shownopmuponnewgift']
		),
		'3' => array(
			'phrasename' => $vbphrase['vbplaza_do_not_receive_pm_upon_new_ribbon'],
			'selectname' => 'nopmuponnewribbon',
			'enabled' => $vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['nopmuponnewribbon'],
			'allowed' => $vbulletin->options['vbplaza_shownopmuponnewribbon']
		),
		'4' => array(
			'phrasename' => construct_phrase($vbphrase['vbplaza_hide_points_postbit'], $vbphrase['vbbux_points']),
			'selectname' => 'hidepointsinposts',
			'enabled' => $vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['hidepointsinposts'],
			'allowed' => $vbulletin->options['vbplaza_showhidepointsinposts']
		),
		'5' => array(
			'phrasename' => construct_phrase($vbphrase['vbplaza_hide_x_changes_postbit'], $vbphrase['username']),
			'selectname' => 'hideusernamechangesinposts',
			'enabled' => $vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['hideusernamechangesinposts'],
			'allowed' => $vbulletin->options['vbplaza_showhideusernamechangesinposts']
		),
		'6' => array(
			'phrasename' => construct_phrase($vbphrase['vbplaza_hide_x_changes_postbit'], $vbphrase['vbplaza_usertitle']),
			'selectname' => 'hideusertitlechangesinposts',
			'enabled' => $vbulletin->userinfo['vbp_vbplazaoptions'] & $vbulletin->bf_misc_vbpvbplazaoptions['hideusertitlechangesinposts'],
			'allowed' => $vbulletin->options['vbplaza_showhideusertitlechangesinposts']
		)
	);

	// process all of the options
	$cansetoptions = false;
	foreach($options AS $option)
	{
		// check that they are allowed to use this first
		if ($option['allowed'] == 1)
		{
			// check if the option is enabled
			if ($option['enabled'] > 0)
			{
				// build the options with yes selected
				$option['options'] = "<option value=\"1\" selected=\"selected\">" . $vbphrase['yes'] . "</option><option value=\"0\">" . $vbphrase['no'] . "</option>";
			}
			else
			{
				// build the options with no selected
				$option['options'] = "<option value=\"1\">" . $vbphrase['yes'] . "</option><option value=\"0\" selected=\"selected\">" . $vbphrase['no'] . "</option>";
			}

			($hook = vBulletinHook::fetch_hook('vbplaza_editvbpoptions_process')) ? eval($hook) : false;

			// add this option to the $editvbpoptions
			$cansetoptions = true;
			eval('$editvbpoptions .= "' . fetch_template('vbplaza_edit_option_select') . '";');
		}
	}

	// check that there are some options the user can edit
	if ($cansetoptions != true)
	{
		// display error, there are no settings you are allowed to set
		eval(standard_error(fetch_error('vbplaza_not_allowed_to_change_vbplaza_options', $vbphrase['vbplaza_name'])));
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_editvbpoptions_complete')) ? eval($hook) : false;

	// Generate a standard confirmation.
	eval('$current .= "' . fetch_template('vbplaza_edit_vbp_options') . '";');
}

// check if it should display the main categories
if ($_REQUEST['do'] == 'main')
{
	// set it to show the categories/stats
	$show['categories'] = true;
	$show['categorystats'] = true;

	($hook = vBulletinHook::fetch_hook('vbplaza_main_start')) ? eval($hook) : false;

	// check if it should count the total of all points in the system
	if ($vbulletin->options['vbbux_showtotalpointsmain'])
	{
		// send off the query to get the full totals
		$overall = $vbulletin->db->query_first("
			SELECT
				COUNT(*) AS totalcount,
				SUM(`" . $vbulletin->options['vbbux_pointsfield'] . "`) AS totalpoints,
				SUM(`" . $vbulletin->options['vbbux_bankfield'] . "`) AS totalbank
			FROM " . TABLE_PREFIX . "user
		");

		// check that it did total everything up
		if (is_numeric($overall['totalcount']))
		{
			// add up the totaloverallpoints
			$overall['totaloverallpoints'] = $overall['totalpoints'] + $overall['totalbank'];

			// build the numbers properly
			$overall['totalpoints'] = vb_number_format($overall['totalpoints'], $vbulletin->options['vbbux_decimalplaces']);
			$overall['totalbank'] = vb_number_format($overall['totalbank'], $vbulletin->options['vbbux_decimalplaces']);
			$overall['totaloverallpoints'] = vb_number_format($overall['totaloverallpoints'], $vbulletin->options['vbbux_decimalplaces']);

			// set it to show the overall
			$show['overall'] = true;
		}
	}

	// count up all of the items
	foreach($vbulletin->vbplazaoptions AS $option)
	{
		// build the proper usergroups info
		$option = vbplaza_build_proper_usergroups($option, $vbulletin->vbplazacategory);

		// only count this field if the user can access it
		if ($option['showinstore'] && vbplaza_check_allowed($vbulletin->userinfo, $option['allowedgroups'], $option['deniedgroups']))
		{
			// add this to the category totals
			$vbulletin->vbplazacategory[$option[category]]['totalitems'] += 1;
			$vbulletin->vbplazacategory[$option[category]]['totalsold'] += $option['sold'];
		}
	}

	// sort the categories by display order
	$sortedcategories = vbplaza_sort_by_display_order($vbulletin->vbplazacategory);

	// build the $vbplazacategorylist
	$displayed = 0;
	$vbplazacategorylist = '';
	foreach($sortedcategories AS $category)
	{
		// verify this user is allowed to buy this item
		if (vbplaza_check_allowed($vbulletin->userinfo, $category['allowedgroups'], $category['deniedgroups']))
		{
			// setup the $show['categoryimage']
			$show['categoryimage'] = false;
			if (!empty($category[imagelocation])) { $show['categoryimage'] = true; }

			// check if it needs to start a table row
			if ($displayed == 0) { $vbplazacategorylist .= "<tr><td align=\"left\" width=\"48%\" valign=\"top\">"; }
			else { $vbplazacategorylist .= "<td>&nbsp; &nbsp;</td><td align=\"right\" width=\"48%\" valign=\"top\">"; }

			// verify the stats are there
			if (empty($category['totalitems'])) { $category['totalitems'] = "0"; }
			if (empty($category['totalsold'])) { $category['totalsold'] = "0"; }

			($hook = vBulletinHook::fetch_hook('vbplaza_main_process')) ? eval($hook) : false;

			// add this item to the list
			eval('$vbplazacategorylist .= "' . fetch_template('vbplaza_nav_categorybits') . '</td>";');

			// increase $displayed
			$displayed++;

			// check if it needs to end a table row
			if ($displayed == 2)
			{
				// end the table row
				$vbplazacategorylist .= "</tr>\n";

				// reset $displayed
				$displayed = 0;
			}
		}

		// check if it needs to end the row still
		if (($displayed % 2) == 0) { $vbplazacategorylist .= "</tr>\n"; }
	}

	($hook = vBulletinHook::fetch_hook('vbplaza_main_complete')) ? eval($hook) : false;
}

// build the current points / bank for this user
$userinfo['userid'] = $vbulletin->userinfo['userid'];
$userinfo['username'] = $vbulletin->userinfo['username'];
$userinfo['points'] = vb_number_format($vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']], $vbulletin->options['vbbux_decimalplaces']);
$userinfo['bank'] = vb_number_format($vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']], $vbulletin->options['vbbux_decimalplaces']);
if ($vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']] > 0)
{
	// check if the vbp_nextbankinterest is 0
	if ($vbulletin->userinfo['vbp_nextbankinterest'] == 0)
	{
		// reset this user's current vbp_nextbankinterest
		$vbulletin->userinfo['vbp_nextbankinterest'] = TIMENOW + $vbulletin->options['vbbux_bankinterestinterval'];

		// update this user's bank interest
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
			SET vbp_nextbankinterest = " . $vbulletin->userinfo['vbp_nextbankinterest'] . "
			WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
		");
	}

	// set the nextinterest up properly
	$userinfo['nextinterest'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $vbulletin->userinfo['vbp_nextbankinterest']);
}
else
{
	// set the nextinterest to no points in the bank yet
	$userinfo['nextinterest'] = construct_phrase($vbphrase['vbplaza_no_points_in_bank_yet'], $vbphrase['vbbux_name'], $vbphrase['vbbux_bank']);
}

// check to see if show history link should be active
$userhistory = unserialize($vbulletin->userinfo['vbp_history']);
if (!empty($userhistory))
{
	// set it to show history link
	$show['userhistory'] = true;
}

// setup the avatar if any
$avatar = fetch_avatar_url($vbulletin->userinfo['userid']);
if ($avatar == '' || !$vbulletin->options['avatarenabled'])
{
	// disable it from showing avatars
	$show['avatar'] = false;
}
else
{
	// enable it to show avatars
	$show['avatar'] = true;
	$avatar['avatarpath'] = $avatar[0];
}

// build navbar
$navbits = vbplaza_construct_navbits($navitems);
$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');

($hook = vBulletinHook::fetch_hook('vbplaza_complete')) ? eval($hook) : false;

// display the output
eval('print_output("' . fetch_template('vbplaza_main') . '");');
?>